/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui.widgets;

import com.ibm.collaboration.realtime.ui.util.ColorCache;
import com.ibm.collaboration.realtime.ui.util.ImageCache;
import com.ibm.collaboration.realtime.ui.util.SwtUtils;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class TitleBar
extends Canvas {
    Image icon = null;
    String title = null;
    private static final int GAP = 5;
    private static final int PAD = 6;
    private static final int CLOSE_RECT_EDGE = 16;
    private static final int BUTTON_NONE = 0;
    private static final int BUTTON_HOVER = 1;
    private static final int BUTTON_ARMED = 2;
    boolean buttonArmed = false;
    int buttonState = 0;
    Rectangle closeRect = new Rectangle(0, 0, 0, 0);
    Rectangle lastCloseRect = new Rectangle(0, 0, 0, 0);
    Rectangle iconRect = new Rectangle(0, 0, 0, 0);
    Rectangle lastIconRect = new Rectangle(0, 0, 0, 0);
    Rectangle textRect = new Rectangle(0, 0, 0, 0);
    Rectangle lastTextRect = new Rectangle(0, 0, 0, 0);
    Rectangle clientRect = new Rectangle(0, 0, 0, 0);
    Rectangle lastClientRect = new Rectangle(0, 0, 0, 0);
    boolean movingWindow = false;
    Point startShellLocation = new Point(0, 0);
    Point startMousePoint = new Point(0, 0);

    public TitleBar(Shell parent, int style) {
        super((Composite)parent, style);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                TitleBar.this.onPaint(event);
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent ev) {
                Point cursorPoint = new Point(ev.x, ev.y);
                if (TitleBar.this.closeRect.contains(cursorPoint)) {
                    TitleBar.this.handleMouseMove(1);
                } else {
                    TitleBar.this.handleMouseMove(0);
                }
            }
        });
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                TitleBar.this.handleMouseMove(0);
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TitleBar.this.handleMouseDown(e);
            }

            public void mouseUp(MouseEvent e) {
                TitleBar.this.handleMouseUp(e);
            }
        });
    }

    private void handleMouseMove(int state) {
        if (this.movingWindow) {
            Point e = this.getDisplay().getCursorLocation();
            Point newShellLocation = new Point(0, 0);
            newShellLocation.x = this.startShellLocation.x + e.x - this.startMousePoint.x;
            newShellLocation.y = this.startShellLocation.y + e.y - this.startMousePoint.y;
            this.getShell().setLocation(newShellLocation);
        } else if (state != this.buttonState) {
            this.buttonState = state;
            GC gc = new GC((Drawable)this);
            this.redrawElements(gc);
            gc.dispose();
        }
    }

    private void handleMouseDown(MouseEvent e) {
        Point cursorPoint = new Point(e.x, e.y);
        if (this.closeRect.contains(cursorPoint)) {
            this.buttonArmed = true;
            this.buttonState = 2;
            GC gc = new GC((Drawable)this);
            this.redrawElements(gc);
            gc.dispose();
        } else {
            this.movingWindow = true;
            this.startShellLocation = this.getShell().getLocation();
        }
        this.startMousePoint = this.getDisplay().getCursorLocation();
    }

    private void handleMouseUp(MouseEvent e) {
        Point cursorPoint = new Point(e.x, e.y);
        if (this.closeRect.contains(cursorPoint)) {
            this.buttonState = 1;
            GC gc = new GC((Drawable)this);
            this.redrawElements(gc);
            gc.dispose();
            this.getShell().dispose();
        } else if (!this.movingWindow) {
            this.buttonState = 0;
            GC gc = new GC((Drawable)this);
            this.redrawElements(gc);
            gc.dispose();
        }
        this.movingWindow = false;
        this.buttonArmed = false;
    }

    public void setIcon(Image icon) {
        if (icon == null) {
            return;
        }
        this.icon = icon;
        this.redraw();
    }

    public void setTitle(String title) {
        this.title = title;
        this.setToolTipText("");
        this.redraw();
    }

    private Point getTotalSize(GC gc, String text) {
        Point size = new Point(0, 0);
        if (this.icon != null) {
            size.x += this.icon.getBounds().width;
            size.x += 5;
            size.y += this.icon.getBounds().height;
        }
        if (text != null && text.length() > 0) {
            Point e = gc.textExtent(text);
            size.x += e.x;
            size.y = Math.max(size.y, e.y);
            size.x += 5;
        } else {
            size.y = Math.max(size.y, gc.getFontMetrics().getHeight());
        }
        size.x += 16;
        size.y = Math.max(size.y, 16);
        size.x += 12;
        size.y += 12;
        return size;
    }

    private void onPaint(PaintEvent event) {
        this.redrawElements(event.gc);
    }

    private void redrawElements(GC gc) {
        this.clientRect = this.getClientArea();
        if (this.clientRect.width == 0 || this.clientRect.height == 0) {
            return;
        }
        boolean shortenText = false;
        String displayText = this.title;
        int availableWidth = this.clientRect.width;
        int x = 6;
        int y = 6;
        if (!SwtUtils.usingHighContrast()) {
            gc.setForeground(ColorCache.getColor("GLOBAL_TOOLBAR_GRADIENT_FROM"));
            gc.setBackground(ColorCache.getColor("GLOBAL_TOOLBAR_GRADIENT_TO"));
            gc.fillGradientRectangle(this.clientRect.x, this.clientRect.y, this.clientRect.width, this.clientRect.height, true);
        }
        gc.setForeground(this.getDisplay().getSystemColor(17));
        gc.drawLine(0, this.clientRect.height - 2, this.clientRect.width, this.clientRect.height - 2);
        gc.setForeground(this.getDisplay().getSystemColor(20));
        gc.drawLine(0, this.clientRect.height - 1, this.clientRect.width, this.clientRect.height - 1);
        if (this.icon != null) {
            int offset = Math.max(0, (this.clientRect.height - this.icon.getImageData().height) / 2);
            gc.drawImage(this.icon, x, this.clientRect.y + offset);
            x += this.icon.getBounds().width;
            x += 5;
        }
        Point extent = this.getTotalSize(gc, displayText);
        if (extent.x > availableWidth) {
            shortenText = true;
        }
        if (shortenText) {
            displayText = this.shortenText(gc, this.title, availableWidth - 6 - x - 5 - 16 - 6);
            extent = this.getTotalSize(gc, displayText);
            super.setToolTipText(this.title);
        }
        if (displayText != null) {
            gc.getFontMetrics().getHeight();
            gc.setForeground(this.getForeground());
            gc.drawText(displayText, x, y + 1, true);
            x += 5;
        }
        this.drawCloseButton(gc, this.clientRect);
        gc.setForeground(ColorCache.getColor("GLOBAL_TOOLBAR_GRADIENT_TO"));
        gc.drawRoundRectangle(this.clientRect.x, this.clientRect.y, this.clientRect.width, this.clientRect.height * 2, 16, 16);
    }

    private void drawCloseButton(GC gc, Rectangle clientRect) {
        this.closeRect = new Rectangle(clientRect.width - 6 - 16 - 1, 5, 16, 16);
        gc.drawImage(ImageCache.getImage("images/ST_Close_x_h2.png"), this.closeRect.x, this.closeRect.y);
        if (this.buttonState == 1 || this.buttonState == 2) {
            gc.drawImage(ImageCache.getImage("images/ST_Close_x_h1.png"), this.closeRect.x, this.closeRect.y);
        }
    }

    private String shortenText(GC gc, String t, int width) {
        int l;
        if (t == null) {
            return null;
        }
        int w = gc.textExtent((String)"...").x;
        int e = l = t.length();
        while (e >= 0) {
            String s1 = t.substring(0, e);
            int l1 = gc.textExtent((String)s1).x;
            if (l1 + w < width) {
                t = String.valueOf(s1) + "...";
                break;
            }
            --e;
        }
        return t;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        GC gc = new GC((Drawable)this);
        Point p = this.getTotalSize(gc, this.title);
        gc.dispose();
        return p;
    }
}

