/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui.widgets;

import com.ibm.collaboration.realtime.browser.Browser;
import com.ibm.collaboration.realtime.browser.ProgressEvent;
import com.ibm.collaboration.realtime.browser.ProgressListener;
import com.ibm.collaboration.realtime.magiccarpet.messageprocessor.MessageProcessor;
import com.ibm.collaboration.realtime.ui.UiPlugin;
import com.ibm.collaboration.realtime.ui.WorkbenchAdapter;
import com.ibm.collaboration.realtime.ui.internal.registry.WorkbenchFreeActionSetRegistry;
import com.ibm.collaboration.realtime.ui.strings.Messages;
import com.ibm.collaboration.realtime.ui.util.BitmapTransfer;
import com.ibm.collaboration.realtime.ui.util.ImageCache;
import com.ibm.collaboration.realtime.ui.util.SwtUtils;
import com.ibm.collaboration.realtime.util.FileUtils;
import com.ibm.collaboration.realtime.util.OSUtils;
import com.ibm.rcp.jface.action.SActionContributionItem;
import com.ibm.rcp.jface.action.SToolBarManager;
import com.ibm.rcp.swt.swidgets.SToolBar;
import com.ibm.rcp.swt.swidgets.SToolItem;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.eclipse.ui.progress.UIJob;

public class ScreenShotShell {
    private boolean isDrawing = false;
    private ArrayList pts = new ArrayList();
    private Annotation currAnnotation = null;
    private int currWidth = 2;
    private GC dgc = null;
    private Image dim = null;
    private GC ggc = null;
    private Image gdim = null;
    private Image screenshotImage = null;
    private Shell s = null;
    private Rectangle sBounds = new Rectangle(0, 0, 0, 0);
    private SToolBarManager actionToolBar = null;
    private SToolBarManager drawingToolBar = null;
    private MenuManager fileMenuManager = null;
    private Canvas body;
    private Shell parentShell;
    private boolean shiftSelected = false;
    private static final int FREEHAND = 0;
    private static final int LINE = 1;
    private static final int RECTANGLE = 2;
    private static final int ELLIPSE = 3;
    private static final int ARROW = 4;
    private static final int NONE = -1;
    private int annotationState = 0;
    private boolean firstTimeOpen = true;
    private Color currColor = null;
    private RGB currRGB = null;
    private static final Logger logger = Logger.getLogger(ScreenShotShell.class.getName());
    private Browser printBrowser = null;
    private Point initial = new Point(0, 0);
    Cursor pencil;
    private Image finalImage;
    private final Point offscreenImageSize = new Point(0, 0);
    private ImageDescriptor colorImageDesc;
    private Image swatchImage;
    private Image baseImage;

    public ScreenShotShell() {
        this.actionToolBar = new SToolBarManager(0x800000);
        this.drawingToolBar = new SToolBarManager(0x800000);
        this.actionToolBar.add((IContributionItem)new Separator("start"));
        this.actionToolBar.add((IContributionItem)new Separator("additions"));
        this.actionToolBar.add((IContributionItem)new Separator("end"));
        this.drawingToolBar.add((IContributionItem)new Separator("start"));
        this.drawingToolBar.add((IContributionItem)new Separator("additions"));
        this.drawingToolBar.add((IContributionItem)new Separator("end"));
    }

    public void createButtonBar(SToolBar parent) {
    }

    protected void addShellListeners(Shell s) {
        s.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    ScreenShotShell.this.warnThenClose();
                }
            }
        });
        s.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                if (!ScreenShotShell.this.warnThenClose()) {
                    e.doit = false;
                }
            }
        });
    }

    private static Rectangle getToolBarBounds(SToolBarManager manager, String id) {
        SToolBar bar;
        if (manager != null && (bar = (SToolBar)manager.getControl2()) != null) {
            SToolItem[] items = bar.getItems();
            int i = 0;
            while (i < items.length) {
                SActionContributionItem sac;
                if (items[i].getData() instanceof SActionContributionItem && (sac = (SActionContributionItem)items[i].getData()).getId() != null && sac.getId().equals(id)) {
                    Rectangle rect = items[i].getBounds();
                    Point toDisp = bar.toDisplay(rect.x, rect.y);
                    rect.x = toDisp.x;
                    rect.y = toDisp.y;
                    return rect;
                }
                ++i;
            }
        }
        return null;
    }

    private static int getStyle(String type) {
        if (type == null || "".equals(type)) {
            return 1;
        }
        if ("push".equals(type)) {
            return 1;
        }
        if ("radio".equals(type)) {
            return 8;
        }
        if ("toggle".equals(type)) {
            return 2;
        }
        if ("pulldown".equals(type)) {
            return 4;
        }
        return 1;
    }

    private void addActions() {
        WorkbenchFreeActionSetRegistry reg = WorkbenchAdapter.getInstance().getActionSetRegistry();
        IActionSetDescriptor[] actionSetDescs = reg.getActionSetsFor("com.ibm.collaboration.realtime.screentool");
        int i = 0;
        while (i < actionSetDescs.length) {
            IActionSetDescriptor actionSetDesc = actionSetDescs[i];
            IConfigurationElement configElmt = actionSetDesc.getConfigurationElement();
            IConfigurationElement[] children = configElmt.getChildren();
            SToolBarManager manager = this.actionToolBar;
            int k = 0;
            while (k < children.length) {
                block15: {
                    IConfigurationElement actionSetChild = children[k];
                    if ("action".equals(actionSetChild.getName())) {
                        final String aid = actionSetChild.getAttribute("id");
                        String path = actionSetChild.getAttribute("toolbarPath");
                        if (path != null) {
                            if (path.indexOf(47) > -1) {
                                String bar = path.substring(0, path.indexOf(47));
                                manager = "drawing".equals(bar) ? this.drawingToolBar : this.actionToolBar;
                                path = path.substring(path.indexOf(47) + 1);
                            }
                        } else {
                            path = "additions";
                        }
                        String label = actionSetChild.getAttribute("label");
                        try {
                            String attr = actionSetChild.getAttribute("class");
                            if (attr != null) {
                                Action action;
                                Object classAction = actionSetChild.createExecutableExtension("class");
                                int style = ScreenShotShell.getStyle(actionSetChild.getAttribute("style"));
                                if (style == 4) {
                                    if (classAction instanceof IWorkbenchWindowPulldownDelegate2) {
                                        if (classAction instanceof ScreenShotTool) {
                                            ((ScreenShotTool)classAction).setScreenShotShell(this);
                                        }
                                        action = new DropDownAction(label, (IWorkbenchWindowPulldownDelegate2)classAction){

                                            public String getId() {
                                                return aid;
                                            }
                                        };
                                        SActionContributionItem item = new SActionContributionItem((IAction)action);
                                        item.setMode(SActionContributionItem.MODE_FORCE_TEXT);
                                        manager.appendToGroup(path, (IContributionItem)item);
                                    }
                                } else {
                                    if (classAction instanceof ScreenShotTool) {
                                        ((ScreenShotTool)classAction).setScreenShotShell(this);
                                    }
                                    action = new Action(actionSetChild.getAttribute("label"), style, classAction){
                                        Object delegate;
                                        {
                                            super($anonymous0, $anonymous1);
                                            this.delegate = object;
                                        }

                                        public void run() {
                                            if (this.delegate instanceof IWorkbenchWindowActionDelegate) {
                                                ((IWorkbenchWindowActionDelegate)this.delegate).run((IAction)this);
                                            }
                                        }

                                        public String getId() {
                                            return aid;
                                        }
                                    };
                                    boolean checked = false;
                                    String state = actionSetChild.getAttribute("state");
                                    checked = "true".equals(state);
                                    if (style == 2) {
                                        action.setChecked(checked);
                                    }
                                    SActionContributionItem item = new SActionContributionItem((IAction)action);
                                    item.setMode(SActionContributionItem.MODE_FORCE_TEXT);
                                    manager.appendToGroup(path, (IContributionItem)item);
                                }
                            }
                        }
                        catch (Exception ex) {
                            if (!logger.isLoggable(Level.WARNING)) break block15;
                            logger.log(Level.WARNING, ex.getMessage(), ex);
                        }
                    }
                }
                ++k;
            }
            ++i;
        }
    }

    public ScreenShotShell(Shell parent) {
        this();
        this.parentShell = parent;
    }

    public void open() {
        this.open(-1, -1);
    }

    public void open(int x, int y) {
        final Shell sizer = new Shell(Display.getDefault(), Window.getDefaultOrientation() | 8 | 0x4000);
        sizer.setSize(5, 5);
        this.startTrackerJob(sizer);
        sizer.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle bounds = sizer.getClientArea();
                e.gc.setBackground(Display.getDefault().getSystemColor(25));
                e.gc.fillRectangle(bounds.x, bounds.y, bounds.width, bounds.height);
                e.gc.setForeground(Display.getDefault().getSystemColor(24));
                e.gc.drawRectangle(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
            }
        });
        sizer.setBackground(Display.getDefault().getSystemColor(25));
        sizer.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent arg0) {
                Point pt = Display.getDefault().getCursorLocation();
                sizer.setLocation(pt.x - 2, pt.y - 2);
            }
        });
        sizer.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent arg0) {
                Point pt = Display.getDefault().getCursorLocation();
                sizer.setLocation(pt.x - 2, pt.y - 2);
                sizer.forceActive();
            }
        });
        sizer.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent arg0) {
                ScreenShotShell.this.initial = Display.getDefault().getCursorLocation();
                ScreenShotShell.this.createTracker(sizer, false);
            }
        });
        sizer.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u001b') {
                    if (ScreenShotShell.this.parentShell != null && ScreenShotShell.this.parentShell.getMinimized()) {
                        ScreenShotShell.this.parentShell.setMinimized(false);
                        ScreenShotShell.this.parentShell.forceActive();
                    }
                    sizer.dispose();
                } else if (e.keyCode == 131072) {
                    ScreenShotShell.this.shiftSelected = false;
                }
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 131072) {
                    ScreenShotShell.this.shiftSelected = true;
                } else if (ScreenShotShell.this.shiftSelected && (e.keyCode == 0x1000002 || e.keyCode == 0x1000001 || e.keyCode == 0x1000003 || e.keyCode == 0x1000004)) {
                    Point cursorLocation = Display.getDefault().getCursorLocation();
                    ScreenShotShell.this.initial = cursorLocation;
                    ScreenShotShell.this.createTracker(sizer, true);
                } else if (e.keyCode == 0x1000002) {
                    Point cursorLocation = Display.getDefault().getCursorLocation();
                    cursorLocation.y += 10;
                    Display.getDefault().setCursorLocation(cursorLocation);
                    sizer.setLocation(cursorLocation);
                } else if (e.keyCode == 0x1000001) {
                    Point cursorLocation = Display.getDefault().getCursorLocation();
                    cursorLocation.y -= 10;
                    Display.getDefault().setCursorLocation(cursorLocation);
                    sizer.setLocation(cursorLocation);
                } else if (e.keyCode == 0x1000003) {
                    Point cursorLocation = Display.getDefault().getCursorLocation();
                    cursorLocation.x -= 10;
                    Display.getDefault().setCursorLocation(cursorLocation);
                    sizer.setLocation(cursorLocation);
                } else if (e.keyCode == 0x1000004) {
                    Point cursorLocation = Display.getDefault().getCursorLocation();
                    cursorLocation.x += 10;
                    Display.getDefault().setCursorLocation(cursorLocation);
                    sizer.setLocation(cursorLocation);
                }
            }
        });
        sizer.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    if (ScreenShotShell.this.parentShell != null && ScreenShotShell.this.parentShell.getMinimized()) {
                        ScreenShotShell.this.parentShell.setMinimized(false);
                        ScreenShotShell.this.parentShell.forceActive();
                    }
                    sizer.dispose();
                }
            }
        });
        sizer.setCursor(Display.getDefault().getSystemCursor(2));
        Point pt = Display.getDefault().getCursorLocation();
        sizer.setLocation(pt.x - 2, pt.y - 2);
        sizer.open();
        sizer.forceActive();
    }

    private void createTracker(Shell sizer, boolean exitTrackerOnShiftKeyRelease) {
        final Tracker tracker = new Tracker(Display.getDefault(), 16);
        tracker.setStippled(true);
        tracker.setRectangles(new Rectangle[]{new Rectangle(this.initial.x, this.initial.y, 1, 1)});
        if (exitTrackerOnShiftKeyRelease) {
            tracker.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    if (e.keyCode == 131072) {
                        ScreenShotShell.this.shiftSelected = false;
                        tracker.close();
                    }
                }
            });
        }
        tracker.open();
        Rectangle[] rect = tracker.getRectangles();
        Rectangle first = rect[0];
        if (first.width <= 1 && first.height <= 1) {
            sizer.dispose();
            if (this.parentShell != null && this.parentShell.getMinimized()) {
                this.parentShell.setMinimized(false);
                this.parentShell.forceActive();
            }
        } else {
            sizer.dispose();
            this.openShell(first, true);
        }
    }

    public void openShell(Rectangle rect, boolean doCapture) {
        IContributionItem item;
        if (this.s != null && !this.s.isDisposed()) {
            this.dispose();
        }
        this.currColor = this.currRGB != null ? new Color((Device)Display.getDefault(), this.currRGB) : (Display.getDefault().getHighContrast() ? new Color((Device)Display.getDefault(), Display.getDefault().getSystemColor(21).getRGB()) : new Color((Device)Display.getDefault(), this.getDefaultColor()));
        if (this.swatchImage == null) {
            this.swatchImage = this.createSwatchImage();
            this.colorImageDesc = ImageDescriptor.createFromImage((Image)this.swatchImage);
        }
        if (this.firstTimeOpen) {
            this.setupActions();
            this.addActions();
            this.firstTimeOpen = false;
        } else {
            this.actionToolBar.add((IContributionItem)new Separator("start"));
            this.actionToolBar.add((IContributionItem)new Separator("additions"));
            this.actionToolBar.add((IContributionItem)new Separator("end"));
            this.drawingToolBar.add((IContributionItem)new Separator("start"));
            this.drawingToolBar.add((IContributionItem)new Separator("additions"));
            this.drawingToolBar.add((IContributionItem)new Separator("end"));
        }
        int height = rect.height;
        int width = rect.width;
        this.s = this.parentShell != null ? new Shell(this.parentShell, 0x4F0 | Window.getDefaultOrientation()) : new Shell(Display.getDefault(), 0x4F0 | Window.getDefaultOrientation());
        this.addMenu(this.s);
        this.addShellListeners(this.s);
        this.s.setVisible(false);
        this.s.setImages(new Image[]{ImageCache.getImage("images/ST_Screen_Capture.png")});
        this.s.setText(Messages.screenshotTitle);
        this.s.setLayout((Layout)new FormLayout());
        this.s.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (ScreenShotShell.this.currRGB != null) {
                    PreferenceConverter.setValue((IPreferenceStore)UiPlugin.getDefault().getPreferenceStore(), (String)"screenShotColor", (RGB)ScreenShotShell.this.currRGB);
                }
                if (ScreenShotShell.this.dgc != null && !ScreenShotShell.this.dgc.isDisposed()) {
                    ScreenShotShell.this.dgc.dispose();
                    ScreenShotShell.this.dgc = null;
                }
                if (ScreenShotShell.this.ggc != null && !ScreenShotShell.this.ggc.isDisposed()) {
                    ScreenShotShell.this.ggc.dispose();
                    ScreenShotShell.this.ggc = null;
                }
                if (ScreenShotShell.this.dim != null && !ScreenShotShell.this.dim.isDisposed()) {
                    ScreenShotShell.this.dim.dispose();
                    ScreenShotShell.this.dim = null;
                }
                if (ScreenShotShell.this.gdim != null && !ScreenShotShell.this.gdim.isDisposed()) {
                    ScreenShotShell.this.gdim.dispose();
                    ScreenShotShell.this.gdim = null;
                }
                if (ScreenShotShell.this.drawingToolBar != null) {
                    ScreenShotShell.this.cleanupToolBar(ScreenShotShell.this.drawingToolBar);
                    ScreenShotShell.this.drawingToolBar.dispose();
                }
                if (ScreenShotShell.this.actionToolBar != null) {
                    ScreenShotShell.this.cleanupToolBar(ScreenShotShell.this.actionToolBar);
                    ScreenShotShell.this.actionToolBar.dispose();
                }
                if (ScreenShotShell.this.currColor != null && !ScreenShotShell.this.currColor.isDisposed()) {
                    ScreenShotShell.this.currColor.dispose();
                    ScreenShotShell.this.currColor = null;
                }
                if (ScreenShotShell.this.swatchImage != null && !ScreenShotShell.this.swatchImage.isDisposed()) {
                    ScreenShotShell.this.swatchImage.dispose();
                    ScreenShotShell.this.swatchImage = null;
                }
                if (ScreenShotShell.this.baseImage != null && !ScreenShotShell.this.baseImage.isDisposed()) {
                    ScreenShotShell.this.baseImage.dispose();
                    ScreenShotShell.this.baseImage = null;
                }
                if (ScreenShotShell.this.fileMenuManager != null) {
                    ScreenShotShell.this.fileMenuManager.dispose();
                    ScreenShotShell.this.fileMenuManager = null;
                }
            }
        });
        FormData fd = new FormData();
        Composite comp = new Composite((Composite)this.s, 0);
        FillLayout fl = new FillLayout();
        fl.marginHeight = 10;
        fl.marginWidth = 10;
        comp.setLayout((Layout)fl);
        Composite border = new Composite(comp, 0);
        GridLayout gl = new GridLayout();
        if (Display.getDefault().getHighContrast()) {
            gl.marginHeight = 2;
            gl.marginWidth = 2;
        } else {
            gl.marginHeight = 1;
            gl.marginWidth = 1;
        }
        border.setLayout((Layout)gl);
        border.setBackground(Display.getDefault().getSystemColor(21));
        this.body = new Canvas(border, 262144);
        this.body.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ScreenShotShell.this.onPaint(e);
            }
        });
        this.body.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent arg0) {
            }

            public void mouseDown(MouseEvent e) {
                if (ScreenShotShell.this.screenshotImage != null) {
                    ScreenShotShell.this.isDrawing = true;
                    ScreenShotShell.this.currAnnotation = new Annotation();
                    ((ScreenShotShell)ScreenShotShell.this).currAnnotation.type = ScreenShotShell.this.annotationState;
                    ((ScreenShotShell)ScreenShotShell.this).currAnnotation.color = new Color((Device)Display.getDefault(), ScreenShotShell.this.currColor.getRGB());
                    ((ScreenShotShell)ScreenShotShell.this).currAnnotation.linewidth = ScreenShotShell.this.currWidth;
                    switch (ScreenShotShell.this.annotationState) {
                        case 0: {
                            ((ScreenShotShell)ScreenShotShell.this).currAnnotation.pts = new int[]{e.x, e.y};
                            break;
                        }
                        case 2: 
                        case 3: {
                            ((ScreenShotShell)ScreenShotShell.this).currAnnotation.rect = new Rectangle(e.x, e.y, 0, 0);
                            break;
                        }
                        case 1: 
                        case 4: {
                            ((ScreenShotShell)ScreenShotShell.this).currAnnotation.pts = new int[]{e.x, e.y};
                        }
                    }
                }
            }

            public void mouseUp(MouseEvent e) {
                if (ScreenShotShell.this.isDrawing) {
                    ScreenShotShell.this.isDrawing = false;
                    if (ScreenShotShell.this.currAnnotation != null) {
                        switch (ScreenShotShell.this.annotationState) {
                            case 2: 
                            case 3: {
                                ((ScreenShotShell)ScreenShotShell.this).currAnnotation.rect.width = e.x - ((ScreenShotShell)ScreenShotShell.this).currAnnotation.rect.x;
                                ((ScreenShotShell)ScreenShotShell.this).currAnnotation.rect.height = e.y - ((ScreenShotShell)ScreenShotShell.this).currAnnotation.rect.y;
                                break;
                            }
                            case 1: 
                            case 4: {
                                if (((ScreenShotShell)ScreenShotShell.this).currAnnotation.pts.length == 2) {
                                    int[] newpts = new int[((ScreenShotShell)ScreenShotShell.this).currAnnotation.pts.length + 2];
                                    System.arraycopy(((ScreenShotShell)ScreenShotShell.this).currAnnotation.pts, 0, newpts, 0, ((ScreenShotShell)ScreenShotShell.this).currAnnotation.pts.length);
                                    newpts[((ScreenShotShell)ScreenShotShell.this).currAnnotation.pts.length] = e.x;
                                    newpts[((ScreenShotShell)ScreenShotShell.this).currAnnotation.pts.length + 1] = e.y;
                                    ((ScreenShotShell)ScreenShotShell.this).currAnnotation.pts = newpts;
                                    break;
                                }
                                if (((ScreenShotShell)ScreenShotShell.this).currAnnotation.pts.length != 4) break;
                                ((ScreenShotShell)ScreenShotShell.this).currAnnotation.pts[2] = e.x;
                                ((ScreenShotShell)ScreenShotShell.this).currAnnotation.pts[3] = e.y;
                            }
                        }
                        ScreenShotShell.this.pts.add(ScreenShotShell.this.currAnnotation);
                        ScreenShotShell.this.currAnnotation = null;
                    }
                }
            }
        });
        Image im = ImageCache.getImage("images/Freehand_cursor.png");
        Image mask = ImageCache.getImage("images/Freehand_cursor_mask.png");
        Image image = new Image((Device)this.body.getDisplay(), im.getImageData(), mask.getImageData());
        this.pencil = new Cursor((Device)this.body.getDisplay(), image.getImageData(), 1, mask.getImageData().height - 1);
        image.dispose();
        im.dispose();
        mask.dispose();
        this.body.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                ScreenShotShell.this.setCursorState();
            }

            public void mouseExit(MouseEvent e) {
                ScreenShotShell.this.body.setCursor(null);
            }
        });
        this.body.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (ScreenShotShell.this.isDrawing && ScreenShotShell.this.currAnnotation != null) {
                    switch (ScreenShotShell.this.annotationState) {
                        case 0: {
                            if (((ScreenShotShell)ScreenShotShell.this).currAnnotation.pts != null) {
                                int[] newpts = new int[((ScreenShotShell)ScreenShotShell.this).currAnnotation.pts.length + 2];
                                System.arraycopy(((ScreenShotShell)ScreenShotShell.this).currAnnotation.pts, 0, newpts, 0, ((ScreenShotShell)ScreenShotShell.this).currAnnotation.pts.length);
                                newpts[((ScreenShotShell)ScreenShotShell.this).currAnnotation.pts.length] = e.x;
                                newpts[((ScreenShotShell)ScreenShotShell.this).currAnnotation.pts.length + 1] = e.y;
                                ((ScreenShotShell)ScreenShotShell.this).currAnnotation.pts = newpts;
                                break;
                            }
                            ((ScreenShotShell)ScreenShotShell.this).currAnnotation.pts = new int[]{e.x, e.y};
                            break;
                        }
                        case 2: 
                        case 3: {
                            if (((ScreenShotShell)ScreenShotShell.this).currAnnotation.rect == null) break;
                            ((ScreenShotShell)ScreenShotShell.this).currAnnotation.rect.width = e.x - ((ScreenShotShell)ScreenShotShell.this).currAnnotation.rect.x;
                            ((ScreenShotShell)ScreenShotShell.this).currAnnotation.rect.height = e.y - ((ScreenShotShell)ScreenShotShell.this).currAnnotation.rect.y;
                            break;
                        }
                        case 1: 
                        case 4: {
                            if (((ScreenShotShell)ScreenShotShell.this).currAnnotation.pts.length == 2) {
                                int[] newpts = new int[((ScreenShotShell)ScreenShotShell.this).currAnnotation.pts.length + 2];
                                System.arraycopy(((ScreenShotShell)ScreenShotShell.this).currAnnotation.pts, 0, newpts, 0, ((ScreenShotShell)ScreenShotShell.this).currAnnotation.pts.length);
                                newpts[((ScreenShotShell)ScreenShotShell.this).currAnnotation.pts.length] = e.x;
                                newpts[((ScreenShotShell)ScreenShotShell.this).currAnnotation.pts.length + 1] = e.y;
                                ((ScreenShotShell)ScreenShotShell.this).currAnnotation.pts = newpts;
                                break;
                            }
                            if (((ScreenShotShell)ScreenShotShell.this).currAnnotation.pts.length != 4) break;
                            ((ScreenShotShell)ScreenShotShell.this).currAnnotation.pts[2] = e.x;
                            ((ScreenShotShell)ScreenShotShell.this).currAnnotation.pts[3] = e.y;
                        }
                    }
                    ScreenShotShell.this.body.redraw();
                }
            }
        });
        this.body.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                ScreenShotShell.this.pencil.dispose();
                ScreenShotShell.this.pencil = null;
            }
        });
        this.body.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & 0x40000) != 0 && e.keyCode == 122) {
                    if (ScreenShotShell.this.pts.size() > 0) {
                        ScreenShotShell.this.pts.remove(ScreenShotShell.this.pts.size() - 1);
                    }
                    ScreenShotShell.this.currAnnotation = null;
                    ScreenShotShell.this.body.redraw();
                }
            }
        });
        this.body.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    ScreenShotShell.this.warnThenClose();
                }
            }
        });
        SToolBar buttons = (SToolBar)this.actionToolBar.getControl2();
        if (buttons == null || buttons.isDisposed()) {
            buttons = (SToolBar)this.actionToolBar.createControl2((Composite)this.s);
        }
        this.createButtonBar(buttons);
        this.fixMnemonics(buttons);
        fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 1);
        fd.right = new FormAttachment(100, -1);
        buttons.setLayoutData((Object)fd);
        Composite separator = new Composite((Composite)this.s, 0);
        separator.setBackground(Display.getDefault().getSystemColor(24));
        fd = new FormData();
        fd.top = new FormAttachment((Control)buttons, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.height = 1;
        separator.setLayoutData((Object)fd);
        SToolBar annotations = (SToolBar)this.drawingToolBar.getControl2();
        if (annotations == null || annotations.isDisposed()) {
            annotations = (SToolBar)this.drawingToolBar.createControl2((Composite)this.s);
        }
        final SToolBar bar = annotations;
        bar.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = SwtUtils.getAccessibleTextFromSToolBar(bar);
            }
        });
        bar.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getValue(AccessibleControlEvent e) {
                e.result = SwtUtils.getAccessibleTextFromSToolBar(bar);
            }
        });
        Composite topControl = separator;
        if (this.drawingToolBar.getItemCount() > 0) {
            fd = new FormData();
            fd.top = new FormAttachment((Control)topControl, 0);
            fd.left = new FormAttachment(0, 1);
            fd.right = new FormAttachment(100, -1);
            annotations.setLayoutData((Object)fd);
            Composite separator2 = new Composite((Composite)this.s, 0);
            separator2.setBackground(Display.getDefault().getSystemColor(24));
            fd = new FormData();
            fd.top = new FormAttachment((Control)annotations, 0);
            fd.left = new FormAttachment(0, 0);
            fd.right = new FormAttachment(100, 0);
            fd.height = 1;
            separator2.setLayoutData((Object)fd);
            topControl = separator2;
        }
        fd = new FormData();
        fd.top = new FormAttachment((Control)topControl, 0);
        fd.left = new FormAttachment(50, -((width + 20) / 2));
        comp.setLayoutData((Object)fd);
        GridData gd = new GridData(68);
        gd.widthHint = width;
        gd.heightHint = height;
        this.body.setLayoutData((Object)gd);
        this.body.setLayout((Layout)new FormLayout());
        String id = null;
        switch (this.annotationState) {
            case 0: {
                id = "freehand";
                break;
            }
            case 1: {
                id = "straight";
                break;
            }
            case 4: {
                id = "arrow";
                break;
            }
            case 2: {
                id = "rectangle";
                break;
            }
            case 3: {
                id = "ellipse";
            }
        }
        if (id != null && (item = this.drawingToolBar.find(id)) instanceof SActionContributionItem) {
            ((SActionContributionItem)item).getAction().setChecked(true);
            ((SActionContributionItem)item).update("checked");
        }
        if (doCapture) {
            this.doScreenshot(rect);
        }
        this.s.pack();
        this.sBounds = this.body.getBounds();
        if (this.parentShell != null) {
            this.parentShell.setMinimized(false);
            this.parentShell.forceActive();
        }
        SwtUtils.centerShell(this.parentShell, this.s);
        this.s.open();
        this.s.forceFocus();
        if (buttons.getItemCount() > 0) {
            buttons.forceFocus();
        }
        this.body.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 8) {
                    e.doit = true;
                }
            }
        });
        this.s.setTabList(new Control[]{buttons, annotations, comp});
    }

    public void performScreenshot() {
        this.performScreenshot(null);
    }

    private void doScreenshot(Rectangle r) {
        GC gc = new GC((Drawable)Display.getDefault());
        this.screenshotImage = new Image((Device)Display.getDefault(), r);
        gc.copyArea(this.screenshotImage, r.x, r.y);
        gc.dispose();
    }

    private void performScreenshot(Rectangle rect) {
        this.clearAnnotations();
        this.currAnnotation = null;
        Rectangle r = rect;
        if (rect == null) {
            r = new Rectangle(this.s.getLocation().x + 10, this.s.getLocation().y + 10, this.s.getSize().x - 20, this.s.getSize().y - 20);
            r.x = this.s.getLocation().x + this.sBounds.x;
            r.y = this.s.getLocation().y + this.sBounds.y;
            r.width = this.sBounds.width;
            r.height = this.sBounds.height;
        }
        this.doScreenshot(r);
        this.s.layout();
    }

    private void clearAnnotations() {
        for (Annotation ann : this.pts) {
            ann.dispose();
        }
        this.pts.clear();
    }

    public Image getScreenshot() {
        if (this.screenshotImage == null) {
            return null;
        }
        if (this.finalImage != null) {
            this.finalImage.dispose();
        }
        this.finalImage = new Image((Device)Display.getDefault(), this.screenshotImage.getImageData().width, this.screenshotImage.getImageData().height);
        GC gc = new GC((Drawable)this.finalImage);
        gc.drawImage(this.screenshotImage, 0, 0);
        if (this.pts != null) {
            gc.setForeground(this.currColor);
            int i = 0;
            while (i < this.pts.size()) {
                Object obj = this.pts.get(i);
                if (obj instanceof int[]) {
                    gc.drawPolyline((int[])obj);
                } else if (obj instanceof Rectangle) {
                    gc.drawRectangle((Rectangle)obj);
                } else if (obj instanceof Annotation) {
                    this.drawAnnotation(gc, (Annotation)obj);
                }
                ++i;
            }
            if (this.currAnnotation != null) {
                this.drawAnnotation(gc, this.currAnnotation);
            }
        }
        gc.dispose();
        return this.finalImage;
    }

    private void drawAnnotation(GC gc, Annotation ann) {
        gc.setForeground(ann.color);
        gc.setLineWidth(ann.linewidth);
        switch (ann.type) {
            case 0: {
                if (ann.pts == null) break;
                gc.drawPolyline(ann.pts);
                break;
            }
            case 3: {
                if (ann.rect == null) break;
                gc.drawOval(ann.rect.x, ann.rect.y, ann.rect.width, ann.rect.height);
                break;
            }
            case 2: {
                if (ann.rect == null) break;
                gc.drawRectangle(ann.rect);
                break;
            }
            case 1: {
                if (ann.pts == null) break;
                gc.drawLine(ann.pts[0], ann.pts[1], ann.pts[2], ann.pts[3]);
                break;
            }
            case 4: {
                if (ann.pts == null) break;
                this.drawArrowHead(gc, ann.linewidth, ann.pts[0], ann.pts[1], ann.pts[2], ann.pts[3]);
            }
        }
    }

    private void drawArrowHead(GC gc, int width, int x, int y, int x1, int y1) {
        double angle = Math.atan2(x1 - x, y1 - y);
        gc.drawLine(x, y, x1 - (int)((double)(2 * width) * Math.sin(angle)), y1 - (int)((double)(2 * width) * Math.cos(angle)));
        int[] poly = new int[]{x1, y1, x1 - (int)((double)(8 * width) * Math.sin(angle + 0.5)), y1 - (int)((double)(8 * width) * Math.cos(angle + 0.5)), x1 - (int)((double)(8 * width) * Math.sin(angle - 0.5)), y1 - (int)((double)(8 * width) * Math.cos(angle - 0.5))};
        Color bg = gc.getBackground();
        gc.setBackground(gc.getForeground());
        gc.fillPolygon(poly);
        gc.setBackground(bg);
    }

    public void dispose() {
        if (this.s != null && !this.s.isDisposed()) {
            this.s.dispose();
            this.s = null;
        }
        if (this.screenshotImage != null && !this.screenshotImage.isDisposed()) {
            this.screenshotImage.dispose();
            this.screenshotImage = null;
        }
        if (this.actionToolBar != null) {
            this.actionToolBar.dispose();
            this.actionToolBar = null;
        }
        if (this.drawingToolBar != null) {
            this.drawingToolBar.dispose();
            this.drawingToolBar = null;
        }
    }

    public Shell getShell() {
        return this.s;
    }

    public static void main(String[] args) {
        Display d = new Display();
        ScreenShotShell shell = new ScreenShotShell(){

            public void createButtonBar(SToolBar parent) {
                super.createButtonBar(parent);
                SToolItem buton = new SToolItem(parent, 8);
                buton.setText("Close");
                buton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent arg0) {
                        this.getShell().dispose();
                        System.exit(0);
                    }
                });
            }
        };
        shell.open();
        while (!d.isDisposed()) {
            if (d.readAndDispatch()) continue;
            d.sleep();
        }
    }

    private void onPaint(PaintEvent e) {
        Rectangle size = this.body.getClientArea();
        GC gc = e.gc;
        try {
            if (this.offscreenImageSize.x != size.width || this.offscreenImageSize.y != size.height) {
                if (this.gdim != null) {
                    this.gdim.dispose();
                    this.gdim = null;
                }
                if (this.ggc != null) {
                    this.ggc.dispose();
                    this.ggc = null;
                }
                PaletteData offscreenImagePalette = new PaletteData(65280, 0xFF0000, -16777216);
                ImageData offscreenImageData = new ImageData(size.width, size.height, 32, offscreenImagePalette);
                offscreenImageData.type = 0;
                this.gdim = new Image(null, offscreenImageData);
                this.ggc = new GC((Drawable)this.gdim, Window.getDefaultOrientation());
                this.offscreenImageSize.x = size.width;
                this.offscreenImageSize.y = size.height;
            }
        }
        finally {
            if (this.ggc != null) {
                this.ggc.setForeground(gc.getForeground());
                this.ggc.setBackground(gc.getBackground());
                this.ggc.fillRectangle(0, 0, size.width, size.height);
                gc = this.ggc;
            }
        }
        if (!Display.getDefault().getHighContrast()) {
            gc.fillRectangle(0, 0, size.width, size.height);
        } else {
            gc.setForeground(Display.getDefault().getSystemColor(17));
        }
        if (this.screenshotImage != null) {
            gc.drawImage(this.screenshotImage, 0, 0);
            if (this.pts != null) {
                if (this.currColor != null) {
                    gc.setForeground(this.currColor);
                }
                int i = 0;
                while (i < this.pts.size()) {
                    Object obj = this.pts.get(i);
                    if (obj instanceof int[]) {
                        gc.drawPolyline((int[])obj);
                    } else if (obj instanceof Rectangle) {
                        gc.drawRectangle((Rectangle)obj);
                    } else if (obj instanceof Annotation) {
                        this.drawAnnotation(gc, (Annotation)obj);
                    }
                    ++i;
                }
                if (this.currAnnotation != null) {
                    this.drawAnnotation(gc, this.currAnnotation);
                }
            }
        }
        if (gc == this.ggc) {
            e.gc.drawImage(this.gdim, 0, 0);
        }
    }

    private void startTrackerJob(Shell shell) {
        new TrackerJob(shell).schedule();
    }

    private void setupActions() {
        SActionContributionItem item = new SActionContributionItem((IAction)new Action(Messages.takeScreenshot, 1){

            public void run() {
                if (ScreenShotShell.this.currColor != null) {
                    ScreenShotShell.this.currRGB = ScreenShotShell.this.currColor.getRGB();
                }
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        ScreenShotShell.this.s.dispose();
                        if (ScreenShotShell.this.parentShell != null) {
                            ScreenShotShell.this.parentShell.setMinimized(true);
                        }
                        ScreenShotShell.this.currAnnotation = null;
                        ScreenShotShell.this.clearAnnotations();
                        ScreenShotShell.this.open();
                    }
                });
            }
        });
        item.setMode(SActionContributionItem.MODE_FORCE_TEXT);
        this.actionToolBar.appendToGroup("end", (IContributionItem)item);
        item = new SActionContributionItem((IAction)new Action(Messages.close, 1){

            public void run() {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        ScreenShotShell.this.dispose();
                    }
                });
            }
        });
        item.setMode(SActionContributionItem.MODE_FORCE_TEXT);
        this.actionToolBar.appendToGroup("end", (IContributionItem)item);
        Action a = new Action(){

            public int getStyle() {
                return 8;
            }

            public void run() {
                if (this.isChecked()) {
                    ScreenShotShell.this.setAnnotationState(0);
                } else {
                    ScreenShotShell.this.setAnnotationState(-1);
                }
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageCache.getImageDescriptor((Plugin)UiPlugin.getDefault(), "images/Freehand_Line_Tool_18x18.png");
            }

            public String getToolTipText() {
                return Messages.drawFreehandLineTooltip;
            }

            public String getId() {
                return "freehand";
            }
        };
        a.setChecked(true);
        item = new SActionContributionItem((IAction)a);
        this.drawingToolBar.appendToGroup("start", (IContributionItem)item);
        a = new Action(){

            public int getStyle() {
                return 8;
            }

            public void run() {
                if (this.isChecked()) {
                    ScreenShotShell.this.setAnnotationState(1);
                } else {
                    ScreenShotShell.this.setAnnotationState(-1);
                }
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageCache.getImageDescriptor((Plugin)UiPlugin.getDefault(), "images/Straight_Line_Tool_18x18.png");
            }

            public String getToolTipText() {
                return Messages.drawStraightLineTooltip;
            }

            public String getId() {
                return "straight";
            }
        };
        item = new SActionContributionItem((IAction)a);
        this.drawingToolBar.appendToGroup("start", (IContributionItem)item);
        a = new Action(){

            public int getStyle() {
                return 8;
            }

            public void run() {
                if (this.isChecked()) {
                    ScreenShotShell.this.setAnnotationState(4);
                } else {
                    ScreenShotShell.this.setAnnotationState(-1);
                }
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageCache.getImageDescriptor((Plugin)UiPlugin.getDefault(), "images/Create_Arrow_18x18.png");
            }

            public String getToolTipText() {
                return Messages.drawArrowTooltip;
            }

            public String getId() {
                return "arrow";
            }
        };
        item = new SActionContributionItem((IAction)a);
        this.drawingToolBar.appendToGroup("start", (IContributionItem)item);
        a = new Action(){

            public int getStyle() {
                return 8;
            }

            public void run() {
                if (this.isChecked()) {
                    ScreenShotShell.this.setAnnotationState(2);
                } else {
                    ScreenShotShell.this.setAnnotationState(-1);
                }
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageCache.getImageDescriptor((Plugin)UiPlugin.getDefault(), "images/Rect_18x18.png");
            }

            public String getToolTipText() {
                return Messages.drawRectangleTooltip;
            }

            public String getId() {
                return "rectangle";
            }
        };
        item = new SActionContributionItem((IAction)a);
        this.drawingToolBar.appendToGroup("start", (IContributionItem)item);
        a = new Action(){

            public int getStyle() {
                return 8;
            }

            public void run() {
                if (this.isChecked()) {
                    ScreenShotShell.this.setAnnotationState(3);
                } else {
                    ScreenShotShell.this.setAnnotationState(-1);
                }
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageCache.getImageDescriptor((Plugin)UiPlugin.getDefault(), "images/Create_Ellipse_Outline_18x18.png");
            }

            public String getToolTipText() {
                return Messages.drawEllipseTooltip;
            }

            public String getId() {
                return "ellipse";
            }
        };
        item = new SActionContributionItem((IAction)a);
        this.drawingToolBar.appendToGroup("start", (IContributionItem)item);
        a = new Action(){

            public int getStyle() {
                return 1;
            }

            public void run() {
                ColorDialog dialog = new ColorDialog(ScreenShotShell.this.getShell());
                RGB rgb = dialog.open();
                if (rgb != null) {
                    Image old = ScreenShotShell.this.swatchImage;
                    Color oldColor = ScreenShotShell.this.currColor;
                    ScreenShotShell.this.currColor = new Color((Device)Display.getDefault(), rgb);
                    ScreenShotShell.this.currRGB = rgb;
                    ScreenShotShell.this.swatchImage = ScreenShotShell.this.createSwatchImage();
                    ScreenShotShell.this.colorImageDesc = ImageDescriptor.createFromImage((Image)ScreenShotShell.this.swatchImage);
                    old.dispose();
                    oldColor.dispose();
                    this.firePropertyChange("image", null, null);
                }
            }

            public ImageDescriptor getImageDescriptor() {
                return ScreenShotShell.this.getColorImageDescriptor();
            }

            public String getToolTipText() {
                return Messages.changeColorTooltip;
            }
        };
        item = new SActionContributionItem((IAction)a);
        this.drawingToolBar.appendToGroup("additions", (IContributionItem)item);
        DropDownAction changeWidth = new DropDownAction("2", new IWorkbenchWindowPulldownDelegate2(){
            Menu menu;

            public void dispose() {
                if (this.menu != null) {
                    this.menu.dispose();
                    this.menu = null;
                }
            }

            public Menu getMenu(Control arg0) {
                if (this.menu == null) {
                    this.menu = new Menu(arg0);
                    MenuItem item = new MenuItem(this.menu, 0);
                    item.setText("1");
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ScreenShotShell.this.currWidth = 1;
                            IContributionItem item = ScreenShotShell.this.drawingToolBar.find("line.width");
                            if (item instanceof SActionContributionItem) {
                                ((SActionContributionItem)item).getAction().setText("1");
                                item.update("text");
                            }
                        }
                    });
                    item = new MenuItem(this.menu, 0);
                    item.setText("2");
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ScreenShotShell.this.currWidth = 2;
                            IContributionItem item = ScreenShotShell.this.drawingToolBar.find("line.width");
                            if (item instanceof SActionContributionItem) {
                                ((SActionContributionItem)item).getAction().setText("2");
                                item.update("text");
                            }
                        }
                    });
                    item = new MenuItem(this.menu, 0);
                    item.setText("3");
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ScreenShotShell.this.currWidth = 3;
                            IContributionItem item = ScreenShotShell.this.drawingToolBar.find("line.width");
                            if (item instanceof SActionContributionItem) {
                                ((SActionContributionItem)item).getAction().setText("3");
                                item.update("text");
                            }
                        }
                    });
                    item = new MenuItem(this.menu, 0);
                    item.setText("4");
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ScreenShotShell.this.currWidth = 4;
                            IContributionItem item = ScreenShotShell.this.drawingToolBar.find("line.width");
                            if (item instanceof SActionContributionItem) {
                                ((SActionContributionItem)item).getAction().setText("4");
                                item.update("text");
                            }
                        }
                    });
                }
                return this.menu;
            }

            public Menu getMenu(Menu arg0) {
                return null;
            }

            public void init(IWorkbenchWindow arg0) {
            }

            public void run(IAction a) {
            }

            public void selectionChanged(IAction arg0, ISelection arg1) {
            }
        }){

            public String getId() {
                return "line.width";
            }

            public String getToolTipText() {
                return Messages.setLineWidth;
            }

            public void run() {
                Rectangle rect = this.getToolBarBounds();
                if (rect != null) {
                    Menu menu = this.getMenu((Control)ScreenShotShell.this.getShell());
                    menu.setLocation(rect.x, rect.y + rect.height);
                    menu.setVisible(true);
                }
            }
        };
        item = new SActionContributionItem((IAction)changeWidth);
        this.drawingToolBar.appendToGroup("additions", (IContributionItem)item);
    }

    private ImageDescriptor getColorImageDescriptor() {
        if (this.colorImageDesc == null) {
            this.swatchImage = this.createSwatchImage();
            this.colorImageDesc = ImageDescriptor.createFromImage((Image)this.swatchImage);
        }
        return this.colorImageDesc;
    }

    private Image createSwatchImage() {
        Image image = new Image((Device)Display.getDefault(), 18, 18);
        GC gc = new GC((Drawable)image);
        if (this.baseImage == null) {
            this.baseImage = ImageCache.getImage("images/Color_Picker_18x18.png");
        }
        gc.drawImage(this.baseImage, 0, 0);
        gc.setBackground(this.currColor);
        gc.fillRectangle(2, 2, 13, 13);
        gc.dispose();
        return image;
    }

    private void setAnnotationState(int state) {
        this.annotationState = state;
        this.setCursorState();
    }

    private void setCursorState() {
        switch (this.annotationState) {
            case 0: {
                this.body.setCursor(this.pencil);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.body.setCursor(Display.getDefault().getSystemCursor(2));
                break;
            }
            default: {
                this.body.setCursor(null);
            }
        }
    }

    public void addActionToActionBar(String path, IAction action) {
        SActionContributionItem item = new SActionContributionItem(action);
        item.setMode(SActionContributionItem.MODE_FORCE_TEXT);
        if (path == null || this.actionToolBar.find(path) == null) {
            path = "additions";
        }
        this.actionToolBar.appendToGroup(path, (IContributionItem)item);
    }

    public void addActionToDrawingBar(String path, IAction action) {
        SActionContributionItem item = new SActionContributionItem(action);
        item.setMode(SActionContributionItem.MODE_FORCE_TEXT);
        if (path == null || this.drawingToolBar.find(path) == null) {
            path = "additions";
        }
        this.drawingToolBar.appendToGroup(path, (IContributionItem)item);
    }

    private void fixMnemonics(SToolBar bar) {
        SToolItem[] items = bar.getItems();
        IContributionItem[] toolItems = this.actionToolBar.getItems();
        int i = 0;
        while (i < items.length) {
            int j = 0;
            while (j < toolItems.length) {
                if (toolItems[j] instanceof SActionContributionItem) {
                    SActionContributionItem item = (SActionContributionItem)toolItems[j];
                    if (items[i].getText().equals(SwtUtils.removeMnemonic(item.getAction().getText()))) {
                        items[i].setText(item.getAction().getText());
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void addMenu(Shell s) {
        if (this.fileMenuManager == null) {
            this.fileMenuManager = new MenuManager();
            try {
                MenuItem[] items;
                Menu menu = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getMenuBar();
                if (menu != null && (items = menu.getItems()).length >= 2) {
                    MenuManager mm = new MenuManager(items[0].getText(), "file");
                    mm.add((IAction)new Action(UiPlugin.getDefault().getResourceString("browser_SavePictAs")){

                        public void run() {
                            FileDialog fd = new FileDialog(ScreenShotShell.this.getShell(), 8192);
                            fd.setText(Messages.save_image);
                            fd.setFilterExtensions(new String[]{"*.bmp", "*.jpg", "*.png"});
                            if (OSUtils.isWin32()) {
                                fd.setFileName(MessageProcessor.generateUniqueID());
                            } else {
                                fd.setFileName(String.valueOf(MessageProcessor.generateUniqueID()) + ".jpg");
                            }
                            if (fd.open() != null) {
                                String fileName = String.valueOf(fd.getFilterPath()) + File.separator + fd.getFileName();
                                try {
                                    boolean overwrite;
                                    File locNew = new File(fileName);
                                    if (locNew.exists() && !(overwrite = MessageDialog.openConfirm((Shell)ScreenShotShell.this.getShell(), (String)UiPlugin.getDefault().getSharedString("com.ibm.collaboration.realtime.chat.logging.dialog_file_exists"), (String)UiPlugin.getDefault().getSharedString("com.ibm.collaboration.realtime.chat.logging.dialog_file_overwrite")))) {
                                        return;
                                    }
                                    ImageLoader loader = new ImageLoader();
                                    ImageData data = ScreenShotShell.this.getScreenshot().getImageData();
                                    loader.data = new ImageData[]{data};
                                    FileOutputStream fos = new FileOutputStream(locNew);
                                    int type = 4;
                                    if (fileName.endsWith(".bmp")) {
                                        type = 0;
                                    } else if (fileName.endsWith(".png")) {
                                        type = 5;
                                    }
                                    loader.save((OutputStream)fos, type);
                                    fos.close();
                                }
                                catch (Throwable throwable) {}
                            }
                        }
                    });
                    mm.add((IAction)new Action(UiPlugin.getDefault().getResourceString("browser_printImage")){

                        public void run() {
                            try {
                                StringBuffer tmp = new StringBuffer();
                                tmp.append(System.getProperty("java.io.tmpdir"));
                                tmp.append("/");
                                tmp.append(MessageProcessor.generateUniqueID());
                                ImageLoader loader = new ImageLoader();
                                ImageData data = ScreenShotShell.this.getScreenshot().getImageData();
                                loader.data = new ImageData[]{data};
                                File file = new File(tmp.toString());
                                FileOutputStream fos = new FileOutputStream(file);
                                tmp = null;
                                int type = 0;
                                loader.save((OutputStream)fos, type);
                                fos.close();
                                if (ScreenShotShell.this.printBrowser == null) {
                                    ScreenShotShell.this.printBrowser = new Browser((Composite)ScreenShotShell.this.getShell(), 0);
                                    ScreenShotShell.this.printBrowser.addProgressListener(new ProgressListener(){

                                        public void changed(ProgressEvent event) {
                                        }

                                        public void completed(ProgressEvent event) {
                                            ScreenShotShell.this.printBrowser.execute("window.print();");
                                        }
                                    });
                                }
                                ScreenShotShell.this.printBrowser.setUrl(FileUtils.getLocalUrl((String)file.getAbsolutePath()));
                            }
                            catch (Throwable throwable) {}
                        }
                    });
                    this.fileMenuManager.add((IContributionItem)mm);
                    MenuManager editm = new MenuManager(items[1].getText(), "edit");
                    Action copy = new Action(UiPlugin.getDefault().getResourceString("browser_copy")){

                        public void run() {
                            Clipboard cBoard = new Clipboard(Display.getDefault());
                            BitmapTransfer transfer = BitmapTransfer.getInstance();
                            cBoard.setContents(new Object[]{ScreenShotShell.this.getScreenshot()}, new Transfer[]{transfer});
                            cBoard.dispose();
                        }
                    };
                    if (!OSUtils.isWin32()) {
                        copy.setEnabled(false);
                    }
                    editm.add((IAction)copy);
                    editm.add((IAction)new Action(Messages.clearAnnotations){

                        public void run() {
                            ScreenShotShell.this.clearAnnotations();
                            ScreenShotShell.this.body.redraw();
                        }
                    });
                    this.fileMenuManager.add((IContributionItem)editm);
                }
                Menu m = this.fileMenuManager.createMenuBar((Decorations)s);
                s.setMenuBar(m);
            }
            catch (Throwable throwable) {}
        }
    }

    private RGB getDefaultColor() {
        if (UiPlugin.getDefault().getPluginPreferences().contains("screenShotColor")) {
            return PreferenceConverter.getColor((IPreferenceStore)UiPlugin.getDefault().getPreferenceStore(), (String)"screenShotColor");
        }
        return new RGB(255, 0, 0);
    }

    private void cleanupToolBar(SToolBarManager manager) {
        IContributionItem[] items = manager.getItems();
        int i = 0;
        while (i < items.length) {
            SActionContributionItem item;
            IAction action;
            if (items[i] instanceof SActionContributionItem && (action = (item = (SActionContributionItem)items[i]).getAction()) instanceof DropDownAction) {
                ((DropDownAction)action).dispose();
            }
            ++i;
        }
    }

    private boolean warnThenClose() {
        if (MessageDialog.openConfirm((Shell)this.s, (String)Messages.screenshotTitle, (String)Messages.closeScreenshotConfirm)) {
            this.dispose();
            return true;
        }
        return false;
    }

    private class Annotation {
        Rectangle rect;
        int[] pts;
        int type;
        Color color;
        int linewidth;

        private Annotation() {
            this.linewidth = ScreenShotShell.this.currWidth;
        }

        void dispose() {
            if (this.color != null && !this.color.isDisposed()) {
                this.color.dispose();
                this.color = null;
            }
        }
    }

    protected class DropDownAction
    extends Action
    implements IMenuCreator {
        IWorkbenchWindowPulldownDelegate2 pulldown;

        public DropDownAction(String label, IWorkbenchWindowPulldownDelegate2 classAction) {
            super(label, 4);
            this.pulldown = null;
            this.setMenuCreator(this);
            this.pulldown = classAction;
        }

        public Menu getMenu(Control arg0) {
            return this.pulldown.getMenu(arg0);
        }

        public Menu getMenu(Menu arg0) {
            return this.pulldown.getMenu(arg0);
        }

        public void dispose() {
            this.pulldown.dispose();
        }

        public Rectangle getToolBarBounds() {
            Rectangle bounds = ScreenShotShell.getToolBarBounds(ScreenShotShell.this.drawingToolBar, this.getId());
            if (bounds == null) {
                bounds = ScreenShotShell.getToolBarBounds(ScreenShotShell.this.actionToolBar, this.getId());
            }
            return bounds;
        }
    }

    private class TrackerJob
    extends UIJob {
        Shell shell;

        TrackerJob(Shell shell) {
            super("trackshelljob");
            this.shell = shell;
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor arg0) {
            try {
                Point pt = Display.getDefault().getCursorLocation();
                if (this.shell == null || this.shell.isDisposed()) {
                    return Status.OK_STATUS;
                }
                if (!this.shell.getBounds().contains(pt)) {
                    this.shell.setLocation(pt.x - 2, pt.y - 2);
                    this.shell.forceActive();
                }
                this.schedule(250L);
            }
            catch (Throwable throwable) {}
            return Status.OK_STATUS;
        }
    }

    public static interface ScreenShotTool {
        public ScreenShotShell getScreenShotShell();

        public void setScreenShotShell(ScreenShotShell var1);
    }
}

