/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ProgressBar
extends Canvas {
    long maximum = 100L;
    long minimum = 0L;
    long current = 0L;
    Color gradientFrom = new Color(null, 210, 211, 183);
    Color gradientTo = new Color(null, 247, 247, 231);
    Color border = new Color(null, 135, 147, 170);

    public ProgressBar(Composite parent, int style) {
        super(parent, style);
        this.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                ProgressBar.this.onPaint(event.gc);
            }
        });
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                ProgressBar.this.gradientFrom.dispose();
                ProgressBar.this.gradientTo.dispose();
                ProgressBar.this.border.dispose();
            }
        });
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                ProgressBar.this.redraw();
            }
        });
    }

    private void onPaint(GC gc) {
        Rectangle rect = this.getClientArea();
        gc.setBackground(this.getDisplay().getSystemColor(1));
        gc.fillRectangle(rect);
        int currPos = this.getCurrentPos(rect.width);
        gc.setForeground(this.gradientFrom);
        gc.setBackground(this.gradientTo);
        gc.fillGradientRectangle(rect.x, rect.y, currPos, rect.height, true);
        gc.setForeground(this.border);
        gc.drawRectangle(rect.x, rect.y, rect.width - 1, rect.height - 1);
        gc.drawRectangle(rect.x, rect.y, currPos - 1, rect.height - 1);
    }

    private int getCurrentPos(int width) {
        return (int)((double)this.current * (double)width / (double)(this.maximum - this.minimum));
    }

    public void setMaximum(long maximum) {
        this.maximum = maximum;
    }

    public void setMinimum(long minimum) {
        this.minimum = minimum;
    }

    public void setSelection(long current) {
        this.current = current;
        this.redraw();
    }

    public Point computeSize(int wHint, int hHint) {
        return this.computeSize(wHint, hHint, true);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = super.computeSize(wHint, hHint, changed);
        size.y = 14;
        return size;
    }
}

