/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui.util;

import com.ibm.collaboration.realtime.browser.Browser;
import com.ibm.collaboration.realtime.browser.LocationEvent;
import com.ibm.collaboration.realtime.browser.LocationListener;
import com.ibm.collaboration.realtime.ui.ExplorerWindow;
import com.ibm.collaboration.realtime.ui.bidiutils.BidiFlag;
import com.ibm.collaboration.realtime.ui.bidiutils.BidiFlagSet;
import com.ibm.collaboration.realtime.ui.bidiutils.BidiText;
import com.ibm.collaboration.realtime.ui.bidiutils.BidiTransform;
import com.ibm.collaboration.realtime.ui.strings.Messages;
import com.ibm.collaboration.realtime.ui.util.ChatTextTransfer;
import com.ibm.collaboration.realtime.ui.util.HTMLUtils;
import com.ibm.collaboration.realtime.ui.util.ImageCache;
import com.ibm.collaboration.realtime.util.OSUtils;
import com.ibm.rcp.jface.action.SActionContributionItem;
import com.ibm.rcp.swt.swidgets.SToolBar;
import com.ibm.rcp.swt.swidgets.SToolItem;
import com.ibm.rcp.swt.swidgets.SViewForm;
import com.ibm.rcp.swt.swidgets.SViewStack;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.ViewSite;
import org.eclipse.ui.internal.presentations.PresentablePart;
import org.eclipse.ui.presentations.IPresentablePart;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SwtUtils {
    private static Logger logger = null;
    public static final String RLM = "\u200f";
    public static final String LRM = "\u200e";
    public static final String LRE = "\u202a";
    public static final String RLE = "\u202b";
    public static final String PDF = "\u202c";
    private static String m_HTML = null;
    private static String m_StyleContents = null;
    static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private static Logger getLogger() {
        if (logger == null) {
            logger = Logger.getLogger(SwtUtils.class.getName());
        }
        return logger;
    }

    public static boolean rightClick(MouseEvent e) {
        return e.button == 3 || OSUtils.isMac() && (e.stateMask & 0x40000) > 0 && e.button == 1;
    }

    public static boolean rightClick(Event e) {
        return e.button == 3 || OSUtils.isMac() && (e.stateMask & 0x40000) > 0 && e.button == 1;
    }

    public static void centerShell(Shell shell) {
        if (shell == null) {
            return;
        }
        try {
            Rectangle bounds = shell.getDisplay().getPrimaryMonitor().getBounds();
            shell.setLocation((bounds.width - shell.getBounds().width) / 2, (bounds.height - shell.getBounds().height) / 2);
        }
        catch (Throwable throwable) {}
    }

    public static void centerShell(Shell parent, Shell shell) {
        if (parent == null) {
            SwtUtils.centerShell(shell);
            return;
        }
        if (shell == null) {
            return;
        }
        try {
            Rectangle bounds = parent.getBounds();
            Rectangle shellBounds = shell.getBounds();
            Rectangle monitor = shell.getDisplay().getPrimaryMonitor().getBounds();
            Point newLocation = new Point((bounds.width - shellBounds.width) / 2, (bounds.height - shellBounds.height) / 2);
            newLocation = parent.toDisplay(newLocation);
            if (newLocation.x < 0) {
                newLocation.x = bounds.x;
            } else if (newLocation.x + shellBounds.width > monitor.width) {
                newLocation.x = monitor.width - shellBounds.width;
            }
            if (newLocation.y < 0) {
                newLocation.y = bounds.y + 25;
            } else if (newLocation.y + shellBounds.height > monitor.height) {
                newLocation.y = monitor.height - shellBounds.height;
            }
            shell.setLocation(newLocation);
        }
        catch (Throwable throwable) {}
    }

    public static ImageDescriptor getScaledImageDescriptor(ImageDescriptor imageDescriptor) {
        if (imageDescriptor.getImageData() == null) {
            return imageDescriptor;
        }
        double percent = SwtUtils.getFontScaleOffset();
        int width = (int)((double)imageDescriptor.getImageData().width * percent);
        int height = (int)((double)imageDescriptor.getImageData().height * percent);
        ImageData id = imageDescriptor.getImageData().scaledTo(width, height);
        ImageDescriptor ides = ImageDescriptor.createFromImageData((ImageData)id);
        if (ides != null) {
            return ides;
        }
        return null;
    }

    public static Image getScaledImage(Image image) {
        double percent = SwtUtils.getFontScaleOffset();
        int width = (int)((double)image.getImageData().width * percent);
        int height = (int)((double)image.getImageData().height * percent);
        ImageData id = image.getImageData().scaledTo(width, height);
        ImageDescriptor ides = ImageDescriptor.createFromImageData((ImageData)id);
        if (ides != null) {
            return ides.createImage();
        }
        return null;
    }

    public static double getFontScaleOffset() {
        return (double)Display.getDefault().getSystemFont().getFontData()[0].getHeight() / 8.0;
    }

    public static String cutText(GC gc, String original, int targetWidth) {
        if (original == null) {
            return null;
        }
        if (gc.textExtent((String)original).x > targetWidth) {
            StringBuffer buff = new StringBuffer();
            char[] chars = original.toCharArray();
            int i = 0;
            while (i < chars.length) {
                int width = gc.textExtent((String)new StringBuilder((String)String.valueOf((Object)buff.toString())).append((char)chars[i]).append((String)"...").toString()).x;
                if (width >= targetWidth) {
                    buff.append("...");
                    break;
                }
                buff.append(chars[i]);
                ++i;
            }
            return buff.toString();
        }
        return original;
    }

    public static String removeMnemonic(String mnemoniced) {
        block3: {
            if (mnemoniced == null || mnemoniced.length() <= 0) break block3;
            StringBuffer buffer = new StringBuffer();
            char[] chars = mnemoniced.toCharArray();
            int i = 0;
            while (i < chars.length) {
                block6: {
                    block5: {
                        block4: {
                            if (chars[i] != '(') break block4;
                            if (i + 1 >= chars.length || chars[i + 1] != '&' || i + 3 >= chars.length || chars[i + 3] != ')') break block5;
                            i += 3;
                            break block6;
                        }
                        if (chars[i] == '&') break block6;
                    }
                    buffer.append(chars[i]);
                }
                ++i;
            }
            return buffer.toString();
        }
        return mnemoniced;
    }

    public static char getShortcutChar(String mnemoniced) {
        int index;
        if (mnemoniced != null && mnemoniced.length() > 0 && (index = mnemoniced.indexOf("&")) > -1 && index + 1 < mnemoniced.length()) {
            return mnemoniced.charAt(index + 1);
        }
        return ' ';
    }

    public static boolean usingHighContrast() {
        return SwtUtils.getDisplay().getHighContrast();
    }

    public static Display getDisplay() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static SToolBar createOverflowButton(final SToolBar control) {
        SToolBar overflow = SwtUtils.createOverflow(control);
        if (control.getParent().getLayout() instanceof FormLayout) {
            FormData fd = new FormData();
            fd.top = new FormAttachment((Control)control, 0, 128);
            fd.right = new FormAttachment(100, 0);
            fd.bottom = new FormAttachment((Control)control, 0, 1024);
            overflow.setLayoutData((Object)fd);
            fd = (FormData)control.getParent().getChildren()[0].getLayoutData();
            if (fd != null) {
                fd.right = new FormAttachment((Control)overflow, 0);
            }
            control.getParent().layout();
            control.getParent().addControlListener(new ControlListener(){

                public void controlResized(ControlEvent arg0) {
                    boolean showChevron = false;
                    int i = 0;
                    while (i < control.getItemCount()) {
                        if (control.getItem((int)i).getBounds().x + control.getItem((int)i).getBounds().width > control.getParent().getClientArea().width) {
                            showChevron = true;
                        }
                        ++i;
                    }
                    Control[] children = control.getParent().getChildren();
                    if (control.getParent().getLayout() instanceof FormLayout) {
                        if (!showChevron && children.length >= 2) {
                            FormData fd = (FormData)children[0].getLayoutData();
                            fd.right = new FormAttachment(100, 0);
                            children[1].setEnabled(false);
                        } else if (showChevron) {
                            if (children.length == 1) {
                                SToolBar overflow = SwtUtils.createOverflow(control);
                                FormData fd = new FormData();
                                fd.top = new FormAttachment(0, 0);
                                fd.right = new FormAttachment(100, 0);
                                fd.bottom = new FormAttachment((Control)control.getParent(), 0, 1024);
                                overflow.setLayoutData((Object)fd);
                                fd = (FormData)children[0].getLayoutData();
                                fd.right = new FormAttachment((Control)overflow, 0);
                                children[1].setEnabled(true);
                            } else {
                                FormData fd = (FormData)children[0].getLayoutData();
                                fd.right = new FormAttachment(children[1], 0);
                                children[1].setEnabled(true);
                            }
                        }
                    }
                }

                public void controlMoved(ControlEvent arg0) {
                }
            });
        }
        return overflow;
    }

    public static Image getHighContrastImage(Image image) {
        ImageData data = image.getImageData();
        double percent = SwtUtils.getFontScaleOffset();
        int width = (int)((double)image.getImageData().width * percent);
        int height = (int)((double)image.getImageData().height * percent);
        data = image.getImageData().scaledTo(width, height);
        width = data.width;
        int[] lineData = new int[width];
        RGB foreground = Display.getDefault().getSystemColor(21).getRGB();
        int fg = Integer.valueOf(SwtUtils.hexify(foreground).substring(1), 16);
        int y = 0;
        while (y < data.height) {
            data.getPixels(0, y, width, lineData, 0);
            int x = 0;
            while (x < lineData.length) {
                data.setPixel(x, y, fg);
                ++x;
            }
            ++y;
        }
        return new Image((Device)Display.getDefault(), data);
    }

    public static String hexify(RGB rgb) {
        String red = Integer.toHexString(rgb.red);
        String green = Integer.toHexString(rgb.green);
        String blue = Integer.toHexString(rgb.blue);
        StringBuffer hexBuffer = new StringBuffer(6);
        hexBuffer.append("#");
        if (rgb.red == 0) {
            hexBuffer.append("00");
        } else if (red.length() == 1) {
            hexBuffer.append("0");
            hexBuffer.append(red);
        } else {
            hexBuffer.append(red);
        }
        if (rgb.green == 0) {
            hexBuffer.append("00");
        } else if (green.length() == 1) {
            hexBuffer.append("0");
            hexBuffer.append(green);
        } else {
            hexBuffer.append(green);
        }
        if (rgb.blue == 0) {
            hexBuffer.append("00");
        } else if (blue.length() == 1) {
            hexBuffer.append("0");
            hexBuffer.append(blue);
        } else {
            hexBuffer.append(blue);
        }
        return hexBuffer.toString();
    }

    private static SToolBar createOverflow(final SToolBar control) {
        boolean hc = control.getDisplay().getHighContrast();
        SToolBar arrowBar = new SToolBar(control.getParent(), 0x800000);
        arrowBar.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.pressForMoreActions;
            }
        });
        final SToolItem button = new SToolItem(arrowBar, 0x800000);
        if (Window.getDefaultOrientation() == 0x4000000) {
            Image im = ImageCache.getImage("images/Expandable_Txt_Pallette.png");
            ImageData id = SwtUtils.flip(im.getImageData(), false);
            Image newImage = new Image((Device)control.getDisplay(), id);
            Image scaled = null;
            scaled = hc ? SwtUtils.getHighContrastImage(newImage) : SwtUtils.getScaledImage(newImage);
            button.setImage(scaled);
            newImage.dispose();
        } else {
            Image scaled = null;
            scaled = hc ? SwtUtils.getHighContrastImage(ImageCache.getImage("images/Expandable_Txt_Pallette.png")) : SwtUtils.getScaledImage(ImageCache.getImage("images/Expandable_Txt_Pallette.png"));
            button.setImage(scaled);
        }
        button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (e.getSource() instanceof SToolItem) {
                    ((SToolItem)e.getSource()).getImage().dispose();
                }
            }
        });
        button.setToolTipText(Messages.moreActions);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SToolBar bar = control;
                Rectangle itemBounds = bar.getClientArea();
                SToolItem[] tools = bar.getItems();
                int i = 0;
                while (i < tools.length) {
                    Rectangle toolBounds = tools[i].getBounds();
                    Rectangle intersection = itemBounds.intersection(toolBounds);
                    if (!intersection.equals((Object)toolBounds)) break;
                    ++i;
                }
                final Menu chevronMenu = new Menu((Decorations)control.getShell(), 8);
                int j = i;
                while (j < tools.length) {
                    String text = tools[j].getText();
                    Image im = null;
                    if (!(text != null && text.length() != 0 || (text = tools[j].getToolTipText()) != null && text.length() != 0)) {
                        im = tools[j].getImage();
                    }
                    if (text != null || im != null) {
                        MenuItem menuItem = new MenuItem(chevronMenu, 64);
                        if (text != null) {
                            menuItem.setText(text);
                        } else if (im != null) {
                            menuItem.setImage(im);
                        }
                        SActionContributionItem item = (SActionContributionItem)tools[j].getData();
                        menuItem.setData((Object)item);
                        menuItem.setEnabled(item.isEnabled());
                        IMenuCreator creator = item.getAction().getMenuCreator();
                        if (creator != null) {
                            try {
                                Menu menu = new Menu(menuItem);
                                Menu returned = creator.getMenu(menu);
                                menuItem.setMenu(returned);
                            }
                            catch (Throwable throwable) {}
                        } else {
                            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent arg0) {
                                    SActionContributionItem item = (SActionContributionItem)((MenuItem)arg0.getSource()).getData();
                                    item.getAction().run();
                                }
                            });
                        }
                    }
                    ++j;
                }
                Point pt = button.getParent().toDisplay(new Point(button.getBounds().x, button.getBounds().y + button.getBounds().height));
                chevronMenu.setLocation(pt.x, pt.y);
                chevronMenu.setVisible(true);
                button.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent arg0) {
                        if (chevronMenu != null && !chevronMenu.isDisposed()) {
                            chevronMenu.dispose();
                        }
                    }
                });
            }
        });
        return arrowBar;
    }

    public static void resizeAndSetImages(Image image, Shell shell) {
        if (image == null || shell == null) {
            return;
        }
        if (image.getImageData().width <= 16 || image.getImageData().height <= 16) {
            ImageData data;
            Display display = shell.getDisplay();
            RGB transparent = new RGB(245, 245, 245);
            Color transColor = new Color((Device)display, transparent);
            Image newImage16 = null;
            if (image.getImageData().width < 16 || image.getImageData().height < 16) {
                Image im = new Image((Device)display, 16, 16);
                GC gc = new GC((Drawable)im);
                gc.setBackground(transColor);
                gc.fillRectangle(0, 0, 16, 16);
                gc.drawImage(image, (int)Math.floor((double)(16 - image.getImageData().width) / 2.0), (int)Math.floor(16 - image.getImageData().height) / 2);
                gc.dispose();
                data = im.getImageData();
                data.transparentPixel = data.palette.getPixel(transparent);
                newImage16 = new Image((Device)display, data);
                im.dispose();
            } else {
                newImage16 = new Image((Device)display, image.getImageData());
            }
            Image im32 = new Image((Device)display, 32, 32);
            GC gc32 = new GC((Drawable)im32);
            gc32.setBackground(transColor);
            gc32.fillRectangle(0, 0, 32, 32);
            gc32.drawImage(image, (int)Math.floor((double)(32 - image.getImageData().width) / 2.0), (int)Math.floor(32 - image.getImageData().height) / 2);
            gc32.dispose();
            data = im32.getImageData();
            data.transparentPixel = data.palette.getPixel(transparent);
            Image newImage32 = new Image((Device)display, data);
            transColor.dispose();
            im32.dispose();
            shell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    Image[] images = ((Shell)e.getSource()).getImages();
                    if (images != null) {
                        int i = 0;
                        while (i < images.length) {
                            images[i].dispose();
                            ++i;
                        }
                    }
                }
            });
            shell.setImages(new Image[]{newImage16, newImage32});
            return;
        }
        shell.setImage(image);
    }

    public static void storeHTMLFromBrowser(String copyValue, String styleContents) {
        m_HTML = copyValue;
        m_StyleContents = styleContents;
    }

    public static String getCopyFromBrowserJavascript(Browser browser) {
        browser.addJavaScriptAllowedClass(SwtUtils.class.getName());
        return "var element = document.createElement(\"div\");element.appendChild(getSelection().getRangeAt(0).cloneContents());var selectedText = element.innerHTML;JavaPackages.com.ibm.collaboration.realtime.ui.util.SwtUtils.storeHTMLFromBrowser(selectedText, document.getElementsByTagName('style')[0].innerHTML);";
    }

    public static boolean canCopy(Browser browser) {
        boolean bCanCopy = false;
        m_HTML = null;
        m_StyleContents = null;
        if (browser.suportsSelection()) {
            if (Browser.getRealBrowserClass().getName().compareTo("com.ibm.swt.xulrunner.browser.SWTXULRunnerBrowser") == 0) {
                String result = SwtUtils.getSelectedText(browser);
                if (result instanceof String) {
                    m_HTML = result;
                    m_StyleContents = browser.getDocument().getElementsByTagName("style").item(0).getFirstChild().getNodeValue();
                    if (m_HTML != null && m_HTML.length() > 0) {
                        bCanCopy = true;
                    }
                }
            } else {
                String js = SwtUtils.getCopyFromBrowserJavascript(browser);
                browser.execute(js);
                if (m_HTML != null && m_HTML.length() > 0) {
                    bCanCopy = true;
                }
            }
        }
        return bCanCopy;
    }

    public static String getSelectedText(Browser browser) {
        block5: {
            if (browser.suportsSelection() && Browser.getRealBrowserClass().getName().compareTo("com.ibm.swt.xulrunner.browser.SWTXULRunnerBrowser") == 0) {
                try {
                    Method cloneContents;
                    Object clone;
                    Method getRangeAt;
                    Object range;
                    Composite realBrowser = browser.getRealBrowser();
                    Method getHTMLWindow = realBrowser.getClass().getMethod("getHTMLWindow", null);
                    Object window = getHTMLWindow.invoke((Object)realBrowser, null);
                    Method getSelection = window.getClass().getMethod("getSelection", null);
                    Object selection = getSelection.invoke(window, null);
                    if (selection != null && (range = (getRangeAt = selection.getClass().getMethod("getRangeAt", Integer.TYPE)).invoke(selection, new Integer(0))) != null && (clone = (cloneContents = range.getClass().getMethod("cloneContents", null)).invoke(range, null)) instanceof DocumentFragment) {
                        DocumentFragment frag = (DocumentFragment)clone;
                        Element div = browser.getDocument().createElement("div");
                        div.appendChild(frag);
                        Method getInnerHtml = div.getClass().getMethod("getInnerHTML", null);
                        Object result = getInnerHtml.invoke((Object)div, null);
                        if (result instanceof String) {
                            return (String)result;
                        }
                    }
                }
                catch (Exception e) {
                    if (!SwtUtils.getLogger().isLoggable(Level.FINE)) break block5;
                    SwtUtils.getLogger().log(Level.FINE, e.getMessage(), e);
                }
            }
        }
        return null;
    }

    public static void copySelectedToClipboard(Browser browser, String pathHTMLTransform, String pathTextTransform) {
        if (SwtUtils.canCopy(browser)) {
            HTMLTransfer htmlTransfer = null;
            if (OSUtils.isWin32()) {
                try {
                    Class<?> htmlTransferUTF8 = Class.forName("com.ibm.collaboration.realtime.ui.win32.win32.x86.HTMLTransferUTF8");
                    Method getInstance = htmlTransferUTF8.getMethod("getInstance", null);
                    if (getInstance != null) {
                        htmlTransfer = (Transfer)getInstance.invoke(htmlTransferUTF8, null);
                    }
                }
                catch (Throwable throwable) {}
            }
            if (htmlTransfer == null) {
                htmlTransfer = HTMLTransfer.getInstance();
            }
            HTMLUtils.copyToClipboard(m_HTML, m_StyleContents, new String[]{pathHTMLTransform, String.valueOf(pathTextTransform) + "?chatTransfer=true", pathTextTransform}, new Transfer[]{htmlTransfer, ChatTextTransfer.getInstance(), TextTransfer.getInstance()});
            m_HTML = null;
            m_StyleContents = null;
        }
    }

    public static boolean isRunningBidiUI() {
        int orientation = Window.getDefaultOrientation();
        return orientation != 0 && orientation != 0x2000000;
    }

    public static String getControlChar() {
        String controlChar = "";
        if (SwtUtils.isBidiCapable()) {
            controlChar = LRM;
            if (SwtUtils.isRunningBidiUI()) {
                controlChar = RLM;
            }
        }
        return controlChar;
    }

    public static boolean isBidiCapable() {
        return BidiUtil.isBidiPlatform();
    }

    public static String wrapLeftToRightEmbedding(String text) {
        if (SwtUtils.isBidiCapable() && SwtUtils.isRunningBidiUI()) {
            return LRE + text + PDF;
        }
        return text;
    }

    public static LocationListener getHandleLinksLocationListener() {
        return new LocationListener(){

            public void changed(LocationEvent arg0) {
            }

            public void changing(LocationEvent arg0) {
                if (!(arg0.location == null || arg0.location.trim().length() <= 0 || arg0.location.equals("file:///") || arg0.location.equals("about:blank") || arg0.location.startsWith("javascript:") || arg0.location.indexOf("applewebdata://") == 0)) {
                    ExplorerWindow.launchBrowser(arg0.location, arg0.location);
                    arg0.doit = false;
                } else if (!arg0.location.equals("file:///") && !arg0.location.equals("about:blank")) {
                    arg0.location.indexOf("applewebdata://");
                }
            }
        };
    }

    public static String wrapText(GC gc, String original, int targetWidth, boolean wrap) {
        if (wrap) {
            StringBuffer buff = new StringBuffer();
            String delims = " \t\n\r\f,;";
            StringTokenizer st = new StringTokenizer(original, delims, true);
            String[] tokens = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                String token;
                tokens[i] = token = st.nextToken();
                ++i;
            }
            StringBuffer line = new StringBuffer();
            i = 0;
            while (i < tokens.length) {
                String token = tokens[i];
                String next = i < tokens.length - 1 ? tokens[i + 1] : "";
                int width = gc.textExtent((String)new StringBuilder((String)String.valueOf((Object)line.toString())).append((String)token).append((String)next).toString()).x;
                if (width < targetWidth) {
                    line.append(token);
                } else {
                    line.append(token);
                    if (next.equals(",") || next.equals(";") || next.equals(" ")) {
                        buff.append(line);
                        buff.append(next);
                        buff.append("\n");
                        if (i + 1 < tokens.length) {
                            ++i;
                        }
                    } else {
                        buff.append(line);
                        buff.append("\n");
                    }
                    line = new StringBuffer();
                }
                ++i;
            }
            buff.append(line);
            return buff.toString();
        }
        return SwtUtils.cutText(gc, original, targetWidth);
    }

    public static boolean isPreviousChild(Control control1, Control control2) {
        if (control1 == null || control2 == null || control1.getShell() == null) {
            return false;
        }
        Control first = SwtUtils.getFirstFoundChild((Composite)control1.getShell(), control1, control2);
        return first == control1;
    }

    private static Control getFirstFoundChild(Composite parent, Control control1, Control control2) {
        Control firstFound = null;
        Control[] children = parent.getTabList();
        int i = 0;
        while (i < children.length) {
            if (children[i] == control1) {
                if (firstFound == null) {
                    return control1;
                }
            } else {
                Control c;
                if (children[i] == control2) {
                    if (firstFound != null) {
                        return firstFound;
                    }
                    return control2;
                }
                if (children[i] instanceof Composite && (c = SwtUtils.getFirstFoundChild((Composite)children[i], control1, control2)) != null) {
                    return c;
                }
            }
            ++i;
        }
        return null;
    }

    public static ImageData flip(ImageData srcData, boolean vertical) {
        int bytesPerPixel = srcData.bytesPerLine / srcData.width;
        int destBytesPerLine = srcData.width * bytesPerPixel;
        byte[] newData = new byte[srcData.data.length];
        int srcY = 0;
        while (srcY < srcData.height) {
            int srcX = 0;
            while (srcX < srcData.width) {
                int destX = 0;
                int destY = 0;
                int destIndex = 0;
                int srcIndex = 0;
                if (vertical) {
                    destX = srcX;
                    destY = srcData.height - srcY - 1;
                } else {
                    destX = srcData.width - srcX - 1;
                    destY = srcY;
                }
                destIndex = destY * destBytesPerLine + destX * bytesPerPixel;
                srcIndex = srcY * srcData.bytesPerLine + srcX * bytesPerPixel;
                System.arraycopy(srcData.data, srcIndex, newData, destIndex, bytesPerPixel);
                ++srcX;
            }
            ++srcY;
        }
        return new ImageData(srcData.width, srcData.height, srcData.depth, srcData.palette, destBytesPerLine, newData);
    }

    public static String getBIDITextWithNumbers(String txt, int orientation) {
        Locale locale = Locale.getDefault();
        String lang = locale.getLanguage();
        boolean arabicLoacl = false;
        if ("ar".equals(lang)) {
            arabicLoacl = true;
        }
        if (orientation == 0x4000000 && SwtUtils.isBidiCapable() && arabicLoacl) {
            BidiFlagSet nameSrcFlags = new BidiFlagSet(BidiFlag.TYPE_IMPLICIT, BidiFlag.ORIENTATION_RTL, BidiFlag.SWAP_YES, BidiFlag.NUMERALS_NOMINAL, BidiFlag.TEXT_NOMINAL);
            BidiFlagSet nameDstFlags = new BidiFlagSet(BidiFlag.TYPE_IMPLICIT, BidiFlag.ORIENTATION_RTL, BidiFlag.SWAP_YES, BidiFlag.NUMERALS_NATIONAL, BidiFlag.TEXT_NOMINAL);
            BidiText nameSrc = new BidiText(nameSrcFlags, txt);
            BidiTransform nameBdx = new BidiTransform();
            nameBdx.impToImp = true;
            nameBdx.flags = nameDstFlags;
            return nameSrc.transform(nameBdx).toString();
        }
        return txt;
    }

    public static String getOrignalFromBIDIName(String txt) {
        if (SwtUtils.isBidiCapable() && SwtUtils.isRunningBidiUI()) {
            BidiFlagSet nameSrcFlags = new BidiFlagSet(BidiFlag.TYPE_IMPLICIT, BidiFlag.ORIENTATION_LTR, BidiFlag.SWAP_YES, BidiFlag.NUMERALS_NOMINAL, BidiFlag.TEXT_NOMINAL);
            BidiFlagSet nameDstFlags = new BidiFlagSet(BidiFlag.TYPE_IMPLICIT, BidiFlag.ORIENTATION_RTL, BidiFlag.SWAP_YES, BidiFlag.NUMERALS_NOMINAL, BidiFlag.TEXT_NOMINAL);
            BidiText nameSrc = new BidiText(nameDstFlags, txt);
            BidiTransform nameBdx = new BidiTransform();
            nameBdx.impToImp = true;
            nameBdx.flags = nameSrcFlags;
            BidiText nameDst = nameSrc.transform(nameBdx);
            return nameDst.toString();
        }
        return txt;
    }

    public static String getBIDIName(String txt) {
        if (SwtUtils.isBidiCapable() && SwtUtils.isRunningBidiUI()) {
            BidiFlagSet nameSrcFlags = new BidiFlagSet(BidiFlag.TYPE_IMPLICIT, BidiFlag.ORIENTATION_LTR, BidiFlag.SWAP_YES, BidiFlag.NUMERALS_NOMINAL, BidiFlag.TEXT_NOMINAL);
            BidiFlagSet nameDstFlags = new BidiFlagSet(BidiFlag.TYPE_IMPLICIT, BidiFlag.ORIENTATION_RTL, BidiFlag.SWAP_YES, BidiFlag.NUMERALS_NOMINAL, BidiFlag.TEXT_NOMINAL);
            BidiText nameSrc = new BidiText(nameSrcFlags, txt);
            BidiTransform nameBdx = new BidiTransform();
            nameBdx.impToImp = true;
            nameBdx.flags = nameDstFlags;
            return nameSrc.transform(nameBdx).toString();
        }
        return txt;
    }

    public static void drawBIDIText(GC gc, Control cnt, String txt, int xOffset, int y) {
        BidiFlagSet srcFlags = new BidiFlagSet(BidiFlag.TYPE_IMPLICIT, Window.getDefaultOrientation() == 0x4000000 ? BidiFlag.ORIENTATION_RTL : BidiFlag.ORIENTATION_LTR, BidiFlag.SWAP_YES, BidiFlag.NUMERALS_NOMINAL, BidiFlag.TEXT_NOMINAL);
        BidiFlagSet dstFlags = new BidiFlagSet(BidiFlag.TYPE_VISUAL, Window.getDefaultOrientation() == 0x4000000 ? BidiFlag.ORIENTATION_RTL : BidiFlag.ORIENTATION_LTR, BidiFlag.SWAP_NO, BidiFlag.NUMERALS_CONTEXTUAL, BidiFlag.TEXT_SHAPED);
        if (Window.getDefaultOrientation() == 0x4000000) {
            int startPos = txt.lastIndexOf(" (");
            if (startPos > -1) {
                txt = String.valueOf(txt.substring(0, startPos)) + LRM + RLM + txt.substring(startPos);
            }
            SwtUtils.drawString(gc, y, xOffset, txt, srcFlags, dstFlags, startPos);
        } else {
            boolean rtlInside = false;
            int i = 0;
            while (i < txt.length()) {
                char ch = txt.charAt(i);
                if (Character.getDirectionality(ch) == 1 || Character.getDirectionality(ch) == 2) {
                    rtlInside = true;
                    break;
                }
                ++i;
            }
            if (rtlInside) {
                int startPos = txt.lastIndexOf(" (");
                if (startPos > -1) {
                    txt = String.valueOf(txt.substring(0, startPos)) + RLM + LRM + txt.substring(startPos);
                }
                SwtUtils.drawString(gc, y, xOffset, txt, srcFlags, dstFlags, startPos);
            } else {
                gc.drawText(txt, xOffset, y, 3);
            }
        }
    }

    private static void drawString(GC gc, int y, int xOffset, String txt, BidiFlagSet srcFlags, BidiFlagSet dstFlags, int startPos) {
        BidiText src = new BidiText(srcFlags, txt);
        BidiTransform bdx = new BidiTransform();
        bdx.srcToDstMapRequired = true;
        bdx.flags = dstFlags;
        BidiText dst = src.transform(bdx);
        String dstString = new String(dst.data);
        int i = 0;
        while (i < dstString.length()) {
            String ch = dstString.substring(i, i + 1);
            if (Window.getDefaultOrientation() == 0x4000000) {
                if (ch.equals("<")) {
                    ch = ">";
                } else if (ch.equals(">")) {
                    ch = "<";
                } else if (ch.equals("{")) {
                    ch = "}";
                } else if (ch.equals("}")) {
                    ch = "{";
                } else if (ch.equals("(")) {
                    ch = ")";
                } else if (ch.equals(")")) {
                    ch = "(";
                } else if (ch.equals("[")) {
                    ch = "]";
                } else if (ch.equals("]")) {
                    ch = "[";
                }
            }
            gc.drawText(ch, xOffset, y, 3);
            xOffset += gc.textExtent((String)ch, (int)3).x;
            ++i;
        }
    }

    public static SViewStack getStackParent(Composite comp) {
        while (comp != null && !(comp instanceof SViewStack)) {
            comp = comp.getParent();
        }
        return (SViewStack)comp;
    }

    public static SViewForm getSViewForm(Composite comp, ViewSite viewSite) {
        SViewStack stack = SwtUtils.getStackParent(comp);
        if (stack != null) {
            Control[] children = stack.getControls(true);
            int i = 0;
            while (i < children.length) {
                PartPane pane;
                SViewForm form = (SViewForm)children[i];
                IPresentablePart part = (IPresentablePart)form.getData(IPresentablePart.class.getName());
                if (part instanceof PresentablePart && (pane = ((PresentablePart)part).getPane()).equals(viewSite.getPane())) {
                    return form;
                }
                ++i;
            }
        }
        return null;
    }

    public static boolean isCurrentThreadDisplayThread() {
        boolean retVal = false;
        Display curDisplay = Display.getCurrent();
        if (curDisplay != null) {
            curDisplay.getThread();
            Thread curThread = Thread.currentThread();
            if (curThread == curDisplay.getThread()) {
                retVal = true;
            }
        } else {
            retVal = false;
        }
        return retVal;
    }

    public static String translate(String buffer) {
        char c;
        char[] tmpBuf = new char[255];
        int tmpIdx = 0;
        int len = buffer.length();
        tmpIdx = 0;
        int bufIdx = 0;
        while (bufIdx < len) {
            c = buffer.charAt(bufIdx);
            tmpBuf[tmpIdx] = HEX[c >> 12];
            tmpBuf[++tmpIdx] = HEX[c >> 8 & 0xF];
            tmpBuf[++tmpIdx] = HEX[c >> 4 & 0xF];
            tmpBuf[++tmpIdx] = HEX[c & 0xF];
            tmpBuf[++tmpIdx] = 32;
            ++bufIdx;
            ++tmpIdx;
        }
        String tmp = new String(tmpBuf, 0, tmpIdx);
        tmp = tmp.replaceAll("200F", "RLM ");
        tmp = tmp.replaceAll("202E", "LRM ");
        tmp = tmp.replaceAll("202A", "LRE ");
        tmp = tmp.replaceAll("202B", "RLE ");
        tmp = tmp.replaceAll("202C", "PDF ");
        StringBuffer sb = new StringBuffer(String.valueOf(tmp) + "\n");
        int i = 0;
        while (i < buffer.length()) {
            c = buffer.charAt(i);
            sb.append(" (" + c + ") ");
            ++i;
        }
        tmp = "\n" + buffer + "\n" + sb.toString();
        return tmp;
    }

    public static void selectAll(final Browser browser) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (Browser.getRealBrowserClass().getName().compareTo("com.ibm.swt.xulrunner.browser.SWTXULRunnerBrowser") == 0) {
                    try {
                        Composite realBrowser = browser.getRealBrowser();
                        Method getHTMLWindow = realBrowser.getClass().getMethod("getHTMLWindow", null);
                        Object window = getHTMLWindow.invoke((Object)realBrowser, null);
                        Method getSelection = window.getClass().getMethod("getSelection", null);
                        Object selection = getSelection.invoke(window, null);
                        if (selection != null) {
                            Method selectAllChildren = selection.getClass().getMethod("selectAllChildren", Node.class);
                            selectAllChildren.invoke(selection, browser.getDocument().getElementsByTagName("body").item(0));
                            return;
                        }
                    }
                    catch (Throwable throwable) {}
                }
                browser.execute("window.getSelection().selectAllChildren(document.body);");
            }
        });
    }

    public static Shell getTopmostShell() {
        if (!OSUtils.isMac()) {
            try {
                Shell workbench = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                if (workbench != null && !workbench.isDisposed()) {
                    return workbench;
                }
            }
            catch (Throwable throwable) {}
        }
        Shell[] shells = Display.getDefault().getShells();
        int i = shells.length - 1;
        while (i >= 0) {
            if (!shells[i].isDisposed() && (shells[i].getStyle() & 0x4F0) == 1264) {
                return shells[i];
            }
            --i;
        }
        return Display.getDefault().getActiveShell();
    }

    public static String getAccessibleTextFromSToolBar(SToolBar bar) {
        String toolTip = "";
        int index = bar.getSelectionIndex();
        if (index >= 0 && (toolTip = bar.getItem(index).getToolTipText()) == null) {
            toolTip = bar.getItem(bar.getSelectionIndex()).getText();
        }
        return toolTip;
    }
}

