/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui.util;

import com.ibm.collaboration.realtime.ui.util.ChatTextTransfer;
import com.ibm.collaboration.realtime.ui.util.HTMLUtilsAdapter;
import com.ibm.collaboration.realtime.util.OSUtils;
import com.ibm.collaboration.realtime.util.StringUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public class HTMLUtils {
    private HTMLUtilsAdapter itsAdapter = null;
    private static final Logger logger = Logger.getLogger(HTMLUtils.class.getName());

    public HTMLUtilsAdapter getAdapter() {
        return this.itsAdapter;
    }

    public void setAdapter(HTMLUtilsAdapter adapter) {
        this.itsAdapter = adapter;
    }

    public static String convertPlainTextToHTML(String str) {
        str = str.replaceAll("&", "&amp;");
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll(">", "&gt;");
        str = str.replaceAll("\"", "&quot;");
        return str;
    }

    public static String replaceHTMLSymbolsInPlainText(String str) {
        str = str.replaceAll("&lt;", "<");
        str = str.replaceAll("&gt;", ">");
        str = str.replaceAll("&quot;", "\"");
        str = str.replaceAll("&amp;", "&");
        return str;
    }

    public String parseText(String strHTMLIn) {
        String strHTMLOut = strHTMLIn;
        if (this.itsAdapter != null) {
            int pos = strHTMLOut.indexOf("<body");
            if (pos == -1) {
                pos = 0;
            }
            while ((pos = strHTMLOut.indexOf(62, pos)) != -1) {
                int pos3;
                String strText;
                int pos2 = strHTMLOut.indexOf(60, pos);
                if (pos2 != -1 && (strText = strHTMLOut.substring(pos + 1, pos2)) != null && strText.length() > 0) {
                    strText = this.itsAdapter.processText(strText);
                    strHTMLOut = String.valueOf(strHTMLOut.substring(0, pos + 1)) + strText + strHTMLOut.substring(pos2);
                    pos += strText.length();
                }
                if ((pos3 = strHTMLOut.indexOf("</body")) != -1 && pos3 < ++pos) break;
            }
        }
        return strHTMLOut;
    }

    public String parseTagParm(String strHTMLIn, String strTagBegin, String strQuotedParmBegin) {
        String strHTMLOut = strHTMLIn;
        if (this.itsAdapter != null) {
            int pos = 0;
            strTagBegin = "<" + strTagBegin;
            strQuotedParmBegin = String.valueOf(strQuotedParmBegin) + "=\"";
            while ((pos = strHTMLOut.indexOf(strTagBegin, pos)) != -1) {
                int pos2 = strHTMLOut.indexOf(62, pos);
                if (pos2 != -1) {
                    int pos4;
                    String strTag = strHTMLOut.substring(pos, pos2 + 1);
                    int pos3 = (strTag = this.itsAdapter.processTag(strTag)).indexOf(strQuotedParmBegin);
                    if (pos3 != -1 && (pos4 = strTag.indexOf(34, pos3 + strQuotedParmBegin.length())) != -1) {
                        String strParm = strTag.substring(pos3 + strQuotedParmBegin.length(), pos4);
                        strParm = this.itsAdapter.processParm(strParm);
                        strTag = String.valueOf(strTag.substring(0, pos3 + strQuotedParmBegin.length())) + strParm + strTag.substring(pos4);
                    }
                    strHTMLOut = String.valueOf(strHTMLOut.substring(0, pos)) + strTag + strHTMLOut.substring(pos2 + 1);
                    pos += strTag.length();
                    continue;
                }
                pos += strTagBegin.length();
            }
        }
        return strHTMLOut;
    }

    public static String makeHTMLXMLCompliant(String strHTML) {
        int pos2;
        strHTML = strHTML.replaceAll("<br>", "<br />");
        strHTML = strHTML.replaceAll("&", "&amp;");
        int pos = 0;
        while ((pos = strHTML.indexOf("<img", pos)) != -1) {
            pos2 = strHTML.indexOf(62, pos);
            if (pos2 != -1 && strHTML.charAt(pos2 - 1) != '/') {
                strHTML = String.valueOf(strHTML.substring(0, pos2)) + '/' + strHTML.substring(pos2, strHTML.length());
            }
            ++pos;
        }
        pos = 0;
        while ((pos = strHTML.indexOf("<META", pos)) != -1) {
            pos2 = strHTML.indexOf(62, pos);
            if (pos2 != -1 && strHTML.charAt(pos2 - 1) != '/') {
                strHTML = String.valueOf(strHTML.substring(0, pos2)) + '/' + strHTML.substring(pos2, strHTML.length());
            }
            ++pos;
        }
        return strHTML;
    }

    public static void copyToClipboard(String strHTML, String strStyleContents, String[] transforms, Transfer[] transfers) {
        block24: {
            if (strHTML != null && strHTML.length() > 0) {
                try {
                    Clipboard clipboard = new Clipboard(Display.getCurrent());
                    if (clipboard == null) break block24;
                    if (strHTML.indexOf("<") < 0) {
                        TextTransfer textTransfer = TextTransfer.getInstance();
                        if (textTransfer != null) {
                            strHTML = strHTML.replaceAll("&amp;", "&");
                            strHTML = strHTML.replaceAll("&lt;", "<");
                            strHTML = strHTML.replaceAll("&gt;", ">");
                            clipboard.setContents(new Object[]{strHTML}, new Transfer[]{textTransfer});
                        }
                    } else if (transforms.length == transfers.length) {
                        strHTML = HTMLUtils.makeHTMLXMLCompliant(strHTML);
                        strHTML = HTMLUtils.urlDecodeSpecial(strHTML);
                        strHTML = "<div>" + strHTML + "</div>";
                        Object[] useTransforms = new String[transforms.length];
                        Transfer[] useTransfers = new Transfer[transfers.length];
                        Class<?> htmlTransfer = null;
                        if (OSUtils.isWin32()) {
                            try {
                                htmlTransfer = Class.forName("com.ibm.collaboration.realtime.ui.win32.win32.x86.HTMLTransferUTF8");
                            }
                            catch (Throwable throwable) {}
                        }
                        int i = 0;
                        while (i < transforms.length) {
                            if (transforms[i] == null || transfers[i] == null) {
                                useTransforms[i] = null;
                                useTransfers[i] = null;
                            } else {
                                useTransfers[i] = transfers[i];
                                String contents = StringUtils.xslTransform((String)strHTML, (String)transforms[i]);
                                if (transfers[i] instanceof HTMLTransfer) {
                                    if (strStyleContents != null) {
                                        contents = "<style type='text/css'>" + strStyleContents + "</style>" + contents;
                                    }
                                } else if (OSUtils.isWin32() && htmlTransfer != null) {
                                    try {
                                        if (htmlTransfer.isInstance(transfers[i]) && strStyleContents != null) {
                                            contents = "<style type='text/css'>" + strStyleContents + "</style>" + contents;
                                        }
                                    }
                                    catch (Throwable throwable) {}
                                }
                                if (contents != null) {
                                    try {
                                        contents = contents.replaceAll("&amp;", "&");
                                        if (transfers[i] instanceof TextTransfer || transfers[i] instanceof ChatTextTransfer) {
                                            contents = contents.replaceAll("&lt;", "<");
                                            contents = contents.replaceAll("&gt;", ">");
                                        }
                                    }
                                    catch (Throwable throwable) {}
                                }
                                useTransforms[i] = contents;
                            }
                            ++i;
                        }
                        clipboard.setContents(useTransforms, useTransfers);
                    }
                    clipboard.dispose();
                    clipboard = null;
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(Level.WARNING)) break block24;
                    logger.log(Level.WARNING, t.getMessage(), t);
                }
            }
        }
    }

    public static String urlDecodeSpecial(String strHTML) {
        strHTML = strHTML.replaceAll("%20", " ");
        strHTML = strHTML.replaceAll("%7E", "~");
        strHTML = strHTML.replaceAll("%25", "%");
        return strHTML;
    }
}

