/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui.util;

import com.ibm.collaboration.realtime.ui.util.AnimatedGifTimer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class GifAnimatingRunnable
extends TimerTask {
    private int currentFrameNumber = 0;
    private boolean drawing = true;
    private int height;
    private int width;
    private ImageData[] frames;
    private Display display;
    private GC gcToDrawTo;
    private Color backgroundColor;
    private Canvas theCanvas;
    private Image offScreenImage = null;
    private GC offScreenGC = null;
    private Image currentImage;
    private ImageLoader loader;
    private GC imageCanvasGC;
    public int xpos = 0;
    public int ypos = 0;
    private String file;
    private boolean setup = false;
    private static final Logger logger = Logger.getLogger(GifAnimatingRunnable.class.getName());
    int currentFrameDelay = 10;
    int currentDelay = 10;
    boolean inited = false;
    public boolean isVisible = false;

    public GifAnimatingRunnable(String file, Display display, Canvas theCanvas, int xpos, int ypos) {
        this.file = file;
        this.display = display;
        this.theCanvas = theCanvas;
        this.xpos = xpos;
        this.ypos = ypos;
        this.loader = new ImageLoader();
    }

    public GifAnimatingRunnable(ImageData[] frames, Display display, Canvas theCanvas, ImageLoader loader) {
        this.height = loader.logicalScreenHeight;
        this.width = loader.logicalScreenWidth;
        this.frames = frames;
        this.display = display;
        this.theCanvas = theCanvas;
        this.loader = loader;
        this.initializeStuffThatNeedsUIThread();
        this.initialize();
    }

    public GifAnimatingRunnable(ImageData[] frames, Display display, Canvas theCanvas, ImageLoader loader, int xpos, int ypos) {
        this.height = loader.logicalScreenHeight;
        this.width = loader.logicalScreenWidth;
        this.frames = frames;
        this.display = display;
        this.theCanvas = theCanvas;
        this.loader = loader;
        this.xpos = xpos;
        this.ypos = ypos;
        this.initializeStuffThatNeedsUIThread();
        this.initialize();
    }

    public GifAnimatingRunnable(ImageData[] frames, Display display, Canvas theCanvas, int height, int width, int xpos, int ypos) {
        this.height = height;
        this.width = width;
        this.frames = frames;
        this.display = display;
        this.theCanvas = theCanvas;
        this.xpos = xpos;
        this.ypos = ypos;
        this.initializeStuffThatNeedsUIThread();
        this.initialize();
    }

    public GifAnimatingRunnable() {
    }

    public GifAnimatingRunnable(String image, Canvas theCanvas, int x, int y) {
        this.file = image;
        this.theCanvas = theCanvas;
        this.loader = new ImageLoader();
        this.display = Display.getDefault();
        this.xpos = x;
        this.ypos = y;
    }

    public void setup(String image, Canvas theCanvas, int x, int y) {
        if (!this.setup) {
            this.file = image;
            this.theCanvas = theCanvas;
            this.loader = new ImageLoader();
            this.display = Display.getDefault();
            this.setup = true;
        }
        this.xpos = x;
        this.ypos = y;
    }

    public static void main(String[] args) {
        block3: {
            try {
                Display d = new Display();
                Shell s = new Shell(d);
                s.setSize(300, 400);
                s.setLayout((Layout)new FillLayout());
                CLabel l = new CLabel((Composite)s, 2048);
                CLabel l2 = new CLabel((Composite)s, 2048);
                l2.setBackground(d.getSystemColor(1));
                ImageLoader loader = new ImageLoader();
                ImageData[] id = loader.load("C:\\stuff\\workspaces\\m6\\com.ibm.collaboration.realtime.palettes\\smileys\\EmoticonCrying.gif");
                ImageLoader loader2 = new ImageLoader();
                ImageData[] id2 = loader2.load("C:\\stuff\\workspaces\\m6\\com.ibm.collaboration.realtime.palettes\\smileys\\EmoticonTongue.gif");
                ImageLoader loader3 = new ImageLoader();
                ImageData[] id3 = loader3.load("C:\\stuff\\workspaces\\m6\\com.ibm.collaboration.realtime.palettes\\smileys\\EmoticonWink.gif");
                String file = "C:\\stuff\\workspaces\\m6\\com.ibm.collaboration.realtime.palettes\\smileys\\EmoticonThumbsUp.gif";
                s.open();
                Timer timer = new Timer();
                GifAnimatingRunnable gir = new GifAnimatingRunnable(id, d, (Canvas)l, loader, 100, 100);
                GifAnimatingRunnable gir2 = new GifAnimatingRunnable(id2, d, (Canvas)l2, loader2, 0, 100);
                timer.schedule((TimerTask)gir, 0L, 10L);
                timer.schedule((TimerTask)gir2, 0L, 10L);
                timer.schedule((TimerTask)new GifAnimatingRunnable(id3, d, (Canvas)l, loader3, 50, 100), 0L, 10L);
                timer.schedule((TimerTask)new GifAnimatingRunnable(file, (Canvas)l, 75, 100), 0L, 10L);
                while (!s.isDisposed()) {
                    if (s.getDisplay().readAndDispatch()) continue;
                    s.getDisplay().sleep();
                }
                timer.cancel();
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.WARNING)) break block3;
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    public void run() {
        if (!this.inited) {
            block7: {
                try {
                    this.initializeStuffThatNeedsUIThread();
                    if (!this.initialize()) {
                        this.cancel();
                        AnimatedGifTimer.cancelTask((Widget)this.theCanvas, this);
                        return;
                    }
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(Level.WARNING)) break block7;
                    logger.log(Level.WARNING, t.getMessage(), t);
                }
            }
            this.inited = true;
        }
        if ((long)this.currentDelay != this.getFrameDelayinMs()) {
            this.currentDelay += 10;
            return;
        }
        if (this.isDrawing() && this.isVisible) {
            this.drawNextFrame();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    GifAnimatingRunnable.this.theCanvas.redraw();
                }
            });
        }
    }

    private void initializeStuffThatNeedsUIThread() {
        Runnable r = new Runnable(){

            public void run() {
                GifAnimatingRunnable.this.backgroundColor = GifAnimatingRunnable.this.theCanvas.getBackground();
                GifAnimatingRunnable.this.imageCanvasGC = new GC((Drawable)GifAnimatingRunnable.this.theCanvas);
                GifAnimatingRunnable.this.theCanvas.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        GifAnimatingRunnable.this.imageCanvasGC.dispose();
                        GifAnimatingRunnable.this.cancel();
                        AnimatedGifTimer.cancelTask((Widget)GifAnimatingRunnable.this.theCanvas, GifAnimatingRunnable.this);
                    }
                });
            }
        };
        this.display.syncExec(r);
    }

    private long getFrameDelayinMs() {
        return Math.max(10, this.frames[this.currentFrameNumber].delayTime * 10);
    }

    public synchronized boolean isDrawing() {
        return this.drawing;
    }

    public synchronized void stopDrawing() {
        this.drawing = false;
    }

    private void eraseFrame() {
        if (this.frames[this.currentFrameNumber].disposalMethod == 2) {
            Color bgColor = null;
            int backgroundPixel = this.loader.backgroundPixel;
            if (backgroundPixel != -1) {
                RGB backgroundRGB = this.frames[this.currentFrameNumber].palette.getRGB(backgroundPixel);
                bgColor = new Color(null, backgroundRGB);
            }
            try {
                this.offScreenGC.setBackground(bgColor != null ? bgColor : this.backgroundColor);
                this.offScreenGC.fillRectangle(this.frames[this.currentFrameNumber].x, this.frames[this.currentFrameNumber].y, this.frames[this.currentFrameNumber].width, this.frames[this.currentFrameNumber].height);
            }
            finally {
                if (bgColor != null) {
                    bgColor.dispose();
                }
            }
        } else if (this.frames[this.currentFrameNumber].disposalMethod == 3) {
            this.offScreenGC.drawImage(this.currentImage, this.xpos, this.ypos, this.frames[this.currentFrameNumber].width, this.frames[this.currentFrameNumber].height, this.frames[this.currentFrameNumber].x, this.frames[this.currentFrameNumber].y, this.frames[this.currentFrameNumber].width, this.frames[this.currentFrameNumber].height);
        } else if (!(this.frames[this.currentFrameNumber].disposalMethod != 1 && this.frames[this.currentFrameNumber].disposalMethod != 0 || this.currentImage.isDisposed())) {
            this.offScreenGC.drawImage(this.currentImage, 0, 0, this.frames[this.currentFrameNumber].width, this.frames[this.currentFrameNumber].height, this.frames[this.currentFrameNumber].x, this.frames[this.currentFrameNumber].y, this.frames[this.currentFrameNumber].width, this.frames[this.currentFrameNumber].height);
        }
    }

    private void drawNextFrame() {
        this.eraseFrame();
        this.currentFrameNumber = (this.currentFrameNumber + 1) % this.frames.length;
        this.currentFrameDelay = this.frames[this.currentFrameNumber].delayTime;
        this.currentDelay = 10;
        this.currentImage.dispose();
        this.currentImage = new Image((Device)this.display, this.frames[this.currentFrameNumber]);
        this.offScreenGC.drawImage(this.currentImage, 0, 0, this.frames[this.currentFrameNumber].width, this.frames[this.currentFrameNumber].height, this.frames[this.currentFrameNumber].x, this.frames[this.currentFrameNumber].y, this.frames[this.currentFrameNumber].width, this.frames[this.currentFrameNumber].height);
        if (!this.imageCanvasGC.isDisposed()) {
            this.imageCanvasGC.drawImage(this.offScreenImage, this.xpos, this.ypos);
        } else {
            this.stopDrawing();
        }
    }

    public void cleanup() {
        if (this.loader != null) {
            this.loader = null;
        }
        if (this.offScreenGC != null) {
            this.offScreenGC.dispose();
            this.offScreenGC = null;
        }
        if (this.offScreenImage != null) {
            this.offScreenImage.dispose();
            this.offScreenImage = null;
        }
        if (this.currentImage != null) {
            this.currentImage.dispose();
            this.currentImage = null;
        }
    }

    private boolean initialize() {
        if (this.frames == null) {
            if (this.loader == null) {
                return false;
            }
            this.frames = this.loader.load(this.file);
            this.width = this.loader.logicalScreenWidth;
            this.height = this.loader.logicalScreenHeight;
            if (this.width == 0 && this.height == 0) {
                return false;
            }
        }
        this.offScreenImage = new Image((Device)Display.getCurrent(), this.width, this.height);
        this.offScreenGC = new GC((Drawable)this.offScreenImage);
        this.currentImage = new Image((Device)Display.getCurrent(), this.frames[this.currentFrameNumber]);
        this.offScreenGC.setBackground(this.backgroundColor);
        this.offScreenGC.fillRectangle(this.xpos, this.ypos, this.width, this.height);
        this.currentFrameDelay = this.frames[this.currentFrameNumber].delayTime;
        return true;
    }

    public boolean cancel() {
        this.stopDrawing();
        this.cleanup();
        return super.cancel();
    }
}

