/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui.util;

import com.ibm.collaboration.realtime.ui.strings.LogMessages;
import com.ibm.collaboration.realtime.util.OSUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Composite;

public class CustomAccessibleEvent {
    private static final Logger logger = Logger.getLogger(CustomAccessibleEvent.class.getName());

    public static void notifyEvent(Composite accComposite, int objectID, int childID) {
        block9: {
            if (OSUtils.isWin32()) {
                try {
                    Class<?> os = Class.forName("org.eclipse.swt.internal.win32.OS");
                    Method notifyWinEvent = os.getDeclaredMethod("NotifyWinEvent", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                    notifyWinEvent.invoke(os, new Integer(32782), new Integer(accComposite.handle), new Integer(objectID), new Integer(childID));
                }
                catch (ClassNotFoundException ex) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, LogMessages.CustomAccessibleEvent_2, ex);
                    }
                }
                catch (NoSuchMethodException ex) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, LogMessages.CustomAccessibleEvent_3, ex);
                    }
                }
                catch (IllegalAccessException ex) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, LogMessages.CustomAccessibleEvent_4, ex);
                    }
                }
                catch (InvocationTargetException ex) {
                    if (!logger.isLoggable(Level.FINE)) break block9;
                    logger.log(Level.FINE, LogMessages.CustomAccessibleEvent_5, ex);
                }
            }
        }
    }
}

