/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui.util;

import com.ibm.collaboration.realtime.ui.DisplayLoop;
import com.ibm.collaboration.realtime.util.OSUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Shell;

public class CSS {
    private static final Logger logger = Logger.getLogger(CSS.class.getName());
    private static String value = null;

    public static void cacheSystemColorAndFont(final Object mutex) {
        DisplayLoop.getDisplay().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block5: {
                    try {
                        CSS.getCSS();
                        if (mutex == null) break block5;
                        Object object = mutex;
                        synchronized (object) {
                            mutex.notify();
                        }
                    }
                    catch (Exception e) {
                        if (!logger.isLoggable(Level.WARNING)) break block5;
                        logger.log(Level.WARNING, "", e);
                    }
                }
            }
        });
    }

    public static void getSystemColorsAndFontsToCss(PrintWriter writer) throws IOException {
        writer.print(CSS.getSystemColorsAndFontsToCss());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSystemColorsAndFontsToCss() {
        block6: {
            if (value != null) {
                return value;
            }
            Object mutex = new Object();
            CSS.cacheSystemColorAndFont(mutex);
            try {
                if (value != null) break block6;
                Object object = mutex;
                synchronized (object) {
                    mutex.wait();
                }
            }
            catch (InterruptedException e) {
                if (!logger.isLoggable(Level.WARNING)) break block6;
                logger.log(Level.WARNING, "", e);
            }
        }
        return value;
    }

    public static String getCSS() {
        String rightAlign = "right";
        String leftAlign = "left";
        String orientation = "ltr";
        Shell shell = DisplayLoop.getDisplay().getShells()[0];
        Color color = shell.getBackground();
        Font font = shell.getFont();
        FontData[] fontData = font.getFontData();
        FontData data = fontData[0];
        String fontFamily = data.getName();
        int fontSize = data.getHeight();
        if (Window.getDefaultOrientation() == 0x4000000) {
            orientation = "rtl";
            rightAlign = "left";
            leftAlign = "right";
        }
        if (Locale.getDefault().getLanguage().equals(Locale.KOREAN.getLanguage())) {
            fontFamily = "sans-serif";
            ++fontSize;
        }
        if (OSUtils.isMac()) {
            fontSize -= 4;
        }
        value = ".bodyDir { direction: " + orientation + ";} .alignRight{text-align: " + rightAlign + ";}  .alignLeft{text-align: " + leftAlign + ";} .eclipseDefaultBGColor{ background: rgb(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + "); } .fontSettings {font-family: " + fontFamily + "; font-size: " + fontSize + "pt;}";
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("run: CSS: " + value);
        }
        return value;
    }
}

