/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui.util;

import com.ibm.collaboration.realtime.ui.util.AnimatedImageDescriptor;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.Bundle;

public class AnimatedToolImageJob
extends UIJob {
    private ImageDescriptor currentDescriptor;
    private int currentDelay;
    private ImageData[] imageData = null;
    private int currentFrame = -1;
    private final Bundle bundle;
    private final IPath path;
    private IToolBarManager manager;
    private String itemId;
    private int repeatCount = -1;
    private ImageLoader loader;

    public AnimatedToolImageJob(Bundle bundle, IPath path) {
        super("animatedJob");
        this.setSystem(true);
        this.bundle = bundle;
        this.path = path;
        this.currentDescriptor = ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)bundle, (IPath)path, null));
    }

    public ImageDescriptor getCurrentDescriptor() {
        return this.currentDescriptor;
    }

    public IStatus runInUIThread(IProgressMonitor arg0) {
        if (this.imageData == null) {
            try {
                this.loader = new ImageLoader();
                this.loader.load(FileLocator.openStream((Bundle)this.bundle, (IPath)this.path, (boolean)false));
                this.repeatCount = this.loader.repeatCount;
                this.imageData = this.loader.data;
            }
            catch (Exception exception) {}
        }
        if (this.imageData != null && this.imageData.length > 1) {
            this.currentDescriptor = this.getNextDescriptor();
            this.updateToolBar();
            this.schedule(this.currentDelay * 10);
        }
        return Status.OK_STATUS;
    }

    public void setToolBarManager(IToolBarManager manager) {
        this.manager = manager;
    }

    public void setContributionItemId(String id) {
        this.itemId = id;
    }

    protected void updateToolBar() {
        IContributionItem item;
        if (this.manager != null && this.itemId != null && (item = this.manager.find(this.itemId)) != null) {
            item.update("image");
        }
    }

    private ImageDescriptor getNextDescriptor() {
        ++this.currentFrame;
        if (this.currentFrame >= this.imageData.length) {
            this.currentFrame = 0;
        }
        ImageData currData = this.imageData[this.currentFrame];
        ImageDescriptor desc = this.currentDescriptor;
        this.currentDescriptor = new AnimatedImageDescriptor(desc.getImageData(), currData);
        this.currentDelay = currData.delayTime;
        return this.currentDescriptor;
    }
}

