/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui.tableextension;

import com.ibm.collaboration.realtime.ui.tableextension.DynamicTableColumn;
import com.ibm.collaboration.realtime.ui.tableextension.DynamicTableExtension;
import com.ibm.collaboration.realtime.ui.tableextension.DynamicTableProvider;
import com.ibm.collaboration.realtime.ui.tableextension.TableCellSelectionListener;
import com.ibm.collaboration.realtime.ui.util.SwtUtils;
import com.ibm.collaboration.realtime.util.OSUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class DynamicTable {
    public static final String ID_DATA = "id";
    private TableViewer stableViewer;
    private ArrayList extensions;
    private ArrayList cellListeners;
    private TableCursor cursor;
    private Listener paintListener = null;
    private Listener selectionPaintListener = null;
    private int selectedColumn = 0;
    private int originalX = 0;
    private int originalStartX = 0;
    private int originalStartY = 0;
    private int originalEndX = 0;
    private int originalEndY = 0;
    private int originalY = 0;
    static final int MOVEOFFSET = 3;
    private final Point lastEventPoint = new Point(0, 0);
    private boolean resizing = false;
    private int preCursor = -1;
    private Color previousColor = null;

    public void createControl(Composite parent, int style) {
        this.stableViewer = new TableViewer(parent, style);
        this.stableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof ArrayList) {
                    return ((ArrayList)inputElement).toArray();
                }
                return null;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.stableViewer.setLabelProvider((IBaseLabelProvider)new DynamicTableProvider(this));
        this.stableViewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent arg0) {
                TableItem item;
                DynamicTable.this.cursor.setVisible(false);
                Table stable = DynamicTable.this.stableViewer.getTable();
                if (stable.getSelection() != null && stable.getSelection().length > 0 && (item = stable.getSelection()[0]) != null) {
                    int i = 0;
                    while (i < stable.getColumnCount()) {
                        if (item.getBounds(i).contains(arg0.x, arg0.y)) {
                            Point pt = stable.toDisplay(item.getBounds((int)i).x, item.getBounds((int)i).y);
                            TableCellSelectionListener[] listeners = DynamicTable.this.getCellListeners(i);
                            if (listeners != null) {
                                Object data;
                                Event e = new Event();
                                e.button = arg0.button;
                                e.item = item;
                                e.widget = stable;
                                e.detail = i;
                                e.x = pt.x;
                                e.y = pt.y;
                                e.height = item.getBounds((int)i).height;
                                e.data = data = item.getData();
                                int l = 0;
                                while (l < listeners.length) {
                                    listeners[l].handleEvent(e);
                                    ++l;
                                }
                                return;
                            }
                        }
                        ++i;
                    }
                }
            }
        });
        this.paintListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 41: {
                        TableItem item = (TableItem)event.item;
                        int index = event.index;
                        Image im = (Image)item.getData("image" + index);
                        if (im == null) break;
                        Rectangle rect = im.getBounds();
                        event.width += rect.width;
                        event.height = Math.max(event.height, rect.height + 2);
                        break;
                    }
                    case 42: {
                        int x = event.x;
                        TableItem item = (TableItem)event.item;
                        int index = event.index;
                        Image im = (Image)item.getData("image" + index);
                        TableColumn col = DynamicTable.this.stableViewer.getTable().getColumn(index);
                        if (im == null) break;
                        Rectangle rect = im.getBounds();
                        int offset = Math.max(0, (event.height - rect.height) / 2);
                        int xoffset = 0;
                        xoffset = col.getAlignment() == 16384 ? 0 : Math.max(0, (col.getWidth() - rect.width) / 2);
                        event.gc.drawImage(im, x + xoffset, event.y + offset);
                        break;
                    }
                    case 40: {
                        int width;
                        if ((event.detail & 2) == 0 || !DynamicTable.this.stableViewer.getTable().isFocusControl()) break;
                        GC gc = event.gc;
                        Rectangle area = DynamicTable.this.stableViewer.getTable().getClientArea();
                        int columnCount = DynamicTable.this.stableViewer.getTable().getColumnCount();
                        if ((event.index == columnCount - 1 || columnCount == 0) && (width = area.x + area.width - event.x) > 0) {
                            Region region = new Region();
                            gc.getClipping(region);
                            region.add(event.x, event.y, width, event.height);
                            gc.setClipping(region);
                            region.dispose();
                        }
                        Rectangle rect = event.getBounds();
                        Color fore = gc.getForeground();
                        Color back = gc.getBackground();
                        if (DynamicTable.this.stableViewer.getTable().isFocusControl()) {
                            gc.setForeground(DynamicTable.this.stableViewer.getTable().getDisplay().getSystemColor(27));
                            gc.setBackground(DynamicTable.this.stableViewer.getTable().getDisplay().getSystemColor(26));
                        }
                        gc.fillRectangle(0, rect.y, area.width, rect.height);
                        gc.setForeground(fore);
                        gc.setBackground(back);
                    }
                }
            }
        };
        this.stableViewer.getTable().addListener(41, this.paintListener);
        this.stableViewer.getTable().addListener(42, this.paintListener);
        if (OSUtils.isWin32()) {
            this.stableViewer.getTable().addListener(40, this.paintListener);
        }
        this.stableViewer.getTable().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent event) {
                TableItem item = DynamicTable.this.stableViewer.getTable().getItem(new Point(event.x, event.y));
                if (item != null) {
                    int i = 0;
                    while (i < DynamicTable.this.stableViewer.getTable().getColumnCount()) {
                        IBaseLabelProvider provider;
                        if (item.getBounds(i).contains(event.x, event.y) && (provider = DynamicTable.this.getTableViewer().getLabelProvider()) instanceof DynamicTableProvider) {
                            DynamicTableProvider labelProv = (DynamicTableProvider)provider;
                            DynamicTable.this.stableViewer.getTable().setToolTipText(labelProv.getColumnToolTipText(item.getData(), i));
                            return;
                        }
                        ++i;
                    }
                }
            }
        });
        this.selectionPaintListener = new Listener(){
            private Rectangle mouseSelectionRect;
            private boolean mouseDown = false;
            private int mouseButtonDown = 0;
            private TableItem[] currSelectionItems;

            public void handleEvent(Event evt) {
                switch (evt.type) {
                    case 3: {
                        this.mouseSelectionRect = new Rectangle(evt.x, evt.y, 1, 1);
                        this.mouseDown = true;
                        this.mouseButtonDown = evt.button;
                        this.currSelectionItems = DynamicTable.this.stableViewer.getTable().getSelection();
                        break;
                    }
                    case 4: {
                        this.mouseSelectionRect = null;
                        this.mouseDown = false;
                        this.currSelectionItems = null;
                        DynamicTable.this.stableViewer.getTable().redraw();
                        break;
                    }
                    case 5: {
                        if (!this.mouseDown || this.mouseButtonDown != 1) {
                            return;
                        }
                        if (evt.x > 0 && evt.x < ((DynamicTable)DynamicTable.this).stableViewer.getTable().getClientArea().width) {
                            this.mouseSelectionRect.width = evt.x - this.mouseSelectionRect.x;
                        }
                        if (evt.y > 20 && evt.y < ((DynamicTable)DynamicTable.this).stableViewer.getTable().getClientArea().height) {
                            this.mouseSelectionRect.height = evt.y - this.mouseSelectionRect.y;
                        }
                        ArrayList testResults = DynamicTable.this.hitTest(this.mouseSelectionRect);
                        ArrayList<Object> newSelections = new ArrayList<Object>();
                        if (testResults.size() > 0) {
                            boolean ctrl;
                            boolean bl = ctrl = (evt.stateMask & 0x40000) > 0;
                            if (ctrl) {
                                List<TableItem> currSels = Arrays.asList(this.currSelectionItems);
                                HashSet<TableItem> tmpSelections = new HashSet<TableItem>();
                                tmpSelections.addAll(testResults);
                                tmpSelections.addAll(currSels);
                                for (TableItem sel : testResults) {
                                    if (!currSels.contains(sel)) continue;
                                    tmpSelections.remove(sel);
                                }
                                for (TableItem it : tmpSelections) {
                                    newSelections.add(it.getData());
                                }
                            } else {
                                for (TableItem it : testResults) {
                                    newSelections.add(it.getData());
                                }
                            }
                            StructuredSelection sels = new StructuredSelection(newSelections);
                            DynamicTable.this.stableViewer.setSelection((ISelection)sels, true);
                        } else {
                            List<TableItem> currSels = Arrays.asList(this.currSelectionItems);
                            for (TableItem it : currSels) {
                                newSelections.add(it.getData());
                            }
                            StructuredSelection sels = new StructuredSelection(newSelections);
                            DynamicTable.this.stableViewer.setSelection((ISelection)sels, true);
                        }
                        DynamicTable.this.stableViewer.getTable().redraw();
                        break;
                    }
                    case 7: {
                        this.mouseSelectionRect = null;
                        this.mouseDown = false;
                        this.currSelectionItems = null;
                        DynamicTable.this.stableViewer.getTable().redraw();
                        break;
                    }
                    case 9: {
                        if (!this.mouseDown || this.mouseSelectionRect == null) {
                            return;
                        }
                        DynamicTable.this.stableViewer.getTable();
                        evt.gc.setForeground(DynamicTable.this.stableViewer.getTable().getDisplay().getSystemColor(2));
                        evt.gc.drawRectangle(this.mouseSelectionRect);
                    }
                }
            }
        };
        this.stableViewer.getTable().addListener(3, this.selectionPaintListener);
        this.stableViewer.getTable().addListener(4, this.selectionPaintListener);
        this.stableViewer.getTable().addListener(5, this.selectionPaintListener);
        this.stableViewer.getTable().addListener(9, this.selectionPaintListener);
        this.stableViewer.getTable().addListener(3, this.selectionPaintListener);
        this.stableViewer.getTable().addListener(7, this.selectionPaintListener);
        this.stableViewer.getTable().getParent().addListener(4, this.selectionPaintListener);
        this.cursor = new TableCursor(this.stableViewer.getTable(), 0);
        this.cursor.setBackground(this.stableViewer.getTable().getDisplay().getSystemColor(26));
        this.cursor.setForeground(this.stableViewer.getTable().getDisplay().getSystemColor(27));
        this.cursor.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                Image im = (Image)DynamicTable.this.cursor.getRow().getData("image" + DynamicTable.this.cursor.getColumn());
                if (im != null) {
                    Rectangle rect = im.getBounds();
                    int offset = Math.max(0, (event.height - rect.height) / 2);
                    int xoffset = Math.max(0, (event.width - rect.width) / 2);
                    event.gc.drawImage(im, event.x + xoffset, event.y + offset);
                }
            }
        });
        this.cursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection sel = new StructuredSelection(DynamicTable.this.cursor.getRow().getData());
                DynamicTable.this.stableViewer.setSelection((ISelection)sel, true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                DynamicTable.this.handleCellSelection((TypedEvent)e);
            }
        });
        this.cursor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                IStructuredSelection sel = (IStructuredSelection)DynamicTable.this.stableViewer.getSelection();
                DynamicTable.this.handleDoubleClick(sel);
            }

            public void mouseDown(MouseEvent arg0) {
                DynamicTable.this.handleCellSelection((TypedEvent)arg0);
            }
        });
        this.cursor.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent arg0) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.character == ' ') {
                    DynamicTable.this.handleCellSelection((TypedEvent)e);
                    return;
                }
                if (DynamicTable.this.preCursor == DynamicTable.this.cursor.getColumn()) {
                    if (DynamicTable.this.cursor.getColumn() == 0 && e.keyCode == 0x1000003) {
                        DynamicTable.this.cursor.setVisible(false);
                    } else if (DynamicTable.this.cursor.getColumn() == DynamicTable.this.stableViewer.getTable().getColumnCount() - 1 && e.keyCode == 0x1000004) {
                        DynamicTable.this.cursor.setVisible(false);
                    }
                }
                DynamicTable.this.preCursor = DynamicTable.this.cursor.getColumn();
            }
        });
        this.cursor.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent event) {
                TableItem item = DynamicTable.this.cursor.getRow();
                if (item != null) {
                    int i = 0;
                    while (i < DynamicTable.this.stableViewer.getTable().getColumnCount()) {
                        IBaseLabelProvider provider;
                        if (item.getBounds(i).contains(event.x, event.y) && (provider = DynamicTable.this.getTableViewer().getLabelProvider()) instanceof DynamicTableProvider) {
                            DynamicTableProvider labelProv = (DynamicTableProvider)provider;
                            DynamicTable.this.stableViewer.getTable().setToolTipText(labelProv.getColumnToolTipText(item.getData(), i));
                            return;
                        }
                        ++i;
                    }
                }
            }
        });
        this.cursor.setVisible(false);
        this.stableViewer.getTable().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent arg0) {
                if (DynamicTable.this.stableViewer.getTable().getSelectionCount() > 0) {
                    if (DynamicTable.this.stableViewer.getTable().getSelectionCount() == 1) {
                        TableItem cfr_ignored_0 = DynamicTable.this.stableViewer.getTable().getSelection()[0];
                    }
                } else if (DynamicTable.this.stableViewer.getTable().getItemCount() > 0) {
                    StructuredSelection sel = new StructuredSelection(DynamicTable.this.stableViewer.getTable().getItem(0).getData());
                    DynamicTable.this.stableViewer.setSelection((ISelection)sel);
                }
            }

            public void focusLost(FocusEvent arg0) {
                DynamicTable.this.stableViewer.getTable().redraw();
            }
        });
        this.stableViewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DynamicTable.this.dispose();
            }
        });
        this.stableViewer.getTable().addListener(2, new Listener(){

            public void handleEvent(Event e) {
                if (e.keyCode == 65536) {
                    if (SwtUtils.usingHighContrast()) {
                        DynamicTable.this.stableViewer.getTable().redraw();
                    } else {
                        Event event = new Event();
                        event.type = 5;
                        event.x = ((DynamicTable)DynamicTable.this).lastEventPoint.x;
                        event.y = ((DynamicTable)DynamicTable.this).lastEventPoint.y;
                        Display.getCurrent().post(event);
                    }
                } else if (!DynamicTable.this.resizing) {
                    if (e.keyCode == 0x1000004) {
                        TableItem item = DynamicTable.this.stableViewer.getTable().getSelection()[0];
                        DynamicTable.this.cursor.setSelection(item, 0);
                        DynamicTable.this.cursor.setVisible(true);
                        DynamicTable.this.cursor.setFocus();
                        DynamicTable.this.preCursor = -1;
                    } else if (e.keyCode == 0x1000003) {
                        TableItem item = DynamicTable.this.stableViewer.getTable().getSelection()[0];
                        DynamicTable.this.cursor.setSelection(item, DynamicTable.this.stableViewer.getTable().getColumnCount() - 1);
                        DynamicTable.this.cursor.setVisible(true);
                        DynamicTable.this.cursor.setFocus();
                        DynamicTable.this.preCursor = -1;
                    }
                } else if (e.keyCode == 0x1000001 || e.keyCode == 0x1000002) {
                    DynamicTable.this.resizing = false;
                }
            }
        });
        this.stableViewer.getTable().addListener(1, new Listener(){

            public void handleEvent(Event e) {
                int scrollbarOffset = 0;
                if (DynamicTable.this.stableViewer.getTable().getHorizontalBar().getVisible()) {
                    scrollbarOffset = DynamicTable.this.stableViewer.getTable().getHorizontalBar().getSelection();
                }
                int columnCount = DynamicTable.this.stableViewer.getTable().getColumnCount();
                if (e.keyCode == 65536 && !DynamicTable.this.resizing) {
                    DynamicTable.this.resizing = true;
                    if (SwtUtils.usingHighContrast()) {
                        DynamicTable.this.drawColumnLine(DynamicTable.this.selectedColumn);
                    } else {
                        DynamicTable.this.postEventAtColumn(DynamicTable.this.selectedColumn);
                    }
                }
                if (DynamicTable.this.resizing) {
                    if (e.keyCode == 0x1000003) {
                        if ((e.stateMask & 0x10000) != 0 && DynamicTable.this.selectedColumn > 0) {
                            DynamicTable dynamicTable = DynamicTable.this;
                            dynamicTable.selectedColumn = dynamicTable.selectedColumn - 1;
                            if (SwtUtils.usingHighContrast()) {
                                DynamicTable.this.stableViewer.getTable().redraw();
                                Display.getCurrent().asyncExec(new Runnable(){

                                    public void run() {
                                        DynamicTable.this.drawColumnLine(DynamicTable.this.selectedColumn);
                                    }
                                });
                            } else {
                                DynamicTable.this.postEventAtColumn(DynamicTable.this.selectedColumn);
                            }
                        } else {
                            if (DynamicTable.this.selectedColumn == 0 && DynamicTable.this.stableViewer.getTable().getHorizontalBar().isVisible() && scrollbarOffset == 0 || DynamicTable.this.selectedColumn == columnCount - 1 && DynamicTable.this.stableViewer.getTable().getHorizontalBar().isVisible()) {
                                e.doit = false;
                            }
                            DynamicTable.this.stableViewer.getTable().getColumn(DynamicTable.this.selectedColumn).setWidth(DynamicTable.this.stableViewer.getTable().getColumn(DynamicTable.this.selectedColumn).getWidth() - 3);
                        }
                    }
                    if (e.keyCode == 0x1000004) {
                        if ((e.stateMask & 0x10000) != 0 && DynamicTable.this.selectedColumn < columnCount - 1) {
                            DynamicTable dynamicTable = DynamicTable.this;
                            dynamicTable.selectedColumn = dynamicTable.selectedColumn + 1;
                            if (SwtUtils.usingHighContrast()) {
                                DynamicTable.this.stableViewer.getTable().redraw();
                                Display.getCurrent().asyncExec(new Runnable(){

                                    public void run() {
                                        DynamicTable.this.drawColumnLine(DynamicTable.this.selectedColumn);
                                    }
                                });
                            } else {
                                DynamicTable.this.postEventAtColumn(DynamicTable.this.selectedColumn);
                            }
                        } else {
                            if (DynamicTable.this.selectedColumn == 0 && DynamicTable.this.stableViewer.getTable().getHorizontalBar().isVisible()) {
                                e.doit = false;
                            }
                            DynamicTable.this.stableViewer.getTable().getColumn(DynamicTable.this.selectedColumn).setWidth(DynamicTable.this.stableViewer.getTable().getColumn(DynamicTable.this.selectedColumn).getWidth() + 3);
                        }
                    }
                }
            }
        });
        if (this.extensions != null) {
            int i = 0;
            while (i < this.extensions.size()) {
                DynamicTableExtension ext = (DynamicTableExtension)this.extensions.get(i);
                this.createExtension(ext);
                ++i;
            }
        }
    }

    protected ArrayList hitTest(Rectangle mouseSelectionRect) {
        Rectangle absSelectionRect = new Rectangle(mouseSelectionRect.x, mouseSelectionRect.y, mouseSelectionRect.width, mouseSelectionRect.height);
        ArrayList<TableItem> ret = new ArrayList<TableItem>();
        if (absSelectionRect.width < 0) {
            absSelectionRect.x += absSelectionRect.width;
            absSelectionRect.width = Math.abs(absSelectionRect.width);
        }
        if (absSelectionRect.height < 0) {
            absSelectionRect.y += absSelectionRect.height;
            absSelectionRect.height = Math.abs(absSelectionRect.height);
        }
        Rectangle clientArea = this.stableViewer.getTable().getClientArea();
        int topIndex = this.stableViewer.getTable().getTopIndex();
        int totalLines = this.stableViewer.getTable().getItemCount();
        TableItem[] items = this.stableViewer.getTable().getItems();
        int columns = this.stableViewer.getTable().getColumnCount();
        int i = topIndex;
        while (i < totalLines) {
            Rectangle itemRect = items[i].getBounds(0);
            int j = 1;
            while (j < columns) {
                Rectangle itemColRect = items[i].getBounds(j);
                itemRect = itemRect.union(itemColRect);
                ++j;
            }
            if (itemRect.intersects(clientArea) && itemRect.intersects(absSelectionRect)) {
                ret.add(items[i]);
            }
            ++i;
        }
        return ret;
    }

    public void drawColumnLine(int columnIndex) {
        Point tablePoint = this.stableViewer.getTable().getLocation();
        int tableBorderWidth = this.stableViewer.getTable().getBorderWidth();
        int scrollbarOffset = 0;
        if (this.stableViewer.getTable().getHorizontalBar().getVisible()) {
            scrollbarOffset = this.stableViewer.getTable().getHorizontalBar().getSelection();
        }
        int columnOffset = 0;
        if (columnIndex > 0) {
            int i = 0;
            while (i < columnIndex) {
                columnOffset += this.stableViewer.getTable().getColumn(i).getWidth();
                ++i;
            }
        }
        int currentColumnWidth = this.stableViewer.getTable().getColumn(columnIndex).getWidth();
        this.originalStartX = tableBorderWidth + tablePoint.x + columnOffset - scrollbarOffset - 3;
        this.originalStartY = tableBorderWidth + tablePoint.y;
        this.originalEndX = tableBorderWidth + tablePoint.x + columnOffset + currentColumnWidth - scrollbarOffset - 3;
        this.originalEndY = tableBorderWidth + tablePoint.y;
        GC gc = new GC((Drawable)this.stableViewer.getTable(), 0);
        gc.drawRectangle(this.originalStartX, this.originalStartY, 3, this.stableViewer.getTable().getBounds().height);
        gc.drawRectangle(this.originalEndX, this.originalEndY, 3, this.stableViewer.getTable().getBounds().height);
        gc.dispose();
    }

    public Point getAbsolutePoint(Control control, Point incPoint) {
        if (!(control.getParent() instanceof Shell)) {
            incPoint.x += control.getParent().getLocation().x;
            incPoint.y += control.getParent().getLocation().y;
            return this.getAbsolutePoint((Control)control.getParent(), incPoint);
        }
        return incPoint;
    }

    public void postEventAtColumn(int columnIndex) {
        Shell shell = this.stableViewer.getTable().getParent().getShell();
        Point shellPoint = shell.getLocation();
        Point miniSize = shell.getMinimumSize();
        Point tablePoint = this.getAbsolutePoint((Control)this.stableViewer.getTable(), this.stableViewer.getTable().getLocation());
        int shellBorderWidth = shell.getBorderWidth();
        int tableBorderWidth = this.stableViewer.getTable().getBorderWidth();
        int columnOffset = 0;
        int scrollbarOffset = 0;
        if (this.stableViewer.getTable().getHorizontalBar().getVisible()) {
            scrollbarOffset = this.stableViewer.getTable().getHorizontalBar().getSelection();
        }
        if (columnIndex > 0) {
            int i = 0;
            while (i < columnIndex) {
                columnOffset += this.stableViewer.getTable().getColumn(i).getWidth();
                ++i;
            }
        }
        int currentColumnWidth = this.stableViewer.getTable().getColumn(columnIndex).getWidth();
        this.originalX = shellPoint.x + shellBorderWidth + tableBorderWidth + tablePoint.x + columnOffset + currentColumnWidth / 2 - scrollbarOffset;
        this.originalY = shellPoint.y + shellBorderWidth + tableBorderWidth + miniSize.y + tablePoint.y;
        this.lastEventPoint.x = this.originalX;
        this.lastEventPoint.y = this.originalY + this.stableViewer.getTable().getHeaderHeight();
        Event event = new Event();
        event.type = 5;
        event.x = this.originalX;
        event.y = this.originalY;
        Display.getCurrent().post(event);
    }

    public TableColumn addColumn(String label, int index, int alignment, int width) {
        Table table = this.stableViewer.getTable();
        if (table != null) {
            TableColumn column = new TableColumn(table, alignment);
            column.setText(label);
            column.setWidth(width);
            return column;
        }
        return null;
    }

    public TableColumn addColumn(DynamicTableColumn col) {
        Table table = this.stableViewer.getTable();
        if (table != null) {
            TableColumn column = new TableColumn(table, col.alignment);
            if (col.label != null) {
                column.setText(col.label);
            }
            if (col.image != null) {
                column.setImage(col.image);
            }
            if (col.tooltip != null) {
                column.setToolTipText(col.tooltip);
            }
            if (col.id != null) {
                column.setData(ID_DATA, (Object)col.id);
            }
            column.setWidth(col.width);
            return column;
        }
        return null;
    }

    public void addExtension(DynamicTableExtension ext) {
        if (this.extensions == null) {
            this.extensions = new ArrayList(5);
        }
        this.extensions.add(ext);
        if (this.stableViewer != null) {
            this.createExtension(ext);
        }
    }

    private void createExtension(DynamicTableExtension ext) {
        int i;
        int existingColumns;
        int n = existingColumns = this.stableViewer != null ? this.stableViewer.getTable().getColumnCount() : 0;
        if (ext.getLabelProvider() != null) {
            ext.getLabelProvider().setTable(this, ext);
        }
        if (ext.getExtraColumns() != null) {
            i = 0;
            while (i < ext.getExtraColumns().length) {
                Image im;
                String label;
                TableColumn column = new TableColumn(this.stableViewer.getTable(), ext.getExtraColumns()[i].alignment);
                String id = ext.getExtraColumns()[i].id;
                if (id != null) {
                    column.setData(ID_DATA, (Object)id);
                }
                if ((label = ext.getExtraColumns()[i].label) != null) {
                    column.setText(label);
                }
                if ((im = ext.getExtraColumns()[i].image) != null) {
                    column.setImage(im);
                }
                column.setWidth(ext.getExtraColumns()[i].width);
                String tooltip = ext.getExtraColumns()[i].tooltip;
                if (tooltip != null) {
                    column.setToolTipText(tooltip);
                }
                ++i;
            }
        }
        if (ext.getTableCellListeners() != null) {
            i = 0;
            while (i < ext.getTableCellListeners().length) {
                TableCellSelectionListener listener = ext.getTableCellListeners()[i];
                if (!listener.isReindexed()) {
                    listener.setColumnIndex(existingColumns + listener.getColumnIndex());
                    listener.setReindexed(true);
                }
                this.addTableCellListener(listener);
                ++i;
            }
        }
    }

    public void addTableCellListener(TableCellSelectionListener listener) {
        if (this.cellListeners == null) {
            this.cellListeners = new ArrayList(5);
        }
        this.cellListeners.add(listener);
    }

    public void removeTableCellListener(TableCellSelectionListener listener) {
        if (this.cellListeners == null) {
            return;
        }
        this.cellListeners.remove(listener);
    }

    public void add(Object object) {
        this.stableViewer.add(object);
    }

    public TableCellSelectionListener[] getCellSelectionListeners() {
        if (this.cellListeners == null) {
            return null;
        }
        return this.cellListeners.toArray(new TableCellSelectionListener[this.cellListeners.size()]);
    }

    public int getWidth() {
        Table stable = this.stableViewer.getTable();
        if (stable != null) {
            int total = 0;
            int i = 0;
            while (i < stable.getColumnCount()) {
                TableColumn col = stable.getColumn(i);
                total += col.getWidth();
                ++i;
            }
            return total;
        }
        return -1;
    }

    public TableViewer getTableViewer() {
        return this.stableViewer;
    }

    public Table getTable() {
        return this.stableViewer.getTable();
    }

    public TableColumn getColumn(DynamicTableExtension ext, int relativeIndex) {
        DynamicTableExtension[] extensions = this.getExtensions();
        int count = 0;
        int i = 0;
        while (i < extensions.length) {
            int index;
            DynamicTableExtension extension = extensions[i];
            if (ext == extension && (index = count + relativeIndex) < this.getTable().getColumnCount()) {
                return this.getTable().getColumn(index);
            }
            count += extension.getColumnCount();
            ++i;
        }
        return null;
    }

    public int getColumnIndex(DynamicTableExtension ext, int relativeIndex) {
        DynamicTableExtension[] extensions = this.getExtensions();
        int count = 0;
        int i = 0;
        while (i < extensions.length) {
            int index;
            DynamicTableExtension extension = extensions[i];
            if (ext == extension && (index = count + relativeIndex) < this.getTable().getColumnCount()) {
                return index;
            }
            count += extension.getColumnCount();
            ++i;
        }
        return relativeIndex;
    }

    public TableCellSelectionListener[] getCellListeners(int columnIndex) {
        if (this.cellListeners != null) {
            ArrayList<TableCellSelectionListener> temp = new ArrayList<TableCellSelectionListener>(5);
            for (TableCellSelectionListener listener : this.cellListeners) {
                if (columnIndex != listener.getColumnIndex()) continue;
                temp.add(listener);
            }
            if (temp.size() > 0) {
                TableCellSelectionListener[] listeners = temp.toArray(new TableCellSelectionListener[temp.size()]);
                temp = null;
                return listeners;
            }
            Object var2_2 = null;
        }
        return null;
    }

    public DynamicTableExtension[] getExtensions() {
        if (this.extensions == null) {
            return null;
        }
        return this.extensions.toArray(new DynamicTableExtension[this.extensions.size()]);
    }

    public void dispose() {
        if (this.extensions != null) {
            int i = 0;
            while (i < this.extensions.size()) {
                DynamicTableExtension ext = (DynamicTableExtension)this.extensions.get(i);
                if (ext.getLabelProvider() != null) {
                    ext.getLabelProvider().dispose();
                }
                ++i;
            }
        }
    }

    protected void handleDoubleClick(IStructuredSelection sel) {
    }

    protected void handleCellSelection(TypedEvent arg0) {
        TableItem item = this.stableViewer.getTable().getSelection()[0];
        int i = this.cursor.getColumn();
        Point pt = this.stableViewer.getTable().toDisplay(item.getBounds((int)i).x, item.getBounds((int)i).y);
        TableCellSelectionListener[] listeners = this.getCellListeners(i);
        if (listeners != null) {
            Event e = new Event();
            e.item = item;
            e.widget = this.stableViewer.getTable();
            e.detail = i;
            e.x = pt.x;
            e.y = pt.y;
            e.height = item.getBounds((int)i).height;
            e.data = item.getData();
            int l = 0;
            while (l < listeners.length) {
                listeners[l].handleEvent(e);
                ++l;
            }
            return;
        }
    }

    public TableCursor getTableCursor() {
        return this.cursor;
    }

    private void setEnablePaintListeners(boolean enable) {
        if (enable) {
            this.stableViewer.getTable().addListener(41, this.paintListener);
            this.stableViewer.getTable().addListener(42, this.paintListener);
            this.stableViewer.getTable().addListener(40, this.paintListener);
        } else {
            this.stableViewer.getTable().removeListener(41, this.paintListener);
            this.stableViewer.getTable().removeListener(42, this.paintListener);
            this.stableViewer.getTable().removeListener(40, this.paintListener);
        }
    }

    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.setEnablePaintListeners(false);
            this.previousColor = this.stableViewer.getTable().getBackground();
            this.stableViewer.getTable().setBackground(this.stableViewer.getTable().getDisplay().getSystemColor(22));
        } else {
            this.stableViewer.getTable().setBackground(this.previousColor);
            this.setEnablePaintListeners(true);
        }
        this.stableViewer.getTable().setEnabled(enabled);
    }

    public void select(int index) {
        if (this.stableViewer.getTable().getItemCount() > index) {
            TableItem item = this.stableViewer.getTable().getItem(index);
            StructuredSelection sel = new StructuredSelection(item.getData());
            this.stableViewer.setSelection((ISelection)sel);
        }
    }

    public void setComparator(ViewerComparator arg0) {
        this.stableViewer.setComparator(arg0);
    }
}

