/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui.internal.registry;

import com.ibm.collaboration.realtime.ui.UiPlugin;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.ui.internal.registry.ActionSetDescriptor;

public class ActionSetAdapter {
    private static ActionSetAdapter adapter = new ActionSetAdapter();
    private static final Logger logger = Logger.getLogger(ActionSetAdapter.class.getPackage().getName());
    private static final String CONVERSTION_APPENDAGE = ".stc";
    private final HashMap rcpToStPaths = new HashMap(2);
    private final HashMap rcpToStAdditions = new HashMap(2);
    private final ArrayList convertedActionSets = new ArrayList();

    private ActionSetAdapter() {
        this.rcpToStPaths.put("com.ibm.rcp.ui.viewmenu", "views");
        this.rcpToStPaths.put("com.ibm.rcp.ui.toolsmenu", "tools");
        this.rcpToStAdditions.put("tools_additions", "additions");
    }

    static ActionSetAdapter getInstance() {
        return adapter;
    }

    void fixupActionSetPartAssociations(IConfigurationElement actionSetPartElmt) {
        if (!UiPlugin.getDefault().useActionSetAdapter()) {
            return;
        }
        String actionSetId = actionSetPartElmt.getAttribute("targetID");
        if (!this.isConvertedActionSet(actionSetPartElmt, actionSetId)) {
            return;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.fine("Found actionSetPartAssociation requiring conversion for actionSet: " + actionSetId);
        }
        String convertActionSetPartXml = this.convertActionSetPart(actionSetPartElmt, actionSetId);
        this.addContribution(convertActionSetPartXml, actionSetPartElmt);
    }

    private boolean isConvertedActionSet(IConfigurationElement actionSetPartElmt, String actionSetId) {
        String id = this.getActionSetIdWithNameSpace(actionSetPartElmt, actionSetId);
        return this.convertedActionSets.contains(id);
    }

    private String convertActionSetPart(IConfigurationElement actionSetPartElmt, String actionSetId) {
        String convertedActionSetPart = null;
        IConfigurationElement[] children = actionSetPartElmt.getChildren();
        int j = 0;
        while (j < children.length) {
            String partId;
            IConfigurationElement child = children[j];
            if (child.getName().equals("part") && (partId = child.getAttribute("id")) != null) {
                StringBuffer sb = new StringBuffer(4096);
                sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                sb.append("<plugin>");
                sb.append("<extension point=\"org.eclipse.ui.actionSetPartAssociations\">");
                sb.append("<actionSetPartAssociation targetID=\"" + actionSetId + CONVERSTION_APPENDAGE + "\">");
                sb.append("<part id=\"" + partId + "\"/>");
                sb.append("</actionSetPartAssociation>");
                sb.append("</extension>");
                sb.append("</plugin>");
                convertedActionSetPart = sb.toString();
                break;
            }
            ++j;
        }
        return convertedActionSetPart;
    }

    private void addContribution(String xml, IConfigurationElement configElmt) {
        try {
            IExtensionRegistry reg = RegistryFactory.getRegistry();
            Object key = ((ExtensionRegistry)reg).getTemporaryUserToken();
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            IContributor contrib = configElmt.getContributor();
            reg.addContribution((InputStream)is, contrib, false, null, null, key);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception adding converted actionset menuPath to registry.", e);
        }
    }

    void fixupActionSetPaths(ActionSetDescriptor desc) {
        if (!UiPlugin.getDefault().useActionSetAdapter()) {
            return;
        }
        IConfigurationElement configElmt = desc.getConfigurationElement();
        IConfigurationElement[] children = configElmt.getChildren();
        boolean needfixup = false;
        String path = null;
        int k = 0;
        while (k < children.length) {
            IConfigurationElement actionSetChild = children[k];
            if ("menu".equals(actionSetChild.getName())) {
                path = actionSetChild.getAttribute("path");
                actionSetChild.getAttribute("id");
                if (path != null && this.pathIsRcp(path)) {
                    needfixup = true;
                    break;
                }
            } else if ("action".equals(actionSetChild.getName()) && (path = actionSetChild.getAttribute("menubarPath")) != null && this.pathIsRcp(path)) {
                needfixup = true;
                break;
            }
            ++k;
        }
        if (needfixup) {
            if (logger.isLoggable(Level.FINER)) {
                String id = this.getActionSetIdWithNameSpace(configElmt, desc.getId());
                logger.finer("Converting ActionSet from RCP to ST menuPath: " + id);
            }
            String convertedActionSetXml = this.convertActionSet(desc);
            this.addContribution(convertedActionSetXml, configElmt);
        }
    }

    private boolean pathIsRcp(String path) {
        for (String str : this.rcpToStPaths.keySet()) {
            if (path.indexOf(String.valueOf(str) + "/") != 0) continue;
            return true;
        }
        return false;
    }

    private String convertActionSet(ActionSetDescriptor desc) {
        try {
            StringBuffer sb = new StringBuffer(4096);
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            sb.append("<plugin>");
            sb.append("<extension point=\"org.eclipse.ui.actionSets\">");
            IConfigurationElement actionSetChild = desc.getConfigurationElement();
            actionSetChild.getChildren();
            this.addConvertedActionSet(desc);
            sb.append("<actionSet");
            if (desc.getId() != null) {
                sb.append(" id=\"");
                String convertedId = String.valueOf(desc.getId()) + CONVERSTION_APPENDAGE;
                sb.append(convertedId);
                sb.append("\" ");
            }
            if (desc.getLabel() != null) {
                sb.append(" label=\"");
                sb.append(desc.getLabel());
                sb.append("\"");
            }
            if (desc.isInitiallyVisible()) {
                sb.append(" visible=\"");
                sb.append(desc.isInitiallyVisible());
                sb.append("\"");
            }
            sb.append(">\n");
            IConfigurationElement[] menuOrAction = actionSetChild.getChildren();
            if (menuOrAction != null) {
                int m = 0;
                while (m < menuOrAction.length) {
                    String stPath;
                    String path;
                    String[] atts;
                    IConfigurationElement ma = menuOrAction[m];
                    if ("menu".equals(ma.getName())) {
                        atts = ma.getAttributeNames();
                        sb.append("<menu");
                        if (atts != null) {
                            int i = 0;
                            while (i < atts.length) {
                                if ("path".equals(atts[i])) {
                                    path = ma.getAttribute(atts[i]);
                                    stPath = this.getStPath(path, true);
                                    if (stPath != null) {
                                        sb.append(" ");
                                        sb.append(atts[i]);
                                        sb.append("=\"");
                                        sb.append(stPath);
                                        sb.append("\"");
                                    }
                                } else {
                                    sb.append(" ");
                                    sb.append(atts[i]);
                                    sb.append("=\"");
                                    sb.append(this.escapeXML(ma.getAttribute(atts[i])));
                                    sb.append("\"");
                                }
                                ++i;
                            }
                        }
                        sb.append(">\n");
                        IConfigurationElement[] sep = ma.getChildren();
                        if (sep != null) {
                            this.copyChildren(sb, sep);
                        }
                        sb.append("</menu>\n");
                    } else if ("action".equals(ma.getName())) {
                        atts = ma.getAttributeNames();
                        sb.append("<action");
                        if (atts != null) {
                            int i = 0;
                            while (i < atts.length) {
                                if ("menubarPath".equals(atts[i])) {
                                    path = ma.getAttribute(atts[i]);
                                    stPath = this.getStPath(path, true);
                                    if (stPath == null) {
                                        stPath = path;
                                    }
                                    sb.append(" ");
                                    sb.append(atts[i]);
                                    sb.append("=\"");
                                    sb.append(stPath);
                                    sb.append("\"");
                                } else {
                                    String att = atts[i];
                                    String val = this.escapeXML(ma.getAttribute(att));
                                    sb.append(" ");
                                    sb.append(att);
                                    sb.append("=\"");
                                    sb.append(val);
                                    sb.append("\"");
                                }
                                ++i;
                            }
                        }
                        sb.append("/>\n");
                    }
                    ++m;
                }
            }
            sb.append("</actionSet>\n");
            sb.append("</extension>\n</plugin>");
            return sb.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void addConvertedActionSet(ActionSetDescriptor desc) {
        IConfigurationElement elmt = desc.getConfigurationElement();
        String id = this.getActionSetIdWithNameSpace(elmt, desc.getId());
        this.convertedActionSets.add(id);
    }

    private String getActionSetIdWithNameSpace(IConfigurationElement elmt, String actionSetId) {
        String namespace = elmt.getNamespaceIdentifier();
        return String.valueOf(namespace) + "::" + actionSetId;
    }

    private String getStPath(IConfigurationElement configElmt) {
        String stPath = null;
        String[] atts = configElmt.getAttributeNames();
        int i = 0;
        while (i < atts.length) {
            if ("menubarPath".equals(atts[i])) {
                String path = configElmt.getAttribute(atts[i]);
                stPath = this.getStPath(path, true);
                break;
            }
            ++i;
        }
        return stPath;
    }

    private String getStPath(String path, boolean replaceMarker) {
        String after;
        String addition;
        String menu = path.substring(0, path.indexOf("/"));
        String stPath = (String)this.rcpToStPaths.get(menu);
        if (replaceMarker && (addition = (String)this.rcpToStAdditions.get(after = path.substring(path.indexOf("/") + 1))) != null) {
            return String.valueOf(stPath) + "/" + addition;
        }
        return stPath != null ? String.valueOf(stPath) + path.substring(path.indexOf("/")) : null;
    }

    private void copyChildren(StringBuffer sb, IConfigurationElement[] kids) {
        if (kids != null) {
            int i = 0;
            while (i < kids.length) {
                sb.append("<");
                sb.append(kids[i].getName());
                this.copyAttributes(sb, kids[i]);
                sb.append(">\n");
                IConfigurationElement[] morekids = kids[i].getChildren();
                if (morekids != null && morekids.length > 0) {
                    this.copyChildren(sb, morekids);
                }
                sb.append("</");
                sb.append(kids[i].getName());
                sb.append(">\n");
                ++i;
            }
        }
    }

    private void copyAttributes(StringBuffer sb, IConfigurationElement element) {
        String[] atts = element.getAttributeNames();
        if (atts != null) {
            int i = 0;
            while (i < atts.length) {
                sb.append(" ");
                sb.append(atts[i]);
                sb.append("=\"");
                sb.append(this.escapeXML(element.getAttribute(atts[i])));
                sb.append("\" ");
                ++i;
            }
        }
    }

    private String escapeXML(String xml) {
        return xml.replaceAll("&", "&amp;");
    }
}

