/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui.dnd;

import com.ibm.collaboration.realtime.ui.dnd.ContributedDropTargetListener;
import com.ibm.collaboration.realtime.ui.dnd.TransferOperationContext;
import com.ibm.collaboration.realtime.ui.strings.LogMessages;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;

final class TransferDropTargetProxy
implements ContributedDropTargetListener {
    private static final Logger logger = Logger.getLogger(TransferDropTargetProxy.class.getName());
    private TransferOperationContext context = null;
    private final IConfigurationElement element;
    private ContributedDropTargetListener listener = null;

    public TransferDropTargetProxy(IConfigurationElement element) {
        this.element = element;
    }

    public void dragEnter(DropTargetEvent event) {
        this.lazyCreateListener();
        if (this.listener != null) {
            this.listener.dragEnter(event);
        }
    }

    public void dragLeave(DropTargetEvent event) {
        this.lazyCreateListener();
        if (this.listener != null) {
            this.listener.dragLeave(event);
        }
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.lazyCreateListener();
        if (this.listener != null) {
            this.listener.dragOperationChanged(event);
        }
    }

    public void dragOver(DropTargetEvent event) {
        this.lazyCreateListener();
        if (this.listener != null) {
            this.listener.dragOver(event);
        }
    }

    public void drop(DropTargetEvent event) {
        this.lazyCreateListener();
        if (this.listener != null) {
            this.listener.drop(event);
        }
    }

    public void dropAccept(DropTargetEvent event) {
        this.lazyCreateListener();
        if (this.listener != null) {
            this.listener.dropAccept(event);
        }
    }

    public Transfer getTransfer() {
        this.lazyCreateListener();
        if (this.listener != null) {
            return this.listener.getTransfer();
        }
        return null;
    }

    public boolean isEnabled(DropTargetEvent event) {
        this.lazyCreateListener();
        if (this.listener != null) {
            return this.listener.isEnabled(event);
        }
        return false;
    }

    private void lazyCreateListener() {
        block4: {
            if (this.listener == null) {
                try {
                    Object object = this.element.createExecutableExtension("class");
                    if (object instanceof ContributedDropTargetListener) {
                        ContributedDropTargetListener listener = (ContributedDropTargetListener)object;
                        listener.setContext(this.context);
                        this.listener = listener;
                    }
                }
                catch (CoreException exception) {
                    if (!logger.isLoggable(Level.WARNING)) break block4;
                    logger.log(Level.WARNING, LogMessages.TransferDropTargetProxy_1, exception);
                }
            }
        }
    }

    public void setContext(TransferOperationContext context) {
        this.context = context;
        this.lazyCreateListener();
        if (this.listener != null) {
            this.listener.setContext(context);
        }
    }

    public Class getPreferredContextClass() {
        this.lazyCreateListener();
        if (this.listener != null) {
            return this.listener.getPreferredContextClass();
        }
        return null;
    }

    protected ContributedDropTargetListener getListener() {
        return this.listener;
    }
}

