/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui.dnd;

import com.ibm.collaboration.realtime.ui.dnd.ContributedDragSourceListener;
import com.ibm.collaboration.realtime.ui.dnd.TransferOperationContext;
import com.ibm.collaboration.realtime.ui.strings.LogMessages;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;

final class TransferDragSourceProxy
implements ContributedDragSourceListener {
    private static final Logger logger = Logger.getLogger(TransferDragSourceProxy.class.getName());
    private TransferOperationContext context = null;
    private final IConfigurationElement element;
    private ContributedDragSourceListener listener;

    public TransferDragSourceProxy(IConfigurationElement element) {
        this.element = element;
    }

    public void dragFinished(DragSourceEvent event) {
        this.lazyCreateListener();
        if (this.listener != null) {
            this.listener.dragFinished(event);
        }
    }

    public void dragSetData(DragSourceEvent event) {
        this.lazyCreateListener();
        if (this.listener != null) {
            this.listener.dragSetData(event);
        }
    }

    public void dragStart(DragSourceEvent event) {
        this.lazyCreateListener();
        if (this.listener != null) {
            this.listener.dragStart(event);
        }
    }

    public Transfer getTransfer() {
        this.lazyCreateListener();
        if (this.listener != null) {
            return this.listener.getTransfer();
        }
        return null;
    }

    private void lazyCreateListener() {
        block4: {
            if (this.listener == null) {
                try {
                    Object object = this.element.createExecutableExtension("class");
                    if (object instanceof ContributedDragSourceListener) {
                        ContributedDragSourceListener listener = (ContributedDragSourceListener)object;
                        listener.setContext(this.context);
                        this.listener = listener;
                    }
                }
                catch (CoreException exception) {
                    if (!logger.isLoggable(Level.WARNING)) break block4;
                    logger.log(Level.WARNING, LogMessages.TransferDragSourceProxy_1, exception);
                }
            }
        }
    }

    public void setContext(TransferOperationContext context) {
        this.context = context;
    }
}

