/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui.dnd;

import com.ibm.collaboration.realtime.ui.dnd.DefaultTransferListener;
import com.ibm.collaboration.realtime.ui.dnd.DragAndDropSupportRegistry;
import com.ibm.collaboration.realtime.ui.dnd.TransferDropTargetProxy;
import com.ibm.collaboration.realtime.ui.dnd.TransferOperationContext;
import org.eclipse.jface.util.DelegatingDropAdapter;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class ExtendibleDropTargetListener
extends DelegatingDropAdapter {
    private final TransferOperationContext context;
    private TransferDropTargetListener[] fListeners;
    private TransferDropTargetListener fChosenListener;

    public ExtendibleDropTargetListener(TransferOperationContext context) {
        this.context = context;
    }

    public void dragEnter(DropTargetEvent event) {
        this.fChosenListener = null;
        event.currentDataType = this.selectPreferredListener(event);
        if (this.fChosenListener != null) {
            this.fChosenListener.dragEnter(event);
        }
    }

    public void dragLeave(DropTargetEvent event) {
        if (this.fChosenListener != null) {
            this.fChosenListener.dragLeave(event);
        }
    }

    public void dragOperationChanged(DropTargetEvent event) {
        if (this.fChosenListener != null) {
            this.fChosenListener.dragOperationChanged(event);
        }
    }

    public void dragOver(DropTargetEvent event) {
        if (this.fChosenListener != null) {
            this.fChosenListener.dragOver(event);
        }
    }

    public void drop(DropTargetEvent event) {
        if (this.fChosenListener != null) {
            this.fChosenListener.drop(event);
        }
        this.fChosenListener = null;
        if (this.context.getControl() != null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    Shell shell = ExtendibleDropTargetListener.this.context.getControl().getShell();
                    if (shell != null && !shell.isDisposed()) {
                        shell.forceActive();
                    }
                }
            });
        }
        DragAndDropSupportRegistry.getInstance().removeDropTargetListener(this, this.context);
    }

    public void dropAccept(DropTargetEvent event) {
        if (this.fChosenListener != null) {
            this.fChosenListener.dropAccept(event);
        }
    }

    private TransferData selectPreferredListener(DropTargetEvent event) {
        TransferData[] dataTypes = event.dataTypes;
        this.fListeners = DragAndDropSupportRegistry.getInstance().loadDropTargetListeners(this, this.context);
        TransferDropTargetListener defaultListener = null;
        TransferData type = null;
        int i = 0;
        while (i < dataTypes.length) {
            int j = 0;
            while (j < this.fListeners.length) {
                if (this.fListeners[j].isEnabled(event) && this.fListeners[j].getTransfer().isSupportedType(dataTypes[i])) {
                    if (this.fListeners[j] instanceof TransferDropTargetProxy && ((TransferDropTargetProxy)this.fListeners[j]).getListener() instanceof DefaultTransferListener && ((DefaultTransferListener)((Object)((TransferDropTargetProxy)this.fListeners[j]).getListener())).isDefault()) {
                        defaultListener = this.fListeners[j];
                        type = dataTypes[i];
                    } else {
                        this.fChosenListener = this.fListeners[j];
                        return dataTypes[i];
                    }
                }
                ++j;
            }
            ++i;
        }
        if (defaultListener != null && type != null) {
            this.fChosenListener = defaultListener;
            return type;
        }
        return null;
    }
}

