/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui.dnd;

import com.ibm.collaboration.realtime.ui.dnd.ContributedDragSourceListener;
import com.ibm.collaboration.realtime.ui.dnd.ContributedDropTargetListener;
import com.ibm.collaboration.realtime.ui.dnd.TransferDragSourceProxy;
import com.ibm.collaboration.realtime.ui.dnd.TransferDropTargetProxy;
import com.ibm.collaboration.realtime.ui.dnd.TransferOperationContext;
import com.ibm.collaboration.realtime.ui.dnd.TransferProvider;
import com.ibm.collaboration.realtime.ui.strings.LogMessages;
import com.ibm.collaboration.realtime.util.DoubleKeyHashtable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.DelegatingDragAdapter;
import org.eclipse.jface.util.DelegatingDropAdapter;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;

public final class DragAndDropSupportRegistry {
    private static DragAndDropSupportRegistry instance;
    private static final Logger logger;
    private final Set loaded = new HashSet();
    private final DoubleKeyHashtable dropAdapterToProxies = new DoubleKeyHashtable();

    static {
        logger = Logger.getLogger(DragAndDropSupportRegistry.class.getName());
    }

    public static DragAndDropSupportRegistry getInstance() {
        if (instance == null) {
            instance = new DragAndDropSupportRegistry();
        }
        return instance;
    }

    private DragAndDropSupportRegistry() {
    }

    private Collection createRegistryProxies() {
        HashSet<Object> collection = new HashSet<Object>();
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.collaboration.realtime.ui.stdnd");
        int index = 0;
        while (index < elements.length) {
            block10: {
                IConfigurationElement element = elements[index];
                String attribute = element.getAttribute("class");
                if (attribute != null && !"".equals(attribute)) {
                    String name = element.getName();
                    if ("dropTargetListener".equals(name)) {
                        collection.add(new TransferDropTargetProxy(element));
                    } else if ("dragSourceListener".equals(name)) {
                        collection.add(new TransferDragSourceProxy(element));
                    } else if ("transferProvider".equals(name)) {
                        try {
                            Object object = element.createExecutableExtension("class");
                            if (object instanceof TransferProvider) {
                                collection.add(object);
                            }
                        }
                        catch (CoreException exception) {
                            if (!logger.isLoggable(Level.WARNING)) break block10;
                            logger.log(Level.WARNING, LogMessages.DragAndDropSupportRegistry_7, exception);
                        }
                    }
                }
            }
            ++index;
        }
        return collection;
    }

    private void createTransfers(Collection transfers) {
        Collection proxies = this.createRegistryProxies();
        for (Object object : proxies) {
            TransferProvider provider;
            Transfer transfer;
            if (!(object instanceof TransferProvider) || (transfer = (provider = (TransferProvider)object).createTransfer()) == null) continue;
            transfers.add(transfer);
        }
    }

    public void loadDragSourceListeners(DelegatingDragAdapter adapter, TransferOperationContext context) {
        if (this.loaded.add(adapter)) {
            for (Object listener : this.createRegistryProxies()) {
                if (!(listener instanceof ContributedDragSourceListener)) continue;
                ContributedDragSourceListener extended = (ContributedDragSourceListener)listener;
                extended.setContext(context);
                adapter.addDragSourceListener((TransferDragSourceListener)extended);
            }
        }
    }

    public TransferDropTargetListener[] loadDropTargetListeners(DelegatingDropAdapter adapter, TransferOperationContext context) {
        ArrayList<ContributedDropTargetListener> added = (ArrayList<ContributedDropTargetListener>)this.dropAdapterToProxies.get((Object)adapter, (Object)context);
        if (added == null) {
            added = new ArrayList<ContributedDropTargetListener>();
            for (Object listener : this.createRegistryProxies()) {
                ContributedDropTargetListener extended;
                if (!(listener instanceof ContributedDropTargetListener) || (extended = (ContributedDropTargetListener)listener).getPreferredContextClass() == null || !extended.getPreferredContextClass().isInstance(context.getControl()) && !extended.getPreferredContextClass().isInstance(context)) continue;
                extended.setContext(context);
                adapter.addDropTargetListener((TransferDropTargetListener)extended);
                added.add(extended);
            }
            this.dropAdapterToProxies.put((Object)adapter, (Object)context, added);
        }
        return added.toArray(new TransferDropTargetListener[added.size()]);
    }

    public void loadTransfers(DragSource source) {
        if (this.loaded.add(source)) {
            block3: {
                HashSet<Transfer> transfers = new HashSet<Transfer>();
                this.createTransfers(transfers);
                transfers.addAll(Arrays.asList(source.getTransfer()));
                try {
                    source.setTransfer(transfers.toArray(new Transfer[transfers.size()]));
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(Level.WARNING)) break block3;
                    logger.log(Level.WARNING, "error in DragSource.setTransfer", t);
                }
            }
            source.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent de) {
                    DragAndDropSupportRegistry.this.loaded.remove(de.getSource());
                }
            });
        }
    }

    public void loadTransfers(DropTarget target) {
        if (this.loaded.add(target)) {
            block3: {
                HashSet<Transfer> transfers = new HashSet<Transfer>();
                this.createTransfers(transfers);
                transfers.addAll(Arrays.asList(target.getTransfer()));
                try {
                    target.setTransfer(transfers.toArray(new Transfer[transfers.size()]));
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(Level.WARNING)) break block3;
                    logger.log(Level.WARNING, "error in DropTarget.setTransfer", t);
                }
            }
            target.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent de) {
                    DragAndDropSupportRegistry.this.loaded.remove(de.getSource());
                }
            });
        }
    }

    public void removeDropTargetListener(DelegatingDropAdapter adapter, TransferOperationContext context) {
        this.dropAdapterToProxies.remove((Object)adapter, (Object)context);
    }
}

