/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui.browser;

import com.ibm.collaboration.realtime.browser.Browser;
import com.ibm.collaboration.realtime.browser.ProgressEvent;
import com.ibm.collaboration.realtime.browser.ProgressListener;
import com.ibm.collaboration.realtime.ui.browser.FileDownloaderListener;
import com.ibm.collaboration.realtime.ui.browser.ImageListener;
import com.ibm.collaboration.realtime.util.FileUtils;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;
import org.w3c.dom.events.Event;

public class PrintImageListener
extends ImageListener {
    private static HashMap printBrowsers = null;

    public void handleEvent(Event evt) {
        try {
            String strFile = this.getImgSrc(evt);
            if (strFile != null && strFile.indexOf("http") == 0) {
                this.downloadRemoteImage(strFile, this.getTempFile(this.getFilenameFromUrl(strFile)), new FileDownloaderListener(){

                    public void downloaded(final String filepath) {
                        if (filepath != null) {
                            UIJob uiJob = new UIJob("showBrowserJob"){

                                public IStatus runInUIThread(IProgressMonitor arg0) {
                                    PrintImageListener.this.showPrintBrowser(filepath);
                                    return Status.OK_STATUS;
                                }
                            };
                            uiJob.setSystem(true);
                            uiJob.schedule();
                        }
                    }
                });
            } else {
                this.showPrintBrowser(strFile);
            }
        }
        catch (Throwable throwable) {}
    }

    private void showPrintBrowser(String strFile) {
        Shell s;
        Browser browser = this.getBrowser();
        if (browser != null && (s = this.getPrintShell(browser)) == null) {
            s = new Shell(browser.getShell());
            final Browser printBrowser = new Browser((Composite)s, 0);
            printBrowser.addProgressListener(new ProgressListener(){

                public void changed(ProgressEvent event) {
                }

                public void completed(ProgressEvent event) {
                    printBrowser.execute("window.print();");
                }
            });
            printBrowser.setUrl(FileUtils.getLocalUrl((String)strFile));
            browser.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    PrintImageListener.this.disposePrintShell(PrintImageListener.this.getBrowser());
                }
            });
            this.savePrintShell(browser, s);
        }
    }

    private void savePrintShell(Browser browser, Shell shell) {
        if (printBrowsers == null) {
            printBrowsers = new HashMap(5);
        }
        if (browser == null || shell == null) {
            return;
        }
        printBrowsers.put(browser, shell);
    }

    private Shell getPrintShell(Browser browser) {
        if (printBrowsers == null || browser == null) {
            return null;
        }
        return (Shell)printBrowsers.get(browser);
    }

    private void disposePrintShell(Browser browser) {
        if (printBrowsers == null || browser == null) {
            return;
        }
        Shell shell = (Shell)printBrowsers.remove(browser);
        if (shell != null && !shell.isDisposed()) {
            shell.dispose();
            shell = null;
        }
    }
}

