/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui.browser;

import com.ibm.collaboration.realtime.browser.BrowserListener;
import com.ibm.collaboration.realtime.magiccarpet.messageprocessor.MessageProcessor;
import com.ibm.collaboration.realtime.ui.browser.FileDownloader;
import com.ibm.collaboration.realtime.ui.browser.FileDownloaderListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.w3c.dom.events.Event;
import org.w3c.dom.html.HTMLImageElement;

public abstract class ImageListener
extends BrowserListener {
    private static FileDownloader downloader;
    public static FileDownloader FILE_DOWNLOADER;

    static {
        FILE_DOWNLOADER = downloader = new FileDownloader(){

            public void saveToFile(String url, File file, FileDownloaderListener listener) {
                try {
                    int len;
                    URL urlConn = new URL(url);
                    InputStream inputStream = urlConn.openStream();
                    BufferedInputStream buffStream = new BufferedInputStream(inputStream);
                    FileOutputStream outStream = null;
                    outStream = new FileOutputStream(file);
                    byte[] buffer = new byte[4096];
                    while ((len = buffStream.read(buffer)) != -1) {
                        outStream.write(buffer, 0, len);
                    }
                    inputStream.close();
                    buffStream.close();
                    outStream.close();
                    if (listener != null) {
                        listener.downloaded(file.getAbsolutePath());
                    }
                }
                catch (Throwable throwable) {}
            }
        };
    }

    public String getImgSrc(Event evt) {
        String strFile = null;
        if (evt.getTarget() instanceof HTMLImageElement) {
            HTMLImageElement imgSrc = (HTMLImageElement)((Object)evt.getTarget());
            String src = imgSrc.getSrc();
            try {
                src = URLDecoder.decode(src, "UTF-8");
            }
            catch (Throwable throwable) {}
            if (src.indexOf("http") == 0) {
                strFile = src;
            } else {
                File locFile = null;
                try {
                    URI srcURL = new URI(imgSrc.getSrc());
                    locFile = new File(srcURL);
                    if (locFile.exists()) {
                        strFile = locFile.getAbsolutePath();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return strFile;
    }

    public void downloadRemoteImage(String url, String filename, FileDownloaderListener listener) {
        if (filename == null) {
            return;
        }
        File file = ImageListener.findAvailableFile(filename);
        DownloadImageJob job = new DownloadImageJob(url, file, listener);
        job.schedule();
    }

    protected static File findAvailableFile(String fileName) {
        int num = 1;
        File file = new File(fileName);
        String prefix = null;
        String suffix = "";
        if (fileName.lastIndexOf(".") > -1) {
            prefix = fileName.substring(0, fileName.lastIndexOf("."));
            suffix = fileName.substring(fileName.lastIndexOf("."));
        } else {
            prefix = fileName;
        }
        while (file.exists()) {
            file = new File(String.valueOf(prefix) + "-" + num + suffix);
            ++num;
        }
        return file;
    }

    protected String getFilenameFromUrl(String strFile) {
        String filename = null;
        String end = null;
        if (strFile.lastIndexOf("/") > -1) {
            end = strFile.substring(strFile.lastIndexOf("/") + 1);
        }
        if (this.isImageFile(end)) {
            filename = end;
        } else {
            if (strFile.lastIndexOf("=") > -1) {
                end = strFile.substring(strFile.lastIndexOf("=") + 1);
            }
            if (this.isImageFile(end)) {
                filename = end;
            }
        }
        if (filename == null) {
            filename = MessageProcessor.generateUniqueID();
        }
        return filename;
    }

    private boolean isImageFile(String end) {
        return end != null && (end.endsWith(".jpg") || end.endsWith(".png") || end.endsWith(".gif"));
    }

    protected String getTempFile(String filename) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(System.getProperty("java.io.tmpdir"));
        buffer.append(File.separator);
        if (filename != null) {
            buffer.append(filename);
        } else {
            buffer.append(MessageProcessor.generateUniqueID());
        }
        return buffer.toString();
    }

    protected class DownloadImageJob
    extends Job {
        private String url;
        private File file;
        private FileDownloaderListener listener;

        public DownloadImageJob(String url, File file, FileDownloaderListener listener) {
            super("DownloadImageJob");
            this.setSystem(true);
            this.url = url;
            this.file = file;
            this.listener = listener;
        }

        protected IStatus run(IProgressMonitor arg0) {
            if (FILE_DOWNLOADER != null) {
                FILE_DOWNLOADER.saveToFile(this.url, this.file, this.listener);
            }
            return Status.OK_STATUS;
        }
    }
}

