/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui.bidiutils;

import com.ibm.collaboration.realtime.ui.bidiutils.BidiFlag;
import com.ibm.collaboration.realtime.ui.bidiutils.BidiText;
import com.ibm.collaboration.realtime.ui.bidiutils.BidiTransform;
import java.util.Arrays;
import java.util.Collections;
import java.util.Vector;

class BidiOrder {
    private static final int UBAT_B = 0;
    private static final int UBAT_S = 1;
    private static final int UBAT_L = 2;
    private static final int UBAT_R = 3;
    private static final int UBAT_EN = 4;
    private static final int UBAT_AN = 5;
    private static final int UBAT_W = 6;
    private static final int UBAT_N = 7;
    private static final int UBAT_BD = 8;
    private static final int UBAT_AL = 9;
    private static final int UBAT_ET = 10;
    private static final int UBAT_ES = 11;
    private static final int UBAT_CS = 12;
    private static final int UBAT_NSM = 13;
    private static final int ITIL = 8;
    private static final int ITCOND = 9;
    private static final byte UBAT_N_SWAP = -7;
    private static final byte IMP_LTR = 4;
    private static final byte IMP_RTL = 8;
    private static final byte ORIG = 0;
    private static final byte FINAL = 1;
    private static final char LRM = '\u200e';
    private static final char RLM = '\u200f';
    private static final int BEFORE = 0;
    private static final int AFTER = 65536;
    private static final char NODELIM = '\uffff';
    private static final char[][] notSpacing = new char[][]{{'\u0300', '\u0385'}, {'\u0483', '\u0486'}, {'\u05b0', '\u05bd'}, {'\u05bf', '\u05bf'}, {'\u05c1', '\u05c2'}, {'\u05f5', '\u05f5'}, {'\u064b', '\u0652'}, {'\u0670', '\u0670'}, {'\u06d6', '\u06e4'}, {'\u06e7', '\u06e8'}, {'\u06ea', '\u06ed'}, {'\u0901', '\u0902'}, {'\u093c', '\u093c'}, {'\u0941', '\u0948'}, {'\u094d', '\u094d'}, {'\u0951', '\u0954'}, {'\u0962', '\u0963'}, {'\u0981', '\u0981'}, {'\u09bc', '\u09bc'}, {'\u09c1', '\u09c4'}, {'\u09cd', '\u09cd'}, {'\u09e2', '\u09e3'}, {'\u0a02', '\u0a02'}, {'\u0a3c', '\u0a3c'}, {'\u0a41', '\u0a4c'}, {'\u0a70', '\u0a71'}, {'\u0a81', '\u0a82'}, {'\u0abc', '\u0abc'}, {'\u0ac1', '\u0ac8'}, {'\u0acd', '\u0acd'}, {'\u0b01', '\u0b01'}, {'\u0b3c', '\u0b3c'}, {'\u0b3f', '\u0b3f'}, {'\u0b41', '\u0b43'}, {'\u0b4d', '\u0b4d'}, {'\u0bc0', '\u0bc0'}, {'\u0bcd', '\u0bcd'}, {'\u0c3e', '\u0c40'}, {'\u0c46', '\u0c56'}, {'\u0cbf', '\u0cbf'}, {'\u0cc6', '\u0cc6'}, {'\u0ccc', '\u0ccd'}, {'\u0d41', '\u0d43'}, {'\u0d4d', '\u0d4d'}, {'\u0e31', '\u0e31'}, {'\u0e34', '\u0e3a'}, {'\u0e47', '\u0e4d'}, {'\u0eb1', '\u0eb1'}, {'\u0eb4', '\u0ebc'}, {'\u0ec8', '\u0ecd'}, {'\u1026', '\u102a'}, {'\u102e', '\u102e'}, {'\u1030', '\u1030'}, {'\u1036', '\u1037'}, {'\u103b', '\u103b'}, {'\u103d', '\u103e'}, {'\u104b', '\u104c'}, {'\u20d0', '\u20ff'}, {'\u302a', '\u302f'}, {'\u3099', '\u309a'}};
    private static final char[][] symPairs = new char[][]{{'(', ')'}, {')', '('}, {'<', '>'}, {'>', '<'}, {'[', ']'}, {']', '['}, {'{', '}'}, {'}', '{'}, {'\u00ab', '\u00bb'}, {'\u00bb', '\u00ab'}, {'\u207d', '\u207e'}, {'\u207e', '\u207d'}, {'\u208d', '\u208e'}, {'\u208e', '\u208d'}, {'\u2329', '\u232a'}, {'\u232a', '\u2329'}, {'\ufe59', '\ufe5a'}, {'\ufe5a', '\ufe59'}, {'\ufe5b', '\ufe5c'}, {'\ufe5c', '\ufe5b'}, {'\ufe5d', '\ufe5e'}, {'\ufe5e', '\ufe5d'}, {'\ufe64', '\ufe65'}, {'\ufe65', '\ufe64'}};
    private static final short[][] impTab_LTR;
    private static final short[][] impTab_RTL;
    private static final short[][] impTab_LTR_r;
    private static final short[][] impTab_RTL_r;
    private static final short[][] impTab_LTR_w;
    private static final short[][] impTab_LTR_m;
    private static final short[][] impTab_RTL_m;
    private static final short[][] impTab_LTR_wm;
    int ucb_ix;
    byte ucb_outLev;
    byte ucb_basLev;
    byte ucb_curLev;
    int ucb_impSta;
    int ucb_condPos;
    int ucb_xType;
    byte ucb_wTarget;
    BidiFlag ics_num_flag;
    boolean ics_symmetric;
    BidiFlag ics_orient_in;
    BidiFlag ics_orient_out;
    BidiFlag ics_type_in;
    BidiFlag ics_type_out;
    BidiTransform myBdx;
    int ics_size;
    char[] ics_buffer_in;
    char[] ics_buffer_out;
    boolean invertInput;
    boolean visToVis;
    short[][] impTab;
    byte[][] typeArray;
    boolean insertMarkers;
    int insertCnt;
    int removeCnt;
    int startL2EN;
    int lastStrongRTL;
    boolean reqImpToImp;
    int impToImpOrient;
    int impToImpPhase;
    char delim1;
    char delim2;

    static {
        short[][] sArrayArray = new short[6][];
        short[] sArray = new short[10];
        sArray[3] = 3;
        sArray[5] = 1;
        sArrayArray[0] = sArray;
        short[] sArray2 = new short[10];
        sArray2[3] = 3;
        sArray2[5] = 1;
        sArray2[6] = 2;
        sArray2[7] = 2;
        sArray2[8] = 2;
        sArrayArray[1] = sArray2;
        short[] sArray3 = new short[10];
        sArray3[3] = 3;
        sArray3[5] = 17;
        sArray3[6] = 2;
        sArray3[7] = 2;
        sArray3[9] = 1;
        sArrayArray[2] = sArray3;
        short[] sArray4 = new short[10];
        sArray4[3] = 3;
        sArray4[4] = 5;
        sArray4[5] = 5;
        sArray4[6] = 4;
        sArray4[7] = 4;
        sArray4[8] = 1;
        sArrayArray[3] = sArray4;
        short[] sArray5 = new short[10];
        sArray5[3] = 3;
        sArray5[4] = 21;
        sArray5[5] = 21;
        sArray5[6] = 4;
        sArray5[7] = 4;
        sArray5[9] = 1;
        sArrayArray[4] = sArray5;
        short[] sArray6 = new short[10];
        sArray6[3] = 3;
        sArray6[4] = 5;
        sArray6[5] = 5;
        sArray6[6] = 4;
        sArray6[7] = 4;
        sArray6[8] = 2;
        sArrayArray[5] = sArray6;
        impTab_LTR = sArrayArray;
        short[][] sArrayArray2 = new short[4][];
        short[] sArray7 = new short[10];
        sArray7[2] = 2;
        sArray7[4] = 1;
        sArray7[5] = 1;
        sArrayArray2[0] = sArray7;
        short[] sArray8 = new short[10];
        sArray8[2] = 2;
        sArray8[4] = 1;
        sArray8[5] = 1;
        sArray8[8] = 1;
        sArrayArray2[1] = sArray8;
        short[] sArray9 = new short[10];
        sArray9[2] = 2;
        sArray9[4] = 2;
        sArray9[5] = 1;
        sArray9[6] = 3;
        sArray9[7] = 3;
        sArray9[8] = 1;
        sArrayArray2[2] = sArray9;
        short[] sArray10 = new short[10];
        sArray10[2] = 2;
        sArray10[4] = 2;
        sArray10[5] = 33;
        sArray10[6] = 3;
        sArray10[7] = 3;
        sArray10[9] = 1;
        sArrayArray2[3] = sArray10;
        impTab_RTL = sArrayArray2;
        short[][] sArrayArray3 = new short[5][];
        short[] sArray11 = new short[10];
        sArray11[3] = 2;
        sArray11[5] = 1;
        sArrayArray3[0] = sArray11;
        short[] sArray12 = new short[10];
        sArray12[3] = 2;
        sArray12[5] = 1;
        sArray12[6] = 3;
        sArray12[7] = 3;
        sArray12[8] = 2;
        sArrayArray3[1] = sArray12;
        short[] sArray13 = new short[10];
        sArray13[3] = 2;
        sArray13[4] = 4;
        sArray13[5] = 1;
        sArray13[6] = 3;
        sArray13[7] = 3;
        sArray13[8] = 1;
        sArrayArray3[2] = sArray13;
        short[] sArray14 = new short[10];
        sArray14[3] = 34;
        sArray14[4] = 4;
        sArray14[5] = 4;
        sArray14[6] = 3;
        sArray14[7] = 3;
        sArray14[8] = 1;
        sArray14[9] = 1;
        sArrayArray3[3] = sArray14;
        short[] sArray15 = new short[10];
        sArray15[3] = 34;
        sArray15[4] = 4;
        sArray15[5] = 4;
        sArray15[6] = 3;
        sArray15[7] = 3;
        sArray15[8] = 2;
        sArray15[9] = 1;
        sArrayArray3[4] = sArray15;
        impTab_LTR_r = sArrayArray3;
        short[][] sArrayArray4 = new short[6][];
        short[] sArray16 = new short[10];
        sArray16[2] = 3;
        sArray16[4] = 1;
        sArray16[5] = 2;
        sArrayArray4[0] = sArray16;
        sArrayArray4[1] = new short[]{32, 32, 3, 32, 1, 34, 5, 5, 1, 1};
        short[] sArray17 = new short[10];
        sArray17[2] = 3;
        sArray17[4] = 1;
        sArray17[5] = 2;
        sArray17[8] = 1;
        sArrayArray4[2] = sArray17;
        short[] sArray18 = new short[10];
        sArray18[2] = 3;
        sArray18[4] = 3;
        sArray18[5] = 2;
        sArray18[6] = 4;
        sArray18[7] = 4;
        sArray18[8] = 1;
        sArrayArray4[3] = sArray18;
        short[] sArray19 = new short[10];
        sArray19[2] = 3;
        sArray19[4] = 3;
        sArray19[5] = 34;
        sArray19[6] = 4;
        sArray19[7] = 4;
        sArray19[9] = 1;
        sArrayArray4[4] = sArray19;
        short[] sArray20 = new short[10];
        sArray20[0] = 32;
        sArray20[1] = 32;
        sArray20[2] = 3;
        sArray20[3] = 32;
        sArray20[4] = 1;
        sArray20[5] = 34;
        sArray20[6] = 5;
        sArray20[7] = 5;
        sArray20[9] = 1;
        sArrayArray4[5] = sArray20;
        impTab_RTL_r = sArrayArray4;
        short[][] sArrayArray5 = new short[5][];
        short[] sArray21 = new short[10];
        sArray21[3] = 2;
        sArray21[4] = 1;
        sArray21[5] = 1;
        sArrayArray5[0] = sArray21;
        short[] sArray22 = new short[10];
        sArray22[3] = 2;
        sArray22[4] = 1;
        sArray22[5] = 1;
        sArray22[8] = 2;
        sArrayArray5[1] = sArray22;
        short[] sArray23 = new short[10];
        sArray23[3] = 2;
        sArray23[4] = 4;
        sArray23[5] = 4;
        sArray23[6] = 3;
        sArray23[7] = 3;
        sArray23[8] = 1;
        sArrayArray5[2] = sArray23;
        short[] sArray24 = new short[10];
        sArray24[3] = 2;
        sArray24[4] = 20;
        sArray24[5] = 20;
        sArray24[6] = 3;
        sArray24[7] = 3;
        sArray24[9] = 1;
        sArrayArray5[3] = sArray24;
        short[] sArray25 = new short[10];
        sArray25[3] = 2;
        sArray25[4] = 4;
        sArray25[5] = 4;
        sArray25[6] = 3;
        sArray25[7] = 3;
        sArray25[8] = 2;
        sArrayArray5[4] = sArray25;
        impTab_LTR_w = sArrayArray5;
        short[][] sArrayArray6 = new short[7][];
        short[] sArray26 = new short[10];
        sArray26[3] = 99;
        sArray26[5] = 1;
        sArrayArray6[0] = sArray26;
        short[] sArray27 = new short[10];
        sArray27[3] = 99;
        sArray27[5] = 1;
        sArray27[6] = 2;
        sArray27[7] = 2;
        sArray27[8] = 2;
        sArrayArray6[1] = sArray27;
        short[] sArray28 = new short[10];
        sArray28[3] = 99;
        sArray28[5] = 33;
        sArray28[6] = 2;
        sArray28[7] = 2;
        sArray28[8] = 1;
        sArray28[9] = 1;
        sArrayArray6[2] = sArray28;
        short[] sArray29 = new short[10];
        sArray29[3] = 99;
        sArray29[4] = 85;
        sArray29[5] = 86;
        sArray29[6] = 4;
        sArray29[7] = 4;
        sArray29[8] = 1;
        sArrayArray6[3] = sArray29;
        sArrayArray6[4] = new short[]{48, 48, 48, 67, 85, 86, 4, 4, 1, 1};
        short[] sArray30 = new short[10];
        sArray30[0] = 48;
        sArray30[1] = 48;
        sArray30[2] = 48;
        sArray30[3] = 67;
        sArray30[4] = 5;
        sArray30[5] = 86;
        sArray30[6] = 4;
        sArray30[7] = 4;
        sArray30[8] = 2;
        sArrayArray6[5] = sArray30;
        short[] sArray31 = new short[10];
        sArray31[0] = 48;
        sArray31[1] = 48;
        sArray31[2] = 48;
        sArray31[3] = 67;
        sArray31[4] = 85;
        sArray31[5] = 6;
        sArray31[6] = 4;
        sArray31[7] = 4;
        sArray31[8] = 2;
        sArrayArray6[6] = sArray31;
        impTab_LTR_m = sArrayArray6;
        short[][] sArrayArray7 = new short[7][];
        short[] sArray32 = new short[10];
        sArray32[2] = 3;
        sArray32[4] = 1;
        sArray32[5] = 1;
        sArrayArray7[0] = sArray32;
        short[] sArray33 = new short[10];
        sArray33[2] = 115;
        sArray33[4] = 1;
        sArray33[5] = 1;
        sArray33[6] = 2;
        sArray33[7] = 2;
        sArray33[8] = 1;
        sArrayArray7[1] = sArray33;
        short[] sArray34 = new short[10];
        sArray34[2] = 115;
        sArray34[4] = 1;
        sArray34[5] = 1;
        sArray34[6] = 2;
        sArray34[7] = 2;
        sArrayArray7[2] = sArray34;
        short[] sArray35 = new short[10];
        sArray35[2] = 3;
        sArray35[4] = 3;
        sArray35[5] = 134;
        sArray35[6] = 4;
        sArray35[7] = 4;
        sArray35[8] = 1;
        sArrayArray7[3] = sArray35;
        short[] sArray36 = new short[10];
        sArray36[0] = 144;
        sArray36[1] = 144;
        sArray36[2] = 163;
        sArray36[3] = 144;
        sArray36[4] = 5;
        sArray36[5] = 134;
        sArray36[6] = 4;
        sArray36[7] = 4;
        sArray36[9] = 1;
        sArrayArray7[4] = sArray36;
        sArrayArray7[5] = new short[]{144, 144, 163, 144, 5, 134, 4, 4, 1, 1};
        sArrayArray7[6] = new short[]{144, 144, 163, 144, 6, 6, 4, 4, 1, 1};
        impTab_RTL_m = sArrayArray7;
        short[][] sArrayArray8 = new short[5][];
        short[] sArray37 = new short[10];
        sArray37[3] = 98;
        sArray37[4] = 1;
        sArray37[5] = 1;
        sArrayArray8[0] = sArray37;
        short[] sArray38 = new short[10];
        sArray38[3] = 98;
        sArray38[4] = 1;
        sArray38[5] = 1;
        sArray38[8] = 2;
        sArrayArray8[1] = sArray38;
        short[] sArray39 = new short[10];
        sArray39[3] = 98;
        sArray39[4] = 84;
        sArray39[5] = 84;
        sArray39[6] = 3;
        sArray39[7] = 3;
        sArray39[8] = 1;
        sArrayArray8[2] = sArray39;
        sArrayArray8[3] = new short[]{48, 48, 48, 66, 84, 84, 3, 3, 1, 1};
        short[] sArray40 = new short[10];
        sArray40[0] = 48;
        sArray40[1] = 48;
        sArray40[2] = 48;
        sArray40[3] = 66;
        sArray40[4] = 4;
        sArray40[5] = 4;
        sArray40[6] = 3;
        sArray40[7] = 3;
        sArray40[8] = 2;
        sArrayArray8[4] = sArray40;
        impTab_LTR_wm = sArrayArray8;
    }

    BidiOrder() {
    }

    private static boolean odd(int n) {
        return (n & 1) == 1;
    }

    private static boolean even(int n) {
        return (n & 1) == 0;
    }

    private static void invertMap(int[] buffer, int lower_limit, int upper_limit) {
        while (lower_limit < upper_limit) {
            int temp = buffer[lower_limit];
            buffer[lower_limit] = buffer[upper_limit];
            buffer[upper_limit] = temp;
            ++lower_limit;
            --upper_limit;
        }
    }

    private static void invertMap(byte[] buffer, int lower_limit, int upper_limit) {
        while (lower_limit < upper_limit) {
            byte temp = buffer[lower_limit];
            buffer[lower_limit] = buffer[upper_limit];
            buffer[upper_limit] = temp;
            ++lower_limit;
            --upper_limit;
        }
    }

    private static boolean UCQSPAC(char x) {
        int low = 0;
        int high = notSpacing.length - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            if (x < notSpacing[mid][0]) {
                high = mid - 1;
                continue;
            }
            if (x > notSpacing[mid][1]) {
                low = mid + 1;
                continue;
            }
            return false;
        }
        return true;
    }

    private static char UCQSYMM(char x) {
        int low = 0;
        int high = 23;
        while (low <= high) {
            int mid = (low + high) / 2;
            char c = symPairs[mid][0];
            if (x < c) {
                high = mid - 1;
                continue;
            }
            if (x > c) {
                low = mid + 1;
                continue;
            }
            return symPairs[mid][1];
        }
        return x;
    }

    private void fillTypeArray() {
        boolean isArabic = false;
        byte[][] ta = this.typeArray;
        int delimState = 0;
        int i = 0;
        while (i < this.ics_size) {
            byte cType;
            char c = this.ics_buffer_in[i];
            ta[i][0] = cType = BidiOrder.getChType(c, this.myBdx.wordBreak);
            ta[i][1] = 7;
            if (this.delim1 != '\uffff') {
                if (delimState == 0) {
                    if (c == this.delim1) {
                        delimState = 1;
                    }
                    cType = 0;
                } else if (delimState == 1) {
                    if (c == this.delim2) {
                        if (i + 1 < this.ics_size && this.ics_buffer_in[i + 1] == this.delim2) {
                            delimState = 2;
                        } else {
                            delimState = 0;
                            cType = 0;
                        }
                    }
                } else {
                    delimState = 1;
                }
            }
            if (!this.visToVis) {
                switch (cType) {
                    case 0: {
                        isArabic = false;
                        ta[i][1] = 0;
                        break;
                    }
                    case 1: {
                        ta[i][1] = 1;
                        break;
                    }
                    case 2: {
                        isArabic = false;
                        ta[i][1] = 2;
                        break;
                    }
                    case 3: {
                        isArabic = false;
                        ta[i][1] = 3;
                        break;
                    }
                    case 9: {
                        isArabic = true;
                        ta[i][1] = 3;
                        break;
                    }
                    case 4: {
                        int wType;
                        if (isArabic) {
                            wType = 5;
                        } else {
                            wType = 4;
                            if (i >= 2 && ta[i - 1][0] == 11 && ta[i - 2][0] == 4) {
                                ta[i - 1][1] = 4;
                            }
                            int prev = i - 1;
                            while (prev >= 0 && ta[prev][0] == 10) {
                                ta[prev--][1] = 4;
                            }
                        }
                        if (i >= 2 && ta[i - 1][0] == 12 && ta[i - 2][0] == 4) {
                            ta[i - 1][1] = wType;
                        }
                        ta[i][1] = wType;
                        break;
                    }
                    case 5: {
                        if (i >= 2 && ta[i - 1][0] == 12 && ta[i - 2][1] == 5) {
                            ta[i - 1][1] = 5;
                        }
                        ta[i][1] = 5;
                        break;
                    }
                    case 6: {
                        ta[i][1] = 6;
                        break;
                    }
                    case 10: {
                        if (i <= 0 || ta[i - 1][1] != 4) break;
                        ta[i][1] = 4;
                        break;
                    }
                    case 13: {
                        if (i <= 0) break;
                        ta[i][1] = ta[i - 1][1];
                    }
                }
            }
            ++i;
        }
    }

    private void fillTypeArray2() {
        boolean isArabic = false;
        byte[][] ta = this.typeArray;
        int i = 0;
        while (i < this.ics_size) {
            int k = this.myBdx.dstToSrcMap[i];
            byte cType = ta[k][0];
            if (this.delim1 != '\uffff' && ta[k][1] == 0) {
                cType = 0;
            } else {
                ta[k][1] = 7;
            }
            switch (cType) {
                case 0: {
                    isArabic = false;
                    ta[k][1] = 0;
                    break;
                }
                case 1: {
                    ta[k][1] = 1;
                    break;
                }
                case 2: {
                    isArabic = false;
                    ta[k][1] = 2;
                    break;
                }
                case 3: {
                    isArabic = false;
                    ta[k][1] = 3;
                    break;
                }
                case 9: {
                    isArabic = true;
                    ta[k][1] = 3;
                    break;
                }
                case 4: {
                    int wType;
                    if (isArabic) {
                        wType = 5;
                    } else {
                        wType = 4;
                        if (i >= 2 && ta[this.myBdx.dstToSrcMap[i - 1]][0] == 11 && ta[this.myBdx.dstToSrcMap[i - 2]][0] == 4) {
                            ta[this.myBdx.dstToSrcMap[i - 1]][1] = 4;
                        }
                        int prev = i - 1;
                        while (prev >= 0 && ta[this.myBdx.dstToSrcMap[prev]][0] == 10) {
                            ta[this.myBdx.dstToSrcMap[prev--]][1] = 4;
                        }
                    }
                    if (i >= 2 && ta[this.myBdx.dstToSrcMap[i - 1]][0] == 12 && ta[this.myBdx.dstToSrcMap[i - 2]][0] == 4) {
                        ta[this.myBdx.dstToSrcMap[i - 1]][1] = wType;
                    }
                    ta[k][1] = wType;
                    break;
                }
                case 5: {
                    if (i >= 2 && ta[this.myBdx.dstToSrcMap[i - 1]][0] == 12 && ta[this.myBdx.dstToSrcMap[i - 2]][0] == 5) {
                        ta[this.myBdx.dstToSrcMap[i - 1]][1] = 5;
                    }
                    ta[k][1] = 5;
                    break;
                }
                case 6: {
                    ta[k][1] = 6;
                    break;
                }
                case 10: {
                    if (i <= 0 || ta[this.myBdx.dstToSrcMap[i - 1]][1] != 4) break;
                    ta[k][1] = 4;
                    break;
                }
            }
            ++i;
        }
    }

    private void addPoint(int pos, int after, char insert) {
        if (this.myBdx.insertPoints == null) {
            this.myBdx.insertPoints = new Vector(10, 50);
        }
        this.myBdx.insertPoints.addElement(new Long((pos << 17) + after + insert));
    }

    private int afterAN(int i) {
        while (i < this.ics_size && this.typeArray[i][1] == 5) {
            ++i;
        }
        return i;
    }

    private int afterENAN(int i) {
        while (i < this.ics_size && (this.typeArray[i][1] == 4 || this.typeArray[i][1] == 5)) {
            ++i;
        }
        return i;
    }

    private int beforeENAN(int i) {
        while (i >= 0 && (this.typeArray[i][1] == 4 || this.typeArray[i][1] == 5)) {
            --i;
        }
        return i;
    }

    private void implicitProcessing() {
        short sCond;
        int pos;
        byte oldLevel;
        int i;
        int newIS = this.impTab[this.ucb_impSta][this.ucb_xType];
        short Special = (short)(newIS >> 4);
        newIS = (short)(newIS & 0xF);
        short newIL = this.impTab[newIS][8];
        byte newLevel = (byte)(this.ucb_curLev + newIL);
        if (Special > 0) {
            switch (Special) {
                case 1: {
                    byte level = (byte)(this.ucb_curLev + 1);
                    i = this.ucb_condPos;
                    while (i < this.ucb_ix) {
                        oldLevel = this.myBdx.propertyMap[i];
                        this.myBdx.propertyMap[i] = level;
                        if (this.ics_symmetric && BidiOrder.odd(oldLevel ^ level)) {
                            pos = this.impToImpPhase == 2 ? this.myBdx.dstToSrcMap[i] : i;
                            if (this.typeArray[pos][0] == 7) {
                                this.typeArray[pos][0] = -7;
                            } else if (this.typeArray[pos][0] == -7) {
                                this.typeArray[pos][0] = 7;
                            }
                        }
                        ++i;
                    }
                    this.ucb_condPos = -1;
                    break;
                }
                case 2: {
                    this.ucb_condPos = -1;
                    break;
                }
                case 3: {
                    if (this.startL2EN >= 0) {
                        this.addPoint(this.startL2EN, 0, '\u200e');
                    }
                    this.startL2EN = -1;
                    if (this.myBdx.insertPoints == null || this.myBdx.insertPoints.size() <= this.insertCnt) {
                        this.lastStrongRTL = -1;
                        break;
                    }
                    i = this.lastStrongRTL + 1;
                    while (i < this.ucb_ix) {
                        this.myBdx.propertyMap[i] = newLevel;
                        this.typeArray[i][0] = (byte)Math.abs(this.typeArray[i][0]);
                        ++i;
                    }
                    this.insertCnt = this.myBdx.insertPoints.size();
                    this.lastStrongRTL = -1;
                    break;
                }
                case 4: {
                    if (this.myBdx.insertPoints != null) {
                        this.myBdx.insertPoints.setSize(this.insertCnt);
                    }
                    this.startL2EN = -1;
                    this.lastStrongRTL = this.ucb_ix;
                    break;
                }
                case 5: {
                    this.ucb_condPos = -1;
                    if (this.ucb_xType == 5 && this.typeArray[this.ucb_ix][0] == 5 && !this.myBdx.winCompatible) {
                        if (this.startL2EN == -1) {
                            this.lastStrongRTL = this.afterAN(this.ucb_ix) - 1;
                            break;
                        }
                        if (this.startL2EN >= 0) {
                            this.addPoint(this.startL2EN, 0, '\u200e');
                            this.startL2EN = -2;
                        }
                        this.addPoint(this.ucb_ix, 0, '\u200e');
                        break;
                    }
                    if (this.startL2EN != -1) break;
                    this.startL2EN = this.ucb_ix;
                    break;
                }
                case 6: {
                    this.lastStrongRTL = this.ucb_ix;
                    break;
                }
                case 7: {
                    i = this.beforeENAN(this.ucb_ix - 1);
                    if (i < 0) break;
                    this.addPoint(i, 0, '\u200f');
                    this.insertCnt = this.myBdx.insertPoints.size();
                    break;
                }
                case 8: {
                    pos = this.afterENAN(this.ucb_ix);
                    i = this.beforeENAN(this.ucb_ix);
                    if ((pos >= this.ics_size || this.typeArray[pos][1] == 2 || this.typeArray[pos][1] == 3) && i >= 0 && this.typeArray[i][1] == 2) break;
                    this.addPoint(pos - 1, 65536, '\u200e');
                    this.addPoint(i + 1, 0, '\u200e');
                    break;
                }
                case 9: {
                    if (this.myBdx.insertPoints != null) {
                        this.myBdx.insertPoints.setSize(this.insertCnt);
                    }
                    this.ucb_condPos = -1;
                    break;
                }
                case 10: {
                    if (this.myBdx.insertPoints == null) break;
                    this.insertCnt = this.myBdx.insertPoints.size();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException("invalid action number");
                }
            }
        }
        if ((sCond = this.impTab[newIS][9]) == 0) {
            if (this.ucb_condPos > -1) {
                i = this.ucb_condPos;
                while (i < this.ucb_ix) {
                    oldLevel = this.myBdx.propertyMap[i];
                    this.myBdx.propertyMap[i] = newLevel;
                    if (this.ics_symmetric && BidiOrder.odd(oldLevel ^ newLevel)) {
                        pos = this.impToImpPhase == 2 ? this.myBdx.dstToSrcMap[i] : i;
                        if (this.typeArray[pos][0] == 7) {
                            this.typeArray[pos][0] = -7;
                        } else if (this.typeArray[pos][0] == -7) {
                            this.typeArray[pos][0] = 7;
                        }
                    }
                    ++i;
                }
                this.ucb_condPos = -1;
            }
        } else if (this.ucb_condPos == -1) {
            this.ucb_condPos = this.ucb_ix;
        }
        this.ucb_impSta = newIS;
        this.ucb_wTarget = this.ucb_xType == 0 ? (byte)0 : newLevel;
    }

    private static byte getChType(char x, boolean wordBreak) {
        if (wordBreak && x == ' ') {
            return 1;
        }
        return BidiOrder.getChType(x);
    }

    private static byte getChType(char x) {
        if (x == '\n' || x == '\r' || x >= '\u001c' && x <= '\u001e' || x == '\u0085' || x == '\u2029') {
            return 0;
        }
        if (x == '\t' || x == '\u000b' || x == '\u001f') {
            return 1;
        }
        if (x >= 'A' && x <= 'Z' || x >= 'a' && x <= 'z' || x >= '\u00c0' && x <= '\u00d6' || x >= '\u00d8' && x <= '\u00f6' || x >= '\u00f8' && x <= '\u058f' || x >= '\u0900' && x <= '\u10ff' || x == '\u200e' || x >= '\u20d0' && x <= '\u20ff' || x >= '\u2160' && x <= '\u2182' || x >= '\u3040' && x <= '\u9fff' || x >= '\uf900' && x <= '\ufb17' || x == '\ufe60' || x == '\ufe6b' || x == '\uff06' || x >= '\uff20' && x <= '\uff3a' || x >= '\uff41' && x <= '\uff5a' || x >= '\uff60' && x <= '\uffdf') {
            return 2;
        }
        if (x >= '\u0591' && x <= '\u05ff' || x == '\u200f' || x >= '\ufb1d' && x <= '\ufb4f') {
            return 3;
        }
        if (x >= '\u0600' && x <= '\u065f' || x >= '\u066e' && x <= '\u06ef' || x >= '\u06fa' && x <= '\u08ff' || x >= '\ufb50' && x <= '\ufdff' || x >= '\ufe70' && x <= '\ufefc') {
            return 9;
        }
        if (x >= '0' && x <= '9' || x >= '\u00b2' && x <= '\u00b3' || x == '\u00b9' || x >= '\u06f0' && x <= '\u06f9' || x == '\u2070' || x >= '\u2074' && x <= '\u2079' || x >= '\u2080' && x <= '\u2089' || x >= '\u2460' && x <= '\u249b' || x == '\u24ea' || x >= '\uff10' && x <= '\uff19') {
            return 4;
        }
        if (x >= '\u0660' && x <= '\u0669' || x >= '\u066b' && x <= '\u066c') {
            return 5;
        }
        if (x >= '#' && x <= '%' || x >= '\u00a2' && x <= '\u00a5' || x >= '\u00b0' && x <= '\u00b1' || x == '\u066a' || x >= '\u09f2' && x <= '\u09f3' || x == '\u0af1' || x == '\u0bf9' || x == '\u0e3f' || x == '\u17db' || x >= '\u2030' && x <= '\u2034' || x >= '\u207a' && x <= '\u207b' || x >= '\u208a' && x <= '\u208b' || x >= '\u20a0' && x <= '\u20b1' || x == '\u212e' || x >= '\u2212' && x <= '\u2213' || x == '\ufb29' || x == '\ufe5f' || x >= '\ufe62' && x <= '\ufe63' || x >= '\ufe69' && x <= '\ufe6a' || x >= '\uff03' && x <= '\uff05' || x == '\uff0b' || x == '\uff0d' || x >= '\uffe0' && x <= '\uffe1' || x >= '\uffe5' && x <= '\uffe6') {
            return 10;
        }
        if (x == '+' || x == '-' || x == '/' || x == '\uff0f') {
            return 11;
        }
        if (x == ',' || x == '.' || x == ':' || x == '\u00a0' || x == '\u060c' || x == '\ufe50' || x == '\ufe52' || x == '\ufe55' || x == '\uff0c' || x == '\uff0e' || x == '\uff1a') {
            return 12;
        }
        if (x == '\f' || x == ' ' || x == '\u1680' || x == '\u180e' || x >= '\u2000' && x <= '\u200a' || x == '\u2028' || x == '\u202f' || x == '\u205f' || x == '\u3000') {
            return 6;
        }
        if (x >= '\u202a' && x <= '\u202e' || x >= '\u206c' && x <= '\u206f') {
            return 8;
        }
        return 7;
    }

    private static int firstStrong(BidiText src) {
        int lim = src.offset + src.count;
        int i = src.offset;
        while (i < lim) {
            byte type = BidiOrder.getChType(src.data[i]);
            if (type == 2 || type == 3) {
                return type;
            }
            ++i;
        }
        return 7;
    }

    private static int lastStrong(BidiText src) {
        int lim = src.offset + src.count;
        int i = lim - 1;
        while (i >= src.offset) {
            byte type = BidiOrder.getChType(src.data[i]);
            if (type == 2 || type == 3) {
                return type;
            }
            --i;
        }
        return 7;
    }

    private void BaseLvl() {
        this.visToVis = false;
        this.ucb_basLev = this.ics_orient_in == BidiFlag.ORIENTATION_RTL ? (byte)1 : 0;
        this.ucb_outLev = this.ics_orient_out == BidiFlag.ORIENTATION_RTL ? (byte)1 : 0;
        this.ucb_curLev = this.ucb_basLev;
        if (this.ucb_basLev == 0 && this.ucb_outLev == 1) {
            this.ucb_curLev = (byte)2;
        }
        if (this.ics_type_in == BidiFlag.TYPE_VISUAL && this.ics_type_out == BidiFlag.TYPE_VISUAL) {
            this.visToVis = true;
        }
        if (this.myBdx.roundTrip) {
            this.impTab = this.ucb_basLev == 1 ? impTab_RTL_r : impTab_LTR_r;
        } else if (this.myBdx.winCompatible) {
            if (this.insertMarkers) {
                this.impTab = this.ucb_basLev == 1 ? impTab_RTL_m : impTab_LTR_wm;
                this.startL2EN = -1;
                this.lastStrongRTL = -1;
                if (this.myBdx.insertPoints != null) {
                    this.myBdx.insertPoints.setSize(0);
                }
            } else {
                this.impTab = this.ucb_basLev == 1 ? impTab_RTL : impTab_LTR_w;
            }
        } else if (this.insertMarkers) {
            this.impTab = this.ucb_basLev == 1 ? impTab_RTL_m : impTab_LTR_m;
            this.startL2EN = -1;
            this.lastStrongRTL = -1;
            if (this.myBdx.insertPoints != null) {
                this.myBdx.insertPoints.setSize(0);
            }
        } else {
            this.impTab = this.ucb_basLev == 1 ? impTab_RTL : impTab_LTR;
        }
        this.insertCnt = 0;
        this.removeCnt = 0;
        this.ucb_impSta = 0;
        this.ucb_condPos = -1;
    }

    private void pass2() {
        byte current_level;
        byte lowest_level = 100;
        byte highest_level = 0;
        int flip_from = 0;
        int flip_to = this.ics_size - 1;
        int i = 0;
        while (i < this.ics_size) {
            if (this.impToImpPhase != 2) {
                this.myBdx.dstToSrcMap[i] = i;
            }
            if ((current_level = this.myBdx.propertyMap[i]) < lowest_level) {
                lowest_level = current_level;
            }
            if (current_level > highest_level) {
                highest_level = current_level;
            }
            ++i;
        }
        if (this.reqImpToImp && this.impToImpOrient == 0) {
            return;
        }
        lowest_level = this.ics_orient_out == BidiFlag.ORIENTATION_RTL ? (byte)(lowest_level + 1 & 0xFFFFFFFE) : (byte)((byte)(lowest_level | 1));
        byte work_level = highest_level;
        while (work_level >= lowest_level) {
            i = 0;
            while (i < this.ics_size) {
                current_level = this.myBdx.propertyMap[i];
                if (current_level < work_level) {
                    ++i;
                    continue;
                }
                flip_from = i;
                i = flip_from + 1;
                while (i < this.ics_size && this.myBdx.propertyMap[i] >= work_level) {
                    ++i;
                }
                flip_to = i - 1;
                BidiOrder.invertMap(this.myBdx.dstToSrcMap, flip_from, flip_to);
            }
            work_level = (byte)(work_level - 1);
        }
    }

    private void pass3() {
        int i = 0;
        while (i < this.ics_size) {
            int logPos = this.myBdx.dstToSrcMap[i];
            char xchar = this.ics_buffer_in[logPos];
            byte xtype = this.typeArray[logPos][0];
            if (xtype == 4) {
                if (this.ics_num_flag == BidiFlag.NUMERALS_NATIONAL || this.ics_num_flag == BidiFlag.NUMERALS_CONTEXTUAL && this.typeArray[logPos][1] == 5) {
                    xchar = (char)(xchar + 1584);
                }
            } else if (xtype == 5) {
                if (this.ics_num_flag == BidiFlag.NUMERALS_NOMINAL) {
                    xchar = (char)(xchar - 1584);
                }
            } else if (xtype == -7) {
                xchar = BidiOrder.UCQSYMM(xchar);
            }
            this.ics_buffer_out[i] = xchar;
            ++i;
        }
    }

    synchronized void order(BidiText src, BidiText dst, BidiTransform bdx) {
        int pos;
        boolean dstToSrcMapRequired;
        int ipos;
        int type1;
        int i = 0;
        if (src.count < 1) {
            if (dst.data == null) {
                dst.data = new char[0];
            }
            bdx.inpCount = 0;
            bdx.outCount = 0;
            return;
        }
        this.myBdx = bdx;
        this.ics_orient_in = src.flags.getOrientation();
        this.ics_orient_out = dst.flags.getOrientation();
        if (this.ics_orient_in == BidiFlag.ORIENTATION_CONTEXT_LTR || this.ics_orient_in == BidiFlag.ORIENTATION_CONTEXT_RTL) {
            type1 = BidiOrder.firstStrong(src);
            switch (type1) {
                case 2: {
                    this.ics_orient_in = BidiFlag.ORIENTATION_LTR;
                    break;
                }
                case 3: {
                    this.ics_orient_in = BidiFlag.ORIENTATION_RTL;
                    break;
                }
                case 7: {
                    this.ics_orient_in = this.ics_orient_in == BidiFlag.ORIENTATION_CONTEXT_RTL ? BidiFlag.ORIENTATION_RTL : BidiFlag.ORIENTATION_LTR;
                }
            }
        }
        if (this.ics_orient_out == BidiFlag.ORIENTATION_CONTEXT_LTR || this.ics_orient_out == BidiFlag.ORIENTATION_CONTEXT_RTL) {
            type1 = BidiOrder.firstStrong(src);
            switch (type1) {
                case 2: {
                    type1 = BidiOrder.lastStrong(src);
                    if (type1 == 3) {
                        this.ics_orient_out = BidiFlag.ORIENTATION_RTL;
                        break;
                    }
                    this.ics_orient_out = BidiFlag.ORIENTATION_LTR;
                    break;
                }
                case 3: {
                    this.ics_orient_out = BidiFlag.ORIENTATION_RTL;
                    break;
                }
                case 7: {
                    this.ics_orient_out = this.ics_orient_out == BidiFlag.ORIENTATION_CONTEXT_RTL ? BidiFlag.ORIENTATION_RTL : BidiFlag.ORIENTATION_LTR;
                }
            }
        }
        this.ics_type_in = src.flags.getType();
        this.ics_type_out = dst.flags.getType();
        boolean bl = this.reqImpToImp = this.ics_type_in == BidiFlag.TYPE_IMPLICIT && this.ics_type_out == BidiFlag.TYPE_IMPLICIT;
        this.impToImpOrient = this.myBdx.impToImp && this.reqImpToImp && this.ics_orient_in != this.ics_orient_out ? (this.ics_orient_in == BidiFlag.ORIENTATION_LTR ? 4 : 8) : 0;
        this.delim1 = (char)65535;
        if (this.myBdx.delimiters != null && this.myBdx.delimiters.length() > 0) {
            this.delim1 = this.myBdx.delimiters.charAt(0);
            this.delim2 = this.myBdx.delimiters.length() > 1 ? this.myBdx.delimiters.charAt(1) : this.delim1;
        }
        this.insertMarkers = this.myBdx.insertMarkers;
        this.ics_buffer_in = new char[src.count];
        if (this.ics_type_in == BidiFlag.TYPE_VISUAL && this.ics_type_out == BidiFlag.TYPE_IMPLICIT && (this.insertMarkers && this.ics_orient_in == BidiFlag.ORIENTATION_RTL || !this.insertMarkers && this.ics_orient_in != this.ics_orient_out)) {
            this.invertInput = true;
            int ofs = src.offset + src.count - 1;
            int k = 0;
            while (k < src.count) {
                this.ics_buffer_in[k] = src.data[ofs - k];
                ++k;
            }
            this.ics_orient_in = this.insertMarkers ? BidiFlag.ORIENTATION_LTR : this.ics_orient_out;
        } else {
            this.invertInput = false;
            System.arraycopy(src.data, src.offset, this.ics_buffer_in, 0, src.count);
        }
        if (this.insertMarkers) {
            if (this.ics_type_in != BidiFlag.TYPE_VISUAL || this.ics_type_out != BidiFlag.TYPE_IMPLICIT || this.myBdx.removeMarkers) {
                this.insertMarkers = false;
            } else if (this.ics_orient_out == BidiFlag.ORIENTATION_RTL) {
                this.ics_orient_in = BidiFlag.ORIENTATION_RTL;
                this.ics_orient_out = BidiFlag.ORIENTATION_LTR;
            }
        }
        this.ics_size = src.count;
        this.ics_num_flag = dst.flags.getNumerals();
        this.ics_symmetric = this.reqImpToImp ? false : dst.flags.getSwap() != src.flags.getSwap();
        this.ics_buffer_out = new char[src.count];
        this.typeArray = new byte[src.count][2];
        if (this.myBdx.propertyMap == null || this.myBdx.propertyMap.length < src.count) {
            this.myBdx.propertyMap = new byte[src.count];
        }
        if (this.myBdx.dstToSrcMap == null || this.myBdx.dstToSrcMap.length < src.count) {
            this.myBdx.dstToSrcMap = new int[src.count];
        }
        if (this.impToImpOrient > 0) {
            this.impToImpPhase = 1;
            BidiFlag orient_save = this.ics_orient_out;
            this.ics_orient_out = BidiFlag.ORIENTATION_LTR;
            this.ics_symmetric = src.flags.getSwap() == BidiFlag.SWAP_YES;
            this.BaseLvl();
            this.fillTypeArray();
            this.ucb_ix = 0;
            while (this.ucb_ix < this.ics_size) {
                this.ucb_xType = this.typeArray[this.ucb_ix][1];
                this.implicitProcessing();
                this.myBdx.propertyMap[this.ucb_ix] = this.ucb_wTarget;
                if (this.typeArray[this.ucb_ix][0] == 7 && this.ics_symmetric && BidiOrder.odd(this.ucb_wTarget)) {
                    this.typeArray[this.ucb_ix][0] = -7;
                }
                ++this.ucb_ix;
            }
            this.ucb_ix = this.ics_size;
            this.ucb_xType = 0;
            this.implicitProcessing();
            this.pass2();
            this.ics_orient_out = orient_save;
            this.impToImpPhase = 2;
            orient_save = this.ics_orient_in;
            if (this.impToImpOrient == 4) {
                this.ics_orient_in = BidiFlag.ORIENTATION_RTL;
                BidiOrder.invertMap(this.myBdx.dstToSrcMap, 0, this.ics_size - 1);
            } else {
                this.ics_orient_in = BidiFlag.ORIENTATION_LTR;
            }
            this.ics_symmetric = dst.flags.getSwap() == BidiFlag.SWAP_YES;
            this.BaseLvl();
            this.fillTypeArray2();
            this.ucb_ix = 0;
            while (this.ucb_ix < this.ics_size) {
                ipos = this.myBdx.dstToSrcMap[this.ucb_ix];
                this.ucb_xType = this.typeArray[ipos][1];
                this.implicitProcessing();
                this.myBdx.propertyMap[this.ucb_ix] = this.ucb_wTarget;
                if (Math.abs(this.typeArray[ipos][0]) == 7 && this.ics_symmetric && BidiOrder.odd(this.ucb_wTarget)) {
                    byte[] byArray = this.typeArray[ipos];
                    byArray[0] = (byte)(byArray[0] * -1);
                }
                ++this.ucb_ix;
            }
            this.ucb_ix = this.ics_size;
            this.ucb_xType = 0;
            this.implicitProcessing();
            this.pass2();
            this.ics_orient_in = orient_save;
            this.ics_symmetric = true;
        } else {
            this.BaseLvl();
            this.fillTypeArray();
            this.ucb_ix = 0;
            while (this.ucb_ix < this.ics_size) {
                this.ucb_xType = this.typeArray[this.ucb_ix][1];
                this.implicitProcessing();
                this.myBdx.propertyMap[this.ucb_ix] = this.ucb_wTarget;
                if (this.typeArray[this.ucb_ix][0] == 7 && this.ics_symmetric && BidiOrder.odd(this.ucb_wTarget)) {
                    this.typeArray[this.ucb_ix][0] = -7;
                }
                ++this.ucb_ix;
            }
            this.ucb_ix = this.ics_size;
            this.ucb_xType = 0;
            this.implicitProcessing();
            this.pass2();
        }
        this.pass3();
        boolean bl2 = dstToSrcMapRequired = this.myBdx.dstToSrcMapRequired || this.myBdx.srcToDstMapRequired;
        if (dstToSrcMapRequired && this.invertInput) {
            i = 0;
            while (i < src.count) {
                this.myBdx.dstToSrcMap[i] = src.count - this.myBdx.dstToSrcMap[i] - 1;
                ++i;
            }
        }
        if (this.myBdx.removeMarkers) {
            pos = 0;
            while (pos < src.count) {
                char c = this.ics_buffer_out[pos];
                if (c == '\u200e' || c == '\u200f') {
                    ++this.removeCnt;
                } else if (this.removeCnt > 0) {
                    this.ics_buffer_out[pos - this.removeCnt] = this.ics_buffer_out[pos];
                    this.myBdx.dstToSrcMap[pos - this.removeCnt] = this.myBdx.dstToSrcMap[pos];
                }
                ++pos;
            }
        }
        dst.count = src.count - this.removeCnt + this.insertCnt;
        if (dst.data == null) {
            dst.data = dst.offset == 0 && this.insertCnt == 0 ? this.ics_buffer_out : new char[dst.offset + dst.count];
        }
        if (dst.offset + dst.count > dst.data.length) {
            char[] temp = new char[dst.offset + dst.count];
            if (dst.offset > 0) {
                System.arraycopy(dst.data, 0, temp, 0, dst.offset);
            }
            dst.data = temp;
            temp = null;
        }
        if (this.insertCnt > 0) {
            char insert;
            int after;
            int[] tempMap = null;
            i = 0;
            while (i < this.insertCnt) {
                long iPoint = (Long)this.myBdx.insertPoints.get(i);
                ipos = (int)(iPoint >> 17);
                after = (int)(iPoint & 0x10000L);
                insert = (char)iPoint;
                if (this.ucb_basLev == 1) {
                    pos = 0;
                    while (pos < src.count) {
                        if (ipos == this.myBdx.dstToSrcMap[pos]) {
                            ipos = pos;
                            break;
                        }
                        ++pos;
                    }
                    this.myBdx.insertPoints.setElementAt(new Long((ipos << 17) + after + insert), i);
                }
                ++i;
            }
            if (this.ucb_basLev == 1) {
                Collections.sort(this.myBdx.insertPoints);
            }
            if (dstToSrcMapRequired) {
                tempMap = new int[dst.count];
            }
            pos = 0;
            i = 0;
            while (i < this.insertCnt) {
                long iPoint = (Long)this.myBdx.insertPoints.get(i);
                ipos = (int)(iPoint >> 17);
                after = (int)(iPoint & 0x10000L);
                insert = (char)iPoint;
                System.arraycopy(this.ics_buffer_out, pos, dst.data, dst.offset + pos + i, (ipos += after >> 16) - pos);
                dst.data[dst.offset + ipos + i] = insert;
                if (dstToSrcMapRequired) {
                    System.arraycopy(this.myBdx.dstToSrcMap, pos, tempMap, pos + i, ipos - pos);
                    tempMap[ipos + i] = -1;
                }
                pos = ipos;
                ++i;
            }
            System.arraycopy(this.ics_buffer_out, pos, dst.data, dst.offset + pos + this.insertCnt, dst.count - pos - this.insertCnt);
            if (dstToSrcMapRequired) {
                System.arraycopy(this.myBdx.dstToSrcMap, pos, tempMap, pos + this.insertCnt, dst.count - pos - this.insertCnt);
                this.myBdx.dstToSrcMap = tempMap;
            }
        } else if (dst.data != this.ics_buffer_out) {
            System.arraycopy(this.ics_buffer_out, 0, dst.data, dst.offset, dst.count);
        }
        if (this.myBdx.srcToDstMapRequired) {
            if (this.myBdx.srcToDstMap == null || this.myBdx.srcToDstMap.length < src.count) {
                this.myBdx.srcToDstMap = new int[src.count];
            }
            if (this.removeCnt > 0) {
                Arrays.fill(this.myBdx.srcToDstMap, 0, src.count, -1);
            }
            i = 0;
            while (i < dst.count) {
                pos = this.myBdx.dstToSrcMap[i];
                if (pos >= 0) {
                    this.myBdx.srcToDstMap[pos] = i;
                }
                ++i;
            }
        }
        if (this.myBdx.propertyMapRequired) {
            i = 0;
            while (i < src.count) {
                if (this.typeArray[i][0] != 13) {
                    int n = i;
                    bdx.propertyMap[n] = (byte)(bdx.propertyMap[n] | 0x80);
                }
                ++i;
            }
            if (this.invertInput) {
                BidiOrder.invertMap(this.myBdx.propertyMap, 0, src.count - 1);
            }
        }
        this.myBdx.inpCount = src.count;
        this.myBdx.outCount = dst.count;
    }
}

