/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui;

import com.ibm.collaboration.realtime.ui.DisplayLoop;
import com.ibm.collaboration.realtime.ui.NonmodalPreferenceDialog;
import com.ibm.collaboration.realtime.ui.UiPlugin;
import com.ibm.collaboration.realtime.ui.internal.registry.WorkbenchFreeActionSetRegistry;
import com.ibm.collaboration.realtime.ui.strings.LogMessages;
import com.ibm.collaboration.realtime.ui.util.SwtUtils;
import com.ibm.collaboration.realtime.util.OSUtils;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivity;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.themes.IThemeRegistry;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;

public class WorkbenchAdapter {
    private static final Logger logger = Logger.getLogger(WorkbenchAdapter.class.getName());
    private static WorkbenchAdapter adapter = new WorkbenchAdapter();
    private final int returnCode = 0;
    private PrefNodeComparator prefNodeComparator;
    private WorkbenchFreeActionSetRegistry actionSetRegistry;
    private static boolean isRunning;
    private static boolean usingPersonality;
    private static String SAMETIME_HIDE_UI_ACTIVITY_ID;
    private static String SAMETIME_PARENT_PREF_PAGE;
    private String parentPageId;
    private static NonmodalPreferenceDialog prefsDialog;
    private static boolean disposeParent;
    private static Shell parentToDispose;
    private final ArrayList filteredPages = new ArrayList();

    static {
        SAMETIME_HIDE_UI_ACTIVITY_ID = "activity.collaboration.realtime.ui";
        SAMETIME_PARENT_PREF_PAGE = "com.ibm.collaboration.realtime.application.prefs.SametimePreferencePage";
        prefsDialog = null;
        disposeParent = false;
        parentToDispose = null;
    }

    public static WorkbenchAdapter getInstance() {
        return adapter;
    }

    public static boolean isRunning() {
        return isRunning;
    }

    public static boolean isStandalone() {
        return WorkbenchAdapter.isRunning() || usingPersonality;
    }

    public static boolean isUiDisabled() {
        IWorkbench workbench;
        IWorkbenchActivitySupport activitySupport;
        IActivityManager activityMgr;
        IActivity activity;
        boolean isUiDisabled = false;
        if (!WorkbenchAdapter.isStandalone() && (activity = (activityMgr = (activitySupport = (workbench = PlatformUI.getWorkbench()).getActivitySupport()).getActivityManager()).getActivity(SAMETIME_HIDE_UI_ACTIVITY_ID)).isDefined()) {
            isUiDisabled = !activity.isEnabled();
        }
        return isUiDisabled;
    }

    public static void setUsingPersonality(boolean usingIt) {
        usingPersonality = usingIt;
    }

    public static boolean isUsingPersonality() {
        return usingPersonality;
    }

    public ITheme getCurrentTheme() {
        return this.getThemeManager().getCurrentTheme();
    }

    public IThemeManager getThemeManager() {
        IThemeManager themeMgr = null;
        if (PlatformUI.isWorkbenchRunning()) {
            themeMgr = PlatformUI.getWorkbench().getThemeManager();
        }
        return themeMgr;
    }

    public static boolean isXpdBased() {
        File rcpDir = OSUtils.getRcpDir();
        return rcpDir != null && rcpDir.exists();
    }

    public int run(Display display, WorkbenchAdvisor advisor) {
        isRunning = true;
        if (logger.isLoggable(Level.FINE)) {
            if (advisor != null) {
                logger.fine(LogMessages.WorkbenchAdapter_0);
            } else {
                logger.fine(LogMessages.WorkbenchAdapter_1);
            }
        }
        int returnCode = advisor != null ? this.createAndRunWorkbench(display, advisor) : this.runEventLoop(display);
        isRunning = false;
        return returnCode;
    }

    private int runEventLoop(Display display) {
        DisplayLoop.setDisplay(display);
        this.init();
        DisplayLoop.runEventLoop();
        return 0;
    }

    private int createAndRunWorkbench(Display display, WorkbenchAdvisor advisor) {
        return PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)advisor);
    }

    private void init() {
    }

    public void close() {
        if (WorkbenchAdapter.getPreferencesDialog() != null && WorkbenchAdapter.getPreferencesDialog().getShell() != null && !WorkbenchAdapter.getPreferencesDialog().getShell().isDisposed()) {
            WorkbenchAdapter.getPreferencesDialog().close();
        }
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().close();
        } else {
            DisplayLoop.setRunEventLoop(false);
        }
    }

    public IThemeRegistry getThemeRegistry() {
        if (PlatformUI.isWorkbenchRunning()) {
            return WorkbenchPlugin.getDefault().getThemeRegistry();
        }
        return null;
    }

    public WorkbenchFreeActionSetRegistry getActionSetRegistry() {
        if (this.actionSetRegistry == null) {
            this.actionSetRegistry = new WorkbenchFreeActionSetRegistry();
        }
        return this.actionSetRegistry;
    }

    public PreferenceManager getPreferenceManager() {
        if (PlatformUI.isWorkbenchRunning()) {
            return PlatformUI.getWorkbench().getPreferenceManager();
        }
        return null;
    }

    public static PreferenceDialog getPreferencesDialog() {
        return prefsDialog;
    }

    public PreferenceDialog getPreferencesDialog(Shell parent) {
        if (prefsDialog != null && prefsDialog.getShell() != null && !prefsDialog.getShell().isDisposed()) {
            return prefsDialog;
        }
        Shell useMe = parent;
        if (useMe == null && (useMe = SwtUtils.getTopmostShell()) == null) {
            parentToDispose = useMe = new Shell(Display.getDefault());
        }
        if (prefsDialog == null) {
            PreferenceManager prefMgr = PlatformUI.getWorkbench().getPreferenceManager();
            if (WorkbenchAdapter.isStandalone()) {
                this.filterPreferencePages(prefMgr);
                prefsDialog = new NonmodalPreferenceDialog(useMe, prefMgr);
            } else {
                int modalStyle = 68720;
                prefsDialog = new NonmodalPreferenceDialog(useMe, prefMgr, modalStyle);
            }
            useMe.addShellListener((ShellListener)new ShellAdapter(){

                public void shellClosed(ShellEvent e) {
                    block3: {
                        if (prefsDialog != null) {
                            try {
                                prefsDialog.close();
                                prefsDialog = null;
                            }
                            catch (Exception ex) {
                                if (!logger.isLoggable(Level.FINE)) break block3;
                                logger.log(Level.FINE, "", ex);
                            }
                        }
                    }
                }
            });
            prefsDialog.setBlockOnOpen(true);
        }
        return prefsDialog;
    }

    private IPreferenceNode[] filterPreferencePages(PreferenceManager manager) {
        int i = 0;
        while (i < this.filteredPages.size()) {
            FilteredPage page = (FilteredPage)this.filteredPages.get(i);
            if (page.m_Node == null) {
                page.m_Node = WorkbenchAdapter.filterPreferencePage(manager, page.m_Page);
            }
            ++i;
        }
        ArrayList filteredPrefPages = new ArrayList();
        String pages = UiPlugin.getDefault().getPreferenceStore().getString("filteredPreferencePages");
        if (pages != null) {
            this.filterPreferencePages(pages);
        }
        if ((pages = UiPlugin.getDefault().getPreferenceStore().getString("filteredPrefPagesOverride")) != null) {
            this.filterPreferencePages(pages);
        }
        return filteredPrefPages.toArray(new IPreferenceNode[0]);
    }

    private void filterPreferencePages(String pages) {
        StringTokenizer tok = new StringTokenizer(pages, ",");
        while (tok.hasMoreTokens()) {
            String pageToFilter = tok.nextToken();
            this.filterPreferencePage(pageToFilter);
        }
    }

    private static IPreferenceNode filterPreferencePage(PreferenceManager manager, String pageToFilter) {
        if (pageToFilter == null) {
            return null;
        }
        IPreferenceNode node = manager.find(pageToFilter);
        if (node != null) {
            manager.remove(node);
        }
        return node;
    }

    public void unfilterPreferencePage(String pageToFilter) {
        block22: {
            FilteredPage page;
            boolean bFound;
            block21: {
                IPreferenceNode node = null;
                bFound = false;
                page = null;
                int i = 0;
                while (i < this.filteredPages.size()) {
                    page = (FilteredPage)this.filteredPages.get(i);
                    if (page.m_Page.equals(pageToFilter)) {
                        bFound = true;
                        this.filteredPages.remove(i);
                        break;
                    }
                    ++i;
                }
                if (WorkbenchAdapter.isStandalone() || !PlatformUI.isWorkbenchRunning()) break block21;
                if (!bFound || page.m_Node == null) break block22;
                PreferenceManager manager = WorkbenchAdapter.getInstance().getPreferenceManager();
                IPreferenceNode sametimeParentNode = null;
                node = manager.find(pageToFilter);
                if (node == null && page.m_Parent != null) {
                    IPreferenceNode parentNode = manager.find(page.m_Parent);
                    if (parentNode != null) {
                        IPreferenceNode subNode;
                        parentNode.add(page.m_Node);
                        IPreferenceNode[] subNodes = parentNode.getSubNodes();
                        int index = 0;
                        while (index < subNodes.length) {
                            subNode = subNodes[index];
                            parentNode.remove(subNode);
                            ++index;
                        }
                        Arrays.sort(subNodes, this.getPrefNodeComparator());
                        index = 0;
                        while (index < subNodes.length) {
                            subNode = subNodes[index];
                            parentNode.add(subNode);
                            ++index;
                        }
                    } else {
                        IPreferenceNode[] subnodes = manager.getRootSubNodes();
                        int i2 = 0;
                        while (i2 < subnodes.length) {
                            if (subnodes[i2].getId().compareTo(SAMETIME_PARENT_PREF_PAGE) == 0 && (sametimeParentNode = subnodes[i2]) != null) {
                                IPreferenceNode[] sametimeSubnodes = sametimeParentNode.getSubNodes();
                                if (page.m_Parent != null) {
                                    int sametimeLoop = 0;
                                    while (sametimeLoop < sametimeSubnodes.length) {
                                        if (sametimeSubnodes[sametimeLoop].getId().compareTo(page.m_Parent) == 0) {
                                            IPreferenceNode childSubNode;
                                            IPreferenceNode subParentNode = sametimeSubnodes[sametimeLoop];
                                            subParentNode.add(page.m_Node);
                                            IPreferenceNode[] tmpSubNodes = subParentNode.getSubNodes();
                                            int index = 0;
                                            while (index < tmpSubNodes.length) {
                                                childSubNode = tmpSubNodes[index];
                                                subParentNode.remove(childSubNode);
                                                ++index;
                                            }
                                            Arrays.sort(tmpSubNodes, this.getPrefNodeComparator());
                                            index = 0;
                                            while (index < tmpSubNodes.length) {
                                                childSubNode = tmpSubNodes[index];
                                                subParentNode.add(childSubNode);
                                                ++index;
                                            }
                                        }
                                        ++sametimeLoop;
                                    }
                                }
                            }
                            ++i2;
                        }
                    }
                }
                break block22;
            }
            if (bFound && page.m_Node != null) {
                PreferenceManager manager = WorkbenchAdapter.getInstance().getPreferenceManager();
                IPreferenceNode tmpInstallNode = manager.find(pageToFilter);
                if (tmpInstallNode != null) {
                    return;
                }
                if (page.m_Parent != null) {
                    IPreferenceNode subNode;
                    IPreferenceNode parentNode = manager.find(page.m_Parent);
                    parentNode.add(page.m_Node);
                    IPreferenceNode[] subNodes = parentNode.getSubNodes();
                    int i = 0;
                    while (i < subNodes.length) {
                        subNode = subNodes[i];
                        parentNode.remove(subNode);
                        ++i;
                    }
                    Arrays.sort(subNodes, this.getPrefNodeComparator());
                    i = 0;
                    while (i < subNodes.length) {
                        subNode = subNodes[i];
                        parentNode.add(subNode);
                        ++i;
                    }
                } else {
                    manager.addToRoot(page.m_Node);
                    IPreferenceNode[] nodes = manager.getRootSubNodes();
                    Arrays.sort(nodes, this.getPrefNodeComparator());
                    manager.removeAll();
                    int i = 0;
                    while (i < nodes.length) {
                        IPreferenceNode tmpNode = nodes[i];
                        manager.addToRoot(tmpNode);
                        ++i;
                    }
                }
            }
        }
    }

    private PrefNodeComparator getPrefNodeComparator() {
        if (this.prefNodeComparator == null) {
            this.prefNodeComparator = new PrefNodeComparator();
        }
        return this.prefNodeComparator;
    }

    public IPreferenceNode filterPreferencePage(String pageToFilter) {
        IPreferenceNode node = null;
        boolean bFound = false;
        int i = 0;
        while (i < this.filteredPages.size()) {
            FilteredPage page = (FilteredPage)this.filteredPages.get(i);
            if (page.m_Page.equals(pageToFilter)) {
                bFound = true;
                node = page.m_Node;
                break;
            }
            ++i;
        }
        if (!bFound) {
            String parent = null;
            if (PlatformUI.isWorkbenchRunning()) {
                PreferenceManager prefMgr = null;
                if (!WorkbenchAdapter.isStandalone()) {
                    node = this.findSamtimeEmbeddedPreferencePage(pageToFilter);
                    parent = this.parentPageId;
                } else {
                    prefMgr = PlatformUI.getWorkbench().getPreferenceManager();
                    node = WorkbenchAdapter.filterPreferencePage(prefMgr, pageToFilter);
                    if (node == null) {
                        IPreferenceNode[] subnodes = prefMgr.getRootSubNodes();
                        int i2 = 0;
                        while (i2 < subnodes.length) {
                            node = subnodes[i2].findSubNode(pageToFilter);
                            if (node != null) {
                                node = subnodes[i2].remove(pageToFilter);
                                parent = subnodes[i2].getId();
                                break;
                            }
                            ++i2;
                        }
                    }
                }
                WorkbenchAdapter.refreshPreferenceDialogTree();
            }
            if (node != null) {
                FilteredPage newpage = new FilteredPage();
                newpage.m_Node = node;
                newpage.m_Page = pageToFilter;
                if (parent != null) {
                    newpage.m_Parent = parent;
                }
                this.filteredPages.add(newpage);
            }
        }
        return node;
    }

    public boolean isPreferencePageFiltered(String page) {
        int i = 0;
        while (i < this.filteredPages.size()) {
            if (((FilteredPage)this.filteredPages.get((int)i)).m_Page.equals(page)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IPreferenceNode findSamtimeEmbeddedPreferencePage(String pageToFilter) {
        IPreferenceNode node = null;
        IPreferenceNode tmpNode = null;
        if (!PlatformUI.isWorkbenchRunning()) {
            return null;
        }
        if (WorkbenchAdapter.isStandalone()) {
            return null;
        }
        PreferenceManager prefMgr = null;
        IPreferenceNode sametimeParentNode = null;
        prefMgr = PlatformUI.getWorkbench().getPreferenceManager();
        IPreferenceNode[] subnodes = prefMgr.getRootSubNodes();
        if (subnodes == null) {
            return null;
        }
        int i = 0;
        while (i < subnodes.length) {
            if (subnodes[i].getId().compareTo(SAMETIME_PARENT_PREF_PAGE) == 0) {
                sametimeParentNode = subnodes[i];
                break;
            }
            ++i;
        }
        if (sametimeParentNode == null) {
            return null;
        }
        node = WorkbenchAdapter.filterPreferencePage(prefMgr, pageToFilter);
        if (node != null) {
            this.parentPageId = sametimeParentNode.getId();
            return node;
        }
        IPreferenceNode[] sametimeSubnodes = sametimeParentNode.getSubNodes();
        if (sametimeSubnodes == null) {
            return null;
        }
        int sametimeLoop = 0;
        while (sametimeLoop < sametimeSubnodes.length) {
            if (sametimeSubnodes[sametimeLoop].getId().compareTo(pageToFilter) == 0) {
                node = sametimeParentNode.remove(pageToFilter);
                this.parentPageId = sametimeParentNode.getId();
                break;
            }
            tmpNode = sametimeSubnodes[sametimeLoop].findSubNode(pageToFilter);
            if (tmpNode != null) {
                node = sametimeSubnodes[sametimeLoop].remove(pageToFilter);
                this.parentPageId = sametimeSubnodes[sametimeLoop].getId();
                break;
            }
            ++sametimeLoop;
        }
        return node;
    }

    public static void showPreferences(String selected, Shell parent) {
        WorkbenchAdapter.showPreferences(selected, parent, null);
    }

    public static void showPreferences(String selected, Shell parent, Object data) {
        try {
            if (prefsDialog != null && prefsDialog.getShell() != null && !prefsDialog.getShell().isDisposed()) {
                if (prefsDialog.getShell().getMinimized()) {
                    prefsDialog.getShell().setMinimized(false);
                } else {
                    if (selected != null) {
                        try {
                            IPreferenceNode node = prefsDialog.getPreferenceManager().find(selected);
                            if (node != null) {
                                prefsDialog.forceSelection(node);
                            } else {
                                prefsDialog.setSelectedNode(selected);
                            }
                        }
                        catch (Exception exception) {}
                    }
                    if (data != null) {
                        prefsDialog.setPageData(data);
                    }
                    prefsDialog.getShell().setActive();
                }
                return;
            }
            if (prefsDialog == null || prefsDialog.getShell() == null || prefsDialog.getShell().isDisposed()) {
                WorkbenchAdapter.getInstance().getPreferencesDialog(parent);
                if (parent != null) {
                    parent.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent arg0) {
                            block3: {
                                if (prefsDialog != null) {
                                    try {
                                        prefsDialog.close();
                                        prefsDialog = null;
                                    }
                                    catch (Exception e) {
                                        if (!logger.isLoggable(Level.FINE)) break block3;
                                        logger.log(Level.FINE, "", e);
                                    }
                                }
                            }
                        }
                    });
                }
            }
            if (selected != null) {
                try {
                    prefsDialog.setSelectedNode(selected);
                }
                catch (Exception exception) {}
            }
            if (data != null) {
                prefsDialog.setPageData(data);
            }
            prefsDialog.open();
            prefsDialog = null;
            if (parentToDispose != null) {
                parentToDispose.dispose();
                parentToDispose = null;
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, LogMessages.couldNotOpenPrefDialog, e);
            }
            if (prefsDialog != null) {
                prefsDialog.close();
            }
            prefsDialog = null;
            parentToDispose = null;
        }
    }

    public static void showPreferences(String selected) {
        WorkbenchAdapter.showPreferences(selected, null, null);
    }

    public static void showPreferences(String selected, Object data) {
        WorkbenchAdapter.showPreferences(selected, null, data);
    }

    public static void refreshPreferenceDialogTree() {
        if (prefsDialog != null) {
            prefsDialog.refreshTreeViewer();
        }
    }

    public static void showPreferences() {
        WorkbenchAdapter.showPreferences(null);
    }

    public IEclipsePreferences getEclipsePreferences(String qualifier) {
        return this.getEclipsePreferences(qualifier, true);
    }

    public IEclipsePreferences getEclipsePreferences(String qualifier, boolean validateBundleExists) {
        IEclipsePreferences prefs;
        block5: {
            prefs = null;
            try {
                if (prefs == null) {
                    Bundle b;
                    boolean createPrefs = true;
                    if (validateBundleExists && (b = Platform.getBundle((String)qualifier)) == null) {
                        createPrefs = false;
                    }
                    if (createPrefs) {
                        InstanceScope context = new InstanceScope();
                        prefs = context.getNode(qualifier);
                    }
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.INFO)) break block5;
                String msg = NLS.bind((String)LogMessages.couldNotObtainEclipsePrefs, (Object)qualifier);
                logger.log(Level.INFO, msg, e);
            }
        }
        return prefs;
    }

    public void setEclipsePreference(IEclipsePreferences prefs, String key, String value) {
        block3: {
            if (prefs != null) {
                try {
                    prefs.sync();
                    prefs.put(key, value);
                    prefs.flush();
                }
                catch (BackingStoreException e) {
                    if (!logger.isLoggable(Level.INFO)) break block3;
                    String msg = NLS.bind((String)LogMessages.exSavingEclipsePrefs, (Object)prefs.name());
                    logger.log(Level.INFO, msg, e);
                }
            }
        }
    }

    public void setEclipsePreference(IEclipsePreferences prefs, String key, boolean value) {
        block3: {
            if (prefs != null) {
                try {
                    prefs.sync();
                    prefs.putBoolean(key, value);
                    prefs.flush();
                }
                catch (BackingStoreException e) {
                    if (!logger.isLoggable(Level.INFO)) break block3;
                    String msg = NLS.bind((String)LogMessages.exSavingEclipsePrefs, (Object)prefs.name());
                    logger.log(Level.INFO, msg, e);
                }
            }
        }
    }

    public void setEclipsePreference(IEclipsePreferences prefs, String key, int value) {
        block3: {
            if (prefs != null) {
                try {
                    prefs.sync();
                    prefs.putInt(key, value);
                    prefs.flush();
                }
                catch (BackingStoreException e) {
                    if (!logger.isLoggable(Level.INFO)) break block3;
                    String msg = NLS.bind((String)LogMessages.exSavingEclipsePrefs, (Object)prefs.name());
                    logger.log(Level.INFO, msg, e);
                }
            }
        }
    }

    class FilteredPage {
        public String m_Page;
        public IPreferenceNode m_Node = null;
        public String m_Parent = null;

        FilteredPage() {
        }
    }

    private class PrefNodeComparator
    implements Comparator {
        private PrefNodeComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            String label1 = ((IPreferenceNode)arg0).getLabelText();
            String label2 = ((IPreferenceNode)arg1).getLabelText();
            return Collator.getInstance().compare(label1, label2);
        }
    }
}

