/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui;

import com.ibm.collaboration.realtime.ui.STBrandingControl;
import com.ibm.collaboration.realtime.ui.strings.LogMessages;
import com.ibm.collaboration.realtime.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class UiPlugin
extends AbstractUIPlugin {
    public static final String PREF_USE_XUL_FOR_MEETINGS = "UseXulrunnerForMeetings";
    public static final String PREF_USE_XUL_FOR_ATTEND_AND_SCHEDUAL_MEETINGS = "UseXulrunnerForAttendAndSchedualMeetings";
    public static final String PREF_USE_ACTION_SET_ADAPTER = "useActionSetAdapter";
    private static final Logger _logger = Logger.getLogger(UiPlugin.class.getPackage().getName());
    private static UiPlugin plugin;
    private ResourceBundle bundle;
    private HashMap sharedStrings;
    private final ArrayList brands = new ArrayList();

    public UiPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Job loadExt = new Job("Load branding extensions"){

            protected IStatus run(IProgressMonitor arg0) {
                block5: {
                    block4: {
                        try {
                            UiPlugin.this.loadBrandingExtensions();
                        }
                        catch (Exception e) {
                            if (!_logger.isLoggable(Level.FINE)) break block4;
                            _logger.log(Level.FINE, LogMessages.ExLoadingExt, e);
                        }
                    }
                    try {
                        UiPlugin.this.unzipXulApp();
                    }
                    catch (Exception e) {
                        if (!_logger.isLoggable(Level.FINE)) break block5;
                        _logger.log(Level.FINE, LogMessages.ExXulApp, e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        loadExt.setSystem(true);
        loadExt.schedule();
    }

    public void unzipXulApp() {
        block3: {
            try {
                String pathToApplication = FileLocator.toFileURL((URL)FileLocator.find((Bundle)this.getBundle(), (IPath)new Path("/xulapp.zip"), null)).getFile();
                String dest = this.getStateLocation().toString();
                StringBuffer buf = new StringBuffer(dest);
                buf.append("/xulapp");
                File xulApp = new File(buf.toString());
                if (!xulApp.exists()) {
                    FileUtils.unzip((String)pathToApplication, (String)dest);
                }
            }
            catch (IOException e) {
                if (!_logger.isLoggable(Level.FINE)) break block3;
                _logger.log(Level.FINE, LogMessages.ExXulApp, e);
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static UiPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.collaboration.realtime.ui", (String)path);
    }

    private void loadBrandingExtensions() {
        IExtension[] extensions;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.collaboration.realtime.ui.stbranding");
        if (extensionPoint != null && (extensions = extensionPoint.getExtensions()) != null) {
            int index = 0;
            while (index < extensions.length) {
                IConfigurationElement[] elements = extensions[index].getConfigurationElements();
                int i = 0;
                while (i < elements.length) {
                    String id = extensions[index].getUniqueIdentifier();
                    this.brands.add(new STBrandingControl(id, extensions[index].getNamespaceIdentifier(), elements[i]));
                    ++i;
                }
                ++index;
            }
        }
    }

    public void fillBrandingArea(Composite parent, int width, int height, String viewRestriction) {
        STBrandingControl ctrl = this.getBranding(width, height, -1, viewRestriction);
        if (ctrl != null) {
            ctrl.createControl(parent);
        }
    }

    public STBrandingControl getBranding(int width, int height, String targetView) {
        return this.getBranding(width, height, -1, targetView, true);
    }

    public STBrandingControl getBranding(int width, int height, int valign, String targetView) {
        STBrandingControl bestFit = null;
        int bestRanking = -1;
        int i = 0;
        while (i < this.brands.size()) {
            STBrandingControl control = (STBrandingControl)this.brands.get(i);
            int ranking = this.getBestFitRanking(control, width, height, valign, targetView);
            if (ranking > bestRanking) {
                bestFit = control;
            }
            ++i;
        }
        if (bestFit == null && width == -1 && height == -1) {
            bestFit = (STBrandingControl)this.brands.get(0);
        }
        return bestFit;
    }

    public STBrandingControl getBranding(int width, int height, int valign, String targetView, boolean exact) {
        String brand = this.getPluginPreferences().getString("stbranding");
        STBrandingControl bestFit = null;
        int bestRanking = -1;
        int i = 0;
        while (i < this.brands.size()) {
            STBrandingControl control = (STBrandingControl)this.brands.get(i);
            if (exact) {
                if (!(width != -1 && width != control.getWidth() || height != -1 && height != control.getHeight() || valign != -1 && valign != control.getVAlignment() || targetView == null || !targetView.equals(control.getRestriction()) || (brand == null || !brand.equals(control.getBrandId())) && brand != null && !"".equals(brand))) {
                    return control;
                }
            } else {
                int ranking = this.getBestFitRanking(control, width, height, valign, targetView);
                if (ranking > bestRanking) {
                    bestFit = control;
                }
            }
            ++i;
        }
        if (!exact && bestFit == null && width == -1 && height == -1 && this.brands.size() > 0) {
            bestFit = (STBrandingControl)this.brands.get(0);
        }
        return bestFit;
    }

    public NLS getCustomMessages() {
        NLS customMessages = null;
        int i = 0;
        while (i < this.brands.size()) {
            STBrandingControl control = (STBrandingControl)this.brands.get(i);
            customMessages = control.getMessages();
            if (customMessages != null) {
                return customMessages;
            }
            ++i;
        }
        return customMessages;
    }

    private int getBestFitRanking(STBrandingControl control, int width, int height, int valign, String targetView) {
        String brand = this.getPluginPreferences().getString("stbranding");
        int rank = -1;
        if (brand != null && brand.equals(control.getBrandId())) {
            rank += 100;
        }
        if (control.getRestriction() != null && targetView != null && control.getRestriction().compareTo(targetView) == 0) {
            rank += 3;
        }
        if (control.getWidth() != -1) {
            if (width != -1 && control.getWidth() == width) {
                rank += 2;
            } else if (control.getWidth() < width) {
                ++rank;
            }
        }
        if (control.getHeight() != -1) {
            if (height != -1 && control.getHeight() == height) {
                rank += 2;
            } else if (control.getHeight() < height) {
                ++rank;
            }
        }
        if (control.getVAlignment() == valign) {
            ++rank;
        }
        return rank;
    }

    public String getResourceString(String string) {
        if (this.bundle == null) {
            this.bundle = Platform.getResourceBundle((Bundle)this.getBundle());
        }
        if (this.bundle != null) {
            try {
                return this.bundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return string;
    }

    public void setSharedString(String key, String value) {
        if (this.sharedStrings == null) {
            this.sharedStrings = new HashMap(10);
        }
        this.sharedStrings.put(key, value);
    }

    public String getSharedString(String key) {
        String value;
        if (this.sharedStrings != null && (value = (String)this.sharedStrings.get(key)) != null) {
            return value;
        }
        return key;
    }

    public boolean useActionSetAdapter() {
        return this.getPluginPreferences().getBoolean(PREF_USE_ACTION_SET_ADAPTER);
    }
}

