/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SimpleWindow {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private Shell shell;
    private Shell parentShell;
    private Control contents;
    private boolean block;
    private int returnCode = 0;
    private int shellStyle = 1264;
    private static final Logger logger = Logger.getLogger(SimpleWindow.class.getName());

    public SimpleWindow() {
    }

    public SimpleWindow(Shell parent) {
        this.parentShell = parent;
    }

    protected Control getContents() {
        return this.contents;
    }

    public Shell getShell() {
        return this.shell;
    }

    protected int getShellStyle() {
        return this.shellStyle;
    }

    protected void setShellStyle(int newShellStyle) {
        this.shellStyle = newShellStyle;
    }

    public void setBlockOnOpen(boolean shouldBlock) {
        this.block = shouldBlock;
    }

    public int open() {
        if (this.shell == null || this.shell.isDisposed()) {
            this.shell = null;
            this.create();
        }
        this.shell.open();
        if (this.block) {
            this.runEventLoop(this.shell);
        }
        return this.returnCode;
    }

    public void create() {
        this.shell = this.createShell();
        this.contents = this.createContents((Composite)this.shell);
        this.initializeBounds();
    }

    protected final Shell createShell() {
        Shell newShell = new Shell(this.parentShell, this.getShellStyle());
        newShell.setData((Object)this);
        newShell.addShellListener(this.getShellListener());
        this.configureShell(newShell);
        return newShell;
    }

    private void runEventLoop(Shell loopShell) {
        Display display = this.shell == null ? Display.getCurrent() : loopShell.getDisplay();
        while (loopShell != null && !loopShell.isDisposed()) {
            try {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            catch (Throwable e) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        display.update();
    }

    protected Control createContents(Composite parent) {
        return new Composite(parent, 0);
    }

    protected void configureShell(Shell newShell) {
        Layout layout = this.getLayout();
        if (layout != null) {
            newShell.setLayout(layout);
        }
    }

    protected Layout getLayout() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        return layout;
    }

    protected Point getInitialSize() {
        return this.shell.computeSize(-1, -1, true);
    }

    protected Point getInitialLocation(Point shellSize) {
        return null;
    }

    protected void initializeBounds() {
        Point location;
        Point shellSize = this.getInitialSize();
        if (shellSize != null) {
            this.shell.setSize(shellSize.x, shellSize.y);
        }
        if ((location = this.getInitialLocation(shellSize)) != null) {
            int xp = location.x;
            int yp = location.y;
            Display display = this.shell.getDisplay();
            if (xp <= display.getClientArea().width && yp <= display.getClientArea().height) {
                this.shell.setLocation(xp, yp);
            }
        }
    }

    protected boolean canHandleShellCloseEvent() {
        return true;
    }

    protected ShellListener getShellListener() {
        return new ShellAdapter(){

            public void shellClosed(ShellEvent event) {
                event.doit = false;
                if (SimpleWindow.this.canHandleShellCloseEvent()) {
                    SimpleWindow.this.handleShellCloseEvent();
                }
            }
        };
    }

    protected void handleShellCloseEvent() {
        this.setReturnCode(1);
        this.close();
    }

    protected void setReturnCode(int code) {
        this.returnCode = code;
    }

    protected void saveShellPositionInformation(Shell shell) {
    }

    public boolean close() {
        if (this.shell == null || this.shell.isDisposed()) {
            return true;
        }
        this.saveShellPositionInformation(this.getShell());
        this.shell.dispose();
        this.shell = null;
        this.contents = null;
        return true;
    }
}

