/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui;

import com.ibm.collaboration.realtime.util.PluginConfigHelper;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public abstract class RtcUIPlugin
extends AbstractUIPlugin {
    public static final String IMAGE_ICON = "icon";
    private static final String PNG_ICON = "icon/icon.png";
    private static final String GIF_ICON = "icon/icon.gif";
    protected static final Logger logger = Logger.getLogger(RtcUIPlugin.class.getPackage().getName());
    private PluginConfigHelper pluginConfigHelper;
    private ResourceBundle pluginProperties;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.pluginProperties = Platform.getResourceBundle((Bundle)this.getBundle());
    }

    public void stop(BundleContext context) throws Exception {
        this.saveConfig();
        super.stop(context);
    }

    protected PluginConfigHelper getPluginConfigHelper() {
        return new PluginConfigHelper((Plugin)this);
    }

    public void saveConfig() {
        this.savePluginPreferences();
    }

    public ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)this.getId(), (String)path);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        ImageDescriptor desc = RtcUIPlugin.imageDescriptorFromPlugin((String)this.getBundle().getSymbolicName(), (String)PNG_ICON);
        if (desc == null) {
            desc = RtcUIPlugin.imageDescriptorFromPlugin((String)this.getBundle().getSymbolicName(), (String)GIF_ICON);
        }
        if (desc != null) {
            reg.put(IMAGE_ICON, desc);
        }
    }

    public Image getImageIcon() {
        ImageDescriptor desc;
        Image im = this.getImageRegistry().get(IMAGE_ICON);
        if (im == null && (desc = this.getImageRegistry().getDescriptor(IMAGE_ICON)) != null) {
            im = desc.createImage();
            this.getImageRegistry().put(IMAGE_ICON, im);
            return im;
        }
        return im;
    }

    public String getId() {
        String id = "unknown";
        Bundle bundle = this.getBundle();
        if (bundle != null) {
            id = bundle.getSymbolicName();
        }
        return id;
    }

    public String getAlias() {
        return this.getHeader("Bundle-Name");
    }

    public String getVersion() {
        return this.getHeader("Bundle-Version");
    }

    public String getDescription() {
        return this.getHeader("Bundle-Description");
    }

    protected String getHeader(String key) {
        String result = null;
        Bundle bundle = this.getBundle();
        if (bundle != null) {
            result = (String)bundle.getHeaders().get(key);
        }
        return result;
    }

    public String getProperty(String key) {
        String val = this.getPref(key);
        if (val != null && "".equals(val.trim()) && this.pluginConfigHelper != null) {
            val = this.pluginConfigHelper.getProperty(key);
        }
        if (val != null && "".equals(val.trim())) {
            val = null;
        }
        return val;
    }

    public void setProperty(String key, String value) {
        if (value == null) {
            value = "";
        }
        this.storePref(key, value);
    }

    public String getPref(String key) {
        return this.getPreferenceStore().getString(key);
    }

    public boolean getPrefAsBoolean(String key) {
        return this.getPreferenceStore().getBoolean(key);
    }

    public int getPrefAsInt(String key) {
        return this.getPreferenceStore().getInt(key);
    }

    public void storePref(String key, String val) {
        if (val == null) {
            val = "";
        }
        this.getPreferenceStore().setValue(key, val);
    }

    public void storePref(String key, boolean val) {
        this.getPreferenceStore().setValue(key, val);
    }

    public void storePref(String key, int val) {
        this.getPreferenceStore().setValue(key, val);
    }

    public boolean prefExists(String key) {
        boolean prefExists = false;
        String pref = this.getPref(key);
        if (pref != null && !"".equals(pref.trim())) {
            prefExists = true;
        }
        return prefExists;
    }

    public String getUID() {
        return this.getId();
    }

    public String getPluginProperty(String key) {
        if (this.pluginProperties != null) {
            return this.pluginProperties.getString(key);
        }
        return null;
    }

    public Object getPluginPropertyObject(String key) {
        if (this.pluginProperties != null) {
            return this.pluginProperties.getObject(key);
        }
        return null;
    }

    public String[] getPluginPropertyArray(String key) {
        if (this.pluginProperties != null) {
            return this.pluginProperties.getStringArray(key);
        }
        return null;
    }
}

