/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;

public class OverlayImageDescriptorWithBase
extends CompositeImageDescriptor {
    protected ImageData idBase;
    protected ImageData overlay;
    protected ImageData another;
    public int iconOffset = 2;
    protected int left = 0;
    protected boolean preserveTransparency = false;
    protected int baseAlpha = 255;
    protected boolean ontop = true;
    protected Point size = null;
    public boolean drawBase = true;
    public boolean alphaOverride = true;
    private boolean hasTransparency = false;
    private ImageData imageData;

    public OverlayImageDescriptorWithBase() {
    }

    public OverlayImageDescriptorWithBase(Image baseImage, Image overlayImage, boolean alphaOveride, int transparency, Color colorOverride, Image anotherOverlay, boolean ontop) {
        this.baseAlpha = transparency;
        if (this.baseAlpha == -1) {
            this.baseAlpha = 255;
        }
        this.ontop = ontop;
        this.idBase = baseImage.getImageData();
        if (overlayImage != null) {
            this.overlay = overlayImage.getImageData();
        }
        if (anotherOverlay != null) {
            this.another = anotherOverlay.getImageData();
        }
        this.left = (this.getSize().x - 16) / 2;
    }

    protected void drawCompositeImage(int x, int y) {
        if (!this.alphaOverride) {
            int i;
            this.preserveTransparency = true;
            if (this.idBase.alphaData != null) {
                i = 0;
                while (i < this.idBase.alphaData.length) {
                    if (this.idBase.alphaData[i] > 0) {
                        this.hasTransparency = true;
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < this.idBase.width) {
                int j = 0;
                while (j < this.idBase.height) {
                    int alpha = this.idBase.getAlpha(i, j);
                    if (!this.hasTransparency) {
                        alpha = 255;
                    }
                    alpha = (int)((double)alpha * ((double)this.baseAlpha / 255.0));
                    this.idBase.setAlpha(i, j, alpha);
                    ++j;
                }
                ++i;
            }
            if (this.idBase.maskData != null) {
                this.idBase.maskData = null;
            }
        }
        if (this.drawBase) {
            this.drawImage2(this.idBase, 0, 0);
        }
        if (!this.alphaOverride) {
            this.preserveTransparency = false;
        }
        if (this.ontop) {
            if (this.overlay != null) {
                this.drawImage2(this.overlay, this.idBase.width + this.iconOffset - this.overlay.width - 3 + this.left, (this.idBase.height - this.overlay.height) / 2 + 1);
            }
            if (this.another != null) {
                this.drawImage2(this.another, this.idBase.width + this.iconOffset - this.another.width - 3 + this.left, (this.idBase.height - this.another.height) / 2 + 1);
            }
        } else {
            if (this.another != null) {
                this.drawImage2(this.another, this.idBase.width + this.iconOffset - this.another.width - 5 + this.left, (this.idBase.height - this.another.height) / 2);
            }
            if (this.overlay != null) {
                this.drawImage2(this.overlay, this.idBase.width + this.iconOffset - this.overlay.width - 3 + this.left, (this.idBase.height - this.overlay.height) / 2 + 1);
            }
        }
    }

    public void setSize(int x, int y) {
        this.size = new Point(x, y);
    }

    protected Point getSize() {
        if (this.size == null) {
            this.size = new Point(this.idBase.width, this.idBase.height);
        }
        return this.size;
    }

    protected final void drawImage2(ImageData src, int ox, int oy) {
        ImageData dst = this.imageData;
        PaletteData srcPalette = src.palette;
        ImageData srcMask = null;
        int alphaMask = 0;
        int alphaShift = 0;
        if (src.maskData != null) {
            srcMask = src.getTransparencyMask();
            if (src.depth == 32) {
                alphaMask = ~(srcPalette.redMask | srcPalette.greenMask | srcPalette.blueMask);
                while (alphaMask != 0 && (alphaMask >>> alphaShift & 1) == 0) {
                    ++alphaShift;
                }
            }
        }
        int srcY = 0;
        int dstY = srcY + oy;
        while (srcY < src.height) {
            int srcX = 0;
            int dstX = srcX + ox;
            while (srcX < src.width) {
                if (dstX >= 0 && dstX < dst.width && dstY >= 0 && dstY < dst.height) {
                    int srcPixel = src.getPixel(srcX, srcY);
                    int srcAlpha = 255;
                    if (src.maskData != null) {
                        if (src.depth == 32) {
                            srcAlpha = (srcPixel & alphaMask) >>> alphaShift;
                            if (srcAlpha == 0) {
                                srcAlpha = srcMask.getPixel(srcX, srcY) != 0 ? 255 : 0;
                            }
                        } else if (srcMask.getPixel(srcX, srcY) == 0) {
                            srcAlpha = 0;
                        }
                    } else if (src.transparentPixel != -1) {
                        if (src.transparentPixel == srcPixel) {
                            srcAlpha = 0;
                        }
                    } else if (src.alpha != -1) {
                        srcAlpha = src.alpha;
                    } else if (src.alphaData != null) {
                        srcAlpha = src.getAlpha(srcX, srcY);
                    }
                    if (srcAlpha != 0) {
                        int dstAlpha;
                        int dstBlue;
                        int dstGreen;
                        int dstRed;
                        int srcBlue;
                        int srcGreen;
                        int srcRed;
                        if (srcPalette.isDirect) {
                            srcRed = srcPixel & srcPalette.redMask;
                            srcRed = srcPalette.redShift < 0 ? srcRed >>> -srcPalette.redShift : srcRed << srcPalette.redShift;
                            srcGreen = srcPixel & srcPalette.greenMask;
                            srcGreen = srcPalette.greenShift < 0 ? srcGreen >>> -srcPalette.greenShift : srcGreen << srcPalette.greenShift;
                            srcBlue = srcPixel & srcPalette.blueMask;
                            srcBlue = srcPalette.blueShift < 0 ? srcBlue >>> -srcPalette.blueShift : srcBlue << srcPalette.blueShift;
                        } else {
                            RGB rgb = srcPalette.getRGB(srcPixel);
                            srcRed = rgb.red;
                            srcGreen = rgb.green;
                            srcBlue = rgb.blue;
                        }
                        if (srcAlpha == 255 || this.preserveTransparency) {
                            dstRed = srcRed;
                            dstGreen = srcGreen;
                            dstBlue = srcBlue;
                            dstAlpha = srcAlpha;
                        } else {
                            int dstPixel = dst.getPixel(dstX, dstY);
                            dstAlpha = dst.getAlpha(dstX, dstY);
                            dstRed = (dstPixel & 0xFF) >>> 0;
                            dstGreen = (dstPixel & 0xFF00) >>> 8;
                            dstBlue = (dstPixel & 0xFF0000) >>> 16;
                            dstRed += (srcRed - dstRed) * srcAlpha / 255;
                            dstGreen += (srcGreen - dstGreen) * srcAlpha / 255;
                            dstBlue += (srcBlue - dstBlue) * srcAlpha / 255;
                            dstAlpha += (srcAlpha - dstAlpha) * srcAlpha / 255;
                        }
                        dst.setPixel(dstX, dstY, (dstRed & 0xFF) << 0 | (dstGreen & 0xFF) << 8 | (dstBlue & 0xFF) << 16);
                        dst.setAlpha(dstX, dstY, dstAlpha);
                    }
                }
                ++srcX;
                ++dstX;
            }
            ++srcY;
            ++dstY;
        }
    }

    public ImageData getImageData() {
        Point size = this.getSize();
        this.imageData = new ImageData(size.x, size.y, 24, new PaletteData(255, 65280, 0xFF0000));
        this.imageData.alphaData = new byte[this.imageData.width * this.imageData.height];
        this.drawCompositeImage(size.x, size.y);
        boolean transparency = false;
        byte[] alphaData = this.imageData.alphaData;
        int i = 0;
        while (i < alphaData.length) {
            int alpha = alphaData[i] & 0xFF;
            if (alpha != 0 && alpha != 255) {
                return this.imageData;
            }
            if (!transparency && alpha == 0) {
                transparency = true;
            }
            ++i;
        }
        if (transparency) {
            PaletteData palette = new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)});
            ImageData mask = new ImageData(this.imageData.width, this.imageData.height, 1, palette);
            int y = 0;
            while (y < mask.height) {
                int x = 0;
                while (x < mask.width) {
                    mask.setPixel(x, y, this.imageData.getAlpha(x, y) == 255 ? 1 : 0);
                    ++x;
                }
                ++y;
            }
        } else {
            this.imageData.alphaData = null;
        }
        return this.imageData;
    }

    protected int getTransparentPixel() {
        return 0;
    }

    protected void setImageData(ImageData imageData) {
        this.imageData = imageData;
    }
}

