/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui;

import com.ibm.collaboration.realtime.ui.OverlayImageDescriptorWithBase;
import com.ibm.collaboration.realtime.ui.StatusExtension;
import com.ibm.collaboration.realtime.ui.StatusImageKey;
import com.ibm.collaboration.realtime.ui.UiPlugin;
import com.ibm.collaboration.realtime.ui.util.ImageCache;
import java.io.File;
import java.util.HashMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ImageMgr {
    private static ImageMgr imgMgr = new ImageMgr();
    private final HashMap overlayCache = new HashMap();
    public static final String KEY_GROUP = "baseGroup";
    public static final String KEY_DYNAMIC_GROUP = "dynamicGroup";
    public static final String KEY_INVALID_GROUP = "invalidGroup";
    public static final String KEY_PUBLIC_GROUP = "publicGroup";
    public static final int BASE_IMG_TRANSPARENCY_PERCENT_DEFAULT = 100;
    public static final int BASE_IMG_TRANSPARENCY_UNSPECIFIED = -1;
    public static final String IMHUB_PLUGIN = "com.ibm.collaboration.realtime.imhub";
    public static final String IMHUB_PROP_STATUS_IMG_BKGRD_TRANSPARENCY = "statusImgBackgroundTransparency";
    public static final String IMHUB_PROP_SHOW_COMMUNITY_ICON_BACKGROUND = "showCommunityIconBackground";
    private boolean readCommunityIconPrefs = false;
    private int iconOffset = 1;
    private boolean showChatSystemIcon = true;
    private boolean showStatusOverlay = true;
    private int defBaseImgTransparencyPercent = 100;
    private Image directoryLookupImage;
    private Image onlineOverlay;
    private Image awayOverlay;
    private Image notUsingOverlay;
    private Image dndOverlay;
    private Image inaMeetingOverlay;
    private Image connectingOverlay;
    private Image offlineOverlay;
    private Image blankOverlay;
    private Image alertOverlay;
    private Image questionOverlay;
    private Image onlineMobileOverlay;
    private Image awayMobileOverlay;
    private Image inMtgMobileOverlay;
    private Image dndMobileOverlay;
    private Image externalOverlay;
    private Image externalOfflineOverlay;
    private Image voicejamOverlay;
    private Image voicejamawayOverlay;
    private Image voicejamdndOverlay;
    private Image invalidOverlay;
    private Image groupImage;
    private Image dynamicGroupImage;
    private Image publicGroupImage;
    private Image imOnlineOverlay;
    private Image imPartialOverlay;
    private Image imOfflineOverlay;
    private Image typingOverlay;

    private ImageMgr() {
    }

    public static ImageMgr getInstance() {
        return imgMgr;
    }

    public Image getImage(Plugin plugin, String relativePath) {
        return ImageCache.getImage(plugin, relativePath);
    }

    public Image getImage(String relativePath) {
        return ImageCache.getImage((Plugin)UiPlugin.getDefault(), relativePath);
    }

    public ImageDescriptor getImageDescriptor(Plugin plugin, String relativePath) {
        return ImageCache.getImageDescriptor(plugin, relativePath);
    }

    public boolean showChatSystemIcon() {
        return this.showChatSystemIcon;
    }

    public void setShowChatSystemIcon(boolean showChatSystemIcon) {
        this.showChatSystemIcon = showChatSystemIcon;
    }

    public boolean showStatusOverlay() {
        return this.showStatusOverlay;
    }

    public void setShowStatusOverlay(boolean showStatusOverlay) {
        this.showStatusOverlay = showStatusOverlay;
    }

    public int getIconOffset() {
        return this.iconOffset;
    }

    public void setIconOffset(int iconOffset) {
        this.iconOffset = iconOffset;
    }

    public int getDefaultBaseImgTransparencyPercent() {
        if (!this.readCommunityIconPrefs) {
            this.getCommunityIconBackgroundPrefs();
        }
        return this.defBaseImgTransparencyPercent;
    }

    public void getCommunityIconBackgroundPrefs() {
        String prefQualifier;
        IPreferencesService service = Platform.getPreferencesService();
        boolean showCommunityIconBkgrd = service.getBoolean(prefQualifier = IMHUB_PLUGIN, IMHUB_PROP_SHOW_COMMUNITY_ICON_BACKGROUND, false, null);
        int transparency = showCommunityIconBkgrd ? service.getInt(prefQualifier, IMHUB_PROP_STATUS_IMG_BKGRD_TRANSPARENCY, 100, null) : 100;
        this.setDefaultBaseImgTransparencyPercent(transparency);
        this.readCommunityIconPrefs = true;
    }

    public void setDefaultBaseImgTransparencyPercent(int baseImgTransparencyPercent) {
        this.defBaseImgTransparencyPercent = baseImgTransparencyPercent;
    }

    public Image getNotUsingOverlay() {
        if (this.notUsingOverlay == null) {
            this.notUsingOverlay = this.getImage("images/status/ST_Awns_Away.png");
        }
        return this.notUsingOverlay;
    }

    public Image getExternalOverlay() {
        if (this.externalOverlay == null) {
            this.externalOverlay = this.getImage("images" + File.separator + "external_overlay.png");
        }
        return this.externalOverlay;
    }

    public Image getExternalOfflineOverlay() {
        if (this.externalOfflineOverlay == null) {
            this.externalOfflineOverlay = this.getImage("images" + File.separator + "external_overlay_offline.png");
        }
        return this.externalOfflineOverlay;
    }

    public Image getVoiceJamOverlay() {
        if (this.voicejamOverlay == null) {
            this.voicejamOverlay = this.getImage("images" + File.separator + "voicejam_overlay.gif");
        }
        return this.voicejamOverlay;
    }

    public Image getTypingOverlay() {
        if (this.typingOverlay == null) {
            this.typingOverlay = this.getImage("images" + File.separator + "ST_Typing_Message.png");
        }
        return this.typingOverlay;
    }

    public Image getVoiceJamAwayOverlay() {
        if (this.voicejamawayOverlay == null) {
            this.voicejamawayOverlay = this.getImage("images" + File.separator + "voicejamaway_overlay.gif");
        }
        return this.voicejamawayOverlay;
    }

    public Image getVoiceJamDndOverlay() {
        if (this.voicejamdndOverlay == null) {
            this.voicejamdndOverlay = this.getImage("images" + File.separator + "voicejamdnd_overlay.gif");
        }
        return this.voicejamdndOverlay;
    }

    public Image getOnlineOverlayMobile() {
        if (this.onlineMobileOverlay == null) {
            this.onlineMobileOverlay = this.getImage("images" + File.separator + "status" + File.separator + "ST_Awns_Active_Mobile.png");
        }
        return this.onlineMobileOverlay;
    }

    public Image getAwayOverlayMobile() {
        if (this.awayMobileOverlay == null) {
            this.awayMobileOverlay = this.getImage("images" + File.separator + "status" + File.separator + "ST_Awns_Away_Mobile.png");
        }
        return this.awayMobileOverlay;
    }

    public Image getInMtgOverlayMobile() {
        if (this.inMtgMobileOverlay == null) {
            this.inMtgMobileOverlay = this.getImage("images" + File.separator + "status" + File.separator + "ST_Awns_InAMtg_Mobile.png");
        }
        return this.inMtgMobileOverlay;
    }

    public Image getDndOverlayMobile() {
        if (this.dndMobileOverlay == null) {
            this.dndMobileOverlay = this.getImage("images" + File.separator + "status" + File.separator + "ST_Awns_DND_Mobile.png");
        }
        return this.dndMobileOverlay;
    }

    public Image getMobileOverlay() {
        if (this.onlineMobileOverlay == null) {
            this.onlineMobileOverlay = this.getImage("images" + File.separator + "mobile_overlay.gif");
        }
        return this.onlineMobileOverlay;
    }

    public Image getOfflineOverlay() {
        if (this.offlineOverlay == null) {
            this.offlineOverlay = this.getImage("images/status/ST_Awns_Offline.png");
        }
        return this.offlineOverlay;
    }

    public Image getBlankOverlay() {
        if (this.blankOverlay == null) {
            this.blankOverlay = this.getImage("images/blank_overlay.gif");
        }
        return this.blankOverlay;
    }

    public Image getOnlineOverlay() {
        if (this.onlineOverlay == null) {
            this.onlineOverlay = this.getImage("images/status/ST_Awns_Active.png");
        }
        return this.onlineOverlay;
    }

    public Image getAwayOverlay() {
        if (this.awayOverlay == null) {
            this.awayOverlay = this.getImage("images/status/ST_Awns_Away.png");
        }
        return this.awayOverlay;
    }

    public Image getDndOverlay() {
        if (this.dndOverlay == null) {
            this.dndOverlay = this.getImage("images/status/ST_Awns_DND.png");
        }
        return this.dndOverlay;
    }

    public Image getInAMeetingOverlay() {
        if (this.inaMeetingOverlay == null) {
            this.inaMeetingOverlay = this.getImage("images/status/ST_Awns_InAMtng.png");
        }
        return this.inaMeetingOverlay;
    }

    public Image getConnectingOverlay() {
        if (this.connectingOverlay == null) {
            this.connectingOverlay = this.getImage("images/status/ST_Awns_Connecting.png");
        }
        return this.connectingOverlay;
    }

    public Image getAlertOverlay() {
        if (this.alertOverlay == null) {
            this.alertOverlay = this.getImage("images/alert_overlay.png");
        }
        return this.alertOverlay;
    }

    public Image getDirectoryLookupImage() {
        if (this.directoryLookupImage == null) {
            this.directoryLookupImage = this.getImage("images/directory.gif");
        }
        return this.directoryLookupImage;
    }

    public Image getImOfflineOverlay() {
        if (this.imOfflineOverlay == null) {
            this.imOfflineOverlay = this.getImage("images/im_off_overlay.gif");
        }
        return this.imOfflineOverlay;
    }

    public Image getImPartialOverlay() {
        if (this.imPartialOverlay == null) {
            this.imPartialOverlay = this.getImage("images/im_partial_overlay.gif");
        }
        return this.imPartialOverlay;
    }

    public Image getImOnlineOverlay() {
        if (this.imOnlineOverlay == null) {
            this.imOnlineOverlay = this.getImage("images/im_on_overlay.gif");
        }
        return this.imOnlineOverlay;
    }

    public Image getQuestionOverlay() {
        if (this.questionOverlay == null) {
            this.questionOverlay = this.getImage("images/question_overlay.png");
        }
        return this.questionOverlay;
    }

    public Image getInvalidOverlay() {
        if (this.invalidOverlay == null) {
            this.invalidOverlay = this.getImage("images/invalid_overlay.gif");
        }
        return this.invalidOverlay;
    }

    public Image getGroupImage() {
        if (this.groupImage == null) {
            this.groupImage = this.getImage("images/ST_Personal_Group.png");
        }
        return this.getOverlaidImage(KEY_GROUP, this.groupImage, null);
    }

    public Image getPublicGroupImage() {
        if (this.publicGroupImage == null) {
            this.publicGroupImage = this.getImage("images/ST_Public_Group.png");
        }
        return this.getOverlaidImage(KEY_PUBLIC_GROUP, this.publicGroupImage, null);
    }

    public Image getDynamicGroupImage() {
        if (this.dynamicGroupImage == null) {
            this.dynamicGroupImage = this.getImage("images/ST_Public_Group.png");
        }
        return this.getOverlaidImage(KEY_DYNAMIC_GROUP, this.dynamicGroupImage, null);
    }

    public Image getInvalidGroupImage() {
        if (this.groupImage == null) {
            this.groupImage = this.getImage("images/ST_Personal_Group.png");
        }
        return this.getOverlaidImage(KEY_INVALID_GROUP, this.groupImage, this.offlineOverlay);
    }

    private Image getOverlaidImage(String imgKey, Image baseImg, Image overlayImg) {
        if (this.getOverlaidImage(imgKey) == null) {
            this.putOverlaidImage(imgKey, this.createImageOverlay(baseImg, overlayImg));
        }
        return this.getOverlaidImage(imgKey);
    }

    private Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    private Image overlayImg(String key, Image baseImg, Image overlayImg, int transparency, boolean forceUpdate, boolean cache) {
        Image image = this.getOverlaidImage(key);
        if (image == null || image.isDisposed() || forceUpdate) {
            image = this.createImageOverlayAlpha(baseImg, overlayImg, transparency);
            if (cache) {
                this.putOverlaidImage(key, image);
            }
        }
        return image;
    }

    private Image overlayImg(String key, Image baseImg, Image overlayImg, Image anotherOverlay, int transparency, boolean forceUpdate, boolean onTop, boolean cache) {
        Image image = this.getOverlaidImage(key);
        if (image == null || image.isDisposed() || forceUpdate) {
            image = this.createImageOverlayAlpha(baseImg, overlayImg, false, transparency, null, anotherOverlay, onTop);
            if (cache) {
                this.putOverlaidImage(key, image);
            }
        }
        return image;
    }

    public Image createImageOverlay(Image baseImage, Image overlayImage) {
        return this.createImageOverlayAlpha(baseImage, overlayImage, true, -1, null);
    }

    public Image createImageOverlayAlpha(Image baseImage, Image overlayImage, int transparency) {
        return this.createImageOverlayAlpha(baseImage, overlayImage, false, transparency, null);
    }

    public Image createImageOverlayAlpha(Image baseImage, Image overlayImage, boolean alphaOveride, int transparency, Color colorOverride) {
        return this.createImageOverlayAlpha(baseImage, overlayImage, alphaOveride, transparency, colorOverride, null);
    }

    public Image createImageOverlayAlpha(Image baseImage, Image overlayImage, boolean alphaOveride, int transparency, Color colorOverride, Image anotherOverlay) {
        return this.createImageOverlayAlpha(baseImage, overlayImage, alphaOveride, transparency, colorOverride, anotherOverlay, false);
    }

    public Image createImageOverlayAlpha(Image baseImage, Image overlayImage, boolean alphaOveride, int transparency, Color colorOverride, Image anotherOverlay, boolean ontop) {
        if (!alphaOveride) {
            if (transparency == -1) {
                transparency = this.defBaseImgTransparencyPercent;
            }
            transparency = 255 - 255 * transparency / 100;
        }
        OverlayImageDescriptorWithBase desc = new OverlayImageDescriptorWithBase(baseImage, overlayImage, alphaOveride, transparency, colorOverride, anotherOverlay, ontop);
        desc.drawBase = this.showChatSystemIcon;
        desc.alphaOverride = alphaOveride;
        desc.setSize(this.getIconWidth(), baseImage.getImageData().height);
        return desc.createImage();
    }

    protected int getIconWidth() {
        return 16 + this.iconOffset;
    }

    public Image getStatusImage(StatusImageKey statusImgKey) {
        Image statusOverlayImg = null;
        String key = statusImgKey.getKey();
        if (!statusImgKey.forceUpdate()) {
            statusOverlayImg = this.getOverlaidImage(key);
        }
        if ((statusOverlayImg == null || statusOverlayImg.isDisposed()) && statusImgKey.getBaseImage() != null) {
            Image baseImg = statusImgKey.getBaseImage();
            Image statusImg = this.getStatusOverlay(statusImgKey);
            Image extensionImg = this.getExtensionOverlay(statusImgKey);
            int transparency = statusImgKey.getBaseImgTransparencyPercent();
            boolean cacheImg = statusImgKey.cacheImg();
            if (extensionImg != null) {
                boolean isExtensionOnTop = statusImgKey.getStatusExtension().isOnTop();
                if (!isExtensionOnTop && statusImgKey.getOtherStatusExtension() != null && statusImgKey.getOtherStatusExtension().isOnTop()) {
                    Image im = this.overlayImg(key, baseImg, statusImg, this.getOtherExtensionOverlay(statusImgKey), 100, false, true, false);
                    statusOverlayImg = this.overlayImg(key, baseImg, im, extensionImg, transparency, statusImgKey.forceUpdate(), isExtensionOnTop, cacheImg);
                    im.dispose();
                } else {
                    statusOverlayImg = this.overlayImg(key, baseImg, statusImg, extensionImg, transparency, statusImgKey.forceUpdate(), isExtensionOnTop, cacheImg);
                }
            } else {
                statusOverlayImg = this.overlayImg(key, baseImg, statusImg, transparency, statusImgKey.forceUpdate(), cacheImg);
            }
        }
        return statusOverlayImg;
    }

    private Image getStatusOverlay(StatusImageKey statusImgKey) {
        int status = statusImgKey.getStatus();
        Image img = null;
        if (-1 == status) {
            img = this.getQuestionOverlay();
        } else if (-2 == status) {
            img = this.getQuestionOverlay();
        } else if (-3 == status) {
            img = this.getInvalidOverlay();
        } else if (status == 0) {
            img = statusImgKey.showOfflineOverlay() ? this.getOfflineOverlay() : this.getBlankOverlay();
        } else if (1 == status) {
            img = this.getOnlineOverlay();
        } else if (3 == status) {
            img = this.getDndOverlay();
        } else if (2 == status) {
            img = this.getAwayOverlay();
        } else if (4 == status) {
            img = this.getNotUsingOverlay();
        } else if (5 == status) {
            img = this.getInAMeetingOverlay();
        } else if (9 == status) {
            img = this.getConnectingOverlay();
        } else if (6 == status) {
            img = this.getOnlineOverlayMobile();
        } else if (7 == status) {
            img = this.getAwayOverlayMobile();
        } else if (10 == status) {
            img = this.getInMtgOverlayMobile();
        } else if (8 == status) {
            img = this.getDndOverlayMobile();
        }
        return img;
    }

    private Image getExtensionOverlay(StatusImageKey statusImgKey) {
        Image img = null;
        StatusExtension ext = statusImgKey.getStatusExtension();
        if (ext != null && (img = ext.getImage()) == null) {
            img = this.getExtensionImage(ext);
        }
        return img;
    }

    private Image getOtherExtensionOverlay(StatusImageKey statusImgKey) {
        Image img = null;
        StatusExtension ext = statusImgKey.getOtherStatusExtension();
        if (ext != null && (img = ext.getImage()) == null) {
            img = this.getExtensionImage(ext);
        }
        return img;
    }

    private Image getExtensionImage(StatusExtension ext) {
        Image img = null;
        if (StatusExtension.EXT_ALERT_ME_WHEN.equals(ext)) {
            img = this.getAlertOverlay();
        } else if (StatusExtension.EXT_MOBILE.equals(ext)) {
            img = this.getMobileOverlay();
        } else if (StatusExtension.EXT_EXTERNAL.equals(ext)) {
            img = this.getExternalOverlay();
        } else if (StatusExtension.EXT_EXTERNAL_OFFLINE.equals(ext)) {
            img = this.getExternalOfflineOverlay();
        } else if (StatusExtension.EXT_VOICEJAM.equals(ext)) {
            img = this.getVoiceJamOverlay();
        } else if (StatusExtension.EXT_TYPING.equals(ext)) {
            img = this.getTypingOverlay();
        }
        return img;
    }

    public Image getOverlaidImage(String key) {
        return (Image)this.overlayCache.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putOverlaidImage(String key, Image image) {
        if (this.overlayCache.containsKey(key)) {
            HashMap hashMap = this.overlayCache;
            synchronized (hashMap) {
                this.getOverlaidImage(key).dispose();
                this.overlayCache.remove(key);
                this.overlayCache.put(key, image);
            }
        } else {
            this.overlayCache.put(key, image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOverlaidImage(String key) {
        if (this.overlayCache.containsKey(key)) {
            HashMap hashMap = this.overlayCache;
            synchronized (hashMap) {
                this.getOverlaidImage(key).dispose();
                this.overlayCache.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearOverlayCache() {
        HashMap hashMap = this.overlayCache;
        synchronized (hashMap) {
            for (Object key : this.overlayCache.keySet()) {
                this.getOverlaidImage((String)key).dispose();
            }
            this.overlayCache.clear();
        }
    }
}

