/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui;

import com.ibm.collaboration.realtime.core.CorePlugin;
import com.ibm.collaboration.realtime.ui.ExternalApplicationPreferences;
import com.ibm.collaboration.realtime.ui.UiPlugin;
import com.ibm.collaboration.realtime.ui.WorkbenchAdapter;
import com.ibm.collaboration.realtime.ui.strings.Messages;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;

public class ExternalApplicationPreferencesInitializer
extends AbstractPreferenceInitializer {
    public void initializeDefaultPreferences() {
        Preferences corePrefs;
        Preferences preferences = UiPlugin.getDefault().getPluginPreferences();
        preferences.setDefault("external.application.use.custom.browser", false);
        preferences.setDefault("external.application.use.custom.mail", false);
        preferences.setDefault("external.application.use.default.mail", true);
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("linux")) {
            if (ExternalApplicationPreferences.getSystemDefaultBrowser() != null) {
                preferences.setDefault("external.application.browser", Messages.system_default);
            } else {
                preferences.setDefault("external.application.browser", Messages.browser_name_firefox);
            }
            if (ExternalApplicationPreferences.getSystemDefaultMailer() != null) {
                preferences.setDefault("external.application.mail", Messages.system_default);
            } else {
                preferences.setDefault("external.application.mail", Messages.mail_name_mozilla);
            }
            preferences.setDefault("external.custom.browser", "firefox %s");
            preferences.setDefault("external.custom.mail", "mozilla -compose %s");
        } else if (osName.startsWith("win")) {
            preferences.setDefault("external.application.browser", Messages.browser_name_firefox);
            preferences.setDefault("external.application.mail", "");
        }
        if (!WorkbenchAdapter.isRunning() && (corePrefs = CorePlugin.getDefault().getPluginPreferences()).getBoolean("embeddedInNotes")) {
            preferences.setDefault("external.application.use.default.mail", false);
            preferences.setDefault("external.application.mail", Messages.mail_name_notes);
        }
    }
}

