/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui;

import com.ibm.collaboration.realtime.core.CorePlugin;
import com.ibm.collaboration.realtime.ui.ExternalApplicationPreferences;
import com.ibm.collaboration.realtime.ui.strings.LogMessages;
import com.ibm.collaboration.realtime.util.OSUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BrowserLauncher {
    private static final Logger logger = Logger.getLogger(CorePlugin.class.getPackage().getName());

    public void launch(String url) {
        block14: {
            if (OSUtils.isLinux()) {
                String[] cmdArray;
                if (url != null && url.substring(0, 8).equalsIgnoreCase("notes://")) {
                    String notesPath = ExternalApplicationPreferences.getSystemDefaultMailer();
                    int end_pos = notesPath.indexOf(" ");
                    if (end_pos > 0) {
                        notesPath = notesPath.substring(0, end_pos);
                    }
                    ArrayList<String> cmdList = new ArrayList<String>();
                    cmdList.add("gnome-open");
                    cmdList.add(url);
                    cmdArray = new String[cmdList.size()];
                    cmdList.toArray(cmdArray);
                } else {
                    String prefCmd = ExternalApplicationPreferences.getBrowserCommand().trim();
                    if (prefCmd == null || prefCmd.length() == 0) {
                        return;
                    }
                    if (!ExternalApplicationPreferences.useCustomBrowser()) {
                        String shortCmd = prefCmd;
                        int spacePos = shortCmd.indexOf(" ");
                        if (spacePos > 0) {
                            shortCmd = shortCmd.substring(0, spacePos);
                        }
                        ArrayList<String> cmdList = new ArrayList<String>();
                        cmdList.add(shortCmd);
                        if (url != null) {
                            cmdList.add(url);
                        }
                        cmdArray = new String[cmdList.size()];
                        cmdList.toArray(cmdArray);
                    } else {
                        if (prefCmd.indexOf(" ") < 0) {
                            prefCmd = String.valueOf(prefCmd) + " %s";
                        }
                        cmdArray = BrowserLauncher.parseBrowserCommand(prefCmd, url);
                    }
                }
                if (cmdArray != null) {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.log(Level.INFO, String.valueOf(LogMessages.BrowserLauncher_37) + BrowserLauncher.commandArrayToString(cmdArray));
                    }
                    try {
                        Runtime.getRuntime().exec(cmdArray);
                    }
                    catch (Throwable t) {
                        if (!logger.isLoggable(Level.SEVERE)) break block14;
                        logger.log(Level.SEVERE, LogMessages.BrowserLauncher_40, t);
                    }
                }
            }
        }
    }

    public void launch(URL url) {
        this.launch(url.toString());
    }

    private static String commandArrayToString(String[] cmdArray) {
        StringBuffer resultBuffer = new StringBuffer();
        int index = 0;
        while (index < cmdArray.length) {
            if (index > 0) {
                resultBuffer.append(' ');
            }
            resultBuffer.append(cmdArray[index]);
            ++index;
        }
        return resultBuffer.toString();
    }

    protected static String[] parseBrowserCommand(String prefCmd, String url) {
        ArrayList<String> commandList = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(prefCmd, " ");
        while (tokenizer.hasMoreTokens()) {
            String aToken = tokenizer.nextToken();
            if (aToken.equals("%s")) {
                if (url == null) continue;
                commandList.add(url);
                continue;
            }
            commandList.add(aToken);
        }
        String[] result = new String[commandList.size()];
        commandList.toArray(result);
        return result;
    }
}

