/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.ui.dnd;

import com.ibm.collaboration.realtime.annotate.AnnotatedRange;
import com.ibm.collaboration.realtime.annotate.AnnotationManager;
import com.ibm.team.collaboration.internal.ui.SametimeMessages;
import com.ibm.team.collaboration.internal.ui.annotation.AbstractAnnotationProvider;
import com.ibm.team.collaboration.internal.ui.annotation.ArtifactAnnotationRange;
import com.ibm.team.collaboration.internal.ui.dnd.AbstractDropTargetListener;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.ui.URIReferenceTransfer;
import java.text.MessageFormat;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;

public final class URIReferenceDropTargetListener
extends AbstractDropTargetListener {
    static /* synthetic */ Class class$0;

    private static void pasteReference(StyledText text, URIReference reference) {
        String name = reference.getName();
        String details = reference.getDetails();
        ArtifactAnnotationRange annotation = AbstractAnnotationProvider.setupAnnotationRange(new ArtifactAnnotationRange());
        annotation.artifactURL = reference.getURI().toString();
        annotation.details = details;
        annotation.replacementText = MessageFormat.format(SametimeMessages.CollaborationReferenceDropTargetListener_0, annotation.artifactURL, details, name);
        AnnotationManager manager = AnnotationManager.getAnnotationManager((StyledText)text);
        manager.disableModify();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.team.collaboration.internal.ui.annotation.reference.ReferenceAnnotationProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.insertAnnotation((Class)clazz, name, (AnnotatedRange)annotation);
        manager.enableModify();
        text.setCaretOffset(text.getCaretOffset() + name.length());
    }

    public void dragEnter(DropTargetEvent event) {
        if (event.detail == 16) {
            event.detail = (event.operations & 4) != 0 ? 4 : 0;
        }
        URIReferenceTransfer transfer = URIReferenceTransfer.getInstance();
        int index = 0;
        while (index < event.dataTypes.length) {
            if (transfer.isSupportedType(event.dataTypes[index])) {
                event.currentDataType = event.dataTypes[index];
                break;
            }
            ++index;
        }
    }

    public void dragOperationChanged(DropTargetEvent event) {
        if (event.detail == 16) {
            event.detail = (event.operations & 4) != 0 ? 4 : 0;
        }
        if (URIReferenceTransfer.getInstance().isSupportedType(event.currentDataType) && event.detail != 4) {
            event.detail = 0;
        }
    }

    public void drop(DropTargetEvent event) {
        Control control;
        if (this.fContext != null && (control = this.fContext.getControl()) instanceof StyledText) {
            Object data;
            StyledText extended = (StyledText)control;
            if (URIReferenceTransfer.getInstance().isSupportedType(event.currentDataType) && (data = event.data) instanceof URIReference[]) {
                URIReference[] references = (URIReference[])data;
                int index = 0;
                while (index < references.length) {
                    URIReferenceDropTargetListener.pasteReference(extended, references[index]);
                    extended.insert(" ");
                    extended.setCaretOffset(extended.getCaretOffset() + 1);
                    ++index;
                }
                extended.setFocus();
            }
        }
    }

    public Transfer getTransfer() {
        return URIReferenceTransfer.getInstance();
    }

    public boolean isEnabled(DropTargetEvent event) {
        URIReferenceTransfer transfer = URIReferenceTransfer.getInstance();
        int index = 0;
        while (index < event.dataTypes.length) {
            if (transfer.isSupportedType(event.dataTypes[index])) {
                return true;
            }
            ++index;
        }
        return false;
    }
}

