/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.ui.dnd;

import com.ibm.team.collaboration.internal.ui.dnd.AbstractDropTargetListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;

public final class TextDropTargetListener
extends AbstractDropTargetListener {
    public void dragEnter(DropTargetEvent event) {
        if (event.detail == 16) {
            event.detail = (event.operations & 1) != 0 ? 1 : 0;
        }
        TextTransfer transfer = TextTransfer.getInstance();
        int index = 0;
        while (index < event.dataTypes.length) {
            if (transfer.isSupportedType(event.dataTypes[index])) {
                event.currentDataType = event.dataTypes[index];
                break;
            }
            ++index;
        }
    }

    public void dragOperationChanged(DropTargetEvent event) {
        if (event.detail == 16) {
            event.detail = (event.operations & 1) != 0 ? 1 : 0;
        }
        if (TextTransfer.getInstance().isSupportedType(event.currentDataType) && event.detail != 1) {
            event.detail = 0;
        }
    }

    public void drop(DropTargetEvent event) {
        Control control;
        if (this.fContext != null && (control = this.fContext.getControl()) instanceof StyledText) {
            StyledText extended = (StyledText)control;
            if (TextTransfer.getInstance().isSupportedType(event.currentDataType)) {
                Point range = extended.getSelectionRange();
                extended.replaceTextRange(range.x, range.y, (String)event.data);
            }
        }
    }

    public Transfer getTransfer() {
        return TextTransfer.getInstance();
    }

    public boolean isEnabled(DropTargetEvent event) {
        TextTransfer transfer = TextTransfer.getInstance();
        int index = 0;
        while (index < event.dataTypes.length) {
            if (transfer.isSupportedType(event.dataTypes[index])) {
                return true;
            }
            ++index;
        }
        return false;
    }
}

