/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.ui.dnd;

import com.ibm.collaboration.realtime.imhub.model.PartnerNode;
import com.ibm.collaboration.realtime.people.PeopleUtil;
import com.ibm.collaboration.realtime.people.Person;
import com.ibm.collaboration.realtime.people.PersonInternal;
import com.ibm.collaboration.realtime.ui.MailComposer;
import com.ibm.collaboration.realtime.ui.dnd.ContributedDropTargetListener;
import com.ibm.collaboration.realtime.ui.dnd.TransferOperationContext;
import com.ibm.team.collaboration.internal.ui.SametimeMessages;
import com.ibm.team.collaboration.internal.ui.chat.OpenChatMessageAdapter;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.ui.URIReferenceTransfer;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public final class OpenChatDropTargetListener
extends DropTargetAdapter
implements ContributedDropTargetListener {
    private TransferOperationContext fContext = null;
    static /* synthetic */ Class class$0;

    public void dragEnter(DropTargetEvent event) {
        if (event.detail == 16) {
            event.detail = (event.operations & 4) != 0 ? 4 : 0;
        }
        URIReferenceTransfer transfer = URIReferenceTransfer.getInstance();
        int index = 0;
        while (index < event.dataTypes.length) {
            if (transfer.isSupportedType(event.dataTypes[index])) {
                event.currentDataType = event.dataTypes[index];
                break;
            }
            ++index;
        }
    }

    public void dragOperationChanged(DropTargetEvent event) {
        if (event.detail == 16) {
            event.detail = (event.operations & 4) != 0 ? 4 : 0;
        }
        if (URIReferenceTransfer.getInstance().isSupportedType(event.currentDataType) && event.detail != 4) {
            event.detail = 0;
        }
    }

    public void drop(DropTargetEvent event) {
        Person person;
        Object data;
        Widget item;
        Control control;
        if (this.fContext != null && (control = this.fContext.getControl()) instanceof Tree && URIReferenceTransfer.getInstance().isSupportedType(event.currentDataType) && (item = event.item) instanceof TreeItem && (data = item.getData()) instanceof PartnerNode && (person = ((PartnerNode)data).getPerson()) != null) {
            if (PeopleUtil.canAcceptChat((Person)person)) {
                new OpenChatMessageAdapter((URIReference[])event.data);
                PeopleUtil.getPeopleService().createConversation(person);
            } else {
                String email;
                PersonInternal internal = PeopleUtil.getPerson((String)person.getContactId(), (String)person.getCommunityId());
                if (internal != null && (email = internal.getContactId()) != null) {
                    String name = SametimeMessages.OpenChatDropTargetListener_1;
                    IProduct product = Platform.getProduct();
                    if (product != null) {
                        name = product.getName();
                    }
                    if (MessageDialog.openQuestion((Shell)control.getShell(), (String)name, (String)MessageFormat.format(SametimeMessages.OpenChatDropTargetListener_2, internal.getDisplayName()))) {
                        MailComposer composer = new MailComposer(null);
                        composer.setTo(email);
                        composer.invoke();
                    }
                }
            }
        }
    }

    public Class getPreferredContextClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.widgets.Tree");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public Transfer getTransfer() {
        return URIReferenceTransfer.getInstance();
    }

    public boolean isEnabled(DropTargetEvent event) {
        URIReferenceTransfer transfer = URIReferenceTransfer.getInstance();
        int index = 0;
        while (index < event.dataTypes.length) {
            if (transfer.isSupportedType(event.dataTypes[index])) {
                return true;
            }
            ++index;
        }
        return false;
    }

    public void setContext(TransferOperationContext context) {
        this.fContext = context;
    }
}

