/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.ui.chat;

import com.ibm.collaboration.realtime.magiccarpet.MessageEvent;
import com.ibm.collaboration.realtime.magiccarpet.MessageEventConstants;
import com.ibm.collaboration.realtime.magiccarpet.messageprocessor.MessageProcessor;
import com.ibm.collaboration.realtime.messages.DefaultMessageHandler;
import com.ibm.collaboration.realtime.messages.Message;
import com.ibm.collaboration.realtime.messages.MessageHandler;
import com.ibm.collaboration.realtime.messages.MessageHandlerAdapter;
import com.ibm.collaboration.realtime.messages.im.ImTextConnectionOpenSuccessMessage;
import com.ibm.team.collaboration.internal.ui.SametimeMessages;
import com.ibm.team.collaboration.internal.ui.SametimeUIPlugin;
import com.ibm.team.foundation.common.URIReference;
import java.text.MessageFormat;

public class OpenChatMessageAdapter
extends MessageHandlerAdapter {
    public OpenChatMessageAdapter(URIReference[] references) {
        super((MessageHandler)new OpenChatMessageHandler());
        ((OpenChatMessageHandler)this.m_handler).initialize(this, references);
        this.registerEvents();
    }

    public void deregister() {
        this.deRegisterEvents();
    }

    private static class OpenChatMessageHandler
    extends DefaultMessageHandler {
        private OpenChatMessageAdapter fAdapter;
        private URIReference[] fReference;

        OpenChatMessageHandler() {
        }

        private String createChatInputText() {
            StringBuffer buffer = new StringBuffer(64);
            int index = 0;
            while (index < this.fReference.length) {
                if (index > 0) {
                    buffer.append(", ");
                }
                buffer.append("<a href=\"");
                buffer.append(this.fReference[index].getURI().toString());
                buffer.append("\" title=\"");
                buffer.append(SametimeUIPlugin.escapeXML(this.fReference[index].getDetails()));
                buffer.append("\">");
                buffer.append(SametimeUIPlugin.escapeXML(this.fReference[index].getName()));
                buffer.append("</a>");
                ++index;
            }
            return MessageFormat.format(SametimeMessages.OpenChatDropTargetListener_0, buffer.toString());
        }

        public void handleDefaultMessage(Message message) {
        }

        public void handleMessage(ImTextConnectionOpenSuccessMessage message) {
            MessageEvent event = new MessageEvent(MessageEventConstants.ImChatWindowEventResponse);
            event.setProperty((Object)"conversationID", (Object)message.getConversationId());
            event.setProperty((Object)"eventType", (Object)"appendText");
            event.setProperty((Object)"hasRichText", (Object)true);
            event.setProperty((Object)"text", (Object)this.createChatInputText());
            MessageProcessor.getInstance().postMessageEvent(event);
            this.fAdapter.deregister();
        }

        public void initialize(OpenChatMessageAdapter adapter, URIReference[] references) {
            this.fAdapter = adapter;
            this.fReference = references;
        }
    }
}

