/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.ui.browser;

import com.ibm.collaboration.realtime.browser.BrowserListener;
import com.ibm.collaboration.realtime.ui.ExplorerWindow;
import com.ibm.team.collaboration.common.uri.CollaborationUriUtilities;
import com.ibm.team.collaboration.internal.ui.SametimeMessages;
import com.ibm.team.collaboration.internal.ui.SametimeUIPlugin;
import com.ibm.team.collaboration.sametime.connection.SametimeConnection;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.html.HTMLAnchorElement;

public final class DefaultBrowserEventListener
extends BrowserListener {
    private static final HTMLAnchorElement findAnchorElement(Node target) {
        Assert.isNotNull((Object)target);
        if (target instanceof HTMLAnchorElement) {
            return (HTMLAnchorElement)target;
        }
        Node parent = target.getParentNode();
        if (parent != null) {
            return DefaultBrowserEventListener.findAnchorElement(parent);
        }
        return null;
    }

    private static final void openErrorDialog(String link) {
        Assert.isNotNull((Object)link);
        final String message = MessageFormat.format(SametimeMessages.DefaultBrowserEventListener_1, link);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null) {
                    MessageDialog.openError((Shell)window.getShell(), (String)SametimeMessages.DefaultBrowserEventListener_2, (String)message);
                }
            }
        });
    }

    public static final boolean supportsWebAccess(String uri) {
        Assert.isNotNull((Object)uri);
        return CollaborationUriUtilities.isWorkitemURI((String)uri);
    }

    public void handleEvent(Event event) {
        HTMLAnchorElement anchor;
        Assert.isNotNull((Object)event);
        EventTarget target = event.getTarget();
        if (target instanceof Node && (anchor = DefaultBrowserEventListener.findAnchorElement((Node)((Object)target))) != null) {
            SametimeUIPlugin plugin = SametimeUIPlugin.getInstance();
            SametimeConnection connection = plugin.getConnection();
            String link = anchor.getTitle();
            NodeList nodes = anchor.getChildNodes();
            int index = 0;
            while (index < nodes.getLength()) {
                Node node = nodes.item(index);
                String value = node.getNodeValue();
                if (value != null && !"".equals(value)) {
                    link = value;
                    break;
                }
                ++index;
            }
            String uri = anchor.getHref();
            if (plugin.getPreferenceStore().getBoolean("com.ibm.team.collaboration.sametime.ui.prefer.web.ui")) {
                if (DefaultBrowserEventListener.supportsWebAccess(uri)) {
                    ExplorerWindow.launchBrowser((String)SametimeMessages.DefaultBrowserEventListener_0, (String)uri);
                } else if (plugin.isJazzRunning()) {
                    connection.openHyperlink(uri, "dummy" + System.currentTimeMillis());
                } else {
                    DefaultBrowserEventListener.openErrorDialog(link);
                }
            } else if (plugin.isJazzRunning()) {
                connection.openHyperlink(uri, "dummy" + System.currentTimeMillis());
            } else if (DefaultBrowserEventListener.supportsWebAccess(uri)) {
                ExplorerWindow.launchBrowser((String)SametimeMessages.DefaultBrowserEventListener_0, (String)uri);
            } else {
                DefaultBrowserEventListener.openErrorDialog(link);
            }
            event.stopPropagation();
            event.preventDefault();
        }
    }
}

