/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.ui.browser;

import com.ibm.collaboration.realtime.browser.Browser;
import com.ibm.collaboration.realtime.browser.BrowserListener;
import com.ibm.collaboration.realtime.buddylist.BuddyList;
import com.ibm.collaboration.realtime.buddylist.BuddyListService;
import com.ibm.collaboration.realtime.people.Person;
import com.ibm.collaboration.realtime.servicehub.ServiceException;
import com.ibm.collaboration.realtime.servicehub.ServiceHub;
import com.ibm.team.collaboration.common.uri.CollaborationUriUtilities;
import com.ibm.team.collaboration.internal.ui.SametimeMessages;
import com.ibm.team.collaboration.internal.ui.SametimeUIPlugin;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.widgets.Composite;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;

public final class CommentWorkItemBrowserEventListener
extends BrowserListener {
    static /* synthetic */ Class class$0;

    private static boolean isXULRunner(Browser browser) {
        Assert.isNotNull((Object)browser);
        Composite composite = browser.getRealBrowser();
        if (composite != null) {
            return composite.getClass().getName().equals("com.ibm.swt.xulrunner.browser.SWTXULRunnerBrowser");
        }
        return false;
    }

    private void findChildMessageBlocks(Node node, List messageBlocks) {
        if (this.isMessageBlock(node)) {
            messageBlocks.add(node);
            return;
        }
        NodeList nodes = node.getChildNodes();
        int index = 0;
        while (index < nodes.getLength()) {
            this.findChildMessageBlocks(nodes.item(index), messageBlocks);
            ++index;
        }
    }

    private Node findParentMessageBlock(Node node) {
        if (this.isMessageBlock(node)) {
            return node;
        }
        if (node.getParentNode() != null) {
            return this.findParentMessageBlock(node.getParentNode());
        }
        return null;
    }

    private String getMessageBlockAuthor(Node messageBlock) {
        NodeList childNodes = messageBlock.getChildNodes();
        Node infoDiv = childNodes.item(1);
        Attr titleAttr = (Attr)infoDiv.getAttributes().getNamedItem("title");
        String name = titleAttr.getValue();
        name = name.substring(0, name.indexOf(" ["));
        return name;
    }

    private String getMessageBlockHTMLContents(Map buddyMap, Node messageBlock) {
        String name = this.getMessageBlockAuthor(messageBlock);
        String message = this.getMessageTextContents(messageBlock.getChildNodes().item(2));
        return MessageFormat.format(SametimeMessages.CommentWorkItemBrowserEventListener_0, this.hyperlinkName(buddyMap, name), message);
    }

    private String getMessageTextContents(Node message) {
        Attr href;
        if (message instanceof CharacterData) {
            return SametimeUIPlugin.escapeXML(((CharacterData)message).getData());
        }
        StringBuffer buffer = new StringBuffer(512);
        String suffix = null;
        if (message.getNodeName().equalsIgnoreCase("a") && (href = (Attr)message.getAttributes().getNamedItem("href")) != null) {
            buffer.append("<a href=\"");
            buffer.append(SametimeUIPlugin.escapeXML(href.getValue()));
            buffer.append("\">");
            suffix = "</a>";
        }
        NodeList nodes = message.getChildNodes();
        int index = 0;
        while (index < nodes.getLength()) {
            buffer.append(this.getMessageTextContents(nodes.item(index)));
            ++index;
        }
        if (suffix != null) {
            buffer.append(suffix);
        }
        return buffer.toString();
    }

    public void handleEvent(Event event) {
        Node startMessageBlock = null;
        Node endMessageBlock = null;
        Browser browser = this.getBrowser();
        if (CommentWorkItemBrowserEventListener.isXULRunner(browser)) {
            try {
                Boolean bool;
                Method getRangeAt;
                Object jRange;
                Class<?> JRangeClass;
                Method getCollapsed;
                Object collapsed;
                Integer integer;
                int count;
                Method getHTMLWindow = Browser.getRealBrowserClass().getMethod("getHTMLWindow", new Class[0]);
                Object htmlWindow = getHTMLWindow.invoke((Object)browser, new Object[0]);
                Method getSelection = htmlWindow.getClass().getMethod("getSelection", new Class[0]);
                Object jSelection = getSelection.invoke(htmlWindow, new Object[0]);
                Method getRangeCount = jSelection.getClass().getMethod("getRangeCount", new Class[0]);
                Object rangeCount = getRangeCount.invoke(jSelection, new Object[0]);
                if (rangeCount instanceof Integer && (count = (integer = (Integer)rangeCount).intValue()) == 1 && (collapsed = (getCollapsed = (JRangeClass = (jRange = (getRangeAt = jSelection.getClass().getMethod("getRangeAt", Integer.TYPE)).invoke(jSelection, new Integer(0))).getClass()).getMethod("getCollapsed", new Class[0])).invoke(jRange, new Object[0])) instanceof Boolean && !(bool = (Boolean)collapsed).booleanValue()) {
                    Method getStartContainer = JRangeClass.getMethod("getStartContainer", new Class[0]);
                    Method getEndContainer = JRangeClass.getMethod("getEndContainer", new Class[0]);
                    Object startContainer = getStartContainer.invoke(jRange, new Object[0]);
                    Object endContainer = getEndContainer.invoke(jRange, new Object[0]);
                    if (startContainer instanceof Node && endContainer instanceof Node) {
                        startMessageBlock = this.findParentMessageBlock((Node)startContainer);
                        endMessageBlock = this.findParentMessageBlock((Node)endContainer);
                    }
                }
            }
            catch (Exception exception) {}
        }
        Document doc = browser.getDocument();
        ArrayList messageBlocks = new ArrayList(5);
        this.findChildMessageBlocks(doc, messageBlocks);
        if (messageBlocks.size() == 0) {
            return;
        }
        HashMap<String, Person> buddyMap = new HashMap<String, Person>();
        try {
            BuddyListService buddyListService = (BuddyListService)ServiceHub.getService((String)BuddyListService.SERVICE_TYPE);
            BuddyList buddyList = buddyListService.getBuddyList();
            Person[] persons = buddyList.getAllPersons(true);
            int index = 0;
            while (index < persons.length) {
                buddyMap.put(persons[index].getDisplayName(), persons[index]);
                ++index;
            }
        }
        catch (ServiceException exception) {
            SametimeUIPlugin.getInstance().log(exception);
            return;
        }
        boolean started = startMessageBlock == null;
        StringBuffer extract = new StringBuffer();
        HashSet<String> participants = new HashSet<String>();
        Iterator msgIt = messageBlocks.iterator();
        while (msgIt.hasNext()) {
            Node messageBlock = (Node)msgIt.next();
            if (!started && this.isEqualNode(messageBlock, startMessageBlock)) {
                started = true;
            }
            if (!started) continue;
            participants.add(this.getMessageBlockAuthor(messageBlock));
            extract.append(String.valueOf(this.getMessageBlockHTMLContents(buddyMap, messageBlock)) + "<br/>");
            if (endMessageBlock != null && this.isEqualNode(messageBlock, endMessageBlock)) break;
        }
        if (extract.length() == 0) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        Iterator it = participants.iterator();
        while (it.hasNext()) {
            if (!first) {
                buffer.append(", ");
            } else {
                first = false;
            }
            buffer.append(this.hyperlinkName(buddyMap, (String)it.next()));
        }
        SametimeUIPlugin.getInstance().getConnection().openHyperlink(CollaborationUriUtilities.createWorkItemCommentURI((String)MessageFormat.format(SametimeMessages.CommentWorkItemBrowserEventListener_1, buffer.toString(), extract.toString())).toString(), "dummy" + System.currentTimeMillis());
    }

    private String hyperlinkName(Map buddyMap, String name) {
        Person person = (Person)buddyMap.get(name);
        if (person != null) {
            return "<a href=\"mailto:" + person.getContactId() + "\">" + name + "</a>";
        }
        return name;
    }

    private boolean isEqualNode(Node node1, Node node2) {
        if (node1.getNodeType() != node2.getNodeType()) {
            return false;
        }
        if (!this.isEqualString(node1.getNodeName(), node2.getNodeName())) {
            return false;
        }
        if (node1 instanceof CharacterData) {
            CharacterData cdata1 = (CharacterData)node1;
            CharacterData cdata2 = (CharacterData)node2;
            return cdata1.getData().equals(cdata2.getData());
        }
        NodeList childNodes1 = node1.getChildNodes();
        NodeList childNodes2 = node2.getChildNodes();
        if (childNodes1.getLength() != childNodes2.getLength()) {
            return false;
        }
        int i = 0;
        while (i < childNodes1.getLength()) {
            if (!this.isEqualNode(childNodes1.item(i), childNodes2.item(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isEqualString(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }

    private boolean isMessageBlock(Node node) {
        Attr classAttr;
        Node classNode;
        NamedNodeMap attributes = node.getAttributes();
        return attributes != null && (classNode = attributes.getNamedItem("class")) instanceof Attr && (classAttr = (Attr)classNode).getValue().equals("messageBlock");
    }
}

