/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.ui.annotation.workitem;

import com.ibm.team.collaboration.common.uri.CollaborationUriUtilities;
import com.ibm.team.collaboration.internal.ui.SametimeMessages;
import com.ibm.team.collaboration.internal.ui.annotation.AbstractAnnotationProvider;
import com.ibm.team.collaboration.internal.ui.annotation.workitem.WorkitemActivationListener;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;

public final class WorkitemAnnotationProvider
extends AbstractAnnotationProvider {
    private static final Pattern WORKITEM_REFERENCE_PATTERN = Pattern.compile("(\\S+)(\\s+)(\\d+)");
    private static final String[] WORKITEM_TYPES = new String[]{SametimeMessages.WorkitemAnnotationProvider_1, SametimeMessages.WorkitemAnnotationProvider_2, SametimeMessages.WorkitemAnnotationProvider_3, SametimeMessages.WorkitemAnnotationProvider_4, SametimeMessages.WorkitemAnnotationProvider_5};

    public WorkitemAnnotationProvider() {
        super(WorkitemActivationListener.getInstance());
    }

    protected AbstractAnnotationProvider.AnnotationParseResult parseInput(String text) {
        Assert.isNotNull((Object)text);
        Matcher matcher = WORKITEM_REFERENCE_PATTERN.matcher(text);
        if (matcher.matches()) {
            String type = matcher.group(1);
            String number = matcher.group(3);
            if (type != null && number != null) {
                int index = 0;
                while (index < WORKITEM_TYPES.length) {
                    if (WORKITEM_TYPES[index].equalsIgnoreCase(type)) {
                        try {
                            int id = Integer.parseInt(number);
                            if (id >= 0) {
                                return new AbstractAnnotationProvider.AnnotationParseResult(CollaborationUriUtilities.createWorkItemURI((URI)WorkitemAnnotationProvider.getRepositoryURI(), (int)id), String.valueOf(type) + " " + number, text);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    ++index;
                }
            }
        }
        return null;
    }
}

