/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.ui.annotation.stacktrace;

import com.ibm.collaboration.realtime.annotate.IAnnotationProperties;
import com.ibm.team.collaboration.common.uri.CollaborationUriUtilities;
import com.ibm.team.collaboration.internal.ui.SametimeMessages;
import com.ibm.team.collaboration.internal.ui.annotation.AbstractAnnotationProvider;
import com.ibm.team.collaboration.internal.ui.annotation.ArtifactAnnotationRange;
import com.ibm.team.collaboration.internal.ui.annotation.stacktrace.StacktraceActivationListener;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;

public final class StacktraceAnnotationProvider
extends AbstractAnnotationProvider {
    private static final Pattern STACKTRACE_LINE_PATTERN = Pattern.compile("(\\S*)\\((\\S+.java:\\w+)\\)");

    private static String getLineNumberLabel(String text) {
        int end;
        int middle;
        Assert.isNotNull((Object)text);
        int begin = text.indexOf(40);
        if (begin > 0 && (middle = text.indexOf(58, begin)) > begin && (end = text.indexOf(41, middle)) > 0) {
            return MessageFormat.format(SametimeMessages.StacktraceAnnotationProvider_0, text.substring(begin + 1, middle), text.substring(middle + 1, end));
        }
        return "";
    }

    public StacktraceAnnotationProvider() {
        super(StacktraceActivationListener.getInstance());
    }

    public boolean canAnnotateMultipleWords() {
        return false;
    }

    protected ArtifactAnnotationRange createAnnotation(AbstractAnnotationProvider.AnnotationParseResult result) {
        ArtifactAnnotationRange range = super.createAnnotation(result);
        int offset = result.inputText.indexOf(40);
        if (offset > 0) {
            range.prefixOffset = offset + 1;
            range.postfixOffset = 1;
        }
        return range;
    }

    protected String createLinkTitle(AbstractAnnotationProvider.AnnotationParseResult result) {
        Assert.isNotNull((Object)result);
        return StacktraceAnnotationProvider.getLineNumberLabel(result.inputText);
    }

    public String getToolTip(IAnnotationProperties properties) {
        Assert.isNotNull((Object)properties);
        return MessageFormat.format(this.getToolTipPattern(), StacktraceAnnotationProvider.getLineNumberLabel(properties.getAnnotatedText()));
    }

    protected AbstractAnnotationProvider.AnnotationParseResult parseInput(String text) {
        Assert.isNotNull((Object)text);
        Matcher matcher = STACKTRACE_LINE_PATTERN.matcher(text);
        if (matcher.matches()) {
            return new AbstractAnnotationProvider.AnnotationParseResult(CollaborationUriUtilities.createStacktraceElementURI((String)text), matcher.group(2), text);
        }
        return null;
    }
}

