/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.ui.annotation;

import com.ibm.collaboration.realtime.annotate.AnnotationItem;
import com.ibm.collaboration.realtime.annotate.AnnotationManager;
import com.ibm.collaboration.realtime.annotate.AnnotationProvider;
import com.ibm.collaboration.realtime.annotate.IActivationListener;
import com.ibm.collaboration.realtime.annotate.IAnnotationProperties;
import com.ibm.team.collaboration.internal.ui.SametimeMessages;
import com.ibm.team.collaboration.internal.ui.annotation.ArtifactAnnotationRange;
import com.ibm.team.collaboration.internal.ui.annotation.reference.ReferenceAnnotationProvider;
import com.ibm.team.collaboration.repository.TeamRepositoryService;
import java.net.URI;
import java.text.BreakIterator;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractAnnotationProvider
extends AnnotationProvider {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static String encodeHTML(String string) {
        Assert.isNotNull((Object)string);
        StringBuffer buffer = new StringBuffer(string);
        char[] characters = string.toCharArray();
        int index = characters.length - 1;
        while (index > 0) {
            switch (characters[index]) {
                case '\"': {
                    buffer.replace(index, index + 1, "&quot;");
                    break;
                }
                case '&': {
                    buffer.replace(index, index + 1, "&amp;");
                    break;
                }
                case '<': {
                    buffer.replace(index, index + 1, "&lt;");
                    break;
                }
                case '>': {
                    buffer.replace(index, index + 1, "&gt;");
                }
            }
            --index;
        }
        return buffer.toString();
    }

    protected static URI getRepositoryURI() {
        URI[] repositories = TeamRepositoryService.getTeamRepositories();
        if (repositories.length > 0) {
            return repositories[0];
        }
        return null;
    }

    public static ArtifactAnnotationRange setupAnnotationRange(ArtifactAnnotationRange range) {
        Assert.isNotNull((Object)((Object)range));
        range.foreground = Display.getDefault().getSystemColor(9);
        range.fontStyle = 1;
        range.underline = false;
        return range;
    }

    protected AbstractAnnotationProvider(IActivationListener listener) {
        super(listener);
        String[] stringArray = new String[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.collaboration.realtime.annotate.AnnotatedRange");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("com.ibm.team.collaboration.internal.ui.annotation.ArtifactAnnotationRange");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz2.getName();
        this.setHandledRangeTypes(stringArray);
    }

    public boolean canAnnotateMultipleWords() {
        return true;
    }

    protected ArtifactAnnotationRange createAnnotation(AnnotationParseResult result) {
        String title;
        Assert.isNotNull((Object)result);
        ArtifactAnnotationRange range = AbstractAnnotationProvider.setupAnnotationRange(new ArtifactAnnotationRange());
        range.start = 0;
        range.length = result.inputText.length();
        range.artifactURL = result.artifactURL;
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("<a href=\"");
        buffer.append(result.artifactURL);
        buffer.append("\" title=\"");
        range.details = title = this.createLinkTitle(result);
        buffer.append(AbstractAnnotationProvider.encodeHTML(title));
        buffer.append("\" class=\"link\">");
        buffer.append(AbstractAnnotationProvider.encodeHTML(result.replacementText));
        buffer.append("</a>");
        range.replacementText = buffer.toString();
        return range;
    }

    protected String createLinkTitle(AnnotationParseResult result) {
        Assert.isNotNull((Object)result);
        return result.replacementText;
    }

    public void dispose() {
    }

    public String getToolTip(IAnnotationProperties properties) {
        Assert.isNotNull((Object)properties);
        StyleRange range = properties.getStyle();
        if (range instanceof ArtifactAnnotationRange) {
            ArtifactAnnotationRange extended = (ArtifactAnnotationRange)range;
            return MessageFormat.format(this.getToolTipPattern(), extended.details);
        }
        return null;
    }

    protected String getToolTipPattern() {
        URI[] uris = TeamRepositoryService.getTeamRepositories();
        if (uris != null && uris.length > 0) {
            return SametimeMessages.AbstractAnnotationProvider_0;
        }
        return SametimeMessages.AbstractAnnotationProvider_1;
    }

    public boolean isAnnotatable(IAnnotationProperties properties) {
        Assert.isNotNull((Object)properties);
        AnnotationManager manager = AnnotationManager.getAnnotationManager((StyledText)properties.getStyledText());
        if (manager != null) {
            AnnotationItem item;
            ArtifactAnnotationRange range;
            String text = properties.getAnnotatedText();
            if (this.canAnnotateMultipleWords()) {
                boolean found = false;
                BreakIterator iterator = BreakIterator.getWordInstance();
                iterator.setText(text);
                int firstStart = iterator.first();
                iterator.next();
                int secondStart = 0;
                int secondEnd = 0;
                while (secondEnd != -1) {
                    ArtifactAnnotationRange range2;
                    String string;
                    AnnotationParseResult result;
                    secondStart = iterator.next();
                    secondEnd = iterator.next();
                    if (secondEnd == -1) continue;
                    AnnotationItem item2 = manager.getAnnotationAtOffset(firstStart);
                    if (!(item2 != null && item2.getAnnotationProvider() instanceof ReferenceAnnotationProvider || (result = this.parseInput(string = text.substring(firstStart, secondEnd))) == null || (range2 = this.createAnnotation(result)) == null)) {
                        range2.start = firstStart;
                        range2.length = string.length();
                        properties.registerAnnotationProvider((AnnotationProvider)this, (StyleRange)range2, (Object)properties);
                        found = true;
                    }
                    firstStart = secondStart;
                }
                return found;
            }
            AnnotationParseResult result = this.parseInput(text);
            if (!(result == null || (range = this.createAnnotation(result)) == null || (item = manager.getAnnotationAtOffset(properties.getBeginIndex())) != null && item.getAnnotationProvider() instanceof ReferenceAnnotationProvider)) {
                properties.setOffsetModifier(range.prefixOffset, range.postfixOffset);
                properties.registerAnnotationProvider((AnnotationProvider)this, (StyleRange)range, (Object)properties, result.inputText);
                return true;
            }
        }
        return false;
    }

    public boolean isChangeOnToken() {
        return false;
    }

    protected abstract AnnotationParseResult parseInput(String var1);

    public static final class AnnotationParseResult {
        public final String artifactURL;
        public final String inputText;
        public final String replacementText;

        public AnnotationParseResult(String url, String replacement, String input) {
            Assert.isNotNull((Object)url);
            Assert.isNotNull((Object)replacement);
            Assert.isNotNull((Object)input);
            this.artifactURL = url;
            this.replacementText = replacement;
            this.inputText = input;
        }
    }
}

