/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.ui.annotation;

import com.ibm.collaboration.realtime.annotate.ActivationEvent;
import com.ibm.collaboration.realtime.annotate.EditMenu;
import com.ibm.collaboration.realtime.annotate.IActivationListener;
import com.ibm.collaboration.realtime.annotate.IAnnotationProperties;
import com.ibm.collaboration.realtime.chatwindow.ImChatWindowHandler;
import com.ibm.collaboration.realtime.chatwindow.ui.StyledTextChatArea;
import com.ibm.team.collaboration.internal.ui.SametimeUIPlugin;
import com.ibm.team.collaboration.internal.ui.annotation.ArtifactAnnotationRange;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public abstract class AbstractActivationListener
implements IActivationListener {
    public final void activated(ActivationEvent event) {
        Assert.isNotNull((Object)event);
        IAnnotationProperties properties = event.annotation;
        StyleRange range = properties.getStyle();
        if (range instanceof ArtifactAnnotationRange) {
            final ArtifactAnnotationRange extended = (ArtifactAnnotationRange)range;
            if (extended.artifactURL != null) {
                StyledTextChatArea area;
                ImChatWindowHandler handler;
                String conversationId = "dummy" + System.currentTimeMillis();
                Object source = event.getSource();
                if (source instanceof StyledTextChatArea && (handler = (area = (StyledTextChatArea)source).getChatWindowHandler()) != null) {
                    conversationId = handler.getConversationId();
                }
                Menu menu = new EditMenu(properties.getStyledText()).getMenu();
                MenuItem item = new MenuItem(menu, 2, 0);
                item = new MenuItem(menu, 64, 0);
                item.setText(this.getDefaultActionLabel());
                final String finalId = conversationId;
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selection) {
                        Assert.isNotNull((Object)selection);
                        SametimeUIPlugin.getInstance().getConnection().openHyperlink(extended.artifactURL, finalId);
                    }
                });
                this.fillPopupMenu(menu, extended.artifactURL);
                menu.setVisible(true);
            }
        }
    }

    protected void fillPopupMenu(Menu menu, String url) {
        Assert.isNotNull((Object)menu);
        Assert.isNotNull((Object)url);
    }

    protected abstract String getDefaultActionLabel();
}

