/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.ui;

import com.ibm.collaboration.realtime.chatwindow.ImChatPlugin;
import com.ibm.collaboration.realtime.chatwindow.ImChatWindowHandler;
import com.ibm.collaboration.realtime.ui.ExplorerWindow;
import com.ibm.team.collaboration.internal.ui.SametimeMessages;
import com.ibm.team.collaboration.internal.ui.browser.DefaultBrowserEventListener;
import com.ibm.team.collaboration.sametime.connection.ISametimeConnectionListener;
import com.ibm.team.collaboration.sametime.connection.SametimeConnection;
import java.text.MessageFormat;
import java.util.Dictionary;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public final class SametimeUIPlugin
extends AbstractUIPlugin {
    private static final String CONNECTION_SAMETIME = "sametime";
    private static final String CORE_BUNDLE_ID = "com.ibm.collaboration.realtime.core";
    private static SametimeUIPlugin fgPlugin;
    private static ImageRegistry fgRegistry;
    private static final String PING_JAZZ = "jazz";
    public static final String PLUGIN_ID = "com.ibm.team.collaboration.sametime.ui";
    private static final int PORT_NUMBER_V75 = 1883;
    private static final int PORT_NUMBER_V8 = 51883;
    SametimeConnection fConnection = null;
    private SametimeConnectionListener fConnectionListener = null;

    public static String escapeXML(String text) {
        Assert.isNotNull((Object)text);
        StringBuffer buffer = new StringBuffer(text.length());
        char[] characters = text.toCharArray();
        int index = 0;
        while (index < characters.length) {
            switch (characters[index]) {
                case '<': {
                    buffer.append("&lt;");
                    break;
                }
                case '>': {
                    buffer.append("&gt;");
                    break;
                }
                case '&': {
                    buffer.append("&amp;");
                    break;
                }
                case '^': {
                    buffer.append("&circ;");
                    break;
                }
                case '~': {
                    buffer.append("&tilde;");
                    break;
                }
                case '\"': {
                    buffer.append("&quot;");
                    break;
                }
                case '\t': {
                    buffer.append("&#09;");
                    break;
                }
                case '\n': {
                    char character;
                    if (index > 0 && '\r' == (character = characters[index - 1])) break;
                    buffer.append("<br/>");
                    break;
                }
                case '\r': {
                    buffer.append("<br/>");
                    break;
                }
                default: {
                    buffer.append(characters[index]);
                }
            }
            ++index;
        }
        return buffer.toString();
    }

    public static Image getImage(String path) {
        Image image;
        if (fgRegistry == null) {
            fgRegistry = new ImageRegistry();
        }
        if ((image = fgRegistry.get(path)) == null) {
            ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
            fgRegistry.put(path, descriptor);
            image = fgRegistry.get(path);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        ImageDescriptor descriptor;
        if (fgRegistry == null) {
            fgRegistry = new ImageRegistry();
        }
        if ((descriptor = fgRegistry.getDescriptor(path)) == null) {
            descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
            fgRegistry.put(path, descriptor);
        }
        return descriptor;
    }

    public static SametimeUIPlugin getInstance() {
        return fgPlugin;
    }

    public SametimeUIPlugin() {
        fgPlugin = this;
    }

    public SametimeConnection getConnection() {
        if (!this.fConnection.isConnected()) {
            IStatus status;
            if (this.fConnectionListener != null) {
                this.fConnection.addConnectionListener((ISametimeConnectionListener)this.fConnectionListener);
            }
            if (!(status = this.fConnection.connect()).isOK()) {
                this.log(status);
            }
        }
        return this.fConnection;
    }

    public boolean isJazzRunning() {
        return this.fConnectionListener != null && this.fConnectionListener.isJazzRunning();
    }

    public void log(IStatus status) {
        Logger.getLogger(PLUGIN_ID).log(Level.WARNING, status.getMessage(), status.getException());
    }

    public void log(String message) {
        this.log((IStatus)new Status(4, PLUGIN_ID, 10001, message, null));
    }

    public void log(Throwable throwable) {
        this.log((IStatus)new Status(4, PLUGIN_ID, 4, "Internal Error", throwable));
    }

    public void start(BundleContext context) throws Exception {
        String value;
        Dictionary headers;
        super.start(context);
        int port = 51883;
        Bundle result = Platform.getBundle((String)CORE_BUNDLE_ID);
        if (result != null && (headers = result.getHeaders()) != null && (value = (String)headers.get("Bundle-Version")) != null) {
            Version version = Version.parseVersion((String)value);
            switch (version.getMajor()) {
                case 8: {
                    port = 51883;
                    break;
                }
                case 7: {
                    port = 1883;
                }
            }
        }
        this.fConnection = new SametimeConnection(CONNECTION_SAMETIME + System.currentTimeMillis(), port);
        this.fConnectionListener = new SametimeConnectionListener();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.fConnection != null) {
            if (this.fConnectionListener != null) {
                this.fConnection.removeConnectionListener((ISametimeConnectionListener)this.fConnectionListener);
            }
            if (this.fConnection.isConnected()) {
                this.fConnection.disconnect();
            }
            this.fConnection = null;
        }
        this.fConnectionListener = null;
        super.stop(context);
        if (fgRegistry != null) {
            fgRegistry.dispose();
        }
        fgPlugin = null;
    }

    private final class SametimeConnectionListener
    extends TimerTask
    implements ISametimeConnectionListener {
        private long fLastPing = 0L;
        private Timer fTimer = null;

        SametimeConnectionListener() {
        }

        public void connected() {
            this.fLastPing = System.currentTimeMillis();
            if (this.fTimer != null) {
                this.fTimer.cancel();
            }
            this.fTimer = new Timer(true);
            this.fTimer.scheduleAtFixedRate((TimerTask)this, 0L, 1000L);
        }

        public void contactsRetrieved(String name, String[] userIds) {
        }

        public void disconnected() {
            this.fLastPing = 0L;
            if (this.fTimer != null) {
                this.fTimer.cancel();
                this.fTimer = null;
            }
        }

        Shell getShell(String conversationId) {
            IWorkbenchWindow window;
            Shell shell = null;
            ImChatWindowHandler handler = ImChatPlugin.getChatWindow((String)conversationId);
            if (handler != null) {
                shell = handler.getShell();
            }
            if ((window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
                shell = window.getShell();
            }
            return shell;
        }

        public void groupsRetrieved(String type, String[] groups) {
        }

        public void hyperlinkOpened(String conversationId, int severity, String message, String uri) {
            int type;
            Assert.isNotNull((Object)conversationId);
            Assert.isNotNull((Object)uri);
            switch (severity) {
                case 1: 
                case 8: {
                    type = 2;
                    break;
                }
                case 2: {
                    type = 4;
                    break;
                }
                case 4: {
                    type = 1;
                    break;
                }
                default: {
                    type = -1;
                }
            }
            if (type != -1) {
                String reason = message;
                reason = reason == null || "".equals(reason) ? SametimeMessages.SametimeUIPlugin_1 : MessageFormat.format(SametimeMessages.SametimeUIPlugin_0, reason);
                if (DefaultBrowserEventListener.supportsWebAccess(uri)) {
                    String finalReason = MessageFormat.format(SametimeMessages.SametimeUIPlugin_2, reason);
                    Display.getDefault().asyncExec(new Runnable(this, conversationId, finalReason, uri){
                        final /* synthetic */ SametimeConnectionListener this$1;
                        private final /* synthetic */ String val$conversationId;
                        private final /* synthetic */ String val$finalReason;
                        private final /* synthetic */ String val$uri;
                        {
                            this.this$1 = sametimeConnectionListener;
                            this.val$conversationId = string;
                            this.val$finalReason = string2;
                            this.val$uri = string3;
                        }

                        public void run() {
                            int result;
                            Shell shell = this.this$1.getShell(this.val$conversationId);
                            if (shell != null && !shell.isDisposed() && (result = new MessageDialog(shell, SametimeMessages.DefaultBrowserEventListener_2, null, this.val$finalReason, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0).open()) == 0) {
                                ExplorerWindow.launchBrowser((String)SametimeMessages.DefaultBrowserEventListener_0, (String)this.val$uri);
                            }
                        }
                    });
                } else {
                    String finalReason = reason;
                    Display.getDefault().asyncExec(new Runnable(this, conversationId, finalReason, type){
                        final /* synthetic */ SametimeConnectionListener this$1;
                        private final /* synthetic */ String val$conversationId;
                        private final /* synthetic */ String val$finalReason;
                        private final /* synthetic */ int val$type;
                        {
                            this.this$1 = sametimeConnectionListener;
                            this.val$conversationId = string;
                            this.val$finalReason = string2;
                            this.val$type = n;
                        }

                        public void run() {
                            Shell shell = this.this$1.getShell(this.val$conversationId);
                            if (shell != null && !shell.isDisposed()) {
                                new MessageDialog(shell, SametimeMessages.DefaultBrowserEventListener_2, null, this.val$finalReason, this.val$type, new String[]{IDialogConstants.OK_LABEL}, 0).open();
                            }
                        }
                    });
                }
            }
        }

        public boolean isJazzRunning() {
            return System.currentTimeMillis() - this.fLastPing < 2000L;
        }

        public void openHyperlink(String converationId, String uri) {
        }

        public void pingAnswered(String connectionId, String type) {
            if (SametimeUIPlugin.this.fConnection != null && !SametimeUIPlugin.this.fConnection.getConnectionId().equals(connectionId) && SametimeUIPlugin.PING_JAZZ.equals(type)) {
                this.fLastPing = System.currentTimeMillis();
            }
        }

        public void pingReceived(String connectionId, String type) {
        }

        public void presenceUpdate(String userId, int code, String text) {
        }

        public void run() {
            if (SametimeUIPlugin.this.fConnection != null && SametimeUIPlugin.this.fConnection.isConnected()) {
                SametimeUIPlugin.this.fConnection.sendPing(SametimeUIPlugin.PING_JAZZ);
            }
        }
    }
}

