/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.annotate.ui;

import com.ibm.collaboration.realtime.annotate.AnnotationManager;
import com.ibm.collaboration.realtime.annotate.LinkRange;
import com.ibm.collaboration.realtime.annotate.LinkifyAnnotationProvider;
import com.ibm.collaboration.realtime.annotate.strings.Messages;
import com.ibm.collaboration.realtime.ui.util.HTMLUtils;
import com.ibm.collaboration.realtime.util.NotesLink;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class InsertLinkDialog
extends Dialog {
    private String theUrl;
    private String theName;
    private Text text;
    private Text name;
    private final StyledText styledText;
    private StyleRange currentRange;
    private boolean nameEnabled = true;
    static /* synthetic */ Class class$0;

    public InsertLinkDialog(StyledText styledText) {
        super(styledText != null ? styledText.getShell() : null);
        this.styledText = styledText;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(0x860 | InsertLinkDialog.getDefaultOrientation());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.insert_link_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite control = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        control.setLayout((Layout)layout);
        this.createUrlTab(control);
        return control;
    }

    public void setName(String text) {
        this.theName = text;
    }

    public void setUrl(String url) {
        this.theUrl = url;
    }

    public void setCurrentRange(StyleRange range) {
        this.currentRange = range;
    }

    protected void okPressed() {
        this.theUrl = this.text.getText();
        this.theName = this.name.getText();
        try {
            this.theUrl = this.theUrl.replace('\\', '/');
            this.theUrl = this.theUrl.replace('\"', '\'');
        }
        catch (Throwable throwable) {}
        if (!LinkifyAnnotationProvider.getProtocolPattern().matcher(this.theUrl).find()) {
            this.theUrl = "http://" + this.theUrl.trim();
        }
        String replaceText = NLS.bind((String)Messages.linkHtml, (Object[])new String[]{this.theUrl, HTMLUtils.convertPlainTextToHTML((String)this.theName)});
        if (this.currentRange != null) {
            LinkRange range = new LinkRange();
            range.start = this.currentRange.start;
            if (this.theName != null && this.theName.length() > 0) {
                range.length = this.theName.length();
            } else {
                range.length = this.theUrl.length();
                this.theName = this.theUrl;
                replaceText = null;
            }
            range.link = this.theUrl;
            range.replacementText = replaceText;
            this.styledText.setCaretOffset(this.currentRange.start);
            AnnotationManager.getAnnotationManager(this.styledText).disableModify();
            AnnotationManager annotationManager = AnnotationManager.getAnnotationManager(this.styledText);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.ibm.collaboration.realtime.annotate.LinkifyAnnotationProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            annotationManager.insertAnnotation(clazz, this.theName, range);
            AnnotationManager.getAnnotationManager(this.styledText).enableModify();
            this.styledText.setCaretOffset(this.currentRange.start + this.theName.length());
        } else if (this.theName != null && this.theName.length() > 0) {
            LinkRange range = new LinkRange();
            range.link = this.theUrl;
            range.replacementText = replaceText;
            AnnotationManager.getAnnotationManager(this.styledText).disableModify();
            AnnotationManager annotationManager = AnnotationManager.getAnnotationManager(this.styledText);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.ibm.collaboration.realtime.annotate.LinkifyAnnotationProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            annotationManager.insertAnnotation(clazz, this.theName, range);
            AnnotationManager.getAnnotationManager(this.styledText).enableModify();
            this.styledText.setCaretOffset(this.styledText.getCaretOffset() + this.theName.length());
        } else {
            int offset = this.styledText.getCaretOffset();
            this.styledText.insert(this.theUrl);
            this.styledText.setCaretOffset(offset + this.theUrl.length());
        }
        this.styledText.setFocus();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.styledText.setFocus();
        super.cancelPressed();
    }

    private String getAllowedProtocols() {
        String[] allowed = LinkifyAnnotationProvider.getAllowedProtocols();
        if (allowed != null) {
            StringBuffer buff = new StringBuffer();
            int i = 0;
            while (i < allowed.length) {
                buff.append("\n   ");
                buff.append(allowed[i]);
                ++i;
            }
            return buff.toString();
        }
        return null;
    }

    protected Control createButtonBar(Composite arg0) {
        Control buttonBar = super.createButtonBar(arg0);
        if (this.theUrl == null && this.getButton(0) != null) {
            this.getButton(0).setEnabled(false);
        }
        return buttonBar;
    }

    private void createUrlTab(Composite control) {
        Composite group = new Composite(control, 0);
        group.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(group, 0);
        label.setText(Messages.insert_link_instruct);
        Label url = new Label(group, 0);
        url.setText(Messages.insert_link_url);
        this.text = new Text(group, 33556484);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                if (InsertLinkDialog.this.text != null && InsertLinkDialog.this.getButton(0) != null) {
                    if (InsertLinkDialog.this.text.getText().length() == 0 || InsertLinkDialog.this.text.getText().equals("http://")) {
                        InsertLinkDialog.this.getButton(0).setEnabled(false);
                    } else if (!InsertLinkDialog.this.getButton(0).getEnabled()) {
                        InsertLinkDialog.this.getButton(0).setEnabled(true);
                    }
                }
            }
        });
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if ("http://".equals(InsertLinkDialog.this.text.getText())) {
                    InsertLinkDialog.this.text.setSelection("http://".length());
                }
            }
        });
        DropTarget target = new DropTarget((Control)control.getParent(), 31);
        target.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : ((event.operations & 4) != 0 ? 4 : ((event.operations & 2) != 0 ? 2 : ((event.operations & 8) != 0 ? 8 : 0)));
                }
            }

            public void drop(DropTargetEvent event) {
                Object data = event.data;
                if (data instanceof String) {
                    String[] stuff = ((String)data).split("\n");
                    if (stuff.length == 2) {
                        InsertLinkDialog.this.text.setText(stuff[0]);
                        if (InsertLinkDialog.this.nameEnabled) {
                            InsertLinkDialog.this.name.setText(stuff[1]);
                        }
                    } else {
                        InsertLinkDialog.this.text.setText((String)data);
                    }
                } else if (data instanceof byte[]) {
                    byte[] cfr_ignored_0 = (byte[])data;
                }
            }
        });
        if (this.theUrl != null) {
            this.text.setText(this.theUrl);
        } else {
            this.text.setText("http://");
            this.text.setSelection(0, "http://".length());
        }
        Button paste = new Button(group, 8);
        paste.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_PASTE"));
        paste.setToolTipText(Messages.insert_link_paste);
        paste.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InsertLinkDialog.this.pasteLink();
                ((Button)e.getSource()).setToolTipText(Messages.insert_link_paste);
            }
        });
        paste.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.insert_link_paste;
            }
        });
        Label nameLabel = new Label(group, 0);
        nameLabel.setText(Messages.insert_link_name);
        this.name = new Text(group, 2052);
        if (this.theName != null && this.nameEnabled) {
            this.name.setText(this.theName);
        }
        Label tip = new Label(group, 0);
        tip.setText(Messages.insert_link_tip);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        group.setLayoutData((Object)fd);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        gd = new GridData(32);
        url.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.widthHint = 275;
        this.text.setLayoutData((Object)gd);
        gd = new GridData(128);
        paste.setLayoutData((Object)gd);
        gd = new GridData(32);
        nameLabel.setLayoutData((Object)gd);
        gd = new GridData(768);
        this.name.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        tip.setLayoutData((Object)gd);
        this.name.setEnabled(this.nameEnabled);
        this.text.setFocus();
    }

    public static int getDword(byte[] bytes, int start) {
        return (bytes[start + 3] & 0xFF) << 24 | (bytes[start + 2] & 0xFF) << 16 | (bytes[start + 1] & 0xFF) << 8 | bytes[start] & 0xFF;
    }

    public static short getShort(byte[] bytes, int start) {
        return (short)(((short)bytes[start + 1] & 0xFF) << 8 | (short)bytes[start] & 0xFF);
    }

    private void pasteLink() {
        try {
            Clipboard cb = new Clipboard(Display.getCurrent());
            Object o = cb.getContents((Transfer)TextTransfer.getInstance());
            if (o instanceof String) {
                String substring = (String)o;
                if (substring != null && substring.indexOf("<NDL>") > -1) {
                    NotesLink link = NotesLink.parseNotesLink((String)substring);
                    if (link != null && link.m_link != null) {
                        this.text.setText(link.getLink().trim());
                        if (this.nameEnabled) {
                            this.name.setText(link.getTitle().trim());
                        }
                    }
                } else {
                    String[] stuff = substring.split("\n");
                    if (stuff.length == 2) {
                        if (LinkifyAnnotationProvider.getLinkPattern().matcher(stuff[0]).find()) {
                            this.text.setText(stuff[0].trim());
                        }
                        if (this.nameEnabled) {
                            this.name.setText(stuff[1].trim());
                        }
                    } else if (LinkifyAnnotationProvider.getProtocolPattern().matcher(substring).find()) {
                        this.text.setText(substring.trim());
                    } else if (stuff.length > 1) {
                        this.text.setText("http://" + stuff[0].trim());
                    } else {
                        this.text.setText("http://" + substring.trim());
                    }
                }
            }
            cb.dispose();
        }
        catch (Throwable throwable) {}
    }

    public void setNameEnabled(boolean enabled) {
        this.nameEnabled = enabled;
    }
}

