/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.annotate;

import com.ibm.collaboration.realtime.annotate.AbstractLifecycleManager;
import com.ibm.collaboration.realtime.annotate.AnnotationProvider;
import com.ibm.collaboration.realtime.annotate.IAnnotationProperties;
import com.ibm.collaboration.realtime.annotate.ILifecycleManaged;
import com.ibm.collaboration.realtime.annotate.ImageStyleRange;
import com.ibm.collaboration.realtime.annotate.LinkRange;
import com.ibm.collaboration.realtime.annotate.strings.Messages;
import com.ibm.collaboration.realtime.ui.util.HTMLUtils;
import com.ibm.collaboration.realtime.util.OSUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;

public class HTMLAnnotationProvider
extends AnnotationProvider {
    private static AbstractLifecycleManager theAbstractLifecycleManager;
    private static final Logger logger;
    private static Pattern aPattern;
    private static Pattern imgPattern;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.collaboration.realtime.annotate.HTMLAnnotationProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getPackage().getName());
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.ibm.collaboration.realtime.annotate.HTMLAnnotationProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        theAbstractLifecycleManager = new AbstractLifecycleManager(clazz2){

            protected ILifecycleManaged constructInstance() {
                return new HTMLAnnotationProvider();
            }
        };
        aPattern = Pattern.compile("<a(?:[^<>]*)href=\"(.*?)\"(?:[^<>]*)>(.*?)</a>");
        imgPattern = Pattern.compile("<img(?:[^<>]*)src=\"(.*?)\"(?:[^<>]*)/>");
    }

    public static AbstractLifecycleManager getLifecycleManager() {
        return theAbstractLifecycleManager;
    }

    public static void main(String[] args) {
        Matcher matcher = aPattern.matcher("<a href=\"http://www.ibm.com\">IBM</a>");
        if (matcher.find() && logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, String.valueOf(matcher.group()) + " " + matcher.groupCount());
            logger.log(Level.INFO, matcher.group(1));
            logger.log(Level.INFO, matcher.group(2));
        }
    }

    public HTMLAnnotationProvider() {
        super(null);
    }

    public String getToolTip(IAnnotationProperties annotationProperties) {
        return null;
    }

    public boolean isAnnotatable(IAnnotationProperties annotationProperties) {
        Matcher matcher = aPattern.matcher(annotationProperties.getAnnotatedText());
        if (matcher.find() && matcher.groupCount() == 2) {
            LinkRange range = new LinkRange();
            range.foreground = Display.getCurrent().getSystemColor(9);
            range.fontStyle = 1;
            String link = matcher.group(1);
            String text = matcher.group(2);
            int start = matcher.start();
            String group = matcher.group();
            if (link != null && text != null) {
                if (link.toLowerCase().indexOf("www.") == 0) {
                    link = "http://" + link;
                }
                String amped = text;
                try {
                    amped = amped.replaceAll("&", "&amp;");
                }
                catch (Throwable throwable) {}
                range.link = link;
                range.start = start;
                range.length = group.length();
                range.replacementText = NLS.bind((String)Messages.linkHtml, (Object)link, (Object)amped);
                annotationProperties.setOffsetModifier(start, annotationProperties.getEndIndex() - group.length());
                annotationProperties.registerAnnotationProvider(this, range, null, text);
                return true;
            }
        }
        return (matcher = imgPattern.matcher(annotationProperties.getAnnotatedText())).find();
    }

    public static void annotate(StyledText styledText, String inputString, boolean append) {
        int[] newIndices;
        StyleRange[] newRanges;
        int insertion = styledText.getCaretOffset();
        int charCount = append ? insertion : 0;
        StringBuffer buffer = new StringBuffer();
        StyleRange[] ranges = null;
        int[] indices = null;
        int startIndex = 0;
        if (!append) {
            styledText.replaceTextRange(0, charCount, inputString);
        }
        Matcher matcher = imgPattern.matcher(inputString);
        while (matcher.find()) {
            Image im;
            if (matcher.groupCount() != 1) continue;
            String src = matcher.group(1);
            int start = matcher.start();
            buffer.append(inputString.substring(startIndex, start));
            startIndex = matcher.end();
            ImageStyleRange range = new ImageStyleRange();
            range.start = buffer.length() + charCount;
            range.length = 1;
            range.replacementText = matcher.group();
            src = HTMLUtils.urlDecodeSpecial((String)src);
            try {
                if (OSUtils.isWin32() && src.indexOf("file:///") == 0) {
                    src = src.substring("file:///".length());
                } else if (src.indexOf("file://") == 0) {
                    src = src.substring("file://".length());
                }
            }
            catch (Exception exception) {}
            range.plainText = src;
            range.originalFile = src;
            ImageLoader loader = new ImageLoader();
            loader.load(src);
            range.image = im = new Image(null, loader.data[0]);
            range.metrics = new GlyphMetrics(im.getImageData().height, 0, im.getImageData().width);
            if (ranges == null) {
                ranges = new StyleRange[1];
                indices = new int[2];
                ranges[0] = range;
                indices[0] = range.start;
                indices[1] = range.length;
                continue;
            }
            newRanges = new StyleRange[ranges.length + 1];
            newIndices = new int[indices.length + 2];
            System.arraycopy(ranges, 0, newRanges, 0, ranges.length);
            newRanges[newRanges.length - 1] = range;
            System.arraycopy(indices, 0, newIndices, 0, indices.length);
            newIndices[newIndices.length - 2] = range.start;
            newIndices[newIndices.length - 1] = range.length;
            ranges = newRanges;
            indices = newIndices;
        }
        matcher = aPattern.matcher(inputString);
        while (matcher.find()) {
            if (matcher.groupCount() != 2) continue;
            LinkRange range = new LinkRange();
            range.foreground = Display.getCurrent().getSystemColor(9);
            range.fontStyle = 1;
            String link = matcher.group(1);
            String text = matcher.group(2);
            String group = matcher.group();
            int start = matcher.start();
            buffer.append(inputString.substring(startIndex, start));
            startIndex = matcher.end();
            if (link == null || text == null) continue;
            if (link.toLowerCase().indexOf("www.") == 0) {
                link = "http://" + link;
            }
            range.link = link;
            range.start = buffer.length() + charCount;
            range.length = text.length();
            if (group.indexOf("title=\"") != -1 || group.indexOf("title='") != -1) {
                range.replacementText = group;
            } else {
                String amped = text;
                try {
                    amped = amped.replaceAll("&", "&amp;");
                }
                catch (Throwable throwable) {}
                range.replacementText = NLS.bind((String)Messages.linkHtml, (Object)link, (Object)amped);
            }
            buffer.append(text);
            if (ranges == null) {
                ranges = new StyleRange[1];
                indices = new int[2];
                ranges[0] = range;
                indices[0] = range.start;
                indices[1] = range.length;
                continue;
            }
            newRanges = new StyleRange[ranges.length + 1];
            newIndices = new int[indices.length + 2];
            System.arraycopy(ranges, 0, newRanges, 0, ranges.length);
            newRanges[newRanges.length - 1] = range;
            System.arraycopy(indices, 0, newIndices, 0, indices.length);
            newIndices[newIndices.length - 2] = range.start;
            newIndices[newIndices.length - 1] = range.length;
            ranges = newRanges;
            indices = newIndices;
        }
        buffer.append(inputString.substring(startIndex));
        buffer.append(" ");
        if (append) {
            styledText.insert(buffer.toString());
        } else {
            styledText.setText(buffer.toString());
        }
        if (indices != null && ranges != null) {
            styledText.setStyleRanges(charCount, buffer.length(), indices, ranges);
        }
        styledText.setCaretOffset(insertion + buffer.length());
    }

    public boolean isChangeOnToken() {
        return true;
    }

    public void dispose() {
    }

    public boolean canAnnotateMultipleWords() {
        return true;
    }
}

