/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.annotate;

import com.ibm.collaboration.realtime.annotate.ActivationEvent;
import com.ibm.collaboration.realtime.annotate.AnnotatedRange;
import com.ibm.collaboration.realtime.annotate.AnnotationItem;
import com.ibm.collaboration.realtime.annotate.AnnotationProviderManager;
import com.ibm.collaboration.realtime.annotate.EclipsePlugin;
import com.ibm.collaboration.realtime.annotate.EditMenu;
import com.ibm.collaboration.realtime.annotate.IAnnotationProperties;
import com.ibm.collaboration.realtime.annotate.IReadOnlyListener;
import com.ibm.collaboration.realtime.annotate.ImageStyleRange;
import com.ibm.collaboration.realtime.annotate.strings.Errors;
import com.ibm.collaboration.realtime.ui.util.AnimatedGifTimer;
import com.ibm.collaboration.realtime.ui.util.GifAnimatingRunnable;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.PaintObjectEvent;
import org.eclipse.swt.custom.PaintObjectListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.progress.UIJob;

public class AnnotationManager
implements ExtendedModifyListener,
PaintListener,
MouseTrackListener,
MouseListener,
MouseMoveListener,
DisposeListener,
VerifyKeyListener {
    private static Set registeredAnnotationManagers = new HashSet();
    public static String MODIFIER_KEY_NAME = SWT.MOD1 == 262144 ? "Ctrl" : "OA";
    private final StyledText annotatedText;
    private boolean isDrawingAnnotations;
    private final TreeSet annotations;
    private final AnnotationProviderManager annotationProviderManager;
    private EditMenu editMenu;
    private final Timer timer;
    private boolean isRichTextEnabled = false;
    boolean overrideMenu = false;
    private int lastAnnotated = 0;
    private boolean isKeepStyle = false;
    private final Object paintModifyLock = new Object();
    private Cursor cursor = null;
    private final Listener menuDetectListener = new Listener(){

        public void handleEvent(Event event) {
            if (AnnotationManager.this.overrideMenu) {
                event.doit = false;
            }
        }
    };
    boolean modifyEnabled = true;

    public static synchronized void addAnnotationManager(AnnotationManager annotationManager) {
        registeredAnnotationManagers.add(annotationManager);
    }

    public static synchronized void removeAnnotationManager(AnnotationManager annotationManager) {
        registeredAnnotationManagers.remove(annotationManager);
    }

    public static synchronized void refreshAnnotationManagers(boolean hasAnnotations) {
        Iterator managerIter = registeredAnnotationManagers.iterator();
        while (managerIter.hasNext()) {
            ((AnnotationManager)managerIter.next()).setIsDrawingAnnotations(hasAnnotations);
        }
    }

    public static synchronized void removeAllAnnotationsLike(IAnnotationProperties annotationProperties) {
        Iterator managerIter = registeredAnnotationManagers.iterator();
        while (managerIter.hasNext()) {
            ((AnnotationManager)managerIter.next()).removeAnnotationsLike(annotationProperties);
        }
    }

    public static synchronized AnnotationManager getAnnotationManager(StyledText text) {
        Iterator managerIter = registeredAnnotationManagers.iterator();
        while (managerIter.hasNext()) {
            AnnotationManager m = (AnnotationManager)managerIter.next();
            if (m.annotatedText != text) continue;
            return m;
        }
        return new AnnotationManager(text);
    }

    public AnnotationManager(StyledText toAnnotate) {
        EclipsePlugin.getDefault().createAnnotationProviders();
        if (toAnnotate.isDisposed()) {
            throw new RuntimeException(Errors.styledtext_is_disposed);
        }
        this.annotatedText = toAnnotate;
        this.isDrawingAnnotations = AnnotationProviderManager.getInstance().hasProvidersEnabled();
        this.annotations = new TreeSet(new AnnotationPositionComparator());
        this.annotationProviderManager = AnnotationProviderManager.getInstance();
        this.timer = null;
        this.annotatedText.addExtendedModifyListener((ExtendedModifyListener)this);
        this.annotatedText.addPaintListener((PaintListener)this);
        this.annotatedText.addMouseTrackListener((MouseTrackListener)this);
        this.annotatedText.addMouseListener((MouseListener)this);
        this.annotatedText.addMouseMoveListener((MouseMoveListener)this);
        this.annotatedText.addDisposeListener((DisposeListener)this);
        this.annotatedText.addVerifyKeyListener((VerifyKeyListener)this);
        this.annotatedText.addListener(35, this.menuDetectListener);
        if ((this.annotatedText.getStyle() & 8) != 0) {
            this.annotatedText.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 4) {
                        try {
                            Point location = AnnotationManager.this.annotatedText.getLocationAtOffset(AnnotationManager.this.annotatedText.getCaretOffset());
                            AnnotationItem annotation = AnnotationManager.this.getAnnotationAt(location.x, location.y);
                            if (annotation != null) {
                                ActivationEvent ev = new ActivationEvent(annotation, annotation.getStyledText().getDisplay().getCursorLocation());
                                ((IReadOnlyListener)((Object)annotation.getAnnotationProvider())).activateSelection(ev);
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                }
            });
        } else {
            this.editMenu = new EditMenu(this.annotatedText);
            this.annotatedText.setMenu(this.editMenu.getMenu());
        }
        AnnotationManager.addAnnotationManager(this);
        this.annotatedText.addPaintObjectListener(new PaintObjectListener(){

            public void paintObject(PaintObjectEvent event) {
                StyleRange range = event.style;
                if (range instanceof ImageStyleRange) {
                    ImageStyleRange ii = (ImageStyleRange)range;
                    if (range.metrics != null && ii.image != null) {
                        int x = event.x;
                        int y = event.y + event.ascent - range.metrics.ascent;
                        if (ii.frame == -1) {
                            ii.frame = 0;
                            try {
                                event.gc.drawImage(ii.image, x, y);
                            }
                            catch (Exception exception) {}
                            GifAnimatingRunnable run = ii.runnable;
                            run.setup(ii.originalFile, (Canvas)AnnotationManager.this.annotatedText, x, y);
                            try {
                                boolean added = AnimatedGifTimer.getInstance((Widget)AnnotationManager.this.annotatedText).addGif((TimerTask)run);
                                if (added) {
                                    run.isVisible = true;
                                    ii.runnable = run;
                                }
                            }
                            catch (IllegalStateException illegalStateException) {}
                        }
                    }
                }
            }
        });
    }

    public void setRichTextEnabled(boolean enabled) {
        this.isRichTextEnabled = enabled;
    }

    public void enableListeners(boolean enable) {
        if (enable) {
            this.annotatedText.addExtendedModifyListener((ExtendedModifyListener)this);
            this.annotatedText.addPaintListener((PaintListener)this);
            this.annotatedText.addMouseTrackListener((MouseTrackListener)this);
            this.annotatedText.addMouseListener((MouseListener)this);
            this.annotatedText.addMouseMoveListener((MouseMoveListener)this);
            this.annotatedText.addDisposeListener((DisposeListener)this);
        } else {
            this.annotatedText.removeExtendedModifyListener((ExtendedModifyListener)this);
            this.annotatedText.removePaintListener((PaintListener)this);
            this.annotatedText.removeMouseTrackListener((MouseTrackListener)this);
            this.annotatedText.removeMouseListener((MouseListener)this);
            this.annotatedText.removeMouseMoveListener((MouseMoveListener)this);
            this.annotatedText.removeDisposeListener((DisposeListener)this);
        }
    }

    public AnnotationProviderManager getProviderManager() {
        return this.annotationProviderManager;
    }

    public void widgetDisposed(DisposeEvent e) {
        try {
            this.annotations.clear();
            this.dispose();
            this.annotatedText.removePaintListener((PaintListener)this);
            this.annotatedText.removeMouseTrackListener((MouseTrackListener)this);
            this.annotatedText.removeMouseListener((MouseListener)this);
            this.annotatedText.removeMouseMoveListener((MouseMoveListener)this);
            this.annotatedText.removeDisposeListener((DisposeListener)this);
            AnnotationManager.removeAnnotationManager(this);
        }
        catch (Exception exception) {}
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
    }

    public void mouseMove(MouseEvent e) {
        if (!this.isDrawingAnnotations) {
            return;
        }
        AnnotationItem annotation = this.getAnnotationAt(e.x, e.y);
        if (annotation == null || !annotation.getAnnotationProvider().hasActivationHandler()) {
            if (this.cursor == null) {
                return;
            }
            this.annotatedText.setCursor(null);
            this.cursor.dispose();
            this.cursor = null;
        } else {
            if (this.cursor != null) {
                return;
            }
            this.cursor = new Cursor((Device)this.annotatedText.getDisplay(), 21);
            this.annotatedText.setCursor(this.cursor);
        }
    }

    public void dispose() {
        if (this.cursor != null && !this.cursor.isDisposed()) {
            this.cursor.dispose();
        }
        if (this.editMenu != null && !this.editMenu.isDisposed()) {
            this.editMenu.dispose();
        }
    }

    public void mouseDown(MouseEvent e) {
        AnnotationItem annotation = this.getAnnotationAt(e.x, e.y);
        if (annotation == null) {
            if (e.button == 3 || e.button == 10) {
                this.overrideMenu = false;
                if (this.getContextMenu() != null) {
                    this.getContextMenu().setLocation(Display.getDefault().getCursorLocation());
                }
                return;
            }
            return;
        }
        if (annotation.isReadOnly() && annotation.getAnnotationProvider() instanceof IReadOnlyListener) {
            if (e.button == 1) {
                ActivationEvent ev = new ActivationEvent(annotation, annotation.getStyledText().getDisplay().getCursorLocation());
                ((IReadOnlyListener)((Object)annotation.getAnnotationProvider())).activateSelection(ev);
            }
        } else if (e.button == 3 || e.button == 10) {
            if (this.getContextMenu() != null) {
                this.getContextMenu().setLocation(Display.getDefault().getCursorLocation());
            }
            if (!annotation.getAnnotationProvider().hasActivationHandler()) {
                this.overrideMenu = false;
                return;
            }
            this.overrideMenu = true;
            Point pt = annotation.getStyledText().toDisplay(e.x, e.y);
            if (e.button == 3) {
                pt = annotation.getStyledText().getDisplay().getCursorLocation();
            }
            annotation.getAnnotationProvider().handleActivate(annotation, pt);
        }
    }

    public void mouseHover(MouseEvent e) {
        if (!this.isDrawingAnnotations) {
            return;
        }
        AnnotationItem annotation = this.getAnnotationAt(e.x, e.y);
        if (annotation == null || !annotation.getAnnotationProvider().hasActivationHandler()) {
            if (annotation == null) {
                this.annotatedText.setToolTipText(null);
            } else {
                this.annotatedText.setToolTipText(annotation.getAnnotationProvider().getToolTip(annotation));
            }
        } else {
            this.annotatedText.setToolTipText(annotation.getAnnotationProvider().getToolTip(annotation));
        }
    }

    public AnnotationItem getAnnotationAt(int x, int y) {
        try {
            int offset = this.annotatedText.getOffsetAtLocation(new Point(x, y));
            return this.getAnnotationAtOffset(offset);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public AnnotationItem getAnnotationAtOffset(int offset) {
        SortedSet<Integer> possibleAnnotations = this.annotations.tailSet(new Integer(offset));
        if (possibleAnnotations.size() == 0) {
            return null;
        }
        AnnotationItem annotation = (AnnotationItem)((Object)possibleAnnotations.first());
        if (annotation.getBeginIndex() <= offset && annotation.getEndIndex() >= offset) {
            return annotation;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void modifyText(ExtendedModifyEvent event) {
        if (!this.modifyEnabled) {
            return;
        }
        Object object = this.paintModifyLock;
        synchronized (object) {
            if (!this.isDrawingAnnotations) {
                return;
            }
            String textValue = this.annotatedText.getText();
            this.handleModifyText(event.start, event.start + event.length, event.length - event.replacedText.length(), event.replacedText, textValue);
        }
    }

    public static boolean overlapsRange(int start, int length, int beginIndex, int endIndex) {
        if (beginIndex == endIndex) {
            return false;
        }
        return endIndex > start && beginIndex <= start || beginIndex < start + length && endIndex >= start + length || beginIndex >= start && endIndex <= start + length;
    }

    protected void handleModifyText(int start, int end, int shiftRight, String replaceText, String textValue) {
        try {
            int rhsPos;
            int lhsPos;
            if (this.annotatedText.isDisposed()) {
                return;
            }
            if (textValue.length() == 0) {
                this.lastAnnotated = 0;
                this.annotatedText.setStyleRanges(new StyleRange[0]);
                Iterator annotationIter = this.annotations.iterator();
                while (annotationIter.hasNext()) {
                    AnnotationItem annotation = (AnnotationItem)annotationIter.next();
                    if (!(annotation.getStyle() instanceof ImageStyleRange)) continue;
                    ImageStyleRange rr = (ImageStyleRange)annotation.getStyle();
                    if (rr.runnable == null) continue;
                    rr.runnable.cancel();
                    AnimatedGifTimer.cancelTask((Widget)this.annotatedText, (TimerTask)rr.runnable);
                }
                AnimatedGifTimer.remove((Widget)this.annotatedText);
                this.annotations.clear();
                return;
            }
            int originalStart = start;
            int replaceLength = replaceText.length();
            boolean refreshLeft = false;
            boolean refreshRight = false;
            if (start == end) {
                lhsPos = end - 1;
                rhsPos = end;
                if (lhsPos >= 0 && !Character.isWhitespace(textValue.charAt(lhsPos)) && rhsPos < textValue.length() && !Character.isWhitespace(textValue.charAt(rhsPos))) {
                    refreshRight = true;
                    refreshLeft = true;
                } else if (replaceText.length() != 0) {
                    if (!Character.isWhitespace(replaceText.charAt(0))) {
                        refreshLeft = true;
                    }
                    if (!Character.isWhitespace(replaceText.charAt(replaceLength - 1))) {
                        refreshRight = true;
                    }
                }
                if (replaceText.length() > 0 && Character.isWhitespace(replaceText.charAt(0)) && !Character.isWhitespace(textValue.charAt(end - 1))) {
                    refreshLeft = true;
                    refreshRight = true;
                }
            } else {
                boolean validRhsPos;
                lhsPos = start - 1;
                rhsPos = end;
                boolean validLhsPos = lhsPos >= 0 && lhsPos + 1 < textValue.length();
                boolean bl = validRhsPos = rhsPos < textValue.length() && rhsPos - 1 >= 0;
                if (validLhsPos && validRhsPos && !Character.isWhitespace(textValue.charAt(lhsPos)) && !Character.isWhitespace(textValue.charAt(rhsPos)) && (Character.isWhitespace(textValue.charAt(lhsPos + 1)) || Character.isWhitespace(textValue.charAt(rhsPos - 1)))) {
                    refreshRight = true;
                    refreshLeft = true;
                } else {
                    if (validLhsPos && !Character.isWhitespace(textValue.charAt(lhsPos)) && !Character.isWhitespace(textValue.charAt(lhsPos + 1))) {
                        refreshLeft = true;
                    }
                    if (validRhsPos && !Character.isWhitespace(textValue.charAt(rhsPos)) && !Character.isWhitespace(textValue.charAt(rhsPos - 1))) {
                        refreshRight = true;
                    }
                }
                if (Character.isWhitespace(textValue.charAt(end - 1)) && !Character.isWhitespace(textValue.charAt(end - 2))) {
                    refreshLeft = true;
                    refreshRight = true;
                }
            }
            if (start >= this.annotatedText.getTopIndex() && refreshLeft) {
                int oldStart = start;
                while (start > 0 && !Character.isWhitespace(textValue.charAt(--start))) {
                }
                if (this.getAnnotationAtOffset(start) != null) {
                    start = oldStart;
                }
            }
            if (end >= this.annotatedText.getTopIndex() && refreshRight) {
                while (end < textValue.length() && !Character.isWhitespace(textValue.charAt(end++))) {
                }
            }
            Iterator annotationIter = this.annotations.iterator();
            int startOfLastDeletedStyle = 0;
            while (annotationIter.hasNext()) {
                AnnotationItem annotation = (AnnotationItem)annotationIter.next();
                if (replaceLength != 0 && annotation.overlapsRange(originalStart, originalStart + replaceLength)) {
                    if (annotation.getStyle() instanceof ImageStyleRange) {
                        ImageStyleRange rr = (ImageStyleRange)annotation.getStyle();
                        if (rr.runnable != null) {
                            rr.runnable.cancel();
                            AnimatedGifTimer.cancelTask((Widget)this.annotatedText, (TimerTask)rr.runnable);
                        }
                    }
                    if (startOfLastDeletedStyle == 0 || annotation.getBeginIndex() < startOfLastDeletedStyle) {
                        startOfLastDeletedStyle = annotation.getBeginIndex();
                    }
                    annotation.removeStyle();
                    annotationIter.remove();
                    continue;
                }
                if (annotation.beginsAfter(start)) {
                    annotation.updateOffset(shiftRight, textValue.length());
                }
                if (!annotation.overlapsRange(start, end) && !annotation.endsAfter(textValue.length())) continue;
                if (annotation.getStyle() instanceof ImageStyleRange) {
                    ImageStyleRange rr = (ImageStyleRange)annotation.getStyle();
                    if (rr.runnable != null) {
                        rr.runnable.cancel();
                        AnimatedGifTimer.cancelTask((Widget)this.annotatedText, (TimerTask)rr.runnable);
                    }
                    String text = rr.plainText;
                    int replStart = rr.start;
                    int replLength = rr.length;
                    if (startOfLastDeletedStyle == 0 || annotation.getBeginIndex() < startOfLastDeletedStyle) {
                        startOfLastDeletedStyle = annotation.getBeginIndex();
                    }
                    annotation.removeStyle();
                    annotationIter.remove();
                    this.isKeepStyle = true;
                    this.annotatedText.replaceTextRange(replStart, replLength, text);
                    return;
                }
                if (startOfLastDeletedStyle == 0 || annotation.getBeginIndex() < startOfLastDeletedStyle) {
                    startOfLastDeletedStyle = annotation.getBeginIndex();
                }
                annotation.removeStyle();
                annotationIter.remove();
            }
            if (startOfLastDeletedStyle != 0) {
                this.lastAnnotated = startOfLastDeletedStyle;
            }
            int tokenBegin = -1;
            int startAnnotate = start < this.lastAnnotated ? start : this.lastAnnotated;
            int lastlyAnnotated = this.lastAnnotated;
            int i = startAnnotate;
            while (i <= end) {
                if (i == end || Character.isWhitespace(textValue.charAt(i))) {
                    if (tokenBegin != -1 || i == end) {
                        if (tokenBegin == -1) {
                            int lastspace = end;
                            while (lastspace > 0 && !Character.isWhitespace(textValue.charAt(--lastspace))) {
                            }
                            tokenBegin = lastspace + 1;
                        }
                        AnnotationItem annotationItem = new AnnotationItem(this.annotatedText, textValue.substring(tokenBegin, i), tokenBegin, i);
                        int endStartIndex = annotationItem.getEndIndex();
                        if (this.annotationProviderManager.canAnnotate(textValue.charAt(end - 1), annotationItem, this.isRichTextEnabled)) {
                            this.annotations.add(annotationItem);
                            this.isKeepStyle = true;
                            if (annotationItem.getEndIndex() != endStartIndex) {
                                textValue = String.valueOf(textValue.substring(0, tokenBegin)) + annotationItem.getAnnotatedText() + textValue.substring(i);
                                end -= endStartIndex - annotationItem.getEndIndex();
                                i -= endStartIndex - annotationItem.getEndIndex();
                            }
                            if (Character.isWhitespace(textValue.charAt(end - 1))) {
                                lastlyAnnotated = end;
                            }
                        }
                        tokenBegin = -1;
                    }
                } else if (tokenBegin == -1) {
                    tokenBegin = i;
                }
                ++i;
            }
            AnnotationItem annotationItem = new AnnotationItem(this.annotatedText, textValue, 0, end);
            if (this.annotationProviderManager.canAnnotateMultipleWords(annotationItem, this.isRichTextEnabled)) {
                this.annotations.add(annotationItem);
                lastlyAnnotated = end;
            }
            this.annotatedText.redraw();
            this.lastAnnotated = lastlyAnnotated;
        }
        catch (Throwable throwable) {}
    }

    public void paintControl(PaintEvent e) {
        if (this.timer != null) {
            this.timer.cancel();
        }
        int x = 0;
        if (!this.isDrawingAnnotations) {
            return;
        }
        if (this.annotatedText.isDisposed() || e.gc == null) {
            return;
        }
        Iterator annotationIter = this.annotations.iterator();
        while (annotationIter.hasNext()) {
            ++x;
            AnnotationItem annotation = (AnnotationItem)annotationIter.next();
            try {
                ImageStyleRange isr;
                int topoffset = this.annotatedText.getOffsetAtLocation(new Point(0, 0));
                Rectangle clientArea = this.annotatedText.getClientArea();
                int end = this.annotatedText.getText().length();
                try {
                    end = this.annotatedText.getOffsetAtLocation(new Point(clientArea.width, clientArea.height));
                }
                catch (Throwable throwable) {}
                if (annotation.getBeginIndex() >= topoffset && annotation.getEndIndex() <= end) {
                    if (annotation.getStyle() instanceof ImageStyleRange) {
                        isr = (ImageStyleRange)annotation.getStyle();
                        if (isr.runnable != null) {
                            isr.runnable.isVisible = clientArea.contains(this.annotatedText.getLocationAtOffset(isr.start));
                        }
                    }
                    annotation.drawAnnotations(e.gc);
                    continue;
                }
                if (!(annotation.getStyle() instanceof ImageStyleRange)) continue;
                isr = (ImageStyleRange)annotation.getStyle();
                if (isr.runnable == null) continue;
                if (clientArea.contains(this.annotatedText.getLocationAtOffset(isr.start))) {
                    isr.runnable.isVisible = true;
                    continue;
                }
                isr.runnable.isVisible = false;
            }
            catch (Throwable throwable) {}
        }
    }

    protected void setIsDrawingAnnotations(boolean isDrawing) {
        this.isDrawingAnnotations = isDrawing;
        if (isDrawing) {
            this.lastAnnotated = 0;
            this.annotationProviderManager.forceRefresh = true;
            UIJob job = new UIJob("setAnnotations"){

                public IStatus runInUIThread(IProgressMonitor arg0) {
                    String text = AnnotationManager.this.annotatedText.getText();
                    int charCount = AnnotationManager.this.annotatedText.getCharCount();
                    if (text.length() != 0 && text.charAt(text.length() - 1) != ' ') {
                        text = String.valueOf(text) + " ";
                        ++charCount;
                    }
                    AnnotationManager.this.handleModifyText(0, charCount, 0, text, text);
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule(1000L);
            this.annotationProviderManager.forceRefresh = false;
        } else {
            this.annotations.clear();
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    AnnotationManager.this.annotatedText.redraw();
                }
            });
        }
    }

    protected void removeAnnotationsLike(IAnnotationProperties annotation) {
        boolean hasRemoved = false;
        Iterator annotationIter = this.annotations.iterator();
        while (annotationIter.hasNext()) {
            AnnotationItem curAnnotation = (AnnotationItem)annotationIter.next();
            if (curAnnotation.getAnnotationProvider().getClass() != annotation.getAnnotationProvider().getClass() || !curAnnotation.getModifiedAnnotatedText().equals(annotation.getModifiedAnnotatedText())) continue;
            annotationIter.remove();
            hasRemoved = true;
        }
        if (hasRemoved) {
            this.handleModifyText(0, this.annotatedText.getCharCount(), 0, "", this.annotatedText.getText());
        }
    }

    public void disableModify() {
        this.modifyEnabled = false;
    }

    public void enableModify() {
        this.modifyEnabled = true;
    }

    public void insertAnnotation(Class providerClass, String text, AnnotatedRange range) {
        AnnotationItem annotation;
        int offset = this.annotatedText.getCaretOffset();
        if (this.annotatedText.getSelectionText() != null && this.annotatedText.getSelectionText().length() > 0) {
            offset = this.annotatedText.getSelectionRange().x;
        }
        if ((annotation = this.getAnnotationAtOffset(offset)) != null) {
            this.replaceAnnotation(providerClass, annotation, text, range);
            this.isKeepStyle = true;
            return;
        }
        int length = text.length();
        this.annotatedText.insert(text);
        this.annotatedText.setCaretOffset(offset);
        range.start = offset;
        range.length = length;
        AnnotationItem annotationItem = new AnnotationItem(this.annotatedText, text, range.start, range.start + range.length);
        if (this.annotationProviderManager.insertAnnotation(providerClass, annotationItem, text, range, this.isRichTextEnabled)) {
            this.isKeepStyle = true;
            this.annotations.add(annotationItem);
            this.annotatedText.redraw();
        }
    }

    public void replaceAnnotation(Class providerClass, IAnnotationProperties annotation, String text, AnnotatedRange range) {
        StyleRange existingRange = annotation.getStyle();
        int offset = this.annotatedText.getCaretOffset();
        if (existingRange != null) {
            int start = existingRange.start;
            int length = existingRange.length;
            if (existingRange instanceof AnnotatedRange) {
                ((AnnotatedRange)existingRange).replacementText = range.replacementText;
            }
            this.annotatedText.setStyleRanges(start, length, new int[]{start, length}, new StyleRange[]{existingRange});
            this.annotatedText.setSelectionRange(start, length);
            this.annotatedText.setStyleRanges(start, length, new int[]{start, length}, null);
            offset = start;
        }
        int length = text.length();
        this.annotatedText.insert(text);
        this.annotatedText.setCaretOffset(offset + length);
        range.start = offset;
        range.length = length;
        this.removeAnnotationsLike(annotation);
        AnnotationItem annotationItem = new AnnotationItem(this.annotatedText, text, range.start, range.start + range.length);
        if (this.annotationProviderManager.insertAnnotation(providerClass, annotationItem, text, range, this.isRichTextEnabled)) {
            this.annotations.add(annotationItem);
            this.annotatedText.redraw();
        }
    }

    public void verifyKey(VerifyEvent event) {
        if ((event.stateMask & 0x20000) != 0 && event.keyCode == 0x1000013) {
            Event ev = new Event();
            ev.widget = event.widget;
            ev.button = 10;
            try {
                Point pt = this.annotatedText.getLocationAtOffset(this.annotatedText.getCaretOffset());
                ev.x = pt.x;
                ev.y = pt.y;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            MouseEvent mev = new MouseEvent(ev);
            this.mouseDown(mev);
            this.menuDetectListener.handleEvent(ev);
        }
    }

    public Menu getContextMenu() {
        if (this.editMenu != null) {
            return this.editMenu.getMenu();
        }
        return null;
    }

    public boolean getIsKeepStyle() {
        return this.isKeepStyle;
    }

    public void setIsKeepStyle(boolean value) {
        this.isKeepStyle = value;
    }

    protected boolean isRichTextEnabled() {
        return this.isRichTextEnabled;
    }

    public boolean hasAnnotations() {
        StyleRange[] ranges = this.annotatedText.getStyleRanges();
        return ranges != null && ranges.length > 0;
    }

    private class AnnotationPositionComparator
    implements Comparator {
        private AnnotationPositionComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof Integer) && !(o1 instanceof AnnotationItem) || !(o2 instanceof Integer) && !(o2 instanceof AnnotationItem)) {
                throw new IllegalArgumentException(Errors.wrong_type_to_compare);
            }
            int o1End = o1 instanceof Integer ? ((Integer)o1).intValue() : ((AnnotationItem)o1).getEndIndex();
            int o2End = o2 instanceof Integer ? ((Integer)o2).intValue() : ((AnnotationItem)o2).getEndIndex();
            return o1End - o2End;
        }

        public boolean equals(Object obj) {
            return obj instanceof AnnotationPositionComparator;
        }
    }
}

