/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.annotate;

import com.ibm.collaboration.realtime.annotate.AnnotatedRange;
import com.ibm.collaboration.realtime.annotate.AnnotationManager;
import com.ibm.collaboration.realtime.annotate.AnnotationProvider;
import com.ibm.collaboration.realtime.annotate.IAnnotationDrawer;
import com.ibm.collaboration.realtime.annotate.IAnnotationProperties;
import com.ibm.collaboration.realtime.annotate.ImageStyleRange;
import com.ibm.collaboration.realtime.ui.util.AnimatedGifTimer;
import java.util.TimerTask;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Widget;

public class AnnotationItem
implements IAnnotationProperties {
    private AnnotationProvider annotationProvider = null;
    private IAnnotationDrawer annotationDrawer = null;
    private final StyledText annotationOwner;
    private String annotatedText;
    private int beginIndex;
    private int endIndex;
    private int shiftBegin;
    private int shiftEnd;
    private boolean hasDrawn;
    private boolean hasSetStyle;
    private Color styleForeground;
    private Color styleBackground;
    private int styleFont;
    private long displayAfter = 0L;
    private StyleRange range;
    private Object annotationProviderProperties;

    public AnnotationItem(StyledText annotationOwner, String annotatedText, int beginIndex, int endIndex) {
        this.annotationOwner = annotationOwner;
        this.annotatedText = annotatedText;
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        this.shiftBegin = 0;
        this.shiftEnd = 0;
        this.hasDrawn = false;
        this.hasSetStyle = false;
        this.annotationProviderProperties = null;
        this.displayAfter = System.currentTimeMillis();
    }

    public boolean overlapsRange(int beginIndex, int endIndex) {
        if (beginIndex == endIndex) {
            return false;
        }
        return endIndex > this.beginIndex && beginIndex <= this.beginIndex || beginIndex < this.endIndex && endIndex >= this.endIndex || beginIndex >= this.beginIndex && endIndex <= this.endIndex;
    }

    public void drawAnnotations(GC gc) {
        this.hasDrawn = true;
        if (this.annotationDrawer == null || this.displayAfter != 0L && System.currentTimeMillis() < this.displayAfter) {
            return;
        }
        if (this.endIndex > this.annotationOwner.getCharCount() || this.beginIndex > this.annotationOwner.getCharCount()) {
            return;
        }
        Point begin = this.annotationOwner.getLocationAtOffset(this.beginIndex + this.shiftBegin);
        Point end = this.annotationOwner.getLocationAtOffset(this.endIndex - this.shiftEnd);
        StyleRange styleRange = this.annotationOwner.getStyleRangeAtOffset(this.beginIndex + this.shiftBegin);
        if (styleRange instanceof ImageStyleRange) {
            return;
        }
        int yOff = Math.min(Math.max(this.annotationOwner.getBaseline(this.beginIndex + this.shiftBegin) + 1, this.annotationOwner.getBaseline() + 1), this.annotationOwner.getLineHeight(this.beginIndex + this.shiftBegin));
        if (end.y < -this.annotationOwner.getLineHeight(this.beginIndex + this.shiftBegin) || begin.y - this.annotationOwner.getLineHeight(this.beginIndex + this.shiftBegin) > this.annotationOwner.getSize().y) {
            return;
        }
        if (begin.y != end.y && begin.x != 0) {
            begin = new Point(0, begin.y + this.annotationOwner.getLineHeight(this.beginIndex + this.shiftBegin));
        }
        while (begin.y < end.y) {
            this.annotationProvider.drawAnnotation(this, gc, new Rectangle(begin.x, begin.y + yOff, this.annotationOwner.getSize().x - begin.x, begin.y + yOff));
            begin = new Point(0, begin.y + this.annotationOwner.getLineHeight(this.beginIndex + this.shiftBegin));
        }
        this.annotationProvider.drawAnnotation(this, gc, new Rectangle(begin.x, begin.y + yOff, end.x - begin.x, begin.y + yOff));
    }

    public void updateOffset(int shiftRight, int maxIndex) {
        this.beginIndex += shiftRight;
        this.endIndex += shiftRight;
    }

    public void setOffsetModifier(int shiftBegin, int shiftEnd) {
        this.shiftBegin = shiftBegin;
        this.shiftEnd = shiftEnd;
    }

    public void addStyle() {
        if (this.displayAfter != 0L && System.currentTimeMillis() < this.displayAfter || this.endIndex > this.annotationOwner.getCharCount()) {
            return;
        }
        if (this.hasSetStyle) {
            if (this.range != null) {
                this.addStyle(this.range);
            } else {
                AnnotatedRange arange;
                if (this.styleFont != -1) {
                    arange = new AnnotatedRange(this.beginIndex + this.shiftBegin, this.annotatedText.length() - (this.shiftBegin + this.shiftEnd), this.styleForeground, this.styleBackground, this.styleFont);
                    this.annotationOwner.setStyleRange((StyleRange)arange);
                } else {
                    arange = new AnnotatedRange(this.beginIndex + this.shiftBegin, this.annotatedText.length() - (this.shiftBegin + this.shiftEnd), this.styleForeground, this.styleBackground);
                    this.annotationOwner.setStyleRange((StyleRange)arange);
                }
                boolean keepOldStyle = true;
                if (arange.font != null || arange.background != null || arange.foreground != null || arange.fontStyle != 0 || arange.strikeout || arange.underline) {
                    keepOldStyle = false;
                }
                AnnotationManager.getAnnotationManager(this.annotationOwner).setIsKeepStyle(keepOldStyle);
            }
        }
    }

    public void removeStyle() {
        if (this.displayAfter != 0L && System.currentTimeMillis() < this.displayAfter || this.endIndex > this.annotationOwner.getCharCount()) {
            return;
        }
        if (this.getStyle() != null) {
            AnnotatedRange range = new AnnotatedRange();
            range.start = this.getStyle().start;
            range.length = this.getStyle().length;
            range.fontStyle = 0;
            range.background = null;
            range.foreground = null;
            range.underline = false;
            this.annotationOwner.setStyleRange((StyleRange)range);
        }
    }

    public void addStyle(StyleRange sr) {
        if (this.displayAfter != 0L && System.currentTimeMillis() < this.displayAfter || this.endIndex > this.annotationOwner.getCharCount()) {
            return;
        }
        if (this.hasSetStyle) {
            this.range = (AnnotatedRange)((Object)sr.clone());
            this.range.background = sr.background;
            this.range.foreground = sr.foreground;
            this.range.fontStyle = sr.fontStyle;
            this.range.start = this.beginIndex + this.shiftBegin;
            if (this.annotatedText.indexOf(32) > -1) {
                this.range.length = sr.length;
                this.range.start = sr.start;
            } else {
                this.range.length = this.annotatedText.length() - (this.shiftBegin + this.shiftEnd);
                if (this.range.length < 0) {
                    this.range.length = sr.length;
                }
            }
            this.range.underline = sr.underline;
            if (sr.metrics != null) {
                this.range.metrics = sr.metrics;
                this.range.length = 1;
            }
            StyleRange[] oldRanges = this.annotationOwner.getStyleRanges(true);
            boolean replaced = false;
            if (oldRanges != null) {
                int i = 0;
                while (i < oldRanges.length) {
                    if (oldRanges[i] instanceof AnnotatedRange && oldRanges[i].start == this.range.start) {
                        this.annotationOwner.setStyleRanges(oldRanges[i].start, oldRanges[i].length, new int[]{this.range.start, this.range.length}, new StyleRange[]{this.range});
                        replaced = true;
                    }
                    ++i;
                }
            }
            if (!replaced) {
                this.annotationOwner.setStyleRanges(this.range.start, this.range.length, new int[]{this.range.start, this.range.length}, new StyleRange[]{this.range});
            }
            boolean keepOldStyle = true;
            if (this.range.font != null || this.range.background != null || this.range.foreground != null || this.range.fontStyle != 0 || this.range.strikeout || this.range.underline) {
                keepOldStyle = false;
            }
            AnnotationManager.getAnnotationManager(this.annotationOwner).setIsKeepStyle(keepOldStyle);
        }
    }

    public boolean beginsAfter(int index) {
        return this.beginIndex >= index;
    }

    public boolean endsAfter(int index) {
        return this.endIndex > index;
    }

    public AnnotationProvider getAnnotationProvider() {
        return this.annotationProvider;
    }

    public boolean hasDrawn() {
        return this.hasDrawn;
    }

    public boolean hasAnnotationDrawer() {
        return this.annotationDrawer != null;
    }

    public String getAnnotatedText() {
        return this.annotatedText;
    }

    public String getModifiedAnnotatedText() {
        return this.annotatedText.substring(this.shiftBegin, this.annotatedText.length() - this.shiftEnd);
    }

    public int getBeginIndex() {
        return this.beginIndex;
    }

    public int getModifiedBeginIndex() {
        return this.beginIndex + this.shiftBegin;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public int getModifiedEndIndex() {
        return this.endIndex - this.shiftEnd;
    }

    public StyledText getStyledText() {
        return this.annotationOwner;
    }

    public IAnnotationDrawer getAnnotationDrawer() {
        return this.annotationDrawer;
    }

    public Object getAnnotationProviderProperties() {
        return this.annotationProviderProperties;
    }

    public Object getAnnotationOwner() {
        return this.annotationOwner;
    }

    public void registerAnnotationProvider(AnnotationProvider annotationProvider, IAnnotationDrawer annotationDrawer, Object annotationProviderProperties) {
        this.registerAnnotationProvider(annotationProvider, annotationDrawer, null, null, 0, annotationProviderProperties);
    }

    public void registerAnnotationProvider(AnnotationProvider annotationProvider, Color foreground, Color background, int fontStyle, Object annotationProviderProperties) {
        this.registerAnnotationProvider(annotationProvider, null, foreground, background, fontStyle, annotationProviderProperties);
    }

    public void registerAnnotationProvider(AnnotationProvider annotationProvider, IAnnotationDrawer annotationDrawer, Color foreground, Color background, int fontStyle, Object annotationProviderProperties) {
        this.annotationProvider = annotationProvider;
        this.annotationProviderProperties = annotationProviderProperties;
        this.annotationDrawer = annotationDrawer;
    }

    public void registerAnnotationProvider(AnnotationProvider annotationProvider, StyleRange range, Object annotationProviderProperties) {
        this.annotationProvider = annotationProvider;
        this.annotationProviderProperties = annotationProviderProperties;
        this.hasSetStyle = true;
        this.addStyle(range);
    }

    public void setStyle(Color foreground, Color background) {
        this.setStyle(foreground, background, -1);
    }

    public void removeStyle(int start, int length) {
        StyleRange[] ranges = this.annotationOwner.getStyleRanges(start, length, true);
        if (ranges != null) {
            int i = 0;
            while (i < ranges.length) {
                if (ranges[i] instanceof AnnotatedRange) {
                    if (ranges[i] instanceof ImageStyleRange) {
                        ImageStyleRange rr = (ImageStyleRange)ranges[i];
                        if (rr.runnable != null) {
                            rr.runnable.cancel();
                            AnimatedGifTimer.cancelTask((Widget)this.annotationOwner, (TimerTask)rr.runnable);
                        }
                    }
                    AnnotatedRange range = new AnnotatedRange();
                    range.start = ranges[i].start;
                    range.length = ranges[i].length;
                    range.fontStyle = 0;
                    range.background = null;
                    range.foreground = null;
                    range.underline = false;
                    this.annotationOwner.setStyleRange((StyleRange)range);
                }
                ++i;
            }
        }
    }

    public void setStyle(Color foreground, Color background, int font) {
        this.styleForeground = foreground;
        this.styleBackground = background;
        this.styleFont = font;
        this.hasSetStyle = true;
        this.addStyle();
    }

    public void setDisplayAfter(long displayAfter) {
        this.displayAfter = displayAfter == 0L ? System.currentTimeMillis() : displayAfter;
    }

    public long getDisplayAfter() {
        return this.displayAfter;
    }

    public void registerAnnotationProvider(AnnotationProvider annotationProvider, StyleRange range, Object obj, String textToDisplay) throws IllegalArgumentException {
        try {
            if (textToDisplay != null) {
                AnnotationManager.getAnnotationManager(this.getStyledText()).disableModify();
                if (annotationProvider.canAnnotateMultipleWords()) {
                    int begin = this.getModifiedBeginIndex();
                    this.getModifiedEndIndex();
                    this.getStyledText().replaceTextRange(begin, range.length, textToDisplay);
                } else {
                    this.getStyledText().replaceTextRange(this.getBeginIndex(), this.getAnnotatedText().length(), textToDisplay);
                }
                AnnotationManager.getAnnotationManager(this.getStyledText()).enableModify();
                this.annotatedText = textToDisplay;
                if (annotationProvider.canAnnotateMultipleWords()) {
                    this.endIndex = this.getModifiedBeginIndex() + textToDisplay.length();
                    range.start = this.getModifiedBeginIndex();
                    range.length = this.annotatedText.length();
                } else {
                    this.endIndex = this.getBeginIndex() + textToDisplay.length();
                }
            }
            this.registerAnnotationProvider(annotationProvider, range, (Object)this);
        }
        catch (IllegalArgumentException ex) {
            AnnotationManager.getAnnotationManager(this.getStyledText()).enableModify();
            throw ex;
        }
    }

    public StyleRange getStyle() {
        return this.range;
    }

    public boolean isReadOnly() {
        return (this.annotationOwner.getStyle() & 8) != 0;
    }
}

