/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.repository;

import com.ibm.team.collaboration.internal.repository.SametimeRepositoryPlugin;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public final class TeamRepositoryService {
    private static URI[] fRepositories;

    public static synchronized URI[] getTeamRepositories() {
        if (fRepositories == null) {
            TeamRepositoryService.initializeService();
        }
        return fRepositories;
    }

    private static void initializeService() {
        SametimeRepositoryPlugin.getInstance().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                TeamRepositoryService.readConnectionInfo();
            }
        });
        TeamRepositoryService.readConnectionInfo();
    }

    static void readConnectionInfo() {
        IPreferenceStore store = SametimeRepositoryPlugin.getInstance().getPreferenceStore();
        String preference = store.getString("com.ibm.team.collaboration.repository.teamRepositories");
        if (preference.equals("")) {
            fRepositories = new URI[0];
            return;
        }
        String[] strings = preference.split(",");
        ArrayList<URI> repositories = new ArrayList<URI>();
        int index = 0;
        while (index < strings.length) {
            try {
                repositories.add(new URI(strings[index]));
            }
            catch (URISyntaxException exception) {
                SametimeRepositoryPlugin.getInstance().log(exception);
            }
            ++index;
        }
        fRepositories = repositories.toArray(new URI[repositories.size()]);
    }

    private TeamRepositoryService() {
    }
}

