/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.repository;

import com.ibm.team.collaboration.internal.repository.RepositoryMessages;
import com.ibm.team.collaboration.internal.repository.RepositoryPreferenceDialog;
import com.ibm.team.collaboration.internal.repository.SametimeRepositoryPlugin;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public final class RepositoryPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button fAddButton;
    private Button fDownButton;
    private Button fEditButton;
    org.eclipse.swt.widgets.List fLocationList;
    private Button fRemoveButton;
    final List fRepositoryURIs = new ArrayList();
    private Button fUpButton;

    public RepositoryPreferencePage() {
        this.setPreferenceStore(SametimeRepositoryPlugin.getInstance().getPreferenceStore());
        this.setDescription(RepositoryMessages.RepositoryPreferencePage_0);
    }

    private GridData createButtonGridData() {
        GridData data = new GridData(4, 4, false, false);
        data.widthHint = this.convertHorizontalDLUsToPixels(61);
        return data;
    }

    protected Control createContents(Composite parent) {
        Assert.isNotNull((Object)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(RepositoryMessages.RepositoryPreferencePage_3);
        group.setLayout((Layout)new GridLayout(2, false));
        this.fLocationList = new org.eclipse.swt.widgets.List((Composite)group, 2816);
        GridData data = new GridData(4, 4, true, true);
        this.fLocationList.setLayoutData((Object)data);
        this.fLocationList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositoryPreferencePage.this.handleSettingsChanged();
            }
        });
        Iterator iterator = this.fRepositoryURIs.iterator();
        while (iterator.hasNext()) {
            this.fLocationList.add(((URI)iterator.next()).toString());
        }
        GridLayout buttonLayout = layout;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginHeight = 0;
        Composite buttonComposite = new Composite((Composite)group, 0);
        buttonComposite.setLayoutData((Object)this.createButtonGridData());
        buttonComposite.setLayout((Layout)buttonLayout);
        this.fAddButton = new Button(buttonComposite, 8);
        this.fAddButton.setText(RepositoryMessages.RepositoryPreferencePage_4);
        this.fAddButton.setLayoutData((Object)this.createButtonGridData());
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RepositoryPreferenceDialog preferenceDialog = new RepositoryPreferenceDialog(RepositoryPreferencePage.this.getShell());
                if (preferenceDialog.open() != 0) {
                    return;
                }
                URI uri = preferenceDialog.getRepositoryURI();
                RepositoryPreferencePage.this.fRepositoryURIs.add(uri);
                RepositoryPreferencePage.this.fLocationList.add(uri.toString());
                RepositoryPreferencePage.this.fLocationList.setSelection(RepositoryPreferencePage.this.fLocationList.getItemCount() - 1);
                RepositoryPreferencePage.this.handleSettingsChanged();
            }
        });
        this.fEditButton = new Button(buttonComposite, 8);
        this.fEditButton.setText(RepositoryMessages.RepositoryPreferencePage_8);
        this.fEditButton.setLayoutData((Object)this.createButtonGridData());
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = RepositoryPreferencePage.this.fLocationList.getSelectionIndex();
                if (index != -1) {
                    URI uri = (URI)RepositoryPreferencePage.this.fRepositoryURIs.get(index);
                    RepositoryPreferenceDialog preferenceDialog = new RepositoryPreferenceDialog(RepositoryPreferencePage.this.getShell(), uri.toString());
                    if (preferenceDialog.open() != 0) {
                        return;
                    }
                    uri = preferenceDialog.getRepositoryURI();
                    RepositoryPreferencePage.this.fRepositoryURIs.set(index, uri);
                    RepositoryPreferencePage.this.fLocationList.setItem(index, uri.toString());
                    RepositoryPreferencePage.this.handleSettingsChanged();
                }
            }
        });
        this.fRemoveButton = new Button(buttonComposite, 8);
        this.fRemoveButton.setText(RepositoryMessages.RepositoryPreferencePage_5);
        this.fRemoveButton.setLayoutData((Object)this.createButtonGridData());
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = RepositoryPreferencePage.this.fLocationList.getSelectionIndex();
                if (index != -1) {
                    RepositoryPreferencePage.this.fRepositoryURIs.remove(index);
                    RepositoryPreferencePage.this.fLocationList.remove(index);
                    RepositoryPreferencePage.this.handleSettingsChanged();
                }
            }
        });
        Label separator = new Label(buttonComposite, 258);
        separator.setFont(parent.getFont());
        separator.setVisible(false);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        data.verticalIndent = 4;
        separator.setLayoutData((Object)data);
        this.fUpButton = new Button(buttonComposite, 8);
        this.fUpButton.setText(RepositoryMessages.RepositoryPreferencePage_6);
        this.fUpButton.setLayoutData((Object)this.createButtonGridData());
        this.fUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = RepositoryPreferencePage.this.fLocationList.getSelectionIndex();
                if (index > 0) {
                    URI uri = (URI)RepositoryPreferencePage.this.fRepositoryURIs.get(index);
                    RepositoryPreferencePage.this.fRepositoryURIs.set(index, RepositoryPreferencePage.this.fRepositoryURIs.get(index - 1));
                    RepositoryPreferencePage.this.fRepositoryURIs.set(index - 1, uri);
                    String item = RepositoryPreferencePage.this.fLocationList.getItem(index);
                    RepositoryPreferencePage.this.fLocationList.setItem(index, RepositoryPreferencePage.this.fLocationList.getItem(index - 1));
                    RepositoryPreferencePage.this.fLocationList.setItem(index - 1, item);
                    RepositoryPreferencePage.this.fLocationList.setSelection(index - 1);
                    RepositoryPreferencePage.this.handleSettingsChanged();
                }
            }
        });
        this.fDownButton = new Button(buttonComposite, 8);
        this.fDownButton.setText(RepositoryMessages.RepositoryPreferencePage_7);
        this.fDownButton.setLayoutData((Object)this.createButtonGridData());
        this.fDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = RepositoryPreferencePage.this.fLocationList.getSelectionIndex();
                if (index != -1 && index < RepositoryPreferencePage.this.fLocationList.getItemCount() - 1) {
                    URI uri = (URI)RepositoryPreferencePage.this.fRepositoryURIs.get(index);
                    RepositoryPreferencePage.this.fRepositoryURIs.set(index, RepositoryPreferencePage.this.fRepositoryURIs.get(index + 1));
                    RepositoryPreferencePage.this.fRepositoryURIs.set(index + 1, uri);
                    String item = RepositoryPreferencePage.this.fLocationList.getItem(index);
                    RepositoryPreferencePage.this.fLocationList.setItem(index, RepositoryPreferencePage.this.fLocationList.getItem(index + 1));
                    RepositoryPreferencePage.this.fLocationList.setItem(index + 1, item);
                    RepositoryPreferencePage.this.fLocationList.setSelection(index + 1);
                    RepositoryPreferencePage.this.handleSettingsChanged();
                }
            }
        });
        this.handleSettingsChanged();
        return composite;
    }

    void handleSettingsChanged() {
        int index = this.fLocationList.getSelectionIndex();
        if (index == -1) {
            this.fEditButton.setEnabled(false);
            this.fRemoveButton.setEnabled(false);
            this.fUpButton.setEnabled(false);
            this.fDownButton.setEnabled(false);
        } else {
            this.fEditButton.setEnabled(true);
            this.fRemoveButton.setEnabled(true);
            this.fUpButton.setEnabled(index > 0);
            this.fDownButton.setEnabled(index < this.fLocationList.getItemCount() - 1);
        }
    }

    public void init(IWorkbench workbench) {
        String preference = this.getPreferenceStore().getString("com.ibm.team.collaboration.repository.teamRepositories");
        if (preference.equals("")) {
            return;
        }
        String[] strings = preference.split(",");
        int index = 0;
        while (index < strings.length) {
            try {
                this.fRepositoryURIs.add(new URI(strings[index]));
            }
            catch (URISyntaxException uRISyntaxException) {}
            ++index;
        }
    }

    public boolean performOk() {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        Iterator iterator = this.fRepositoryURIs.iterator();
        while (iterator.hasNext()) {
            URI uri = (URI)iterator.next();
            if (!first) {
                buffer.append(',');
            } else {
                first = false;
            }
            buffer.append(uri.toString());
        }
        this.getPreferenceStore().setValue("com.ibm.team.collaboration.repository.teamRepositories", buffer.toString());
        return super.performOk();
    }
}

