/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.repository;

import com.ibm.team.collaboration.internal.repository.RepositoryMessages;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class RepositoryPreferenceDialog
extends StatusDialog {
    private boolean fAddNew = false;
    private String fLocation;
    private Text fLocationField;
    private boolean fLocationSet = false;

    public RepositoryPreferenceDialog(Shell shell) {
        this(shell, "");
        this.fAddNew = true;
    }

    public RepositoryPreferenceDialog(Shell shell, String uri) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        Assert.isNotNull((Object)uri);
        this.fLocation = uri;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.fAddNew) {
            shell.setText(RepositoryMessages.RepositoryConnectionDialog_0);
        } else {
            shell.setText(RepositoryMessages.RepositoryConnectionDialog_17);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Assert.isNotNull((Object)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setText(RepositoryMessages.RepositoryConnectionDialog_2);
        group.setLayout((Layout)this.createGroupLayout());
        Label label = new Label((Composite)group, 0);
        label.setText(RepositoryMessages.RepositoryConnectionDialog_3);
        label.setLayoutData((Object)this.createLabelLayoutData());
        this.fLocationField = new Text((Composite)group, 2048);
        this.fLocationField.setLayoutData((Object)this.createTextLayoutData());
        this.fLocationField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String trimmed = RepositoryPreferenceDialog.this.fLocationField.getText().trim();
                RepositoryPreferenceDialog.this.fLocation = trimmed.endsWith("/") ? trimmed.substring(0, trimmed.length() - 1) : trimmed;
                RepositoryPreferenceDialog.this.fLocationSet = true;
                RepositoryPreferenceDialog.this.handleSettingsChanged();
            }
        });
        this.fLocationField.setText(this.fLocation);
        this.fLocationSet = !"".equals(this.fLocation);
        this.handleSettingsChanged();
        return composite;
    }

    private GridLayout createGroupLayout() {
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        return layout;
    }

    private GridData createLabelLayoutData() {
        return new GridData(4, 0x1000000, false, false);
    }

    private GridData createTextLayoutData() {
        GridData data = new GridData(4, 4, true, false);
        data.widthHint = this.convertWidthInCharsToPixels(50);
        return data;
    }

    public URI getRepositoryURI() {
        try {
            return new URI(this.fLocation);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    void handleSettingsChanged() {
        try {
            if (this.fLocationSet) {
                new URI(this.fLocation);
                if ("".equals(this.fLocation)) {
                    this.updateStatus((IStatus)new Status(4, "com.ibm.team.collaboration.repository", 1, RepositoryMessages.RepositoryConnectionDialog_10, null));
                } else if (!this.fLocation.startsWith("http://") && !this.fLocation.startsWith("https://")) {
                    this.updateStatus((IStatus)new Status(4, "com.ibm.team.collaboration.repository", 1, RepositoryMessages.RepositoryConnectionDialog_12, null));
                } else {
                    this.updateStatus(Status.OK_STATUS);
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            this.updateStatus((IStatus)new Status(4, "com.ibm.team.collaboration.repository", 1, RepositoryMessages.RepositoryConnectionDialog_9, null));
        }
    }

    protected void updateButtonsEnableState(IStatus status) {
        Button button = this.getButton(0);
        if (button != null && !button.isDisposed()) {
            button.setEnabled(this.fLocationSet && !status.matches(4));
        }
    }
}

