/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rcp.swt.custom;

import com.ibm.collaboration.realtime.ui.strings.Messages;
import com.ibm.collaboration.realtime.ui.util.ColorCache;
import com.ibm.collaboration.realtime.ui.util.SwtUtils;
import com.ibm.rcp.swt.custom.CollapseComposite;
import com.ibm.rcp.swt.custom.CollapseableArea;
import com.ibm.rcp.swt.custom.CollapseableSashForm;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class GrabbyBar
extends Canvas {
    private static int ARROW_HEIGHT = 12;
    private static int ARROW_WIDTH = 6;
    private static int GRIPPER_WIDTH = 6;
    private static int GRIPPER_HEIGHT = 74;
    public static int SIZE = 6;
    private final Display display;
    private final CollapseComposite collapseable;
    private Color gradientBeginColor;
    private Color gradientEndColor;
    private int direction = 16384;
    private boolean isFocus = false;
    private boolean isFocus2 = false;
    private boolean isDoubleDir = false;
    private int collapsedDir = -1;
    boolean isGripper = false;
    boolean isResizing = false;
    private boolean isHover = false;
    private boolean isHover1 = false;
    private boolean isHover2 = false;
    Point originalPos = new Point(0, 0);
    int previousHeight = 0;
    private boolean prevControlFocused = false;
    private boolean selfFocused = false;

    public GrabbyBar(CollapseComposite parent, int style) {
        super((Composite)parent, style);
        this.display = this.getDisplay();
        this.collapseable = parent;
        if (this.display.getHighContrast()) {
            ARROW_HEIGHT = 24;
            ARROW_WIDTH = 14;
            GRIPPER_WIDTH = 14;
            GRIPPER_HEIGHT = 114;
            SIZE = ARROW_WIDTH;
        } else {
            ARROW_HEIGHT = 12;
            ARROW_WIDTH = 6;
            GRIPPER_WIDTH = 6;
            GRIPPER_HEIGHT = 74;
            SIZE = ARROW_WIDTH;
        }
        if ((style & 0x20000) != 0) {
            this.direction = 131072;
            this.isDoubleDir = true;
        }
        if ((style & 0x400) != 0) {
            this.direction = 1024;
        }
        if ((style & 0x100) != 0) {
            this.direction = 131072;
            this.isDoubleDir = true;
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 9: {
                        GrabbyBar.this.onPaint(event);
                        break;
                    }
                    case 4: {
                        GrabbyBar.this.onSelection(event);
                        break;
                    }
                    case 3: {
                        GrabbyBar.this.onMouseDown(event);
                        break;
                    }
                    case 5: {
                        GrabbyBar.this.onMouseMove(event);
                        break;
                    }
                    case 6: {
                        GrabbyBar.this.onHover(event);
                        break;
                    }
                    case 31: {
                        GrabbyBar.this.onTraverse(event);
                        break;
                    }
                    case 1: {
                        GrabbyBar.this.onKeyDown(event);
                        break;
                    }
                    case 15: {
                        GrabbyBar.this.onFocus(event, true);
                        break;
                    }
                    case 16: {
                        GrabbyBar.this.onFocus(event, false);
                        break;
                    }
                    case 7: {
                        GrabbyBar.this.onExit(event);
                    }
                }
            }
        };
        int[] events = new int[]{9, 4, 3, 5, 6, 31, 1, 15, 16, 7};
        int i = 0;
        while (i < events.length) {
            this.addListener(events[i], listener);
            ++i;
        }
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = GrabbyBar.this.collapseable.getCollapsed() ? String.valueOf(Messages.press_spacebar_to_expand) + " " + Messages.use_arrows_to_resize : String.valueOf(Messages.press_spacebar_to_collapse) + " " + Messages.use_arrows_to_resize;
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent e) {
                e.detail = 10;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = GrabbyBar.this.collapseable.getCollapsed() ? 1024 : 512;
            }
        });
    }

    private void onPaint(Event event) {
        boolean hc = this.display.getHighContrast();
        GC gc = event.gc;
        this.getDisplay();
        Rectangle rect = this.getClientArea();
        if (rect.width == 0 || rect.height == 0) {
            return;
        }
        if (!hc) {
            gc.setBackground(ColorCache.getColor("SASH_BACKGROUND"));
        } else {
            gc.setBackground(Display.getDefault().getSystemColor(22));
        }
        gc.fillRectangle(rect.x, rect.y, rect.width, rect.height);
        Rectangle arrowRect = this.getArrowBounds(rect);
        Rectangle gripperRect = this.getGripperBounds(rect);
        int[] shape = null;
        int[] doubleDirShape = null;
        if (this.isHover && !hc) {
            gc.setForeground(ColorCache.getColor("SASH_HOVER_BACKGROUND_TOP"));
            gc.setBackground(ColorCache.getColor("SASH_HOVER_BACKGROUND_BOTTOM"));
            gc.fillRectangle(gripperRect);
            gc.setForeground(ColorCache.getColor("SASH_HOVER_EDGE"));
            gc.drawLine(gripperRect.x, gripperRect.y, gripperRect.x, gripperRect.y + gripperRect.height);
            gc.drawLine(gripperRect.x + gripperRect.width, gripperRect.y, gripperRect.x + gripperRect.width, gripperRect.y + gripperRect.height);
        } else if (this.isHover1 && !hc) {
            gc.setForeground(ColorCache.getColor("SASH_HOVER_BACKGROUND_TOP"));
            gc.setBackground(ColorCache.getColor("SASH_HOVER_BACKGROUND_BOTTOM"));
            gc.fillRectangle(gripperRect.x, gripperRect.y, gripperRect.width, gripperRect.height / 2);
            gc.setForeground(ColorCache.getColor("SASH_HOVER_EDGE"));
            gc.drawLine(gripperRect.x, gripperRect.y, gripperRect.x, gripperRect.y + gripperRect.height);
            gc.drawLine(gripperRect.x + gripperRect.width, gripperRect.y, gripperRect.x + gripperRect.width, gripperRect.y + gripperRect.height);
        } else if (this.isHover2 && !hc) {
            gc.setForeground(ColorCache.getColor("SASH_HOVER_BACKGROUND_TOP"));
            gc.setBackground(ColorCache.getColor("SASH_HOVER_BACKGROUND_BOTTOM"));
            gc.fillRectangle(gripperRect.x, gripperRect.y + gripperRect.height / 2, gripperRect.width, gripperRect.height / 2);
            gc.setForeground(ColorCache.getColor("SASH_HOVER_EDGE"));
            gc.drawLine(gripperRect.x, gripperRect.y, gripperRect.x, gripperRect.y + gripperRect.height);
            gc.drawLine(gripperRect.x + gripperRect.width, gripperRect.y, gripperRect.x + gripperRect.width, gripperRect.y + gripperRect.height);
        }
        if (this.isDoubleDir) {
            arrowRect.y -= ARROW_HEIGHT;
            Rectangle otherRect = this.getOppositeArrowBounds(rect);
            otherRect.y += ARROW_HEIGHT;
            if (this.collapsedDir == -1) {
                shape = new int[]{arrowRect.x + 1, arrowRect.y + 3, arrowRect.x + 1, arrowRect.y + 11, arrowRect.x + 5, arrowRect.y + 7};
                doubleDirShape = new int[]{otherRect.x + 5, otherRect.y + 2, otherRect.x + 5, otherRect.y + 12, otherRect.x + 1, otherRect.y + 7};
            } else if (this.collapsedDir == 16384) {
                doubleDirShape = new int[]{otherRect.x + 5, otherRect.y + 2, otherRect.x + 5, otherRect.y + 12, otherRect.x + 1, otherRect.y + 7};
            } else if (this.collapsedDir == 131072) {
                shape = new int[]{arrowRect.x + 1, arrowRect.y + 3, arrowRect.x + 1, arrowRect.y + 11, arrowRect.x + 5, arrowRect.y + 7};
            }
        } else {
            shape = this.direction == 1024 || this.direction == 128 ? (this.collapseable.getCollapsed() ? new int[]{arrowRect.x + 2, arrowRect.y + 5, arrowRect.x + 12, arrowRect.y + 5, arrowRect.x + 7, arrowRect.y + 1} : new int[]{arrowRect.x + 3, arrowRect.y + 1, arrowRect.x + 11, arrowRect.y + 1, arrowRect.x + 7, arrowRect.y + 5}) : (this.direction == 16384 && this.collapseable.getCollapsed() || this.direction == 131072 && !this.collapseable.getCollapsed() ? new int[]{arrowRect.x + 1, arrowRect.y + 3, arrowRect.x + 1, arrowRect.y + 11, arrowRect.x + 5, arrowRect.y + 7} : new int[]{arrowRect.x + 5, arrowRect.y + 2, arrowRect.x + 5, arrowRect.y + 12, arrowRect.x + 1, arrowRect.y + 7});
        }
        Color previousBack = gc.getBackground();
        if (hc) {
            gc.setBackground(Display.getDefault().getSystemColor(21));
            gc.setForeground(Display.getDefault().getSystemColor(21));
            gc.drawRectangle(rect.x - 1, rect.y, rect.width + 1, rect.height - 1);
        } else {
            gc.setBackground(Display.getDefault().getSystemColor(1));
        }
        if (shape != null) {
            gc.fillPolygon(shape);
        }
        if (doubleDirShape != null) {
            gc.fillPolygon(doubleDirShape);
        }
        gc.setBackground(previousBack);
        if (!hc) {
            gc.setForeground(ColorCache.getColor("SASH_EDGE"));
        }
        if (this.direction == 1024) {
            gc.drawLine(rect.x, rect.y, rect.width, rect.y);
            gc.drawLine(rect.x, rect.y + rect.height - 1, rect.width, rect.y + rect.height - 1);
        } else {
            gc.drawLine(rect.x, rect.y, rect.x, rect.height);
            gc.drawLine(rect.x + rect.width - 1, rect.y, rect.x + rect.width - 1, rect.height);
        }
        if (this.isDoubleDir && this.collapsedDir == -1) {
            gc.setForeground(Display.getDefault().getSystemColor(21));
            if (this.isFocus) {
                gc.drawFocus(gripperRect.x, gripperRect.y, gripperRect.width, gripperRect.height / 2);
            } else if (this.isFocus2) {
                gc.drawFocus(gripperRect.x, gripperRect.y + gripperRect.height / 2, gripperRect.width, gripperRect.height / 2);
            }
        } else if (this.isFocus || this.isFocus2) {
            gc.setForeground(Display.getDefault().getSystemColor(21));
            gc.drawFocus(gripperRect.x, gripperRect.y, gripperRect.width, gripperRect.height);
        }
    }

    private void onSelection(Event event) {
        Rectangle gripper;
        if (event.button != 1) {
            return;
        }
        Rectangle rect = this.getClientArea();
        if (rect.width == 0 || rect.height == 0) {
            return;
        }
        if (this.collapseable instanceof CollapseableSashForm) {
            ((CollapseableSashForm)this.collapseable).setDelta(0);
        }
        if ((gripper = this.getGripperBounds(rect)).contains(event.x, event.y) && this.isGripper) {
            if (this.isDoubleDir) {
                this.selfFocused = true;
                this.collapsedDir = !this.collapseable.getCollapsed() ? (event.y <= gripper.y + gripper.height / 2 ? 131072 : 16384) : -1;
                if (this.collapseable instanceof CollapseableSashForm) {
                    ((CollapseableSashForm)this.collapseable).resizedByClicking = true;
                }
                this.setCollapsedDir(this.collapsedDir);
                return;
            }
            this.collapseable.setCollapsed(!this.collapseable.getCollapsed());
            this.redraw();
        }
        this.isResizing = false;
    }

    public void setCollapsedDir(int dir) {
        this.collapsedDir = dir;
        this.collapseable.setCollapsed(dir != -1);
        if (dir != -1 && this.collapseable instanceof CollapseableSashForm) {
            ((CollapseableSashForm)this.collapseable).setDelta(0);
        }
        this.isResizing = false;
        this.redraw();
    }

    public int getCollapsedDir() {
        return this.collapsedDir;
    }

    private void onHover(Event event) {
        Rectangle rect = this.getClientArea();
        if (rect.width == 0 || rect.height == 0) {
            return;
        }
        Rectangle gripperBounds = this.getGripperBounds(rect);
        if (gripperBounds.contains(event.x, event.y)) {
            if (this.isDoubleDir && this.collapsedDir == -1) {
                this.isHover = false;
                Rectangle top = new Rectangle(gripperBounds.x, gripperBounds.y, gripperBounds.width, gripperBounds.height / 2);
                if (top.contains(event.x, event.y)) {
                    boolean old = this.isHover1;
                    this.isHover1 = true;
                    this.isHover2 = false;
                    if (!old) {
                        this.redraw();
                    }
                    this.setCursor(null);
                } else {
                    boolean old = this.isHover2;
                    this.isHover2 = true;
                    this.isHover1 = false;
                    if (!old) {
                        this.redraw();
                    }
                    this.setCursor(null);
                }
            } else {
                boolean old = this.isHover;
                this.isHover = true;
                if (!old) {
                    this.redraw();
                }
                this.setCursor(null);
            }
        } else {
            boolean old = this.isHover;
            this.isHover = false;
            if (old) {
                this.redraw();
            }
            if (this.direction == 1024 || this.direction == 128) {
                this.setCursor(this.getDisplay().getSystemCursor(7));
            } else {
                this.setCursor(this.getDisplay().getSystemCursor(9));
            }
        }
    }

    private void onExit(Event event) {
        this.isHover = false;
        this.isHover1 = false;
        this.isHover2 = false;
        this.redraw();
    }

    private void onMouseDown(Event event) {
        if (this.getGripperBounds(this.getClientArea()).contains(event.x, event.y)) {
            this.isGripper = true;
            this.isResizing = false;
        } else {
            if (this.collapseable.getCollapsed()) {
                this.isGripper = false;
                this.isResizing = false;
                return;
            }
            this.isGripper = false;
            this.isResizing = true;
            this.originalPos.x = event.x;
            this.originalPos.y = event.y;
        }
    }

    private void onMouseMove(Event event) {
        Rectangle rect = this.getClientArea();
        if (rect.width == 0 || rect.height == 0) {
            return;
        }
        if (this.collapseable.getCollapsed()) {
            return;
        }
        this.onHover(event);
        if (this.direction == 1024) {
            if (!this.isGripper && this.isResizing) {
                Rectangle newBounds = new Rectangle(this.collapseable.getBounds().x, this.collapseable.getBounds().y, this.collapseable.getBounds().width, this.collapseable.getBounds().height - event.y);
                if (newBounds.height < this.collapseable.getParent().getBounds().height - rect.height && newBounds.height > rect.height) {
                    CollapseableArea area;
                    if (this.collapseable instanceof CollapseableArea && newBounds.height > area.getParent().getBounds().height - rect.height - (area = (CollapseableArea)this.collapseable).getSiblingMinimumSize()) {
                        return;
                    }
                    if (this.collapseable instanceof CollapseableSashForm) {
                        ((CollapseableSashForm)this.collapseable).setNewBounds(newBounds);
                    } else {
                        this.collapseable.setBounds(newBounds);
                    }
                    this.collapseable.setCollapsed(false);
                    this.redraw();
                }
            }
        } else if (this.direction == 131072 && !this.isGripper && this.isResizing) {
            if (this.isDoubleDir) {
                int delta = this.originalPos.x - event.x;
                Rectangle newBounds = new Rectangle(this.collapseable.getBounds().x, this.collapseable.getBounds().y, this.collapseable.getBounds().width + delta, this.collapseable.getBounds().height);
                if (this.collapseable instanceof CollapseableSashForm) {
                    ((CollapseableSashForm)this.collapseable).setDelta(event.x);
                } else {
                    this.collapseable.setBounds(newBounds);
                }
                this.collapseable.setCollapsed(false);
                this.originalPos.x = event.x;
                this.originalPos.y = event.y;
                this.redraw();
            } else {
                Rectangle newBounds = new Rectangle(this.collapseable.getBounds().x, this.collapseable.getBounds().y, this.collapseable.getBounds().width - event.x, this.collapseable.getBounds().height);
                if (newBounds.width < this.collapseable.getParent().getBounds().width - rect.width && newBounds.width > rect.width) {
                    if (this.collapseable instanceof CollapseableSashForm) {
                        ((CollapseableSashForm)this.collapseable).setNewBounds(newBounds);
                    } else {
                        this.collapseable.setBounds(newBounds);
                    }
                    this.collapseable.setCollapsed(false);
                    this.redraw();
                }
            }
        }
    }

    private Rectangle getArrowBounds(Rectangle bounds) {
        Rectangle value = new Rectangle(0, 0, 0, 0);
        if (this.direction == 1024 || this.direction == 128) {
            value.x = bounds.x + (bounds.width - ARROW_HEIGHT) / 2;
            value.y = 0;
            value.width = ARROW_HEIGHT;
            value.height = ARROW_WIDTH;
        } else {
            value.x = 0;
            value.y = bounds.y + (bounds.height - ARROW_HEIGHT) / 2;
            value.width = ARROW_WIDTH;
            value.height = ARROW_HEIGHT;
        }
        return value;
    }

    private Rectangle getOppositeArrowBounds(Rectangle bounds) {
        Rectangle value = new Rectangle(0, 0, 0, 0);
        if (this.direction == 1024 || this.direction == 128) {
            value.x = bounds.x + (bounds.width - ARROW_HEIGHT) / 2;
            value.y = 0;
            value.width = ARROW_HEIGHT;
            value.height = ARROW_WIDTH;
        } else {
            value.x = 0;
            value.y = bounds.y + (bounds.height - ARROW_HEIGHT) / 2;
            value.width = ARROW_WIDTH;
            value.height = ARROW_HEIGHT;
        }
        return value;
    }

    private Rectangle getGripperBounds(Rectangle bounds) {
        Rectangle value = new Rectangle(0, 0, 0, 0);
        if (this.direction == 16384 || this.direction == 131072) {
            value.x = 0;
            value.y = bounds.y + (bounds.height - GRIPPER_HEIGHT) / 2;
            value.width = GRIPPER_WIDTH;
            value.height = GRIPPER_HEIGHT;
        } else {
            value.x = bounds.x + (bounds.width - GRIPPER_HEIGHT) / 2;
            value.y = 0;
            value.width = GRIPPER_HEIGHT;
            value.height = GRIPPER_WIDTH;
        }
        return value;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (this.direction == 1024 || this.direction == 128) {
            return super.computeSize(GRIPPER_WIDTH + 1, hHint, changed);
        }
        return super.computeSize(wHint, GRIPPER_WIDTH + 1, changed);
    }

    public void setGradientBeginColor(Color begin) {
        this.gradientBeginColor = Display.getDefault().getHighContrast() ? Display.getDefault().getSystemColor(22) : begin;
    }

    public void setGradientEndColor(Color end) {
        this.gradientEndColor = Display.getDefault().getHighContrast() ? Display.getDefault().getSystemColor(22) : end;
    }

    private void onTraverse(Event event) {
        switch (event.detail) {
            case 2: 
            case 256: 
            case 512: {
                event.doit = true;
                break;
            }
            case 16: {
                if (this.isDoubleDir && this.collapsedDir == -1 && this.isFocus) {
                    this.isFocus2 = true;
                    this.isFocus = false;
                    this.redraw();
                    break;
                }
                event.doit = true;
                break;
            }
            case 8: {
                if (this.isDoubleDir && this.collapsedDir == -1 && this.isFocus2) {
                    this.isFocus = true;
                    this.isFocus2 = false;
                    this.redraw();
                    break;
                }
                event.doit = true;
                break;
            }
            case 4: {
                if (this.isDoubleDir) {
                    this.selfFocused = true;
                    if (this.isFocus) {
                        this.collapsedDir = !this.collapseable.getCollapsed() ? 131072 : -1;
                    } else if (this.isFocus2) {
                        this.collapsedDir = !this.collapseable.getCollapsed() ? 16384 : -1;
                    }
                    if (this.collapseable instanceof CollapseableSashForm) {
                        ((CollapseableSashForm)this.collapseable).resizedByClicking = true;
                    }
                }
                this.collapseable.setCollapsed(!this.collapseable.getCollapsed());
                if (this.collapseable.getCollapsed()) {
                    this.setToolTipText(String.valueOf(Messages.press_spacebar_to_expand) + " " + Messages.use_arrows_to_resize);
                } else {
                    this.setToolTipText(String.valueOf(Messages.press_spacebar_to_collapse) + " " + Messages.use_arrows_to_resize);
                }
                this.redraw();
                this.getAccessible().setFocus(-1);
            }
        }
    }

    private void onKeyDown(Event event) {
        int orient = Window.getDefaultOrientation();
        if (this.isFocus || this.isFocus2) {
            if ((this.getStyle() & 0x400) != 0) {
                Rectangle newBounds;
                if (event.keyCode == 0x1000001 || (orient == 0x4000000 ? event.keyCode == 0x1000004 : event.keyCode == 0x1000003)) {
                    if (!this.collapseable.getCollapsed()) {
                        newBounds = new Rectangle(this.collapseable.getBounds().x, this.collapseable.getBounds().y, this.collapseable.getBounds().width, this.collapseable.getBounds().height + 2);
                        this.resizeTo(newBounds);
                    }
                } else if ((event.keyCode == 0x1000002 || (orient == 0x4000000 ? event.keyCode == 0x1000003 : event.keyCode == 0x1000004)) && !this.collapseable.getCollapsed()) {
                    newBounds = new Rectangle(this.collapseable.getBounds().x, this.collapseable.getBounds().y, this.collapseable.getBounds().width, this.collapseable.getBounds().height - 2);
                    this.resizeTo(newBounds);
                }
            }
            if ((this.getStyle() & 0x20000) != 0 && this.isDoubleDir && !this.collapseable.getCollapsed()) {
                int delta = 0;
                if (!(orient == 0x4000000 ? event.keyCode != 0x1000004 : event.keyCode != 0x1000003) || event.keyCode == 0x1000001) {
                    delta = orient == 0x4000000 ? 2 : -2;
                } else if (!(orient == 0x4000000 ? event.keyCode != 0x1000003 : event.keyCode != 0x1000004) || event.keyCode == 0x1000002) {
                    delta = orient == 0x4000000 ? -2 : 2;
                }
                if (this.collapseable instanceof CollapseableSashForm) {
                    ((CollapseableSashForm)this.collapseable).setDelta(delta);
                } else {
                    Rectangle newBounds = new Rectangle(this.collapseable.getBounds().x, this.collapseable.getBounds().y, this.collapseable.getBounds().width + delta, this.collapseable.getBounds().height);
                    this.collapseable.setBounds(newBounds);
                }
                this.collapseable.setCollapsed(false);
                if (this.collapseable instanceof CollapseableSashForm) {
                    ((CollapseableSashForm)this.collapseable).setDelta(0);
                }
                this.redraw();
            }
            if (event.character == ' ') {
                if (this.isDoubleDir) {
                    this.selfFocused = true;
                    if (this.isFocus) {
                        this.collapsedDir = !this.collapseable.getCollapsed() ? 131072 : -1;
                    } else if (this.isFocus2) {
                        this.collapsedDir = !this.collapseable.getCollapsed() ? 16384 : -1;
                    }
                    if (this.collapseable instanceof CollapseableSashForm) {
                        ((CollapseableSashForm)this.collapseable).resizedByClicking = true;
                    }
                }
                this.collapseable.setCollapsed(!this.collapseable.getCollapsed());
                if (this.collapseable.getCollapsed()) {
                    this.setToolTipText(String.valueOf(Messages.press_spacebar_to_expand) + " " + Messages.use_arrows_to_resize);
                } else {
                    this.setToolTipText(String.valueOf(Messages.press_spacebar_to_collapse) + " " + Messages.use_arrows_to_resize);
                }
                this.redraw();
                this.getAccessible().setFocus(-1);
            }
        }
    }

    public boolean forceFocus() {
        Control prevf = this.getDisplay().getFocusControl();
        this.prevControlFocused = SwtUtils.isPreviousChild(prevf, (Control)this);
        return super.forceFocus();
    }

    private void onFocus(Event event, boolean focus) {
        this.isFocus = focus;
        if (this.isDoubleDir) {
            if (focus) {
                if (this.collapsedDir == -1 && !this.selfFocused) {
                    if (this.prevControlFocused) {
                        this.isFocus = true;
                        this.isFocus2 = false;
                    } else {
                        this.isFocus = false;
                        this.isFocus2 = true;
                    }
                }
                if (this.selfFocused) {
                    this.selfFocused = false;
                }
            } else {
                this.isFocus2 = false;
            }
        }
        this.redraw();
    }

    private void resizeTo(Rectangle newBounds) {
        Rectangle rect = this.getClientArea();
        if (newBounds.height < this.collapseable.getParent().getBounds().height - rect.height && newBounds.height > rect.height) {
            CollapseableArea area;
            if (this.collapseable instanceof CollapseableArea && newBounds.height > area.getParent().getBounds().height - rect.height - (area = (CollapseableArea)this.collapseable).getSiblingMinimumSize()) {
                return;
            }
            if (this.collapseable instanceof CollapseableSashForm) {
                ((CollapseableSashForm)this.collapseable).setNewBounds(newBounds);
            } else {
                this.collapseable.setBounds(newBounds);
            }
            this.collapseable.setCollapsed(false);
            this.redraw();
        }
    }
}

