/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui.widgets;

import com.ibm.collaboration.realtime.ui.UiPlugin;
import com.ibm.collaboration.realtime.ui.util.DrawingUtils;
import com.ibm.collaboration.realtime.ui.util.ImageCache;
import com.ibm.collaboration.realtime.ui.util.SwtUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SliderControl
extends Canvas {
    static int DEFAULT_HEIGHT = 64;
    static int DEFAULT_WIDTH = 27;
    static int SLIDER_WIDTH = 6;
    static int SLIDER_HEIGHT = 52;
    static int SLIDER_DIAMETER = 12;
    int selection = 0;
    int max = 100;
    int min = 0;
    Color borderColor = null;
    Color bgTop = null;
    Color bgBottom = null;
    Color selected = null;
    Color slider = null;
    Color sliderTop = null;
    Color sliderBottom = null;
    Rectangle sliderRect = new Rectangle(0, 0, 0, 0);
    int style = 512;
    boolean mouseDown = false;
    int currY = 0;
    private Image sliderImage;
    private ImageDescriptor lblImage;
    private int sliderW = 0;
    private int sliderH = 0;
    private boolean vertical = false;
    private boolean disposeOnFocusOut = false;
    private static final Logger logger;
    private boolean inFocus = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.collaboration.realtime.ui.widgets.SliderControl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public static void main(String[] args) {
        block3: {
            Display d = new Display();
            Shell s = new Shell();
            try {
                s.setLayout((Layout)new GridLayout());
                SliderControl c = new SliderControl((Composite)s, 256);
                c.setDisposeOnFocusOut(false);
                c.setBackgroundGradient(new Color(null, 219, 225, 235), new Color(null, 232, 235, 241));
                c.setBorderColor(new Color(null, 210, 223, 239));
                c.setSelection(100);
                c = new SliderControl((Composite)s, 512);
                c.setDisposeOnFocusOut(false);
                c.setSelection(30);
                Button b = new Button((Composite)s, 8);
                b.setText("asdf");
                s.open();
                while (!s.isDisposed()) {
                    if (d.readAndDispatch()) continue;
                    d.sleep();
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.WARNING)) break block3;
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    public SliderControl(Composite parent, int style) {
        super(parent, 0);
        this.style = style;
        boolean hc = Display.getDefault().getHighContrast();
        if (!hc) {
            this.borderColor = new Color(null, 127, 142, 173);
            this.bgTop = new Color(null, 255, 255, 255);
            this.bgBottom = new Color(null, 232, 232, 240);
            this.selected = new Color(null, 144, 176, 224);
            this.slider = new Color(null, 255, 255, 255);
            this.sliderTop = new Color(null, 255, 255, 255);
            this.sliderBottom = new Color(null, 168, 200, 128);
            DEFAULT_HEIGHT = 64;
            DEFAULT_WIDTH = 27;
            SLIDER_WIDTH = 6;
            SLIDER_HEIGHT = 52;
            SLIDER_DIAMETER = 12;
        } else {
            this.borderColor = new Color(null, Display.getDefault().getSystemColor(21).getRGB());
            this.bgTop = new Color(null, Display.getDefault().getSystemColor(22).getRGB());
            this.bgBottom = new Color(null, Display.getDefault().getSystemColor(22).getRGB());
            this.selected = new Color(null, Display.getDefault().getSystemColor(31).getRGB());
            this.slider = new Color(null, Display.getDefault().getSystemColor(22).getRGB());
            this.sliderTop = new Color(null, Display.getDefault().getSystemColor(22).getRGB());
            this.sliderBottom = new Color(null, Display.getDefault().getSystemColor(22).getRGB());
            DEFAULT_HEIGHT = (int)(64.0 * SwtUtils.getFontScaleOffset());
            DEFAULT_WIDTH = (int)(27.0 * SwtUtils.getFontScaleOffset());
            SLIDER_WIDTH = (int)(6.0 * SwtUtils.getFontScaleOffset());
            SLIDER_HEIGHT = (int)(52.0 * SwtUtils.getFontScaleOffset());
            SLIDER_DIAMETER = (int)(12.0 * SwtUtils.getFontScaleOffset());
        }
        if ((style & 0x200) != 0) {
            if (!hc) {
                this.sliderImage = ImageCache.getImageDescriptor((Plugin)UiPlugin.getDefault(), "images/Volume_Slider_Control_v.png").createImage();
            }
            this.vertical = true;
        } else if (!hc) {
            this.sliderImage = ImageCache.getImageDescriptor((Plugin)UiPlugin.getDefault(), "images/Volume_Slider_Control.png").createImage();
        }
        if (this.sliderImage != null) {
            this.sliderW = this.sliderImage.getImageData().width;
            this.sliderH = this.sliderImage.getImageData().height;
        } else {
            this.sliderW = SLIDER_DIAMETER;
            this.sliderH = SLIDER_DIAMETER;
        }
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                SliderControl.this.onPaint(e.gc);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (SliderControl.this.borderColor != null && !SliderControl.this.borderColor.isDisposed()) {
                    SliderControl.this.borderColor.dispose();
                }
                if (SliderControl.this.bgTop != null && !SliderControl.this.bgTop.isDisposed()) {
                    SliderControl.this.bgTop.dispose();
                }
                if (SliderControl.this.bgBottom != null && !SliderControl.this.bgBottom.isDisposed()) {
                    SliderControl.this.bgBottom.dispose();
                }
                if (SliderControl.this.selected != null && !SliderControl.this.selected.isDisposed()) {
                    SliderControl.this.selected.dispose();
                }
                if (SliderControl.this.slider != null && !SliderControl.this.slider.isDisposed()) {
                    SliderControl.this.slider.dispose();
                }
                if (SliderControl.this.sliderTop != null && !SliderControl.this.sliderTop.isDisposed()) {
                    SliderControl.this.sliderTop.dispose();
                }
                if (SliderControl.this.sliderBottom != null && !SliderControl.this.sliderBottom.isDisposed()) {
                    SliderControl.this.sliderBottom.dispose();
                }
                if (SliderControl.this.sliderImage != null && !SliderControl.this.sliderImage.isDisposed()) {
                    SliderControl.this.sliderImage.dispose();
                    SliderControl.this.sliderImage = null;
                }
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (SliderControl.this.sliderRect.contains(e.x, e.y)) {
                    SliderControl.this.mouseDown = true;
                    SliderControl.this.currY = SliderControl.this.vertical ? e.y : e.x;
                }
            }

            public void mouseUp(MouseEvent e) {
                SliderControl.this.mouseDown = false;
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (SliderControl.this.mouseDown) {
                    SliderControl.this.currY = SliderControl.this.vertical ? e.y : (SliderControl.this.lblImage == null ? e.x : e.x - SliderControl.this.getLblImageDesc().createImage().getBounds().width);
                    SliderControl.this.redraw();
                }
            }
        });
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                boolean rtl;
                boolean bl = rtl = Window.getDefaultOrientation() == 0x4000000;
                if (e.keyCode == 0x1000001 || !rtl && e.keyCode == 0x1000004 || rtl && e.keyCode == 0x1000003) {
                    SliderControl.this.currY = 0;
                    int sel = SliderControl.this.selection;
                    if (sel + 5 < SliderControl.this.max) {
                        SliderControl.this.setSelection(sel + 5);
                    } else {
                        SliderControl.this.setSelection(SliderControl.this.max);
                    }
                } else if (e.keyCode == 0x1000002 || !rtl && e.keyCode == 0x1000003 || rtl && e.keyCode == 0x1000004) {
                    SliderControl.this.currY = 0;
                    int sel = SliderControl.this.selection;
                    if (sel - 5 > 0) {
                        SliderControl.this.setSelection(sel - 5);
                    } else {
                        SliderControl.this.setSelection(0);
                    }
                } else if (e.keyCode == 27 && SliderControl.this.disposeOnFocusOut) {
                    SliderControl.this.dispose();
                }
            }

            public void keyReleased(KeyEvent arg0) {
            }
        });
        this.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                if (SliderControl.this.disposeOnFocusOut) {
                    SliderControl.this.dispose();
                }
            }

            public void mouseHover(MouseEvent e) {
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent arg0) {
                SliderControl.this.inFocus = true;
                SliderControl.this.redraw();
            }

            public void focusLost(FocusEvent arg0) {
                SliderControl.this.inFocus = false;
                SliderControl.this.redraw();
                if (SliderControl.this.disposeOnFocusOut) {
                    SliderControl.this.dispose();
                }
            }
        });
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                switch (e.detail) {
                    case 2: 
                    case 4: 
                    case 8: 
                    case 16: 
                    case 256: 
                    case 512: {
                        e.doit = true;
                    }
                }
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getValue(AccessibleControlEvent e) {
                e.result = "" + SliderControl.this.getSelection();
            }
        });
    }

    void onPaint(GC gc) {
        Rectangle rect = this.getClientArea();
        gc.setForeground(this.bgTop);
        gc.setBackground(this.bgBottom);
        gc.fillGradientRectangle(rect.x, rect.y, rect.width, rect.height, true);
        if (this.vertical || (this.style & 0x800) != 0) {
            gc.setForeground(this.borderColor);
            gc.drawRoundRectangle(rect.x, rect.y, rect.width - 1, rect.height - 1, 6, 6);
        }
        if (this.vertical) {
            int sliderX = rect.x + (rect.width - SLIDER_WIDTH) / 2;
            int sliderY = rect.y + (rect.height - SLIDER_HEIGHT) / 2;
            gc.setBackground(this.selected);
            gc.fillRectangle(sliderX, sliderY, SLIDER_WIDTH, SLIDER_HEIGHT);
            gc.setBackground(this.slider);
            gc.fillRectangle(sliderX, sliderY, SLIDER_WIDTH, this.getSelectedHeight());
            gc.setForeground(this.borderColor);
            gc.drawRoundRectangle(sliderX, sliderY, SLIDER_WIDTH, SLIDER_HEIGHT, 4, 4);
            int center = rect.x + (rect.width - this.sliderW) / 2;
            this.drawSliderKnob(gc, center, sliderY + this.getSelectedHeight() - this.sliderH / 2);
        } else {
            int sliderX = rect.x + (rect.width - SLIDER_HEIGHT) / 2;
            int sliderY = rect.y + (rect.height - SLIDER_WIDTH) / 2;
            if (this.lblImage != null) {
                gc.drawImage(this.getLblImageDesc().createImage(), rect.x + 5, rect.y + (rect.height - this.getLblImageDesc().createImage().getBounds().width) / 2);
                sliderX = rect.x + 5 + (rect.width - SLIDER_HEIGHT) / 2;
            }
            gc.setBackground(this.slider);
            gc.fillRectangle(sliderX, sliderY, SLIDER_HEIGHT, SLIDER_WIDTH);
            gc.setBackground(this.selected);
            gc.fillRectangle(sliderX, sliderY + 1, this.getSelectedHeight(), SLIDER_WIDTH - 1);
            gc.setForeground(this.borderColor);
            gc.drawRoundRectangle(sliderX, sliderY, SLIDER_HEIGHT, SLIDER_WIDTH, 4, 4);
            int center = rect.y + (rect.height - this.sliderH) / 2;
            this.drawSliderKnob(gc, sliderX + this.getSelectedHeight() - this.sliderW / 2, center);
        }
    }

    void drawSliderKnob(GC gc, int x, int y) {
        if (Display.getDefault().getHighContrast()) {
            Region region = new Region();
            int[] circle = DrawingUtils.getCircle(x + SLIDER_DIAMETER / 2, y + SLIDER_DIAMETER / 2, SLIDER_DIAMETER / 2);
            region.add(circle);
            gc.setClipping(region);
            gc.setForeground(this.sliderTop);
            gc.setBackground(this.sliderBottom);
            gc.fillGradientRectangle(x, y, SLIDER_DIAMETER, SLIDER_DIAMETER, true);
            gc.setClipping(null);
            region.dispose();
            gc.setForeground(this.borderColor);
            gc.drawPolygon(circle);
        } else {
            gc.drawImage(this.sliderImage, x, y);
        }
        this.sliderRect = new Rectangle(x, y, this.sliderW, this.sliderH);
        if (this.inFocus) {
            gc.setForeground(this.getDisplay().getSystemColor(21));
            gc.drawFocus(this.sliderRect.x, this.sliderRect.y, this.sliderRect.width, this.sliderRect.height);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point pt = new Point(0, 0);
        if (this.vertical) {
            pt.x = DEFAULT_WIDTH;
            pt.y = DEFAULT_HEIGHT;
        } else if (this.lblImage != null) {
            pt.x = DEFAULT_HEIGHT + this.getLblImageDesc().createImage().getBounds().width + 15;
            pt.y = DEFAULT_WIDTH;
        } else {
            pt.x = DEFAULT_HEIGHT;
            pt.y = DEFAULT_WIDTH;
        }
        return pt;
    }

    public Point computeSize(int wHint, int hHint) {
        return this.computeSize(wHint, hHint, true);
    }

    public void setSelection(int selection) {
        this.selection = selection;
        if (!this.isDisposed()) {
            this.redraw();
            if (this.inFocus) {
                this.getAccessible().setFocus(-1);
            }
        }
    }

    public void setMaximum(int max) {
        this.max = max;
    }

    public void setMinimum(int min) {
        this.min = min;
    }

    int getSelectedHeight() {
        if (this.currY > 0) {
            this.selection = this.vertical ? this.max - (int)((double)this.currY / (double)SLIDER_HEIGHT * (double)(this.max - this.min)) : (int)((double)this.currY / (double)SLIDER_HEIGHT * (double)(this.max - this.min));
            if (this.selection < 0) {
                this.selection = 0;
            } else if (this.selection > this.max) {
                this.selection = this.max;
            } else {
                return this.currY;
            }
        }
        int height = (int)((double)SLIDER_HEIGHT * ((double)(this.max - this.selection) / (double)(this.max - this.min)));
        if (!this.vertical) {
            height = SLIDER_HEIGHT - height;
        }
        return height;
    }

    public int getSelection() {
        return this.selection;
    }

    public void setDisposeOnFocusOut(boolean dispose) {
        this.disposeOnFocusOut = dispose;
    }

    public void setBackgroundGradient(Color color1, Color color2) {
        if (Display.getDefault().getHighContrast()) {
            color1.dispose();
            color2.dispose();
            return;
        }
        if (this.bgTop != null) {
            this.bgTop.dispose();
            this.bgTop = null;
        }
        this.bgTop = color1;
        if (this.bgBottom != null) {
            this.bgBottom.dispose();
            this.bgBottom = null;
        }
        this.bgBottom = color2;
    }

    public void setBorderColor(Color color) {
        if (Display.getDefault().getHighContrast()) {
            color.dispose();
            return;
        }
        if (this.borderColor != null) {
            this.borderColor.dispose();
            this.borderColor = null;
        }
        this.borderColor = color;
    }

    public void setLblImage(ImageDescriptor lblImage) {
        this.lblImage = lblImage;
    }

    public ImageDescriptor getLblImageDesc() {
        ImageDescriptor desc = this.lblImage;
        if (SwtUtils.usingHighContrast()) {
            return SwtUtils.getScaledImageDescriptor(desc);
        }
        return desc;
    }
}

