/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui.widgets;

import com.ibm.collaboration.realtime.ui.ExplorerWindow;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class HyperlinkLabel
extends Label {
    String url = null;
    Runnable action = null;
    private boolean focus = false;

    public HyperlinkLabel(Composite arg0, int arg1) {
        super(arg0, arg1);
        this.addMouseListener((MouseListener)new MouseAdapter(){
            boolean clickDown = false;

            public void mouseDown(MouseEvent e) {
                this.clickDown = true;
            }

            public void mouseUp(MouseEvent e) {
                if (this.clickDown) {
                    HyperlinkLabel.this.handleClick();
                }
                this.clickDown = false;
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                HyperlinkLabel.this.onDispose(event);
            }
        });
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                switch (event.detail) {
                    case 2: 
                    case 8: 
                    case 16: 
                    case 256: 
                    case 512: {
                        event.doit = true;
                        break;
                    }
                    case 4: {
                        HyperlinkLabel.this.handleClick();
                    }
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                HyperlinkLabel.this.focus = true;
                HyperlinkLabel.this.redraw();
            }

            public void focusLost(FocusEvent e) {
                HyperlinkLabel.this.focus = false;
                HyperlinkLabel.this.redraw();
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (HyperlinkLabel.this.focus) {
                    e.gc.drawFocus(e.x, e.y, e.width, e.height);
                }
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == ' ') {
                    HyperlinkLabel.this.handleClick();
                }
            }
        });
    }

    private void onDispose(DisposeEvent event) {
    }

    public void setText(String t) {
        this.setCursor(null);
        this.setForeground(this.getDisplay().getSystemColor(2));
        this.action = null;
        this.url = null;
        super.setText(t);
    }

    public void setTextAndUrl(String t, String url) {
        super.setText(t);
        this.action = null;
        this.setUrl(url);
    }

    public void setTextAndAction(String t, Runnable action) {
        super.setText(t);
        this.action = action;
        this.url = null;
        if (action != null) {
            this.setCursor(this.getDisplay().getSystemCursor(21));
            this.setForeground(this.getDisplay().getSystemColor(9));
        }
    }

    private void handleClick() {
        if (this.url != null) {
            ExplorerWindow.launchBrowser(this.url, this.url);
        } else if (this.action != null) {
            this.action.run();
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
        if (url != null) {
            this.setCursor(this.getDisplay().getSystemCursor(21));
            this.setForeground(this.getDisplay().getSystemColor(9));
        } else {
            this.setCursor(null);
            this.setForeground(this.getDisplay().getSystemColor(2));
        }
    }

    protected void checkSubclass() {
    }
}

