/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui.util.window;

import com.ibm.collaboration.realtime.ui.strings.LogMessages;
import com.ibm.collaboration.realtime.ui.util.window.AbstractWindowUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Shell;

public class WindowUtils {
    private static final String PLATFORM_CLASS_NAME_WINDOWS = "com.ibm.collaboration.realtime.ui.win32.win32.x86.PlatformWindowUtils";
    private static final String PLATFORM_CLASS_NAME_LINUX = "com.ibm.webahead.ginie.util.LinuxWindowUtils";
    private static final String PLATFORM_CLASS_NAME_MAC = "com.ibm.webahead.ginie.util.MacWindowUtils";
    private static final Logger s_logger;
    private AbstractWindowUtils _windowUtils;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.collaboration.realtime.ui.util.window.WindowUtils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger(clazz.getPackage().getName());
    }

    public static WindowUtils createInstance(Shell shell) {
        return new WindowUtils(shell);
    }

    public WindowUtils(Shell shell) {
        block5: {
            this._windowUtils = null;
            try {
                String osName = System.getProperty("os.name").toLowerCase();
                String platformClassName = PLATFORM_CLASS_NAME_WINDOWS;
                if (osName.startsWith("linux")) {
                    platformClassName = PLATFORM_CLASS_NAME_LINUX;
                } else if (osName.startsWith("mac")) {
                    platformClassName = PLATFORM_CLASS_NAME_MAC;
                }
                this._windowUtils = (AbstractWindowUtils)Class.forName(platformClassName).newInstance();
                this._windowUtils.setShell(shell);
            }
            catch (Throwable t) {
                this._windowUtils = null;
                if (!s_logger.isLoggable(Level.SEVERE)) break block5;
                s_logger.log(Level.SEVERE, LogMessages.WindowUtils_6, t);
            }
        }
    }

    public void setOnTop(boolean top) {
        if (this._windowUtils != null) {
            this._windowUtils.setOnTop(top);
        }
    }

    public void setAlwaysOnTop(Shell shell, boolean top) {
        if (this._windowUtils != null) {
            this._windowUtils.setAlwaysOnTop(top);
        }
    }

    public void flashWindow(boolean activate) {
        if (this._windowUtils != null) {
            this._windowUtils.flashWindow(activate);
        }
    }

    public void notifyUser(boolean notify) {
        if (this._windowUtils != null) {
            this._windowUtils.notifyUser(notify);
        }
    }

    public void setOnTopWOActivating(boolean top) {
        if (this._windowUtils != null) {
            this._windowUtils.setOnTopWOActivating(top);
        }
    }

    public void restoreWhenMinimizedWOActivating() {
        if (this._windowUtils != null) {
            this._windowUtils.restoreWhenMinimizedWOActivating();
        }
    }

    public String getMailClientNames() {
        if (this._windowUtils != null) {
            return this._windowUtils.getMailClientNames();
        }
        return null;
    }

    public int invokeMailComposition(String client, String subject, String to, String fileBody) {
        if (this._windowUtils != null) {
            return this._windowUtils.invokeMailComposition(client, subject, to, fileBody);
        }
        return 0;
    }
}

