/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui.util.tray;

import com.ibm.collaboration.realtime.util.MultilineTextBuffer;
import java.util.HashMap;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;

public class BlinkingTrayItem {
    TrayItem trayIcon;
    Image cachedImage;
    Image _invertedImage;
    private int _blinkIconRequesters = 0;
    private final Integer _blinkIconLock = new Integer(0);
    private Thread _blinkThread = null;
    private boolean _visibleOnlyWhenBlinking = false;
    private boolean _iconInverted = false;
    private boolean _stopBlinkThread = false;
    private boolean _blinkThreadRunning = false;
    MultilineTextBuffer tooltipTextBuffer;
    private Runnable thingToExecute;

    public BlinkingTrayItem(Tray tray, int style) {
        this.trayIcon = new TrayItem(tray, style);
    }

    public void setImage(Image image) {
        if (this.trayIcon == null) {
            return;
        }
        this.cachedImage = image;
        this.trayIcon.setImage(image);
    }

    public void setInvertedImage(Image image) {
        if (this.trayIcon == null) {
            return;
        }
        this._invertedImage = image;
    }

    public void showIcon() {
        if (this.trayIcon == null) {
            return;
        }
        this.trayIcon.setVisible(true);
    }

    public void hideIcon() {
        if (this.trayIcon == null) {
            return;
        }
        this.trayIcon.setVisible(false);
    }

    public void setRunnable(Runnable runner) {
        this.thingToExecute = runner;
        this.trayIcon.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BlinkingTrayItem.this.thingToExecute != null) {
                    BlinkingTrayItem.this.thingToExecute.run();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisibleOnlyWhenBlinking(boolean setting) {
        this._visibleOnlyWhenBlinking = setting;
        if (setting && this.trayIcon != null) {
            Integer n = this._blinkIconLock;
            synchronized (n) {
                if (!this._blinkThreadRunning) {
                    this.hideIcon();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blinkIcon(boolean onOrOff) {
        if (this.trayIcon != null && this._invertedImage != null) {
            Integer n = this._blinkIconLock;
            synchronized (n) {
                if (onOrOff) {
                    ++this._blinkIconRequesters;
                    if (this._blinkIconRequesters == 1) {
                        if (this._visibleOnlyWhenBlinking) {
                            this.showIcon();
                        }
                        this.startBlinkingIconThread();
                    }
                } else {
                    --this._blinkIconRequesters;
                    if (this._blinkIconRequesters == 0) {
                        this.stopBlinkingIconThread();
                    }
                }
            }
        }
    }

    private void startBlinkingIconThread() {
        this._stopBlinkThread = false;
        this._blinkThreadRunning = true;
        this._blinkThread = new Thread("blinking tray thread"){

            public void run() {
                while (!BlinkingTrayItem.this._stopBlinkThread) {
                    BlinkingTrayItem.this._iconInverted = !BlinkingTrayItem.this._iconInverted;
                    BlinkingTrayItem.this.trayIcon.getDisplay().asyncExec(new Runnable(this){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            if (BlinkingTrayItem.access$2(2.access$0(this.this$1))) {
                                2.access$0(this.this$1).trayIcon.setImage(2.access$0(this.this$1)._invertedImage);
                            } else {
                                2.access$0(this.this$1).trayIcon.setImage(2.access$0(this.this$1).cachedImage);
                            }
                        }
                    });
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Throwable throwable) {}
                }
                if (BlinkingTrayItem.this._iconInverted) {
                    BlinkingTrayItem.this._iconInverted = false;
                    BlinkingTrayItem.this.trayIcon.getDisplay().asyncExec(new Runnable(this){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            2.access$0(this.this$1).trayIcon.setImage(2.access$0(this.this$1).cachedImage);
                            if (BlinkingTrayItem.access$4(2.access$0(this.this$1)) && BlinkingTrayItem.access$1(2.access$0(this.this$1))) {
                                2.access$0(this.this$1).hideIcon();
                            }
                        }
                    });
                } else {
                    BlinkingTrayItem.this.trayIcon.getDisplay().asyncExec(new Runnable(this){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            if (BlinkingTrayItem.access$4(2.access$0(this.this$1)) && BlinkingTrayItem.access$1(2.access$0(this.this$1))) {
                                2.access$0(this.this$1).hideIcon();
                            }
                        }
                    });
                }
                BlinkingTrayItem.this._blinkThreadRunning = false;
            }

            static /* synthetic */ BlinkingTrayItem access$0(2 var0) {
                return var0.BlinkingTrayItem.this;
            }
        };
        this._blinkThread.start();
    }

    private void stopBlinkingIconThread() {
        if (this._blinkThread != null) {
            this._stopBlinkThread = true;
        }
    }

    public String getTooltipText() {
        String result = null;
        if (this.trayIcon != null) {
            result = this.trayIcon.getToolTipText();
        }
        return result;
    }

    public String getTooltipEntryAt(int index) {
        String result = null;
        if (this.tooltipTextBuffer != null) {
            result = this.tooltipTextBuffer.getTextAt(index);
        }
        return result;
    }

    public HashMap getTooltipContextAt(int index) {
        HashMap result = null;
        if (this.tooltipTextBuffer != null) {
            result = (HashMap)this.tooltipTextBuffer.getContextAt(index);
        }
        return result;
    }

    public int getNumberOfTooltipEntries() {
        int result = 0;
        if (this.tooltipTextBuffer != null) {
            result = this.tooltipTextBuffer.getNumberOfLines();
        }
        return result;
    }

    public boolean setTooltipText(String tooltip) {
        if (this.trayIcon == null) {
            return false;
        }
        this.trayIcon.setToolTipText(tooltip);
        return true;
    }

    public boolean setTooltipTextBuffer(MultilineTextBuffer textBuffer) {
        if (this.trayIcon == null) {
            return false;
        }
        this.tooltipTextBuffer = textBuffer;
        String currentText = this.tooltipTextBuffer.getText();
        if (currentText != null) {
            this.trayIcon.setToolTipText(currentText);
        }
        return true;
    }

    public boolean appendTooltipText(String text) {
        return this.appendTooltipText(text, new HashMap());
    }

    public boolean appendTooltipText(String text, HashMap context) {
        String currentText;
        boolean result = false;
        if (this.trayIcon != null && this.tooltipTextBuffer != null && (result = this.tooltipTextBuffer.appendText(text, (Object)context)) && (currentText = this.tooltipTextBuffer.getText()) != null) {
            this.trayIcon.setToolTipText(currentText);
        }
        return result;
    }

    public void removeTooltipText(String text) {
        if (this.trayIcon != null && this.tooltipTextBuffer != null) {
            this.tooltipTextBuffer.removeText(text);
            String currentText = this.tooltipTextBuffer.getText();
            if (currentText != null) {
                this.trayIcon.setToolTipText(currentText);
            }
        }
    }

    public void removeTooltipTextWithContext(HashMap context) {
        if (this.trayIcon != null && this.tooltipTextBuffer != null) {
            this.tooltipTextBuffer.removeTextWithContext((Object)context);
            String currentText = this.tooltipTextBuffer.getText();
            if (currentText != null) {
                this.trayIcon.setToolTipText(currentText);
            }
        }
    }

    static /* synthetic */ boolean access$4(BlinkingTrayItem blinkingTrayItem) {
        return blinkingTrayItem._visibleOnlyWhenBlinking;
    }
}

