/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui.util;

import com.ibm.collaboration.realtime.ui.UiPlugin;
import com.ibm.collaboration.realtime.ui.strings.LogMessages;
import com.ibm.collaboration.realtime.ui.util.SwtUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

public class ImageCache {
    public static final String IMAGE_DIRECTORY = "images" + File.separator;
    public static final String STATUS_IMAGE_DIRECTORY = String.valueOf(IMAGE_DIRECTORY) + "status" + File.separator;
    public static final String IMAGE_STATUS_ACTIVE = String.valueOf(STATUS_IMAGE_DIRECTORY) + "ST_Awns_Active.png";
    public static final String IMAGE_STATUS_AWAY = String.valueOf(STATUS_IMAGE_DIRECTORY) + "ST_Awns_Away.png";
    public static final String IMAGE_STATUS_DND = String.valueOf(STATUS_IMAGE_DIRECTORY) + "ST_Awns_DND.png";
    public static final String IMAGE_STATUS_IN_MEETING = String.valueOf(STATUS_IMAGE_DIRECTORY) + "ST_Awns_InAMtng.png";
    public static final String IMAGE_STATUS_ACTIVE_MOBILE = String.valueOf(STATUS_IMAGE_DIRECTORY) + "ST_Awns_Active_Mobile.png";
    public static final String IMAGE_STATUS_AWAY_MOBILE = String.valueOf(STATUS_IMAGE_DIRECTORY) + "ST_Awns_Away_Mobile.png";
    public static final String IMAGE_STATUS_DND_MOBILE = String.valueOf(STATUS_IMAGE_DIRECTORY) + "ST_Awns_DND_Mobile.png";
    public static final String IMAGE_STATUS_IN_MEETING_MOBILE = String.valueOf(STATUS_IMAGE_DIRECTORY) + "ST_Awns_InAMtg_Mobile.png";
    public static final String IMAGE_STATUS_DISCONNECTED = String.valueOf(STATUS_IMAGE_DIRECTORY) + "ST_Awns_Offline.png";
    public static final String IMAGE_STATUS_CONNECTING = String.valueOf(STATUS_IMAGE_DIRECTORY) + "ST_Awns_Connecting.png";
    public static final String IMAGE_STATUS_BLANK = String.valueOf(STATUS_IMAGE_DIRECTORY) + "blankStatus.gif";
    public static final String IMAGE_ST_ICO_ACTIVE = String.valueOf(STATUS_IMAGE_DIRECTORY) + "ST_Logo_Active.ico";
    public static final String IMAGE_ST_ICO_AWAY = String.valueOf(STATUS_IMAGE_DIRECTORY) + "ST_Logo_Away.ico";
    public static final String IMAGE_ST_ICO_DND = String.valueOf(STATUS_IMAGE_DIRECTORY) + "ST_Logo_DND.ico";
    public static final String IMAGE_ST_ICO_IN_MTG = String.valueOf(STATUS_IMAGE_DIRECTORY) + "ST_Logo_InMtg.ico";
    public static final String IMAGE_ST_ICO_CONNECTING = String.valueOf(STATUS_IMAGE_DIRECTORY) + "ST_Logo_Connecting.ico";
    public static final String IMAGE_ST_ICO_OFFLINE = String.valueOf(STATUS_IMAGE_DIRECTORY) + "ST_Logo_Disconnected.ico";
    public static final String IMAGE_ST_LOGO = String.valueOf(STATUS_IMAGE_DIRECTORY) + "ST_Logo_16x16.png";
    public static final String IMAGE_ST_LOGO_ACTIVE = String.valueOf(STATUS_IMAGE_DIRECTORY) + "ST_Logo_Active_16x16.png";
    public static final String IMAGE_ST_LOGO_AWAY = String.valueOf(STATUS_IMAGE_DIRECTORY) + "ST_Logo_Away_16x16.png";
    public static final String IMAGE_ST_LOGO_DND = String.valueOf(STATUS_IMAGE_DIRECTORY) + "ST_Logo_DND_16x16.png";
    public static final String IMAGE_ST_LOGO_IN_MTG = String.valueOf(STATUS_IMAGE_DIRECTORY) + "ST_Logo_InMtg_16x16.png";
    public static final String IMAGE_ST_LOGO_CONNECTING = String.valueOf(STATUS_IMAGE_DIRECTORY) + "ST_Logo_Connecting_16x16.png";
    public static final String IMAGE_ST_LOGO_OFFLINE = String.valueOf(STATUS_IMAGE_DIRECTORY) + "ST_Logo_Disconnected_16x16.png";
    private static final Logger logger;
    private static ImageRegistry imgRegistry;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.collaboration.realtime.ui.util.ImageCache");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getPackage().getName());
        imgRegistry = null;
    }

    private static ImageRegistry getImgRegistry() {
        if (imgRegistry == null) {
            imgRegistry = new ImageRegistry();
        }
        return imgRegistry;
    }

    public static synchronized ImageDescriptor getImageDescriptor(Plugin plugin, String imgFilePath) {
        ImageDescriptor imgDesc;
        block5: {
            imgDesc = null;
            try {
                if (plugin.getBundle() != null) {
                    String key = ImageCache.getKey(plugin, imgFilePath);
                    imgDesc = ImageCache.getImgRegistry().getDescriptor(key);
                    if (imgDesc == null) {
                        imgDesc = ImageCache.loadImageDescriptor(plugin, key, imgFilePath);
                    }
                }
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, NLS.bind((String)LogMessages.ImageCache_26, (Object)imgFilePath, (Object)ImageCache.getPluginId(plugin)));
                }
                if (!logger.isLoggable(Level.WARNING)) break block5;
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return imgDesc;
    }

    private static ImageDescriptor loadImageDescriptor(Plugin plugin, String key, String imgFilePath) {
        String pluginId = ImageCache.getPluginId(plugin);
        return ImageCache.loadImageDescriptor(pluginId, key, imgFilePath);
    }

    private static ImageDescriptor loadImageDescriptor(String pluginId, String key, String imgFilePath) {
        ImageDescriptor imgDesc = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)imgFilePath);
        if (imgDesc != null) {
            ImageCache.getImgRegistry().put(key, imgDesc);
        } else if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, NLS.bind((String)LogMessages.ImageCache_28, (Object)imgFilePath, (Object)pluginId));
        }
        return imgDesc;
    }

    public static synchronized Image getImage(String imgFilePath) {
        return ImageCache.getImage((Plugin)UiPlugin.getDefault(), imgFilePath);
    }

    public static synchronized Image getImage(Plugin plugin, String imgFilePath) {
        return ImageCache.getImage(plugin, imgFilePath, false);
    }

    public static synchronized Image getImage(Plugin plugin, String imgFilePath, boolean needHighContrast) {
        Image img;
        block13: {
            img = null;
            try {
                if (plugin.getBundle() != null) {
                    ImageDescriptor imgDesc;
                    String key = ImageCache.getKey(plugin, imgFilePath);
                    if (needHighContrast) {
                        key = String.valueOf(key) + "_HC";
                    }
                    if ((img = ImageCache.getImgRegistry().get(key)) == null && (imgDesc = ImageCache.getImageDescriptor(plugin, imgFilePath)) != null) {
                        if (needHighContrast) {
                            img = SwtUtils.getScaledImageDescriptor(imgDesc).createImage();
                            if (img != null) {
                                ImageCache.getImgRegistry().put(key, img);
                            }
                        } else {
                            img = imgDesc.createImage();
                        }
                    }
                    if (img == null) {
                        img = ImageCache.loadImage(plugin, key, imgFilePath);
                    } else if (img.isDisposed()) {
                        img = ImageCache.reloadImage(plugin, key, imgFilePath);
                    }
                }
            }
            catch (Exception e) {
                String pid = "";
                if (plugin != null) {
                    pid = ImageCache.getPluginId(plugin);
                }
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, NLS.bind((String)LogMessages.ImageCache_31, (Object)imgFilePath, (Object)pid));
                }
                if (!logger.isLoggable(Level.WARNING)) break block13;
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return img;
    }

    public static synchronized Image getImage(String pluginId, String imgFilePath) {
        Image img;
        block7: {
            img = null;
            try {
                ImageDescriptor imgDesc;
                String key = ImageCache.getKey(pluginId, imgFilePath);
                img = ImageCache.getImgRegistry().get(key);
                if (img == null && (imgDesc = ImageCache.getImageDescriptor(pluginId, imgFilePath)) != null) {
                    img = imgDesc.createImage();
                }
                if (img == null) {
                    img = ImageCache.loadImage(pluginId, key, imgFilePath);
                } else if (img.isDisposed()) {
                    img = ImageCache.reloadImage(pluginId, key, imgFilePath);
                }
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, NLS.bind((String)LogMessages.ImageCache_34, (Object)imgFilePath, (Object)pluginId));
                }
                if (!logger.isLoggable(Level.WARNING)) break block7;
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return img;
    }

    public static void destroyImage(Plugin plugin, String imgFilePath) {
        try {
            if (plugin.getBundle() != null) {
                String key = ImageCache.getKey(plugin, imgFilePath);
                ImageCache.getImgRegistry().remove(key);
            }
        }
        catch (Exception exception) {}
    }

    private static String getPluginId(Object plugin) {
        block6: {
            try {
                Class<?> bundleContextClass = Class.forName("org.osgi.framework.BundleContext");
                if (bundleContextClass.isAssignableFrom(plugin.getClass())) {
                    Method getBundleMethod = bundleContextClass.getMethod("getBundle", new Class[0]);
                    Object bundle = getBundleMethod.invoke(plugin, new Object[0]);
                    return ((Bundle)bundle).getSymbolicName();
                }
            }
            catch (Throwable throwable) {}
            try {
                Class<?> pluginClass = Class.forName("org.eclipse.core.runtime.Plugin");
                if (pluginClass.isAssignableFrom(plugin.getClass())) {
                    return ((Plugin)plugin).getBundle().getSymbolicName();
                }
            }
            catch (ClassNotFoundException e) {
                if (!logger.isLoggable(Level.WARNING)) break block6;
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return null;
    }

    private static String getKey(Plugin plugin, String imgFilePath) {
        String pluginId = ImageCache.getPluginId(plugin);
        return ImageCache.getKey(pluginId, imgFilePath);
    }

    private static String getKey(String pluginId, String imgFilePath) {
        return String.valueOf(pluginId) + "_" + imgFilePath;
    }

    private static Image loadImage(Plugin plugin, String key, String imgFilePath) {
        Image img = ImageCache.createImage(plugin, imgFilePath);
        if (img != null) {
            ImageCache.getImgRegistry().put(key, img);
        } else if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, NLS.bind((String)LogMessages.ImageCache_38, (Object)imgFilePath, (Object)ImageCache.getPluginId(plugin)));
        }
        return img;
    }

    private static Image loadImage(String pluginId, String key, String imgFilePath) {
        Image img = ImageCache.createImage(pluginId, imgFilePath);
        if (img != null) {
            ImageCache.getImgRegistry().put(key, img);
        } else if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, NLS.bind((String)LogMessages.ImageCache_40, (Object)imgFilePath, (Object)pluginId));
        }
        return img;
    }

    private static Image reloadImage(Plugin plugin, String key, String imgFilePath) {
        Image img = ImageCache.createImage(plugin, imgFilePath);
        if (img != null) {
            ImageCache.getImgRegistry().remove(key);
            ImageCache.getImgRegistry().put(key, img);
        } else if (logger.isLoggable(Level.WARNING)) {
            logger.warning(String.valueOf(LogMessages.ImageCache_42) + key);
        }
        return img;
    }

    private static Image reloadImage(String pluginId, String key, String imgFilePath) {
        Image img = ImageCache.createImage(pluginId, imgFilePath);
        if (img != null) {
            ImageCache.getImgRegistry().remove(key);
            ImageCache.getImgRegistry().put(key, img);
        } else if (logger.isLoggable(Level.WARNING)) {
            logger.warning(String.valueOf(LogMessages.ImageCache_44) + key);
        }
        return img;
    }

    private static Image createImage(Plugin plugin, String imgFilePath) {
        URL imgUrl = plugin.find((IPath)new Path(imgFilePath));
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)imgUrl);
        return desc.createImage(true);
    }

    private static Image createImage(String pluginId, String imgFilePath) {
        ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)imgFilePath);
        return desc.createImage(true);
    }

    public static ImageDescriptor getImageDescriptor(String pluginId, String imgFilePath) {
        ImageDescriptor imgDesc;
        block4: {
            imgDesc = null;
            try {
                String key = ImageCache.getKey(pluginId, imgFilePath);
                imgDesc = ImageCache.getImgRegistry().getDescriptor(key);
                if (imgDesc == null) {
                    imgDesc = ImageCache.loadImageDescriptor(pluginId, key, imgFilePath);
                }
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, NLS.bind((String)LogMessages.ImageCache_46, (Object)imgFilePath, (Object)pluginId));
                }
                if (!logger.isLoggable(Level.WARNING)) break block4;
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return imgDesc;
    }

    public static String getImageUrl(Plugin plugin, String imgFilePath) {
        try {
            return FileLocator.toFileURL((URL)FileLocator.find((Bundle)plugin.getBundle(), (IPath)new Path(imgFilePath), null)).toString();
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

